//kt -- Modified with SourceScanner on 7/19/2007
unit fNoteDR;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  fAutoSz, StdCtrls, DKLang;

type
  TfrmNoteDelReason = class(TfrmAutoSz)
    lblInstruction: TStaticText;
    cmdOK: TButton;
    cmdCancel: TButton;
    radPrivacy: TRadioButton;
    radAdmin: TRadioButton;
    DKLanguageController2: TDKLanguageController;
    procedure FormCreate(Sender: TObject);
    procedure cmdOKClick(Sender: TObject);
    procedure cmdCancelClick(Sender: TObject);
  private
    //kt Begin Mod (change Consts to Vars) 7/19/2007
    TX_REQRSN  : string;  //kt
    TC_REQRSN  : string;  //kt
    //kt End Mod -------------------
    OKPressed: Boolean;
    procedure SetupVars;  //kt
  end;

function SelectDeleteReason(ANote: Integer): string;

implementation

{$R *.DFM}

uses ORFn, rTIU, uConst;

//const
//TX_REQRSN = 'A reason must be selected, otherwise press cancel.';  <-- original line.  //kt 7/19/2007
//TC_REQRSN = 'Reason Required';  <-- original line.  //kt 7/19/2007



procedure TfrmNoteDelReason.SetupVars;
//kt Added entire function to replace constant declarations 7/19/2007
begin
  TX_REQRSN := DKLangConstW('fNoteDR_A_reason_must_be_selectedx_otherwise_press_cancelx');
  TC_REQRSN := DKLangConstW('fNoteDR_Reason_Required'); 
end;
 
function SelectDeleteReason(ANote: Integer): string;
var
  frmNoteDelReason: TfrmNoteDelReason;
begin
  if not JustifyDocumentDelete(ANote) then
  begin
    Result := DR_NOTREQ;
    Exit;
  end;
  Result := DR_CANCEL;
  frmNoteDelReason := TfrmNoteDelReason.Create(Application);
  try
    ResizeFormToFont(TForm(frmNoteDelReason));
    frmNoteDelReason.ShowModal;
    with frmNoteDelReason do if OKPressed then
    begin
      if radPrivacy.Checked then Result := DR_PRIVACY;
      if radAdmin.Checked then Result := DR_ADMIN;
    end;
  finally
    frmNoteDelReason.Release;
  end;
end;

procedure TfrmNoteDelReason.FormCreate(Sender: TObject);
begin
  inherited;
  OKPressed := False;
end;

procedure TfrmNoteDelReason.cmdOKClick(Sender: TObject);
begin
  SetupVars;  //kt added 7/19/2007 to replace constants with vars.
  inherited;
  if not (radPrivacy.Checked or radAdmin.Checked) then
  begin
    InfoBox(TX_REQRSN, TC_REQRSN, MB_OK);
    Exit;
  end;
  OKPressed := True;
  Close;
end;

procedure TfrmNoteDelReason.cmdCancelClick(Sender: TObject);
begin
  inherited;
  Close;
end;

end.
