//kt -- Modified with SourceScanner on 7/24/2007
unit fProbCmt;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ORCtrls, StdCtrls, Buttons, DKLang;

type
  TfrmProbCmt = class(TForm)
    edComment: TCaptionEdit;
    bbOK: TBitBtn;
    bbCancel: TBitBtn;
    lblComment: TOROffsetLabel;
    DKLanguageController1: TDKLanguageController;
    procedure bbCancelClick(Sender: TObject);
    procedure bbOKClick(Sender: TObject);
  private
    fCmtResult: string ;
  end;

function NewComment: string ;
function EditComment(OldValue: string): string ;


var
  frmProbCmt: TfrmProbCmt;

implementation

uses
    uProbs, ORfn, rCore ;

{$R *.DFM}

//const
//TX_INVALID_CHAR = 'The character "^" cannot be used in a comment';  <-- original line.  //kt 7/24/2007
//TC_INVALID_CHAR = 'Invalid character';  <-- original line.  //kt 7/24/2007

var
  TX_INVALID_CHAR  : string;  //kt
  TC_INVALID_CHAR  : string;  //kt

procedure SetupVars;
//kt Added entire function to replace constant declarations 7/24/2007
begin
  TX_INVALID_CHAR := DKLangConstW('fProbCmt_The_character_xxx_cannot_be_used_in_a_comment');
  TC_INVALID_CHAR := DKLangConstW('fProbCmt_Invalid_character');
end;
 
function NewComment: string ;
begin
  frmProbCmt := TfrmProbCmt.Create(Application) ;
  try
    ResizeAnchoredFormToFont(frmProbCmt);
    with frmProbCmt do
      begin
        ShowModal;
        Result := fCmtResult;
      end;
  finally
    frmProbCmt.Free ;
  end ;
end ;

function EditComment(OldValue: string): string ;
begin
  frmProbCmt := TfrmProbCmt.Create(Application) ;
  try
    with frmProbCmt do
      begin
        edComment.Text := Piece(OldValue, U, 2);
        ShowModal;
        Result := fCmtResult;
      end;
  finally
    frmProbCmt.Free ;
  end ;
end ;


procedure TfrmProbCmt.bbCancelClick(Sender: TObject);
begin
  fCmtResult := '0^Cancelled' ;
end;

procedure TfrmProbCmt.bbOKClick(Sender: TObject);
begin
  SetupVars;  //kt added 7/24/2007 to replace constants with vars.
  if (edComment.Text <> '') then
    begin
      if Pos('^', edComment.Text) > 0 then
      begin
        InfoBox(TX_INVALID_CHAR, TC_INVALID_CHAR, MB_ICONERROR);
        fCmtResult := '';
        ModalResult := mrNone;
      end
      else
      begin
        fCmtResult := '1^'+FormatFMDateTime('mmm dd yyyy',FMToday)+'^'+ edComment.Text;
        ModalResult := mrOK;
      end;
    end
  else
    begin
      fCmtResult := '';
      ModalResult := mrNone;
    end;
end;

end.
