//kt -- Modified with SourceScanner on 8/8/2007
unit fPCEEdit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ORFn, uPCE, DKLang;

type
  TfrmPCEEdit = class(TForm)
    btnNew: TButton;
    btnNote: TButton;
    lblNew: TMemo;
    lblNote: TMemo;
    btnCancel: TButton;
    Label1: TStaticText;
    DKLanguageController1: TDKLanguageController;
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

function EditPCEData(NoteData: TPCEData): boolean;

implementation

uses uCore, rCore, fEncnt, fFrame, fEncounterFrame;

{$R *.DFM}

//const
//TX_NEED_VISIT2 = 'A visit is required before entering encounter information.';  <-- original line.  //kt 8/8/2007
//TX_NOPCE_TXT1  = 'the encounter date is in the future.';  <-- original line.  //kt 8/8/2007
//TX_NOPCE_TXT2  = 'encounter entry has been disabled.';  <-- original line.  //kt 8/8/2007
//TX_NOPCE_TXT   = 'You can not edit encounter information because ';  <-- original line.  //kt 8/8/2007
//TX_NOPCE_HDR   = 'Can not edit encounter';  <-- original line.  //kt 8/8/2007

var
  TX_NEED_VISIT2  : string;  //kt
  TX_NOPCE_TXT1   : string;  //kt
  TX_NOPCE_TXT2   : string;  //kt
  TX_NOPCE_TXT    : string;  //kt
  TX_NOPCE_HDR    : string;  //kt


procedure SetupVars;
//kt Added entire function to replace constant declarations 8/8/2007
begin
  TX_NEED_VISIT2 := DKLangConstW('fPCEEdit_A_visit_is_required_before_entering_encounter_informationx');
  TX_NOPCE_TXT1  := DKLangConstW('fPCEEdit_the_encounter_date_is_in_the_futurex');
  TX_NOPCE_TXT2  := DKLangConstW('fPCEEdit_encounter_entry_has_been_disabledx');
  TX_NOPCE_TXT   := DKLangConstW('fPCEEdit_You_can_not_edit_encounter_information_because');
  TX_NOPCE_HDR   := DKLangConstW('fPCEEdit_Can_not_edit_encounter');
end;
 
var
  uPCETemp: TPCEData = nil;
  uPCETempOld: TPCEData = nil;
  uPatient: string = '';

function EditPCEData(NoteData: TPCEData): boolean;   // Returns TRUE if NoteData is edited
var
  frmPCEEdit: TfrmPCEEdit;
  BtnTxt, NewTxt, txt: string;
  Ans: integer;

begin
  SetupVars;  //kt added 8/8/2007 to replace constants with vars.
  Result := FALSE;
  if (Encounter.VisitCategory = 'H') then
  begin
    if Assigned(NoteData) then
      Ans := mrNo
    else
    begin
//    InfoBox('Can not edit admission encounter', 'Error', MB_OK or MB_ICONERROR);  <-- original line.  //kt 8/8/2007
      InfoBox(DKLangConstW('fPCEEdit_Can_not_edit_admission_encounter'), DKLangConstW('fPCEEdit_Error'), MB_OK or MB_ICONERROR); //kt added 8/8/2007
      Ans := mrCancel;
    end;
  end
  else
  if not Assigned(NoteData) then
    Ans := mrYes
  else
  if (NoteData.VisitString = Encounter.VisitStr) then
    Ans := mrNo
  else
  begin
    frmPCEEdit := TfrmPCEEdit.Create(Application);
    try
      if Encounter.NeedVisit then
      begin
//      NewTxt := 'Create New Encounter';  <-- original line.  //kt 8/8/2007
        NewTxt := DKLangConstW('fPCEEdit_Create_New_Encounter'); //kt added 8/8/2007
//      BtnTxt := 'New Encounter';  <-- original line.  //kt 8/8/2007
        BtnTxt := DKLangConstW('fPCEEdit_New_Encounter'); //kt added 8/8/2007
      end
      else
      begin
//      NewTxt := 'Edit Encounter for ' + Encounter.LocationName + ' on ' +  <-- original line.  //kt 8/8/2007
        NewTxt := DKLangConstW('fPCEEdit_Edit_Encounter_for')+' ' + Encounter.LocationName + DKLangConstW('fPCEEdit_on') + //kt added 8/8/2007
                  FormatFMDateTime('mmm dd yyyy hh:nn', Encounter.DateTime);
//      BtnTxt := 'Edit Current Encounter';  <-- original line.  //kt 8/8/2007
        BtnTxt := DKLangConstW('fPCEEdit_Edit_Current_Encounter'); //kt added 8/8/2007
      end;
      frmPCEEdit.lblNew.Text := NewTxt;
      frmPCEEdit.btnNew.Caption := BtnTxt;
//    frmPCEEdit.lblNote.Text := 'Edit Note Encounter for ' + ExternalName(NoteData.Location, 44) + ' on ' +  <-- original line.  //kt 8/8/2007
      frmPCEEdit.lblNote.Text := DKLangConstW('fPCEEdit_Edit_Note_Encounter_for')+' ' + ExternalName(NoteData.Location, 44) + DKLangConstW('fPCEEdit_on') + //kt added 8/8/2007
                  FormatFMDateTime('mmm dd yyyy hh:nn', NoteData.VisitDateTime);
      ans := frmPCEEdit.ShowModal;
    finally
      frmPCEEdit.Free;
    end;
  end;
  if ans = mrYes then
  begin
    if Encounter.NeedVisit then
    begin
      UpdateVisit(8);
      frmFrame.DisplayEncounterText;
    end;
    if Encounter.NeedVisit then
    begin
      InfoBox(TX_NEED_VISIT2, TX_NO_VISIT, MB_OK or MB_ICONWARNING);
      Exit;
    end;
    if not assigned(uPCETemp) then
      uPCETemp := TPCEData.Create;
    uPCETemp.UseEncounter := True;
    if not CanEditPCE(uPCETemp) then
    begin
      if FutureEncounter(uPCETemp) then
        txt := TX_NOPCE_TXT1
      else
        txt := TX_NOPCE_TXT2;
      InfoBox(TX_NOPCE_TXT + txt, TX_NOPCE_HDR, MB_OK or MB_ICONWARNING);
      Exit;
    end;
    uPCETemp.PCEForNote(USE_CURRENT_VISITSTR, uPCETempOld);
    UpdatePCE(uPCETemp);
    if not assigned(uPCETempOld) then
      uPCETempOld := TPCEData.Create;
    uPCETemp.CopyPCEData(uPCETempOld);
  end
  else
  if ans = mrNo then
  begin
    UpdatePCE(NoteData);
    Result := TRUE;
  end;
end;

procedure TfrmPCEEdit.FormCreate(Sender: TObject);
begin
  if uPatient <> Patient.DFN then
    begin
      KillObj(@uPCETemp);
      KillObj(@uPCETempOld);
    end;
  uPatient := Patient.DFN;
end;

initialization

finalization
  KillObj(@uPCETemp);
  KillObj(@uPCETempOld);
  uPatient := '';

end.
