//kt -- Modified with SourceScanner on 8/8/2007
unit fOrderFlag;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  fAutoSz, StdCtrls, ComCtrls, ORFn, rOrders, ORCtrls, DKLang;

type
  TfrmFlagOrder = class(TfrmAutoSz)
    txtReason: TCaptionEdit;
    Label1: TLabel;
    cmdOK: TButton;
    cmdCancel: TButton;
    memOrder: TMemo;
    lblAlertRecipient: TLabel;
    cboAlertRecipient: TORComboBox;
    procedure FormCreate(Sender: TObject);
    procedure cmdOKClick(Sender: TObject);
    procedure cmdCancelClick(Sender: TObject);
    procedure cboOnExit(Sender: TObject);
    procedure cboAlertRecipientNeedData(Sender: TObject;
      const StartFrom: String; Direction, InsertAt: Integer);
  private
    OKPressed: Boolean;
  end;

function ExecuteFlagOrder(AnOrder: TOrder): Boolean;

implementation

{$R *.DFM}

uses uCore, rCore;

var AlertRecip: Int64;

function ExecuteFlagOrder(AnOrder: TOrder): Boolean;
var
  frmFlagOrder: TfrmFlagOrder;
begin
  Result := False;
  frmFlagOrder := TfrmFlagOrder.Create(Application);
  try
    ResizeFormToFont(TForm(frmFlagOrder));
    //AlertRecip := User.DUZ;
    with frmFlagOrder do
    begin
      memOrder.SetTextBuf(PChar(AnOrder.Text));
      ShowModal;
      if OKPressed then
      begin
        FlagOrder(AnOrder, txtReason.Text, AlertRecip);
        Result := True;
      end;
    end;
  finally
    frmFlagOrder.Release;
    AlertRecip := 0;
  end;
end;

procedure TfrmFlagOrder.FormCreate(Sender: TObject);
begin
  inherited;
  OKPressed := False;
  cboAlertRecipient.InitLongList('');
  //cboAlertRecipient.SelectByIEN(User.DUZ);
end;

procedure TfrmFlagOrder.cmdOKClick(Sender: TObject);
//const
//TX_REASON_REQ = 'A reason must be entered to flag an order.';  <-- original line.  //kt 8/8/2007
//TC_REASON_REQ = 'Reason Required';  <-- original line.  //kt 8/8/2007
var
  TX_REASON_REQ  : string;  //kt
  TC_REASON_REQ  : string;  //kt

begin
  inherited;
  TX_REASON_REQ := DKLangConstW('fOrderFlag_A_reason_must_be_entered_to_flag_an_orderx');
  TC_REASON_REQ := DKLangConstW('fOrderFlag_Reason_Required');
  if txtReason.Text = '' then
  begin
    InfoBox(TX_REASON_REQ, TC_REASON_REQ, MB_OK);
    Exit;
  end;
  cmdOK.SetFocus;
  OKPressed := True;
  Close;
end;

procedure TfrmFlagOrder.cmdCancelClick(Sender: TObject);
begin
  inherited;
  Close;
end;

procedure TfrmFlagOrder.cboOnExit(Sender: TObject);
begin
  with cboAlertRecipient do
    if (ItemIndex = -1) or (Text = '') then
    begin
      AlertRecip := -1;
      ItemIndex := -1;
      Text := '';
    end
    else
    begin
      AlertRecip := ItemIEN;
    end;
end;

procedure TfrmFlagOrder.cboAlertRecipientNeedData(Sender: TObject;
  const StartFrom: String; Direction, InsertAt: Integer);
begin
   cboAlertRecipient.ForDataUse(SubSetOfPersons(StartFrom, Direction));
end;

end.
