//kt -- Modified with SourceScanner on 8/8/2007
unit fOrderSaveQuick;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  fAutoSz, Buttons, ExtCtrls, StdCtrls, ORCtrls, ORFn, fODBase, uOrders,
  DKLang;

type
  TfrmSaveQuickOrder = class(TfrmAutoSz)
    Panel1: TPanel;
    memOrder: TMemo;
    lblDisplayName: TLabel;
    txtDisplayName: TCaptionEdit;
    Panel2: TPanel;
    lblQuickList: TLabel;
    lstQuickList: TORListBox;
    pnlUpButton: TKeyClickPanel;
    cmdUp: TSpeedButton;
    pnlDownButton: TKeyClickPanel;
    cmdRename: TButton;
    cmdDelete: TButton;
    cmdDown: TSpeedButton;
    Panel3: TPanel;
    cmdOK: TButton;
    cmdCancel: TButton;
    procedure FormCreate(Sender: TObject);
    procedure cmdOKClick(Sender: TObject);
    procedure cmdCancelClick(Sender: TObject);
    procedure txtDisplayNameChange(Sender: TObject);
    procedure cmdUpClick(Sender: TObject);
    procedure cmdDownClick(Sender: TObject);
    procedure cmdRenameClick(Sender: TObject);
    procedure cmdDeleteClick(Sender: TObject);
    procedure pnlUpButtonEnter(Sender: TObject);
    procedure pnlUpButtonExit(Sender: TObject);
  private
    OKPressed: Boolean;
  end;

function EditCommonList(ADisplayGroup: Integer): Boolean;
function SaveAsQuickOrder(ResponseSet: TResponses): Boolean;

implementation

{$R *.DFM}

uses rODBase, rOrders, fRename;

//const
//TX_DNAME_REQ = 'A name for the quick order must be entered in order to save it.';  <-- original line.  //kt 8/8/2007
//TC_DNAME_REQ = 'Display Name Missing';  <-- original line.  //kt 8/8/2007
//TX_DEL_CONFIRM = 'Remove the following quick order from your list?' + CRLF + CRLF;  <-- original line.  //kt 8/8/2007
//TC_DEL_CONFIRM = 'Remove Quick Order';  <-- original line.  //kt 8/8/2007
//TX_QO_RENAME   = 'Rename Quick Order';  <-- original line.  //kt 8/8/2007
//TX_NO_DEL_NEW  = 'A new quick order cannot be deleted.  Press <Cancel> instead.';  <-- original line.  //kt 8/8/2007
//TC_NO_DEL_NEW  = 'Remove Quick Order';  <-- original line.  //kt 8/8/2007
//TX_NO_TEXT     = 'No fields have been entered - cannot save as quick order.';  <-- original line.  //kt 8/8/2007
//TC_NO_TEXT     = 'Save as Quick Order';  <-- original line.  //kt 8/8/2007

var
    TX_DNAME_REQ    : string;  //kt
    TC_DNAME_REQ    : string;  //kt
    TX_DEL_CONFIRM  : string;  //kt
    TC_DEL_CONFIRM  : string;  //kt
    TX_QO_RENAME    : string;  //kt
    TX_NO_DEL_NEW   : string;  //kt
    TC_NO_DEL_NEW   : string;  //kt
    TX_NO_TEXT      : string;  //kt
    TC_NO_TEXT      : string;  //kt

procedure SetupVars;
//kt Added entire function to replace constant declarations 8/8/2007
begin
  TX_DNAME_REQ   := DKLangConstW('fOrderSaveQuick_A_name_for_the_quick_order_must_be_entered_in_order_to_save_itx');
  TC_DNAME_REQ   := DKLangConstW('fOrderSaveQuick_Display_Name_Missing');
  TX_DEL_CONFIRM := DKLangConstW('fOrderSaveQuick_Remove_the_following_quick_order_from_your_listx') + CRLF + CRLF;
  TC_DEL_CONFIRM := DKLangConstW('fOrderSaveQuick_Remove_Quick_Order');
  TX_QO_RENAME   := DKLangConstW('fOrderSaveQuick_Rename_Quick_Order');
  TX_NO_DEL_NEW  := DKLangConstW('fOrderSaveQuick_A_new_quick_order_cannot_be_deletedx__Press_xCancelx_insteadx');
  TC_NO_DEL_NEW  := DKLangConstW('fOrderSaveQuick_Remove_Quick_Order');
  TX_NO_TEXT     := DKLangConstW('fOrderSaveQuick_No_fields_have_been_entered_x_cannot_save_as_quick_orderx');
  TC_NO_TEXT     := DKLangConstW('fOrderSaveQuick_Save_as_Quick_Order');
end;
 
function EditCommonList(ADisplayGroup: Integer): Boolean;
var
  frmSaveQuickOrder: TfrmSaveQuickOrder;
  DGroupName: string;
begin
  Result := False;
  frmSaveQuickOrder := TfrmSaveQuickOrder.Create(Application);
  try
    ResizeFormToFont(TForm(frmSaveQuickOrder));
    with frmSaveQuickOrder do
    begin
      if ADisplayGroup = ClinDisp then
        ADisplayGroup := InptDisp;
      DGroupName := NameOfDGroup(ADisplayGroup);
//    Caption := 'Edit Common Order List (' + DGroupName + ')';  <-- original line.  //kt 8/8/2007
      Caption := DKLangConstW('fOrderSaveQuick_Edit_Common_Order_List_x') + DGroupName + ')'; //kt added 8/8/2007
//    lblQuickList.Caption := 'Common List for ' + DGroupName;  <-- original line.  //kt 8/8/2007
      lblQuickList.Caption := DKLangConstW('fOrderSaveQuick_Common_List_for') + DGroupName; //kt added 8/8/2007
      lstQuickList.Caption := lblQuickList.Caption;
      lblDisplayName.Font.Color := clGrayText;
      txtDisplayName.Enabled := False;
      txtDisplayName.Color := clBtnFace;
      with lstQuickList do
      begin
        LoadQuickListForOD(Items, ADisplayGroup);
        ItemIndex := 0;
      end;
      ShowModal;
      if OKPressed then
      begin
        Result := True;
        // replace the user's quick list with this new quick list
        SaveQuickListForOD(lstQuickList.Items, ADisplayGroup);
      end; {if OKPressed}
    end; {with frmSaveQuickOrder}
  finally
    frmSaveQuickOrder.Release;
  end;
end;

function SaveAsQuickOrder(ResponseSet: TResponses): Boolean;
const
  EMPTY_CRC = 'FFFFFFFF';
var
  frmSaveQuickOrder: TfrmSaveQuickOrder;
  DGroupName, QuickName, CRC: string;
  NewIEN, AnIndex, i: Integer;
  IsClinicOrder: boolean;
begin
  SetupVars;  //kt added 8/8/2007 to replace constants with vars.
  Result := False;
  CRC := ResponseSet.OrderCRC;
  IsClinicOrder := False;
  if CRC = EMPTY_CRC then
  begin
    InfoBox(TX_NO_TEXT, TC_NO_TEXT, MB_OK);
    Exit;
  end;
  frmSaveQuickOrder := TfrmSaveQuickOrder.Create(Application);
  try
    ResizeFormToFont(TForm(frmSaveQuickOrder));
    with frmSaveQuickOrder do
    begin
      if (ResponseSet.DisplayGroup = ClinDisp) and (ResponseSet.Dialog = 'PSJI OR PAT FLUID OE') then
        begin
          ResponseSet.DisplayGroup := IVDisp;
          IsClinicOrder := True;
        end;
      if ResponseSet.DisplayGroup = ClinDisp then
        DGroupName := NameOfDGroup(InptDisp)
      else
        DGroupName := NameOfDGroup(ResponseSet.DisplayGroup);
//    Caption := 'Add Quick Order (' + DGroupName + ')';  <-- original line.  //kt 8/8/2007
      Caption := DKLangConstW('fOrderSaveQuick_Add_Quick_Order_x') + DGroupName + ')'; //kt added 8/8/2007
//    lblQuickList.Caption := 'Common List for ' + DGroupName;  <-- original line.  //kt 8/8/2007
      lblQuickList.Caption := DKLangConstW('fOrderSaveQuick_Common_List_for') + DGroupName; //kt added 8/8/2007
      lstQuickList.Caption := lblQuickList.Caption;
      QuickName := GetQuickName(CRC);
      memOrder.Text := ResponseSet.OrderText;
      txtDisplayName.Text := QuickName;
      with lstQuickList do
      begin
        if ResponseSet.DisplayGroup = ClinDisp then
          LoadQuickListForOD(Items, InptDisp)
        else
          LoadQuickListForOD(Items, ResponseSet.DisplayGroup);
        if Length(QuickName) > 0
          then Items.Insert(0, '-1^' + QuickName)
//        else Items.Insert(0, '-1^<New Quick Order>');  <-- original line.  //kt 8/8/2007
          else Items.Insert(0, '-1^'+DKLangConstW('fOrderSaveQuick_xNew_Quick_Orderx')); //kt added 8/8/2007
        ItemIndex := 0;
      end;
      ShowModal;
      if OKPressed then
      begin
        Result := True;
        // save reponses as quick order
        ResponseSet.SaveQuickOrder(NewIEN, txtDisplayName.Text);
        // find the new quick order and set the new IEN
        AnIndex := -1;
        with lstQuickList do for i := 0 to Items.Count - 1 do
          if GetIEN(i) = -1 then AnIndex := i;
        if AnIndex > -1 then lstQuickList.Items[AnIndex] := IntToStr(NewIEN) + U +
                                                            txtDisplayName.Text;
        // replace the user's quick list with this new quick list
        if ResponseSet.DisplayGroup = ClinDisp then
          SaveQuickListForOD(lstQuickList.Items, InptDisp)
        else
          SaveQuickListForOD(lstQuickList.Items, ResponseSet.DisplayGroup);
      end; {if OKPressed}
      if IsClinicOrder = True then ResponseSet.DisplayGroup := ClinDisp;
    end; {with frmSaveQuickOrder}
  finally
    frmSaveQuickOrder.Release;
  end;
end;

procedure TfrmSaveQuickOrder.txtDisplayNameChange(Sender: TObject);
var
  AnIndex, i: Integer;
begin
  inherited;
  if txtDisplayName.Text = '' then Exit;
  AnIndex := -1;
  with lstQuickList do for i := 0 to Items.Count - 1 do
    if GetIEN(i) = -1 then AnIndex := i;
  if AnIndex > -1 then lstQuickList.Items[AnIndex] := '-1^' + txtDisplayName.Text;
end;

procedure TfrmSaveQuickOrder.cmdUpClick(Sender: TObject);
var
  NewIndex: Integer;
begin
  inherited;
  with lstQuickList do
  begin
    if ItemIndex < 1 then Exit;
    NewIndex := ItemIndex - 1;
    Items.Move(ItemIndex, NewIndex);
    ItemIndex := NewIndex;
  end;
end;

procedure TfrmSaveQuickOrder.cmdDownClick(Sender: TObject);
var
  NewIndex: Integer;
begin
  inherited;
  with lstQuickList do
  begin
    if ItemIndex > Items.Count - 2 then Exit;
    NewIndex := ItemIndex + 1;
    Items.Move(ItemIndex, NewIndex);
    ItemIndex := NewIndex;
  end;
end;

procedure TfrmSaveQuickOrder.cmdRenameClick(Sender: TObject);
var
  AName: string;
begin
  SetupVars;  //kt added 8/8/2007 to replace constants with vars.
  inherited;
  with lstQuickList do
  begin
    if ItemIndex < 0 then Exit;
    AName := Piece(Items[ItemIndex], U, 2);
    if ExecuteRename(AName, TX_QO_RENAME)
      then Items[ItemIndex] := Piece(Items[ItemIndex], U, 1) + U + AName;
  end;
end;

procedure TfrmSaveQuickOrder.cmdDeleteClick(Sender: TObject);
begin
  SetupVars;  //kt added 8/8/2007 to replace constants with vars.
  inherited;
  with lstQuickList do
  begin
    if ItemIndex < 0 then Exit;
    if ItemIEN = -1 then
    begin
      InfoBox(TX_NO_DEL_NEW, TC_NO_DEL_NEW, MB_OK);
      Exit;
    end;
    if InfoBox(TX_DEL_CONFIRM + DisplayText[ItemIndex], TC_DEL_CONFIRM,
      MB_YESNO or MB_ICONQUESTION) = IDYES then Items.Delete(ItemIndex);
  end;
end;

procedure TfrmSaveQuickOrder.FormCreate(Sender: TObject);
begin
  inherited;
  OKPressed := False;
end;

procedure TfrmSaveQuickOrder.cmdOKClick(Sender: TObject);
begin
  SetupVars;  //kt added 8/8/2007 to replace constants with vars.
  inherited;
  if txtDisplayName.Enabled and (txtDisplayName.Text = '') then
  begin
    InfoBox(TX_DNAME_REQ, TC_DNAME_REQ, MB_OK);
    Exit;
  end;
  OKPressed := True;
  Close;
end;

procedure TfrmSaveQuickOrder.cmdCancelClick(Sender: TObject);
begin
  inherited;
  Close;
end;

procedure TfrmSaveQuickOrder.pnlUpButtonEnter(Sender: TObject);
begin
  inherited;
  TPanel(Sender).BevelOuter := bvRaised;
end;

procedure TfrmSaveQuickOrder.pnlUpButtonExit(Sender: TObject);
begin
  inherited;
  TPanel(Sender).BevelOuter := bvNone;
end;

end.
