//kt -- Modified with SourceScanner on 7/7/2007
unit fActivateDeactivate;

interface

uses
  Windows, Messages, SysUtils, StrUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, fAutoSz, StdCtrls, ExtCtrls, ORCtrls,ORFn, rCore, uCore, oRNet, Math, fOrders, ORClasses, rOrders,
  fMeds, rMeds, DKLang;

type
  TfrmActivateDeactive = class(TfrmAutoSz)
    TActivate: TButton;
    TDeactive: TButton;
    Memo1: TMemo;
    TCancel: TButton;
    DKLanguageController1: TDKLanguageController;
    procedure TActivateClick(Sender: TObject);
    procedure TDeactiveClick(Sender: TObject);
    procedure TCancelClick(Sender: TObject);
  private
    { Private declarations }
    procedure GetOriginalOrders(OrderID: TStringList; var OriginalOrder: TORStringList);
    procedure BuildForm(Str1: String);
    function PromptForm(Text: String): String;
  public
     { Public declarations }

    procedure fActivateDeactive(OrderID: TStringList); overload;
    procedure fActivateDeactive(OrderID: TStringList; AList: TListBox); overload;
  end;

var
  frmActivateDeactive: TfrmActivateDeactive;
  Act: Boolean;
  Deact: Boolean;
  CancelProcess: Boolean;

implementation

{$R *.dfm}

{ TfrmActivateDeactive }

procedure TfrmActivateDeactive.BuildForm(Str1: String);
var
 str: string;
begin
  with frmActivateDeactive do
     begin
//      str := 'This order ' + str1 +' is currently in a pending status. ';  <-- original line.  //kt 7/7/2007
        str := DKLangConstW('fActivateDeactivate_This_order_') + str1 +DKLangConstW('fActivateDeactivate__is_currently_in_a_pending_status_'); //kt added 7/7/2007
//      str := str + CRLF + 'If this order is discontinued, the original order status will be changed to active, unless it is discontinued.';  <-- original line.  //kt 7/7/2007
        str := str + CRLF + DKLangConstW('fActivateDeactivate_If_this_order_is_discontinued_the_original_order_status_will_be_changed_to_active_unless_it_is_discontinued'); //kt added 7/7/2007
//      str := str + CRLF + CRLF + 'Click:';  <-- original line.  //kt 7/7/2007
        str := str + CRLF + CRLF + DKLangConstW('fActivateDeactivate_Click'); //kt added 7/7/2007
//      str := str + CRLF + '     "Yes" to discontinue the original order';  <-- original line.  //kt 7/7/2007
        str := str + CRLF + DKLangConstW('fActivateDeactivate_Yes_to_discontinue_the_original_order'); //kt added 7/7/2007
//      str := str + CRLF + '     "No" to change the status to active';  <-- original line.  //kt 7/7/2007
        str := str + CRLF + DKLangConstW('fActivateDeactivate_No_to_change_the_status_to_active'); //kt added 7/7/2007
//      str := str + CRLF + '     "Cancel" to stop the discontinue process for this order';  <-- original line.  //kt 7/7/2007
        str := str + CRLF + DKLangConstW('fActivateDeactivate_Cancel_to_stop_the_discontinue_process_for_this_order'); //kt added 7/7/2007
        Memo1.ReadOnly := False;
        Memo1.Text := str;
        Memo1.ReadOnly := True;
     end;
    ResizeAnchoredFormToFont(frmActivateDeactive);
    frmActivateDeactive.ShowModal;
    frmActivateDeactive.Release;
end;

procedure TfrmActivateDeactive.fActivateDeactive(OrderID: TStringList);
var
i,j,Pos: integer;
tmpArr: TORStringList;
ActDeact: string;
AnOrder,AnOrder1: TOrder;
begin
  //called from order tab
  tmpArr := TORStringList.Create;
  GetOriginalOrders(OrderID,tmpArr);
      with forders.frmOrders.lstOrders do for i := 0 to items.Count-1 do if Selected[i] then
        begin
          AnOrder := TOrder(Items.Objects[i]);
          Pos := tmpArr.IndexOfPiece(AnOrder.ID,U,1);
          if Pos > -1 then
            begin
              ActDeact := PromptForm(AnOrder.Text);
              if ActDeact = 'D' then
                begin
                  for j := 0 to forders.frmOrders.lstOrders.Items.Count-1 do
                    begin
                      AnOrder1 := TOrder(forders.frmOrders.lstOrders.Items.Objects[j]);
                      if AnOrder1.ID = Piece(tmpArr.Strings[Pos],U,2) then
                        forders.frmOrders.lstOrders.Selected[j] := True;
                    end;
                end;
              if ActDeact = 'C' then Selected[i] := False;
            end;
        end;
end;

procedure TfrmActivateDeactive.fActivateDeactive(OrderID: TStringList; AList: TListBox);
var
i,j,Pos: integer;
tmpArr: TORStringList;
ActDeact: String;
AMed,AMed1: TMedListRec;
begin
  //called from Med tab
  tmpArr := TORStringList.Create;
  GetOriginalOrders(OrderID,tmpArr);
      with AList do for i := 0 to items.Count-1 do if Selected[i] then
        begin
          AMed := TMedListRec(Items.Objects[i]);
          Pos := tmpArr.IndexOfPiece(AMed.OrderID,U,1);
          if Pos > -1 then
            begin
              ActDeact := PromptForm(Alist.Items.Strings[i]);
              if ActDeact = 'D' then
                begin
                  for j := 0 to Alist.Items.Count-1 do
                    begin
                      AMed1 := TMedListRec(Alist.Items.Objects[j]);
                      if AMed1.OrderID = Piece(tmpArr.Strings[Pos],U,2) then
                        begin
                          Alist.Selected[j] := True;
                          break;
                        end;
                      //some med orders may not have an action defined tends to be renew order of orders that were renew from another
                      //order and outpatient orders
                      if (AMed1.OrderID = Piece(Piece(tmpArr.Strings[Pos],U,2),';',1)) then
                        begin
                          Alist.Selected[j] := True;
                          break;
                        end;

                    end;
                end;
              if ActDeact = 'C' then Selected[i] := False;
            end;
        end;
end;

procedure TfrmActivateDeactive.GetOriginalOrders(OrderID: TStringList; var OriginalOrder: TORStringList);
var
i: integer;
begin
  CallV('ORWDX1 DCREN', [OrderID]);
  for i := 0 to RPCBrokerV.Results.Count-1 do
    OriginalOrder.Add(RPCBrokerV.Results.Strings[i]);
end;

function TfrmActivateDeactive.PromptForm(Text: String): String;
begin
  frmActivateDeactive := TfrmActivateDeactive.create(Application);
  BuildForm(Text);
  if Deact = True then Result := 'D';
  if Act = True then Result := 'A';
  if CancelProcess = True then Result := 'C';
end;

procedure TfrmActivateDeactive.TActivateClick(Sender: TObject);
begin
  inherited;
   Act := True;
   Deact := False;
   CancelProcess := False;
   frmActivateDeactive.Close;
end;

procedure TfrmActivateDeactive.TDeactiveClick(Sender: TObject);
begin
  inherited;
   Act := False;
   Deact := True;
   CancelProcess := False;
   frmActivateDeactive.Close;
end;

procedure TfrmActivateDeactive.TCancelClick(Sender: TObject);
begin
  inherited;
  Act := False;
  Deact := False;
  CancelProcess := True;
  frmActivateDeactive.Close;
end;

end.
