//kt -- Modified with SourceScanner on 7/15/2007
unit fDefaultEvent;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ORCtrls, ExtCtrls, rOrders, ORFn, uCore, DKLang;

type
  TfrmDefaultEvent = class(TForm)
    pnlTop: TPanel;
    lblCaption: TLabel;
    cboEvents: TORComboBox;
    pnlBottom: TPanel;
    btnOK: TButton;
    btnCancel: TButton;
    DKLanguageController1: TDKLanguageController;
    procedure btnCancelClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure btnOKClick(Sender: TObject);
  private
    //kt Begin Mod (change Consts to Vars) 7/15/2007
    TXT_1  : string;  //kt
    TXT_2  : string;  //kt
    TXT_3  : string;  //kt
    //kt End Mod -------------------
    OKPressed: boolean;
    FDefaultEvtName:    string;
    FPreDefaultEvtID:   string;
    FPreDefaultEvtName: string;
    procedure SetupVars;  //kt 7-15-07
  public
    { Public declarations }
  end;

function ExcueteDefaultEvntSetting: string;

var
  frmDefaultEvent: TfrmDefaultEvent;

implementation

{$R *.DFM}

function ExcueteDefaultEvntSetting: string;
var
  frmDefaultEvent: TfrmDefaultEvent;
begin
  frmDefaultEvent := TfrmDefaultEvent.Create(Application);
  try
    ResizeAnchoredFormToFont(frmDefaultEvent);
    frmDefaultEvent.ShowModal;
    Result := frmDefaultEvent.FDefaultEvtName;
  finally
    frmDefaultEvent.Free;
  end;
end;

procedure TfrmDefaultEvent.btnCancelClick(Sender: TObject);
begin
  Close;
end;

procedure TfrmDefaultEvent.FormCreate(Sender: TObject);
var
  i : integer;
begin
  FPreDefaultEvtID    := '';
  FPreDefaultEvtName  := '';
  FDefaultEvtName     := '';
  FPreDefaultEvtID := GetDefaultEvt(IntToStr(User.DUZ));
  ListSpecialtiesED(#0,cboEvents.Items);
  with cboEvents do
  begin
    for i := 0 to Items.Count - 1 do
    begin
      if FPreDefaultEvtID = Piece(Items[i],'^',1) then
      begin
        ItemIndex := i;
        FPreDefaultEvtName := Piece(Items[i],'^',9);
        if Length(FPreDefaultEvtName)<1 then
          FPreDefaultEvtName := Piece(Items[i],'^',2);
        break;
      end;
    end;
  end;
  OKPressed := False;
end;

procedure TfrmDefaultEvent.SetupVars;
//kt Added entire function to replace constant declarations 7/15/2007
begin
  SetupVars;  //kt added 7/15/2007 to replace constants with vars.
  TXT_1 := DKLangConstW('fDefaultEvent_Would_you_like_to_change_the_default_event_from_');
  TXT_2 := DKLangConstW('fDefaultEvent__to_');
  TXT_3 := DKLangConstW('fDefaultEvent_Would_you_like_set_your_default_event_to_');
end;


procedure TfrmDefaultEvent.btnOKClick(Sender: TObject);
//const
//TXT_1 = 'Would you like to change the default event from "';  <-- original line.  //kt 7/15/2007
//TXT_2 = '" to "';  <-- original line.  //kt 7/15/2007
//TXT_3 = 'Would you like set your default event to "';  <-- original line.  //kt 7/15/2007
var
  errMsg: string;
begin
  if cboEvents.ItemIndex < 0 then
  begin
//  ShowMessage('You have to select an event first!');  <-- original line.  //kt 7/15/2007
    ShowMessage(DKLangConstW('fDefaultEvent_You_have_to_select_an_event_first')); //kt added 7/15/2007
    Exit;
  end;
  if (Piece(cboEvents.Items[cboEvents.ItemIndex],'^',1) <> FPreDefaultEvtID) and ( Length(FPreDefaultEvtID)>0 )then
  begin
//  if InfoBox(TXT_1 + FPreDefaultEvtName + TXT_2 + cboEvents.Text + '"?','Warning', MB_OKCANCEL or MB_ICONWARNING) = IDOK then  <-- original line.  //kt 7/15/2007
    if InfoBox(TXT_1 + FPreDefaultEvtName + TXT_2 + cboEvents.Text + '"?',DKLangConstW('fDefaultEvent_Warning'), MB_OKCANCEL or MB_ICONWARNING) = IDOK then //kt added 7/15/2007
    begin
      errMsg := '';
      SetDefaultEvent(errMsg, Piece(cboEvents.Items[cboEvents.ItemIndex],'^',1));
      if length(errMsg)>0 then
        ShowMessage(errMsg)
      else
//      ShowMessage('The default release event "' + cboEvents.Text + '" has been set successfully!');  <-- original line.  //kt 7/15/2007
        ShowMessage(DKLangConstW('fDefaultEvent_The_default_release_event_') + cboEvents.Text + DKLangConstW('fDefaultEvent__has_been_set_successfully')); //kt added 7/15/2007
      FDefaultEvtName := cboEvents.Text;
      OKPressed := True;
      Close;
    end;
  end
  else if (Piece(cboEvents.Items[cboEvents.ItemIndex],'^',1) <> FPreDefaultEvtID) and ( Length(FPreDefaultEvtID)=0 )then
  begin
//  if InfoBox(TXT_3 + cboEvents.Text + '"?','Warning', MB_OKCANCEL or MB_ICONWARNING) = IDOK then  <-- original line.  //kt 7/15/2007
    if InfoBox(TXT_3 + cboEvents.Text + '"?',DKLangConstW('fDefaultEvent_Warning'), MB_OKCANCEL or MB_ICONWARNING) = IDOK then //kt added 7/15/2007
    begin
      errMsg := '';
      SetDefaultEvent(errMsg, Piece(cboEvents.Items[cboEvents.ItemIndex],'^',1));
      if length(errMsg)>0 then
        ShowMessage(errMsg)
      else
//      ShowMessage('The default release event "' + cboEvents.Text + '" has been set successfully!');  <-- original line.  //kt 7/15/2007
        ShowMessage(DKLangConstW('fDefaultEvent_The_default_release_event_') + cboEvents.Text + DKLangConstW('fDefaultEvent__has_been_set_successfully')); //kt added 7/15/2007
     FDefaultEvtName := cboEvents.Text;
     OKPressed := True;
     Close;
    end;
  end;
end;

end.
