//kt -- Modified with SourceScanner on 7/17/2007
unit fDupPts;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics,
  Controls, Forms, Dialogs, StdCtrls, ORCtrls, ExtCtrls, OrFn, DKLang;

type
  TfrmDupPts = class(TForm)
    pnlDupPts: TPanel;
    btnOK: TButton;
    btnCancel: TButton;
    pnlSelDupPt: TPanel;
    lboSelPt: TORListBox;
    lblDupPts: TLabel;
    lblSelDupPts: TLabel;
    DKLanguageController1: TDKLanguageController;
    procedure btnCancelClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure btnOKClick(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure lboSelPtDblClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmDupPts: TfrmDupPts;

implementation

{$R *.dfm}

uses rCore, uCore, fPtSel;

procedure TfrmDupPts.btnCancelClick(Sender: TObject);
begin

close;

end;

procedure TfrmDupPts.FormCreate(Sender: TObject);
var
  theDups: tStringList;
begin
//fPtSel.DupDFN := 'Cancel'; // Pre-set as default.  <-- original line.  //kt 7/17/2007
  fPtSel.DupDFN := DKLangConstW('fDupPts_Cancel'); // Pre-set as default. //kt added 7/17/2007
  theDups := tStringList.create;
  theDups.assign(fPtSel.PtStrs);
  lboSelPt.items.assign(theDups);
  ResizeAnchoredFormToFont(self);
end;

procedure TfrmDupPts.btnOKClick(Sender: TObject);
begin

if not (Length(lboSelPt.ItemID) > 0) then  //*DFN*
begin
//infoBox('A patient has not been selected.', 'No Patient Selected', MB_OK);  <-- original line.  //kt 7/17/2007
  infoBox(DKLangConstW('fDupPts_A_patient_has_not_been_selectedx'), DKLangConstW('fDupPts_No_Patient_Selected'), MB_OK); //kt added 7/17/2007
  exit;
end;

fPtSel.DupDFN := lboSelPt.ItemID;  //*DFN*
close;

end;

procedure TfrmDupPts.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin

// Check for "Esc" keypress:
if (key = 27) then // ESC key.
  btnCancel.click;

end;

procedure TfrmDupPts.lboSelPtDblClick(Sender: TObject);
begin
  btnOKClick(btnOK);
end;

end.
