//kt -- Modified with SourceScanner on 7/19/2007
unit fNoteCPFields;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  fAutoSz, StdCtrls, ORCtrls, ORFn, ORDtTm, DKLang;

type
  TfrmNoteCPFields = class(TfrmAutoSz)
    lblAuthor: TLabel;
    cboAuthor: TORComboBox;
    lblProcSummCode: TOROffsetLabel;
    cboProcSummCode: TORComboBox;
    lblProcDateTime: TOROffsetLabel;
    calProcDateTime: TORDateBox;
    cmdOK: TButton;
    cmdCancel: TButton;
    DKLanguageController1: TDKLanguageController;
    procedure cmdCancelClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure cmdOKClick(Sender: TObject);
    procedure cboAuthorNeedData(Sender: TObject; const StartFrom: String;
      Direction, InsertAt: Integer);
  private
    //kt Begin Mod (change Consts to Vars) 7/19/2007
    TC_REQ_FIELDS            : string;  //kt
    TX_REQ_AUTHOR            : string;  //kt
    TX_NO_FUTURE             : string;  //kt
    TX_REQ_PROCSUMMCODE      : string;  //kt
    TX_REQ_PROCDATETIME      : string;  //kt
    TX_INVALID_PROCDATETIME  : string;  //kt
    TX_NO_PROC_FUTURE        : string;  //kt
    TX_REQ_CANCEL            : string;  //kt
    //kt End Mod -------------------
    FAuthor: int64;
    FProcSummCode: integer;
    FProcDateTime: TFMDateTime;
    FCPStatusFlag: integer;
    FOKPressed: Boolean;
    procedure ValidateFields(var ErrMsg: string);
    procedure SetupVars;  //kt
  end;

//const
//TC_REQ_FIELDS        = 'Required Information';  <-- original line.  //kt 7/19/2007
//TX_REQ_AUTHOR        = CRLF + 'The author of the note must be identified.';  <-- original line.  //kt 7/19/2007
//TX_NO_FUTURE         = CRLF + 'A reference date/time in the future is not allowed.';  <-- original line.  //kt 7/19/2007
//TX_REQ_PROCSUMMCODE  = CRLF + 'A procedure summary code for this procedure must be entered.';  <-- original line.  //kt 7/19/2007
//TX_REQ_PROCDATETIME  = CRLF + 'A valid date/time for the procedure must be entered.';  <-- original line.  //kt 7/19/2007
//TX_INVALID_PROCDATETIME = CRLF + 'If entered, the date/time for the procedure must be in a valid format.';  <-- original line.  //kt 7/19/2007
//TX_NO_PROC_FUTURE    = CRLF + 'A procedure date/time in the future is not allowed.';  <-- original line.  //kt 7/19/2007
//TX_REQ_CANCEL        = 'You will be required to enter these fields before the note can be saved or signed.' + CRLF +  <-- original line.  //kt 7/19/2007
//                       'Click the "Change" button to enter this information at any time while editing.';  <-- original line.  //kt 7/19/2007


procedure EnterClinProcFields(ACPStatusFlag: integer; ErrMsg: string; var AProcSummCode: integer; var AProcDate: TFMDateTime; var AnAuthor: int64);

implementation

{$R *.DFM}

uses rCore, uConst, uConsults, uCore;


procedure TfrmNoteCPFields.SetupVars;
//kt Added entire function to replace constant declarations 7/19/2007
begin
  TC_REQ_FIELDS        := DKLangConstW('fNoteCPFields_Required_Information');
  TX_REQ_AUTHOR        := CRLF + DKLangConstW('fNoteCPFields_The_author_of_the_note_must_be_identifiedx');
  TX_NO_FUTURE         := CRLF + DKLangConstW('fNoteCPFields_A_reference_datextime_in_the_future_is_not_allowedx');
  TX_REQ_PROCSUMMCODE  := CRLF + DKLangConstW('fNoteCPFields_A_procedure_summary_code_for_this_procedure_must_be_enteredx');
  TX_REQ_PROCDATETIME  := CRLF + DKLangConstW('fNoteCPFields_A_valid_datextime_for_the_procedure_must_be_enteredx');
  TX_INVALID_PROCDATETIME := CRLF + DKLangConstW('fNoteCPFields_If_enteredx_the_datextime_for_the_procedure_must_be_in_a_valid_formatx');
  TX_NO_PROC_FUTURE    := CRLF + DKLangConstW('fNoteCPFields_A_procedure_datextime_in_the_future_is_not_allowedx');
  TX_REQ_CANCEL        := DKLangConstW('fNoteCPFields_You_will_be_required_to_enter_these_fields_before_the_note_can_be_saved_or_signedx') + CRLF +
                         DKLangConstW('fNoteCPFields_Click_the_xChangex_button_to_enter_this_information_at_any_time_while_editingx');
end;


procedure EnterClinProcFields(ACPStatusFlag: integer; ErrMsg: string; var AProcSummCode: integer; var AProcDate: TFMDateTime; var AnAuthor: int64);
var
  frmNoteCPFields: TfrmNoteCPFields;
begin
  frmNoteCPFields := TfrmNoteCPFields.Create(Application);
  with frmNoteCPFields do
    try
      ResizeFormToFont(TForm(frmNoteCPFields));
      FCPStatusFlag := ACPStatusFlag;
      FProcSummCode := AProcSummCode;
      FProcDateTime := AProcDate;
      cboProcSummCode.SelectByIEN(AProcSummCode);
      calProcDateTime.FMDateTime := AProcDate;
      ShowModal;
      if FOKPressed then
      begin
        AnAuthor := FAuthor;
        AProcSummCode := FProcSummCode;
        AProcDate := FProcDateTime;
      end;
    finally
      Release;
    end;
end;

procedure TfrmNoteCPFields.FormCreate(Sender: TObject);
begin
  inherited;
  FOKPressed := False;
  cboAuthor.InitLongList(User.Name);
  cboAuthor.SelectByIEN(User.DUZ);
end;

procedure TfrmNoteCPFields.cmdOKClick(Sender: TObject);
var
  ErrMsg: string;
begin
  SetupVars;  //kt added 7/19/2007 to replace constants with vars.
  inherited;
  ValidateFields(ErrMsg);
  if ShowMsgOn(Length(ErrMsg) > 0, ErrMsg, TC_REQ_FIELDS)
    then Exit
    else
      begin
        FOKPressed := True;
        ModalResult := mrOK;
      end;
end;

procedure TfrmNoteCPFields.ValidateFields(var ErrMsg: string);
begin
  SetupVars;  //kt added 7/19/2007 to replace constants with vars.
  if cboAuthor.ItemIEN = 0   then ErrMsg := ErrMsg + TX_REQ_AUTHOR else FAuthor := cboAuthor.ItemIEN;
  if (FCPStatusFlag = CP_INSTR_INCOMPLETE) then
    begin
      if cboProcSummCode.ItemIEN = 0 then ErrMsg := ErrMsg + TX_REQ_PROCSUMMCODE
        else FProcSummCode := cboProcSummCode.ItemIEN;
      if not calProcDateTime.IsValid then ErrMsg := ErrMsg + TX_REQ_PROCDATETIME
       else if calProcDateTime.IsValid and (calProcDateTime.FMDateTime > FMNow) then ErrMsg := ErrMsg + TX_NO_PROC_FUTURE
       else FProcDateTime := calProcDateTime.FMDateTime;
    end
  else
    begin
      FProcSummCode := cboProcSummCode.ItemIEN;
      if (calProcDateTime.FMDateTime > 0) then
        begin
          if (not calProcDateTime.IsValid) then ErrMsg := ErrMsg + TX_INVALID_PROCDATETIME
           else if calProcDateTime.IsValid and (calProcDateTime.FMDateTime > FMNow) then ErrMsg := ErrMsg + TX_NO_PROC_FUTURE
           else FProcDateTime := calProcDateTime.FMDateTime;
        end;
    end;
end;

procedure TfrmNoteCPFields.cmdCancelClick(Sender: TObject);
var
  ErrMsg: string;
begin
  SetupVars;  //kt added 7/19/2007 to replace constants with vars.
  inherited;
  ValidateFields(ErrMsg);
  if ErrMsg <> '' then
    InfoBox(TX_REQ_CANCEL, TC_REQ_FIELDS, MB_OK or MB_ICONWARNING);
  FOKPressed := False;
  Close;
end;

procedure TfrmNoteCPFields.cboAuthorNeedData(Sender: TObject;
  const StartFrom: String; Direction, InsertAt: Integer);
begin
  (Sender as TORComboBox).ForDataUse(SubSetOfPersons(StartFrom, Direction));
end;

end.
