//kt -- Modified with SourceScanner on 7/19/2007
unit fNoteCslt;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  fAutoSz, StdCtrls, ORCtrls, ORFn, DKLang;

type
  TfrmNoteConsult = class(TfrmAutoSz)
    Label1: TStaticText;
    Label2: TStaticText;
    lstRequests: TORListBox;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    cmdOK: TButton;
    cmdCancel: TButton;
    Label6: TLabel;
    Label7: TLabel;
    procedure cmdCancelClick(Sender: TObject);
    procedure cmdOKClick(Sender: TObject);
    procedure lstRequestsClick(Sender: TObject);
  private
    { Private declarations }
    FSelectedRequest: Integer;
 public
    { Public declarations }
  end;

function SelectConsult: Integer;

implementation

{$R *.DFM}

uses rTIU;

//const
//TX_NO_REQUEST = 'There are no consult requests available for this patient.' + CRLF +  <-- original line.  //kt 7/19/2007
//                 'Another progress note title must be selected.';  <-- original line.  //kt 7/19/2007
//TX_NO_REQUEST_CAP = 'No Consult Requests';  <-- original line.  //kt 7/19/2007

//kt Begin Mod (change Consts to Vars) 7/19/2007
var
  TX_NO_REQUEST      : string;  //kt
  TX_NO_REQUEST_CAP  : string;  //kt
//kt End Mod -------------------


procedure SetupVars;
//kt Added entire function to replace constant declarations 7/19/2007
begin
  TX_NO_REQUEST := DKLangConstW('fNoteCslt_There_are_no_consult_requests_available_for_this_patientx') + CRLF +
                   DKLangConstW('fNoteCslt_Another_progress_note_title_must_be_selectedx');
  TX_NO_REQUEST_CAP := DKLangConstW('fNoteCslt_No_Consult_Requests'); 
end;
 
function SelectConsult: Integer;
var
  frmNoteConsult: TfrmNoteConsult;
  AConsultList: TStringList;
begin
  SetupVars;  //kt added 7/19/2007 to replace constants with vars.
  Result := 0;
  frmNoteConsult := TfrmNoteConsult.Create(Application);
  AConsultList := TStringList.Create;
  try
    ListConsultRequests(AConsultList);
    if AConsultList.Count > 0 then
    begin
      ResizeFormToFont(TForm(frmNoteConsult));
      frmNoteConsult.lstRequests.Items.Assign(AConsultList);
      frmNoteConsult.ShowModal;
      Result := frmNoteConsult.FSelectedRequest;
    end
    else InfoBox(TX_NO_REQUEST, TX_NO_REQUEST_CAP, MB_OK);
  finally
    frmNoteConsult.Release;
    AConsultList.Free;
  end;
end;

procedure TfrmNoteConsult.lstRequestsClick(Sender: TObject);
begin
  inherited;
  if lstRequests.ItemIEN > 0 then cmdOK.Enabled := True else cmdOK.Enabled := False;
end;

procedure TfrmNoteConsult.cmdOKClick(Sender: TObject);
begin
  inherited;
  FSelectedRequest := lstRequests.ItemIEN;
  Close;
end;

procedure TfrmNoteConsult.cmdCancelClick(Sender: TObject);
begin
  inherited;
  FSelectedRequest := 0;
  Close;
end;

end.
