//kt -- Modified with SourceScanner on 8/7/2007
unit fSignItem;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ORFn, rCore, Hash, ORCtrls, DKLang;

type
  TfrmSignItem = class(TForm)
    txtESCode: TCaptionEdit;
    lblESCode: TLabel;
    cmdOK: TButton;
    cmdCancel: TButton;
    lblText: TMemo;
    DKLanguageController1: TDKLanguageController;
    procedure cmdOKClick(Sender: TObject);
    procedure cmdCancelClick(Sender: TObject);
  private
    //kt Begin Mod (change Consts to Vars) 8/7/2007
    TX_INVAL_MSG  : string;  //kt
    TX_INVAL_CAP  : string;  //kt
    //kt End Mod -------------------
    FESCode: string;
    procedure SetupVars;  //kt
  public
    { Public declarations }
  end;

procedure SignatureForItem(FontSize: Integer; const AText, ACaption: string; var ESCode: string);

implementation

{$R *.DFM}

//const
//TX_INVAL_MSG = 'Not a valid electronic signature code.  Enter a valid code or press Cancel.';  <-- original line.  //kt 8/7/2007
//TX_INVAL_CAP = 'Unrecognized Signature Code';  <-- original line.  //kt 8/7/2007

procedure TfrmSignItem.SetupVars;
//kt Added entire function to replace constant declarations 8/7/2007
begin
  TX_INVAL_MSG := DKLangConstW('fSignItem_Not_a_valid_electronic_signature_codex__Enter_a_valid_code_or_press_Cancelx');
  TX_INVAL_CAP := DKLangConstW('fSignItem_Unrecognized_Signature_Code'); 
end;
 
procedure SignatureForItem(FontSize: Integer; const AText, ACaption: string; var ESCode: string);
var
  frmSignItem: TfrmSignItem;
begin
  frmSignItem := TfrmSignItem.Create(Application);
  try
    ResizeAnchoredFormToFont(frmSignItem);
    with frmSignItem do
    begin
      FESCode := '';
      Caption := ACaption;
      lblText.Text := AText;
      ShowModal;
      ESCode := FESCode;
    end;
  finally
    frmSignItem.Release;
  end;
end;

procedure TfrmSignItem.cmdOKClick(Sender: TObject);
begin
  SetupVars;  //kt added 8/7/2007 to replace constants with vars.
  if not ValidESCode(txtESCode.Text) then
  begin
    InfoBox(TX_INVAL_MSG, TX_INVAL_CAP, MB_OK);
    txtESCode.SetFocus;
    txtESCode.SelectAll;
    Exit;
  end;
  FESCode := Encrypt(txtESCode.Text);
  Close;
end;

procedure TfrmSignItem.cmdCancelClick(Sender: TObject);
begin
  FESCode := '';
  Close;
end;

end.
