unit uOrPtf;   //PRF

interface

uses SysUtils, Windows, Classes, Forms, ORFn, ORNet, uCore;

Type
  TPatientFlag = Class(TObject)
  private
    FFlagID:   string;
    FName: string;
    FNarr: TStringList;
    FFlagIndex: integer;
  public
    property FlagID: string      read FFlagID  write FFlagID;
    property Name:   string      read FName    write FName;
    property Narr:   TStringList read FNarr    write FNarr;
    property FlagIndex: integer  read FFlagIndex write FFlagIndex;
    constructor Create;
    procedure Clearup;
  end;

procedure HasActiveFlg(var FlagList: TStringList; var HasFlag: boolean; const PTDFN: string);
function GetCatIFlag(var FlagArr: TStrings): integer;
procedure GetActiveFlg(FlagInfo: TStrings; const PTDFN, FlagRecordID: string);
procedure ClearFlag;

implementation

procedure HasActiveFlg(var FlagList: TStringList; var HasFlag: boolean; const PTDFN: string);
begin
  FlagList.Clear;
  HasFlag := False;
  CallV('ORPRF HASFLG',[PTDFN]);
  if RPCBrokerV.Results.Count > 0 then
  begin
    FlagList.Assign(RPCBrokerV.Results);
    HasFlag := True;
  end;
end;

function GetCatIFlag(var FlagArr: TStrings): integer;
begin
  Result := 0;
  CallV('ORPRF HASCAT1',[nil]);
  if RPCBrokerV.Results.Count < 1 then
    Exit;
  Result := StrToIntDef(Piece(RPCBrokerV.Results[0],'^',2),0);
  RPCBrokerV.Results.Delete(0);
  FlagArr.Assign(RPCBrokerV.Results);
end;

procedure TPatientFlag.Clearup;
begin
  FFlagID := '0';
  FName   := '';
  FNarr.Clear;
  FFlagIndex := -1;
end;

constructor TPatientFlag.Create;
begin
  FFlagID   := '0';
  FName := '';
  FNarr := TStringList.Create;
  FFlagIndex := -1;
end;

procedure GetActiveFlg(FlagInfo: TStrings; const PTDFN, FlagRecordID: string);
begin
  CallV('ORPRF GETFLG', [PTDFN,FlagRecordID]);
  if RPCBrokerV.Results.Count > 0 then
    FlagInfo.Assign(RPCBrokerV.Results);
end;

procedure ClearFlag;
begin
  sCallV('ORPRF CLEAR',[nil]);
end;

end.
