unit ShowConstsU;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, ExtCtrls;

type
  TConstantsOutputForm = class(TForm)
    Panel1: TPanel;
    ConstantsMemo: TMemo;
    OpenButton: TBitBtn;
    SaveButton: TBitBtn;
    ClearButton: TBitBtn;
    OKButton: TBitBtn;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    SaveAsBitBtn: TBitBtn;
    procedure OpenButtonClick(Sender: TObject);
    procedure ClearButtonClick(Sender: TObject);
    procedure SaveButtonClick(Sender: TObject);
    procedure OKButtonClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure SaveAsBitBtnClick(Sender: TObject);
  private
    { Private declarations }
    ConstantsText : AnsiString;
    ConstantsFileName : string;
  public
    { Public declarations }
    procedure AddConst(constSName,constStr : string);
    function NeedsSave: boolean;
  end;

var
  ConstantsOutputForm: TConstantsOutputForm;

implementation

{$R *.dfm}

procedure TConstantsOutputForm.OpenButtonClick(Sender: TObject);
begin
  //CHANGE--first ask user "SURE?"
  if OpenDialog1.Execute then begin
    ConstantsFileName := OpenDialog1.FileName;
    ConstantsMemo.Lines.LoadFromFile(ConstantsFileName);
  end;
end;

procedure TConstantsOutputForm.ClearButtonClick(Sender: TObject);
var choice : integer;
begin
  choice := mrYes;
  if NeedsSave then choice := MessageDlg('Clear Current Constants? (This can not be undone.)',
       mtConfirmation, [mbYes,mbNo,mbCancel], 0);
  if choice=mrYes then ConstantsMemo.Lines.Clear;
end;

procedure TConstantsOutputForm.SaveButtonClick(Sender: TObject);
begin
  if ConstantsFileName <> '' then ConstantsMemo.Lines.SaveToFile(ConstantsFileName);
  ConstantsText:=ConstantsMemo.Text;  // tracks if save needed.
end;

procedure TConstantsOutputForm.SaveAsBitBtnClick(Sender: TObject);
begin
  if SaveDialog1.Execute then begin
    ConstantsFileName := SaveDialog1.FileName;
    ConstantsMemo.Lines.SaveToFile(ConstantsFileName);
    ConstantsText:=ConstantsMemo.Text;  // tracks if save needed.
  end;
end;

procedure TConstantsOutputForm.OKButtonClick(Sender: TObject);
begin
  ConstantsOutputForm.Hide;
end;


procedure TConstantsOutputForm.AddConst(constSName,constStr : string);
var  tempS : string;
begin
  tempS := constSName+'='+constStr;
  if ConstantsMemo.Lines.IndexOf(tempS)<0 then begin
    ConstantsMemo.Lines.Add(tempS);
  end;
end;

function TConstantsOutputForm.NeedsSave: boolean;
begin
  Result := ConstantsMemo.Modified;
  //Result := (ConstantsText=ConstantsMemo.Text);
end;


procedure TConstantsOutputForm.FormCreate(Sender: TObject);
var choice: integer;
begin
  choice := MessageDlg('Open Existing Constants File?', mtCustom, [mbYes,mbNo], 0);
  if choice=mrYes then OpenButtonClick(Sender);
end;


end.
