unit fWebTab;
//kt Added entire unit and form.

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, OleCtrls, SHDocVw, StdCtrls,fPage;

type
  TfrmWebTab = class(TfrmPage)
    WebBrowser: TWebBrowser;
  private
    { Private declarations }
  public
    { Public declarations }
    Procedure RequestPrint; override;
    Procedure NagivateTo(URL: Widestring);
  end;

function AskServerForURLs(URLList : TStringList) : string;

var
  frmWebTabs: TList;

  TMG_URL_RPC_Available : boolean;
  TMG_URL_RPC_Checked : boolean;

implementation

{$R *.dfm}
uses ORNet,ORFn,Trpcb,uConst;


Procedure TfrmWebTab.RequestPrint;
begin
  inherited;
  MessageDlg('Finish code: request printing from web browser...',mtInformation,[mbOK],0);
end;


Procedure TfrmWebTab.NagivateTo(URL: WideString);
begin
  WebBrowser.Navigate(URL);
end;

//=================================================================
//===== Globally available functions, not part of object ==========
//=================================================================

function AskServerForURLs(URLList : TStringList) : string;
//Get URL list from server.
//URLList is filled with RPCBroker.Results.  Should have this format:
//     URLList(0)='1^Success' pr '0^Failure'
//     URLList(1)="URL#1"  a URL to display in tab 1
//     URLList(2)="URL#2"  a URL to display in tab 2
//     URLList(3)="URL#3"  a URL to display in tab 3
//  Note: if URL='<!HIDE!>' then server is requesting tab to be hidden
//Results of Fn: Returns '1^Success' if success, or '0^ErrorMessage'
var
    RPCResult              : AnsiString;
    i                      : integer;
begin
  if TMG_URL_RPC_Checked = false then begin
    RPCBrokerV.remoteprocedure := 'XWB IS RPC AVAILABLE';
    RPCBrokerV.Param[0].Value := 'TMG CPRS GET URL LIST';
    RPCBrokerV.Param[0].ptype := literal;
    RPCBrokerV.Param[1].Value := 'R';
    RPCBrokerV.Param[1].ptype := literal;
    RPCResult := RPCBrokerV.StrCall;   {returns 1 if available, 0 if not available}
    TMG_URL_RPC_Checked := true;
    TMG_URL_RPC_Available := (RPCResult='1');
  end;

  if TMG_URL_RPC_Available= true then begin
    if (URLList <> nil) then begin
      RPCBrokerV.remoteprocedure := 'TMG CPRS GET URL LIST';
      RPCBrokerV.Call;
      URLList.Assign(RPCBrokerV.Results);
      if RPCBrokerV.Results.Count>0 then Result := RPCBrokerV.Results.Strings[0]
      else Result := '-1^Error: No URL''s returned from server.';
    end else begin
      Result := '0^Invalid TStringList URLList passed';
    end;
  end else begin
    Result := '-1^"TMG CPRS GET URL LIST" RPC Not available on server';
  end;
end;


initialization
  TMG_URL_RPC_Available := false;  //default to not avail.
  TMG_URL_RPC_Checked := false;   //default to not checked.
  frmWebTabs := TList.Create;
  frmWebTabs.Count := CT_LAST_WEBTAB-CT_WEBTAB1+1;   //fill up list with nil pointers
finalization
  frmWebTabs.Free;
end.

