CCRVA200 ;WV/CCDCCR/SMH - Routine to get Provider Data;07/13/2008
	;;0.1;CCDCCR;;JUL 13, 2007;Build 0

	; This routine uses Kernel APIs and Direct Global Access to get
	; Proivder Data from File 200.

	; The Global is VA(200,*)

FAMILY(DUZ) ; Get Family Name; PUBLIC; EXTRINSIC
	; INPUT: DUZ (i.e. File 200 IEN) ByVal
	; OUTPUT: String
	N NAME S NAME=$P(^VA(200,DUZ,0),U)
	D NAMECOMP^XLFNAME(.NAME)
	Q NAME("FAMILY")
	;
GIVEN(DUZ) ; Get Given Name; PUBLIC; EXTRINSIC
	; INPUT: DUZ ByVal
	; OUTPUT: String
	N NAME S NAME=$P(^VA(200,DUZ,0),U)
	D NAMECOMP^XLFNAME(.NAME)
	Q NAME("GIVEN")
	;
MIDDLE(DUZ) ; Get Middle Name, PUBLIC; EXTRINSIC
	; INPUT: DUZ ByVal
	; OUTPUT: String
	N NAME S NAME=$P(^VA(200,DUZ,0),U)
	D NAMECOMP^XLFNAME(.NAME)
	Q NAME("MIDDLE")
	;
SUFFIX(DUZ) ; Get Suffix Name, PUBLIC; EXTRINSIC
	; INPUT: DUZ ByVal
	; OUTPUT: String
	N NAME S NAME=$P(^VA(200,DUZ,0),U)
	D NAMECOMP^XLFNAME(.NAME)
	Q NAME("SUFFIX")
	;
TITLE(DUZ) ; Get Title for Proivder, PUBLIC; EXTRINSIC
	; INPUT: DUZ ByVal
	; OUTPUT: String
	; Gets External Value of Title field in New Person File.
	; It's actually a pointer to file 3.1
	; 200=New Person File; 8 is Title Field
	Q $$GET1^DIQ(200,DUZ_",",8)
	;
NPI(DUZ) ; Get NPI Number, PUBLIC; EXTRINSIC
	; INPUT: DUZ ByVal
	; OUTPUT: Delimited String in format:
	;	IDType^ID^IDDescription
	; If the NPI doesn't exist, "" is returned.
	; This routine uses a call documented in the Kernel dev guide
	; This call returns as "NPI^TimeEntered^ActiveInactive"
	; It returns -1 for NPI if NPI doesn't exist.
	N NPI S NPI=$P($$NPI^XUSNPI("Individual_ID",DUZ),U)
	Q:NPI=-1 ""
	Q "NPI^"_NPI_"^HHS"
	;
SPEC(DUZ) ; Get Provider Specialty, PUBLIC; EXTRINSIC
	; INPUT: DUZ ByVal
	; OUTPUT: String: ProviderType/Specialty/Subspecialty OR ""
	; Uses a Kernel API. Returns -1 if a specialty is not specified
	; 	in file 200.
	; Otherwise, returns IEN^Profession^Specialty^Sub­            specialty^Effect date^Expired date^VA code
	N STR S STR=$$GET^XUA4A72(DUZ)
	Q:+STR<0 ""
	; Sometimes we have 3 pieces, or 2. Deal with that.
	Q:$L($P(STR,U,4)) $P(STR,U,2)_"/"_$P(STR,U,3)_"/"_$P(STR,U,4)
	Q $P(STR,U,2)_"/"_$P(STR,U,3)
	;
ADDTYPE(DUZ) ; Get Address Type, PUBLIC; EXTRINSIC
	; INPUT: DUZ, but not needed really... here for future expansion
	; OUTPUT: At this point "Work"
	Q "Work"
	;

