PXRMPDRS ;SLC/PKR - Patient List Demographic Report data selection. ;07/18/2006
 ;;2.0;CLINICAL REMINDERS;**4**;Feb 04, 2005;Build 21
 ;
ADDSEL(ADDDATA) ;Let the user select the address information they want.
 N ADDLIST,LIST
 S ADDLIST("A",1)=" 1 - CURRENT ADDRESS",ADDDATA(1,1)="STREET ADDRESS #1"_U_1
 S ADDDATA(1,2)="STREET ADDRESS #2"_U_1,ADDDATA(1,3)="STREET ADDRESS #3"_U_1
 S ADDDATA(1,4)="CITY"_U_1,ADDDATA(1,5)="STATE"_U_2,ADDDATA(1,6)="ZIP"_U_1
 S ADDDATA(1,7)="COUNTY"_U_2
 S ADDLIST("A",2)=" 2 - PHONE NUMBER",ADDDATA(2,8)="PHONE NUMBER"_U_1
 S ADDLIST("A")="Enter your selection(s)"
 S ADDLIST("?")="^D HELP^PXRMPDRS"
 W !!,"Select from the following address items:"
 S LIST=$$SEL^PXRMPDRS(.ADDLIST,2)
 I $D(DTOUT)!$D(DUOUT) Q
 S ADDDATA=LIST
 S ADDDATA("LEN")=$L(LIST,",")-1
 Q
 ;
APPERR ;
 N ECODE
 I $D(ZTQUEUED) D  Q
 . N NL,TIME
 . S TIME=$$NOW^XLFDT
 . S TIME=$$FMTE^XLFDT(TIME)
 . K ^TMP("PXRMXMZ",$J)
 . S ^TMP("PXRMXMZ",$J,1,0)="The Patient Demographic Report requested by "_$$GET1^DIQ(200,DBDUZ,.01)_" on "
 . S ^TMP("PXRMXMZ",$J,2,0)=TIME_" was supposed to include appointment data."
 . S ^TMP("PXRMXMZ",$J,3,0)="Appointment data could not be obtained from the Scheduling database due to the"
 . S ^TMP("PXRMXMZ",$J,4,0)="following error(s):"
 . S ECODE=0,NL=4
 . F  S ECODE=$O(^TMP($J,"SDAMA301",ECODE)) Q:ECODE=""  D
 .. S NL=NL+1,^TMP("PXRMXMZ",$J,NL,0)=" "_^TMP($J,"SDAMA301",ECODE)
 . D SEND^PXRMMSG("Scheduling database error(s)",1)
 . S ZTSTOP=1
 ;
 I '$D(ZTQUEUED) D  Q
 . W @IOF
 . W !,"Appointment data could not be obtained from the Scheduling database due to the"
 . W !,"following error(s):"
 . S ECODE=0
 . F  S ECODE=$O(^TMP($J,"SDAMA301",ECODE)) Q:ECODE=""  D
 .. W !," ",^TMP($J,"SDAMA301",ECODE)
 Q
 ;
APPSEL(APPDATA) ;Let the user select the appointment information they want.
 ;The first subscript of APPDATA is the selection number and the
 ;the second subscript is the subscript where the data is returned
 ;in VAPA. The first piece of APPDATA is the name of the data and the
 ;second piece is the piece of VAPA this is displayed.
 N APPLIST,LIST,MAX
 S APPLIST("A",1)=" 1 - APPOINTMENT DATE",APPDATA(1,1)="APPOINTMENT DATE"_U_1
 S APPLIST("A",2)=" 2 - CLINIC",APPDATA(2,2)="CLINIC"_U_2
 S APPLIST("A")="Enter your selection(s)"
 S APPLIST("?")="^D HELP^PXRMPDRS"
 W !!,"Select from the following future appointment items:"
 S LIST=$$SEL^PXRMPDRS(.APPLIST,2)
 I $D(DTOUT)!$D(DUOUT) Q
 S APPDATA=LIST
 S APPDATA("LEN")=$L(LIST,",")-1
 I APPDATA("LEN")=0 Q
 S APPDATA("MAX")=$$ASKNUM^PXRMEUT("Maximum number of appointments to display",1,25)
 Q
 ;
DATASEL(LISTIEN,FINDDATA) ; Build a list of data that is availble for
 ;this patient list and let the user select what they want.
 N IND,DATALIST,DTYPE
 S DTYPE="",IND=0
 F  S DTYPE=$O(^PXRMXP(810.5,LISTIEN,35,"B",DTYPE)) Q:DTYPE=""  D
 . S IND=IND+1,DATALIST("A",IND)=" "_IND_" - "_DTYPE
 . S FINDDATA(IND,IND)=DTYPE
 ;If there is no data quit.
 I IND=0 S FINDDATA("LEN")=0 Q
 S DATALIST("A")="Enter your selections(s)"
 S DATALIST("?")="^D HELP^PXRMPDRS"
 W !!,"Select from the following patient data:"
 S LIST=$$SEL^PXRMPDRS(.DATALIST,IND)
 I $D(DTOUT)!$D(DUOUT) Q
 S FINDDATA=LIST
 S FINDDATA("LEN")=$L(LIST,",")-1
 Q
 ;
DEMSEL(DEMDATA) ;Let the user select the demographic information they want.
 ;The first subscript of DEMDATA is the selection number and the
 ;the second subscript is the subscript where the data is returned
 ;in VADM. The first piece of DEMDATA is the name of the data and the
 ;second piece is the piece of VADM this is displayed.
 N DEMLIST,DTOUT,DUOUT,IND,ITEM,JND,KND,LIST,TEMP
 S DEMLIST("A",1)=" 1 - SSN",DEMDATA(1,2)="SSN"_U_2
 S DEMLIST("A",2)=" 2 - DATE OF BIRTH",DEMDATA(2,3)="DOB"_U_2
 S DEMLIST("A",3)=" 3 - AGE",DEMDATA(3,4)="AGE"_U_1
 S DEMLIST("A",4)=" 4 - SEX",DEMDATA(4,5)="SEX"_U_2
 S DEMLIST("A",5)=" 5 - DATE OF DEATH",DEMDATA(5,6)="DOD"_U_2
 S DEMLIST("A",6)=" 6 - REMARKS",DEMDATA(6,7)="REMARKS"_U_1
 S DEMLIST("A",7)=" 7 - HISTORIC RACE",DEMDATA(7,8)="HISTORIC RACE"_U_2
 S DEMLIST("A",8)=" 8 - RELIGION",DEMDATA(8,9)="RELIGION"_U_2
 S DEMLIST("A",9)=" 9 - MARITAL STATUS",DEMDATA(9,10)="MARTIAL STATUS"_U_2
 S DEMLIST("A",10)="10 - ETHNICITY",DEMDATA(10,11)="ETHNICITY"_U_2
 S DEMLIST("A",11)="11 - RACE",DEMDATA(11,12)="RACE"_U_2
 S DEMLIST("A")="Enter your selection(s)"
 S DEMLIST("?")="^D HELP^PXRMPDRS"
DSEL W !!,"Select from the following demographic items:"
 S LIST=$$SEL^PXRMPDRS(.DEMLIST,11)
 I $D(DTOUT)!$D(DUOUT) Q
 S DEMDATA=LIST
 S DEMDATA("LEN")=$L(LIST,",")-1
 F IND=1:1:DEMDATA("LEN") D
 . S JND=$P(LIST,",",IND)
 . S KND=$O(DEMDATA(JND,""))
 . S TEMP=$P(DEMDATA(JND,KND),U,1)
 . I TEMP="SSN" D
 .. N FULLSSN
 .. D SSN^PXRMXSD(.FULLSSN)
 .. S DEMDATA("FULLSSN")=$S($G(FULLSSN)="Y":1,1:0)
 . I $D(DTOUT)!$D(DUOUT) S IND=DEMDATA("LEN")+1 Q
 . I TEMP="ETHNICITY" S $P(DEMDATA(10,11),U,3)=$$ASKNUM^PXRMEUT("Maximum number of ethnicity entries to display",1,10)
 . I TEMP="RACE" S $P(DEMDATA(11,12),U,3)=$$ASKNUM^PXRMEUT("Maximum number of race entries to display",1,10)
 I $D(DTOUT)!$D(DUOUT) K DTOUT,DUOUT G DSEL
 Q
 ;
ELIGSEL(ELIGDATA) ;Let the user select the eligibility data they want.
 ;The first subscript of ELIGDATA is the selection number and the
 ;the second subscript is the subscript where the data is returned
 ;in VAEL. The first piece of ELIGDATA is the name of the data and the
 ;second piece is the piece of VAEL this is displayed.
 N ELIGLIST,ITEM,LIST
 S ELIGLIST("A",1)=" 1 - PRIMARY ELGIBILITY CODE",ELIGDATA(1,1)="PRIMARY ELGIBILITY CODE"_U_2
 S ELIGLIST("A",2)=" 2 - PERIOD OF SERVICE",ELIGDATA(2,2)="PERIOD OF SERVICE"_U_2
 S ELIGLIST("A",3)=" 3 - % SERVICE CONNECTED",ELIGDATA(3,3)="% SERVICE CONNECTED"_U_2
 S ELIGLIST("A",4)=" 4 - VETERAN",ELIGDATA(4,4)="VETERAN"_U_1
 S ELIGLIST("A",5)=" 5 - TYPE",ELIGDATA(5,6)="TYPE"_U_2
 S ELIGLIST("A",6)=" 6 - ELIGIBILITY STATUS",ELIGDATA(6,8)="ELIGIBILITY STATUS"_U_2
 S ELIGLIST("A",7)=" 7 - CURRENT MEANS TEST",ELIGDATA(7,9)="CURRENT MEANS TEST"_U_2
 S ELIGLIST("A")="Enter your selection(s)"
 S ELIGLIST("?")="^D HELP^PXRMPDRS"
 W !!,"Select from the following eligibility items:"
 S LIST=$$SEL^PXRMPDRS(.ELIGLIST,7)
 I $D(DTOUT)!$D(DUOUT) Q
 S ELIGDATA=LIST
 S ELIGDATA("LEN")=$L(LIST,",")-1
 Q
 ;
HELP ; -- help code.
 W !!,"You can choose any combination of numbers i.e., 1-4 or 1,3-5"
 W !!,"See the Clinical Reminders Managers manual for detailed explanations of each"
 W !,"of the selection items."
 Q
 ;
INPSEL(INPDATA) ;Let the user select the inpatient information they want.
 ;The first subscript of INPDATA is the selection number and the
 ;the second subscript is the subscript where the data is returned
 ;in VAIN. The first piece of INPDATA is the name of the data and the
 ;second piece is the piece of VAIN this is displayed.
 N INPLIST,ITEM,LIST
 S INPLIST("A",1)=" 1 - WARD LOCATION",INPDATA(1,4)="WARD"_U_2
 S INPLIST("A",2)=" 2 - ROOM-BED",INPDATA(2,5)="ROOM-BED"_U_1
 S INPLIST("A",3)=" 3 - ADMISSION DATE/TIME",INPDATA(3,7)="ADMISSION DATE/TIME"_U_2
 S INPLIST("A",4)=" 4 - ATTENDING PHYSICIAN",INPDATA(4,11)="ATTENDING"_U_2
 S INPLIST("A")="Enter your selection(s)"
 S INPLIST("?")="^D HELP^PXRMPDRS"
 W !!,"Select from the following inpatient items:"
 S LIST=$$SEL^PXRMPDRS(.INPLIST,5)
 I $D(DTOUT)!$D(DUOUT) Q
 S INPDATA=LIST
 S INPDATA("LEN")=$L(LIST,",")-1
 Q
 ;
REMSEL(PLIEN,REMDATA) ;If the list was generated from a reminder report
 ;let the user select the reminder data they want.
 I '$P(^PXRMXP(810.5,PLIEN,0),U,9) S REMDATA("LEN")=0 Q
 N IEN,IND,REMLIST,RNAME
 S (IEN,IND)=0
 F  S IEN=$O(^PXRMXP(810.5,PLIEN,45,"B",IEN)) Q:IEN=""  D
 . S RNAME=$P(^PXD(811.9,IEN,0),U,3)
 . I RNAME="" S RNAME=$P(^PXD(811.9,IEN,0),U,1)
 . S IND=IND+1
 . S REMDATA("RNAME",IND)=RNAME
 . S REMDATA("IEN",IND)=IEN
 . S REMLIST("A",IND)=" "_IND_" - "_RNAME
 S REMLIST("A")="Enter your selection(s)"
 S REMLIST("?")="^D HELP^PXRMPDRS"
 W !!,"Include due status information for the following reminder(s):"
 S LIST=$$SEL^PXRMPDRS(.REMLIST,IND)
 I $D(DTOUT)!$D(DUOUT) Q
 S REMDATA=LIST
 S REMDATA("LEN")=$L(LIST,",")-1
 Q
 ;
SEL(SELLIST,LEN) ;Select global list
 N DIR,X,Y
 M DIR=SELLIST
 S DIR(0)="LO^1:"_LEN
 D ^DIR
 Q Y
 ;
