//kt -- Modified with SourceScanner on 8/8/2007
unit fOptionsNotes;

interface

{ //kt 8/09  The following objects were addeded to the *FORM* of this unit

  object lblHTMLViewSize: TLabel
    Left = 8
    Top = 144
    Width = 159
    Height = 13
    Caption = 'Formatted Text (HTML) View Size'
  end
  object cboHTMLViewSize: TComboBox
  Left = 8
  Top = 162
  Width = 153
  Height = 21
  ItemHeight = 13
  TabOrder = 6
  Text = '<View Size>'
  OnClick = cboHTMLViewSizeClick
  Items.Strings = (
    'Smallest'
    'Small'
    'Medium'
    'Large'
    'Largest')
  end
  object cbDefaultHTMLMode: TCheckBox
    Left = 8
    Top = 112
    Width = 225
    Height = 17
    Caption = 'Start notes in Formatted (HTML) Mode'
    TabOrder = 7
    OnClick = cbDefaultHTMLModeClick
}


uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  IniFiles,    //kt for IniFile
  StdCtrls, ExtCtrls, ORCtrls, ORFn, ComCtrls, DKLang;

type
  TfrmOptionsNotes = class(TForm)
    lblAutoSave1: TLabel;
    lblCosigner: TLabel;
    txtAutoSave: TCaptionEdit;
    spnAutoSave: TUpDown;
    chkVerifyNote: TCheckBox;
    chkAskSubject: TCheckBox;
    cboCosigner: TORComboBox;
    pnlBottom: TPanel;
    bvlBottom: TBevel;
    btnOK: TButton;
    btnCancel: TButton;
    lblAutoSave2: TLabel;
    cboHTMLViewSize: TComboBox;   //kt 8/09
    lblHTMLViewSize: TLabel;      //kt 8/09
    cbDefaultHTMLMode: TCheckBox; //kt 8/09
    DKLanguageController1: TDKLanguageController; //kt
    procedure FormShow(Sender: TObject);
    procedure btnOKClick(Sender: TObject);
    procedure txtAutoSaveChange(Sender: TObject);
    procedure txtAutoSaveKeyPress(Sender: TObject; var Key: Char);
    procedure txtAutoSaveExit(Sender: TObject);
    procedure spnAutoSaveClick(Sender: TObject; Button: TUDBtnType);
    procedure cboCosignerNeedData(Sender: TObject; const StartFrom: String;
      Direction, InsertAt: Integer);
    procedure cboCosignerExit(Sender: TObject);
    procedure FormCreate(Sender: TObject);              //kt 8/09
    procedure cbDefaultHTMLModeClick(Sender: TObject);  //kt 8/09
    procedure cboHTMLViewSizeChange(Sender: TObject);   //kt 8/09
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmOptionsNotes: TfrmOptionsNotes;
  OptionsNotesIniFile : TIniFile;  //kt 8/09
  DefaultEditHTMLMode : boolean;   //kt 8/09
  FHTMLEditTextSize   : integer;   //kt 8/09

procedure DialogOptionsNotes(topvalue, leftvalue, fontsize: integer; var actiontype: Integer);
procedure SetDefaultEditHTMLMode(Value : boolean);  //kt 8/09
procedure Loaded;                                   //kt 8/09

implementation

{$R *.DFM}

uses
  uCore,    //kt 8/09
  Registry, //kt 8/09
  rOptions, uOptions, rCore, rTIU, rDCSumm;

const
  DEFAULT_HTML_EDIT_MODE = 'Edit-in-HTML default mode';       //kt 8/09
  DEFAULT_HTML_TEXT_SIZE = 'Edit-in-HTML default text size';  //kt 8/09

procedure SetRegHTMLViewSize(Size : integer); forward;        //kt 8/09

procedure DialogOptionsNotes(topvalue, leftvalue, fontsize: integer; var actiontype: Integer);
// create the form and make it modal, return an action
var
  frmOptionsNotes: TfrmOptionsNotes;
begin
  frmOptionsNotes := TfrmOptionsNotes.Create(Application);
  actiontype := 0;
  try
    with frmOptionsNotes do
    begin
      if (topvalue < 0) or (leftvalue < 0) then
        Position := poScreenCenter
      else
      begin
        Position := poDesigned;
        Top := topvalue;
        Left := leftvalue;
      end;
      ResizeAnchoredFormToFont(frmOptionsNotes);
      ShowModal;
      actiontype := btnOK.Tag;
    end;
  finally
    frmOptionsNotes.Release;
  end;
end;

procedure TfrmOptionsNotes.FormShow(Sender: TObject);
// displays defaults
// opening tab^use last tab^autosave seconds^verify note title
var
  autosave, verify: integer;
  cosigner: Int64;
  values, cosignername: string;
begin
  values := rpcGetOther;
  autosave := strtointdef(Piece(values, '^', 3), -1);
  verify := strtointdef(Piece(values, '^', 4), 0);
  chkVerifyNote.Checked := verify = 1;
  chkVerifyNote.Tag := verify;
  spnAutoSave.Position := autosave;
  spnAutoSave.Tag := autosave;

  values := rpcGetDefaultCosigner;
  cosigner := strtoint64def(Piece(values, '^', 1), 0);
  cosignername := Piece(values, '^', 2);
  cboCosigner.Items.Add('0^<none>');
  cboCosigner.InitLongList(cosignername);
  cboCosigner.SelectByIEN(cosigner);
  cboCosigner.Tag := cosigner;
  chkAskSubject.Checked := rpcGetSubject;
  if chkAskSubject.Checked then chkAskSubject.Tag := 1;
  cbDefaultHTMLMode.Checked := DefaultEditHTMLMode; //kt
end;

procedure TfrmOptionsNotes.btnOKClick(Sender: TObject);
// only saves values if they have been changed
// opening tab^use last tab^autosave seconds^verify note title
var
  values: string;
begin
  values := '';
  values := values + '^';
  values := values + '^';
  if spnAutoSave.Position <> spnAutoSave.Tag then
    values := values + inttostr(spnAutoSave.Position);
  values := values + '^';
  if chkVerifyNote.Checked then
    if chkVerifyNote.Tag <> 1 then
      values := values + '1';
  if not chkVerifyNote.Checked then
    if chkVerifyNote.Tag <> 0 then
      values := values + '0';
  rpcSetOther(values);
  with chkAskSubject do
  if (Checked and (Tag = 0)) or (not Checked and (Tag = 1)) then
    rpcSetSubject(Checked);
  with cboCosigner do
    if Tag <> ItemIEN then
      rpcSetDefaultCosigner(ItemIEN);
  ResetTIUPreferences;
  ResetDCSummPreferences;
end;

procedure TfrmOptionsNotes.txtAutoSaveChange(Sender: TObject);
var
  maxvalue: integer;
begin
  maxvalue := spnAutoSave.Max;
  with txtAutoSave do
  begin
    if strtointdef(Text, maxvalue) > maxvalue then
    begin
      beep;
//    InfoBox('Number must be < ' + inttostr(maxvalue), 'Warning', MB_OK or MB_ICONWARNING);  <-- original line.  //kt 8/8/2007
      InfoBox(DKLangConstW('fOptionsNotes_Number_must_be_x')+' ' + inttostr(maxvalue), DKLangConstW('fOptionsNotes_Warning'), MB_OK or MB_ICONWARNING); //kt added 8/8/2007
      if strtointdef(Text, 0) > maxvalue then
        Text := inttostr(maxvalue);
    end;
  end;
  spnAutoSaveClick(self, btNext);
end;

procedure TfrmOptionsNotes.txtAutoSaveKeyPress(Sender: TObject;
  var Key: Char);
begin
  if Key = #13 then
  begin
    Perform(WM_NextDlgCtl, 0, 0);
    exit;
  end;
  if not (Key in ['0'..'9', #8]) then
  begin
    Key := #0;
    beep;
  end;  
end;

procedure TfrmOptionsNotes.txtAutoSaveExit(Sender: TObject);
begin
  with txtAutoSave do
  begin
    if Text = '' then
    begin
      Text := '0';
      spnAutoSaveClick(self, btNext);
    end
    else if (Copy(Text, 1, 1) = '0') and (length(Text) > 1) then
    begin
      Text := inttostr(strtointdef(Text, 0));
      spnAutoSaveClick(self, btNext);
    end;
  end;
end;

procedure TfrmOptionsNotes.spnAutoSaveClick(Sender: TObject;
  Button: TUDBtnType);
begin
  txtAutoSave.SetFocus;
  txtAutoSave.Tag := strtointdef(txtAutoSave.Text, 0);
end;

procedure TfrmOptionsNotes.cboCosignerNeedData(Sender: TObject;
  const StartFrom: String; Direction, InsertAt: Integer);
begin
  cboCosigner.ForDataUse(rpcGetCosigners(StartFrom, Direction));
end;

procedure TfrmOptionsNotes.cboCosignerExit(Sender: TObject);
begin
  with cboCosigner do
  if (Text = '') or (ItemIndex = -1) then
  begin
    ItemIndex := 0;
    Text := DisplayText[0];
  end;
end;


procedure SetRegHTMLViewSize(Size : integer);
//kt added entire function 8/09
//NOTE: The only way to affect the view size of the HTML renderer (IE) is to
//      change a system-wide setting in the registry.  Then CPRS has to be
//      restarted for changes to take effect.
var
  FontSizeData : array[0..3] of byte;
  ZoomReg      : TRegistry;
begin
  if (Size < 0) or (Size > 255) then exit;
  ZoomReg := TRegistry.Create;
  FontSizeData[0] := Lo(Size); FontSizeData[1] := 0; FontSizeData[2] := 0; FontSizeData[3] := 0;
  try
    ZoomReg.Rootkey := HKEY_CURRENT_USER;
    if ZoomReg.OpenKey('\Software\Microsoft\Internet Explorer\International\Scripts\3', False) then begin
      ZoomReg.WriteBinaryData('IEFontSize',FontSizeData,SizeOf(FontSizeData));
    end;
  finally
    ZoomReg.Free;
  end;
end;

procedure SetDefaultEditHTMLMode(Value : boolean);
//kt added entire function 8/09
begin
  if Value <> DefaultEditHTMLMode then begin
    if OptionsNotesIniFile = nil then begin
      OptionsNotesIniFile := TIniFile.Create(ChangeFileExt(Application.ExeName, '.INI'));  //kt
      OptionsNotesIniFile.WriteBool(User.Name,DEFAULT_HTML_EDIT_MODE,Value);
      DefaultEditHTMLMode := Value;
      OptionsNotesIniFile.Free;
      OptionsNotesIniFile := nil;
    end else begin
      OptionsNotesIniFile.WriteBool(User.Name,DEFAULT_HTML_EDIT_MODE,Value);
      DefaultEditHTMLMode := Value;
    end;
  end;
end;

procedure TfrmOptionsNotes.cbDefaultHTMLModeClick(Sender: TObject);
//kt added entire function 8/09
begin
  SetDefaultEditHTMLMode(cbDefaultHTMLMode.Checked);
end;

procedure TfrmOptionsNotes.cboHTMLViewSizeChange(Sender: TObject);
//kt added entire function 8/09
begin
  SetRegHTMLViewSize(cboHTMLViewSize.ItemIndex);
  OptionsNotesIniFile.WriteInteger(User.Name,DEFAULT_HTML_TEXT_SIZE,cboHTMLViewSize.ItemIndex);
  MessageDlg('Formated text size change will take '+#10+#13+
             'effect next time CPRS is restarted.',mtInformation,[mbOK],0);
end;

procedure Loaded;
//kt added entire function 8/09
begin
  //Code was put in global access space because object is not instantiated until
  //after user shows options (which could be never)
  OptionsNotesIniFile := TIniFile.Create(ChangeFileExt(Application.ExeName, '.INI'));  //kt
  DefaultEditHTMLMode := OptionsNotesIniFile.ReadBool(User.Name,DEFAULT_HTML_EDIT_MODE,false);
  FHTMLEditTextSize := OptionsNotesIniFile.ReadInteger(User.Name,DEFAULT_HTML_TEXT_SIZE,2);
  SetRegHTMLViewSize(FHTMLEditTextSize);
end;

procedure TfrmOptionsNotes.FormCreate(Sender: TObject);
//kt added entire function 8/09
//NOTE: form is not created until first time needed.
begin
  //NOTE: FHTMLEditTextSize is set in Loaded function (has to be called after sign on (so User.Name is available)
  if (FHTMLEditTextSize > -1) and (FHTMLEditTextSize < cboHTMLViewSize.Items.Count) then begin
    cboHTMLViewSize.ItemIndex := FHTMLEditTextSize;
    cboHTMLViewSize.Text := cboHTMLViewSize.Items[FHTMLEditTextSize];
    SetRegHTMLViewSize(cboHTMLViewSize.ItemIndex);
  end;
end;

initialization

finalization
  OptionsNotesIniFile.Free;  //kt 8/09

end.
