C0CPROC  ; CCDCCR/GPL - CCR/CCD PROCESSING FOR PROCEDURES ; 01/21/10
 ;;1.0;C0C;;Jan 21, 2010;
 ;Copyright 2010 George Lilly, University of Minnesota and others.
 ;Licensed under the terms of the GNU General Public License.
 ;See attached copy of the License.
 ;
 ;This program is free software; you can redistribute it and/or modify
 ;it under the terms of the GNU General Public License as published by
 ;the Free Software Foundation; either version 2 of the License, or
 ;(at your option) any later version.
 ;
 ;This program is distributed in the hope that it will be useful,
 ;but WITHOUT ANY WARRANTY; without even the implied warranty of
 ;MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ;GNU General Public License for more details.
 ;
 ;You should have received a copy of the GNU General Public License along
 ;with this program; if not, write to the Free Software Foundation, Inc.,
 ;51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 ;
 W "NO ENTRY FROM TOP",!
 Q
 ;
EXTRACT(PROCXML,DFN,PROCOUT) ; EXTRACT PROCEDURES INTO  XML TEMPLATE
 ; PROCXML AND PROCOUT ARE PASSED BY NAME SO GLOBALS CAN BE USED
 ;
 S C0CENC=$NA(^TMP("C0CENC",$J,DFN))
 S C0CPRC=$NA(^TMP("C0CPRC",$J,DFN))
 S C0CNTE=$NA(^TMP("C0CNTE",$J,DFN))
 I '$D(@C0CPRC) D TIUGET(DFN,C0CENC,C0CPRC,C0CNTE) ; GET VARS IF NOT THERE
 D MAP(PROCXML,C0CPRC,PROCOUT) ;MAP RESULTS FOR PROCEDURES
 Q
 ;
TIUGET(DFN,C0CENC,C0CPRC,C0CNTE) ; CALLS ENTRY^C0CCPT TO GET PROCEDURES, 
 ; ENCOUNTERS AND NOTES. RETURNS THEM IN RNF2 ARRAYS PASSED BY NAME
 ; C0CENC: ENCOUNTERS, C0CPRC: PROCEDURES, C0CNTE: NOTES
 ; READY TO BE MAPPED TO XML BY MAP^C0CENC, MAP^C0CPROC, AND MAP^C0CCMT
 ; THESE RETURN ARRAYS ARE NOT INITIALIZED, BUT ARE ADDED TO IF THEY 
 ; EXIST. THIS IS SO THAT ADDITIONAL PROCEDURES CAN BE OBTAINED FROM
 ; THE SURGERY PACKGE AND ADDITIONAL COMMENTS FROM OTHER CCR SECTIONS
 ;
 K VISIT,LST,NOTE
 D ENTRY^C0CCPT(DFN,,,1) ; RETURNS ALL RESULTS IN VISIT LOCAL VARIABLE
 ; NEED TO ADD START AND END DATES FROM PARAMETERS
 N ZI S ZI=""
 F  S ZI=$O(VISIT(ZI),-1) Q:ZI=""  D  ; REVERSE TIME ORDER - MOST RECENT FIRST
 . N ZDATE
 . S ZDATE=$$DATE(VISIT(ZI,"DATE",0))
 . S ZPRVARY=$NA(VISIT(ZI,"PRV"))
 . N ZPRV
 . S ZPRV=$$PRV(ZPRVARY) ; THE PRIMARY PROVIDER OBJECT IN THE FORM
 . ; ACTORPROVIDER_IEN WHERE IEN IS THE PROVIDER IEN IN NEW PERSON 
 . N ZJ S ZJ=""
 . F  S ZJ=$O(VISIT(ZI,"CPT",ZJ)) Q:ZJ=""  D  ;FOR EACH CPT SEG
 . . N ZRNF
 . . N ZCPT S ZCPT=$$CPT(VISIT(ZI,"CPT",ZJ)) ;GET CPT CODE AND TEXT
 . . I ZCPT'="" D  ;IF CPT CODE IS PRESENT
 . . . W !,ZCPT," ",ZDATE," ",ZPRV
 . . . S ZRNF("PROCACTOROBJID")=ZPRV
 . . . S ZRNF("PROCCODE")=$P(ZCPT,U,1)
 . . . S ZRNF("PROCCODESYS")="CPT-4"
 . . . S ZRNF("PROCDATETEXT")="Procedure Date"
 . . . S ZRNF("PROCDATETIME")=ZDATE
 . . . S ZRNF("PROCDESCOBJATTR")=""
 . . . S ZRNF("PROCDESCOBJATTRCODESYS")="" ;WE DON'T HAVE PROC ATTRIBUTES
 . . . S ZRNF("PROCDESCOBJATTRVAL")=""
 . . . S ZRNF("PROCDESCTEXT")=$P(ZCPT,U,3)
 . . . S ZRNF("PROCLINKID")="" ; NO LINKS YET
 . . . S ZRNF("PROCLINKREL")="" ; NO LINKS YET
 . . . S ZRNF("PROCOBJECTID")="PROCEDURE_"_ZI
 . . . S ZRNF("PROCSTATUS")="Completed" ; Is this right?
 . . . S ZRNF("PROCTYPE")=$P(ZCPT,U,2) ; NEED TO ADD THIS TO TEMPLATE
 Q
 ;
PRV(IARY) ; RETURNS THE PRIMARY PROVIDER FROM THE "PRV" ARRAY PASSED BY NAME
 N ZI,ZR,ZRTN S ZI="" S ZR="" S ZRTN=""
 F  S ZI=$O(@IARY@(ZI)) Q:ZI=""  D  ; FOR EACH PRV SEG
 . I ZR'="" Q  ;ONLY WANT THE FIRST PRIMARY PROVIDER
 . I $P(@IARY@(ZI),U,5)=1 S ZR=$P(@IARY@(ZI),U,1)
 I ZR'="" S ZRTN="ACTORPROVIDER_"_ZR
 Q ZRTN
 ;
DATE(ISTR) ; EXTRINSIC TO RETURN THE DATE IN CCR FORMAT
 Q $$FMDTOUTC^C0CUTIL(ISTR,"D")
 ;
CPT(ISTR) ; EXTRINSIC THAT SEARCHES FOR CPT CODES AND RETURNS
 ; CPT^CATEGORY^TEXT
 N Z1,Z2,Z3,ZRTN
 I ISTR["(CPT-4 " D  ; IF THERE IS A CPT CODE IN THERE
 . S Z1=$P($P(ISTR,"(CPT-4 ",2),")",1)
 . S Z2=$P(ISTR,U,2)
 . S Z3=$P(ISTR,U,3)
 . S ZRTN=Z1_U_Z2_U_Z3
 E  S ZRTN=""
 Q ZRTN
 ;
MAP(PROCXML,C0CPRC,PROCOUT) ; MAP PROCEDURES XML 
 ;
 Q
 ;  