//kt -- Modified with SourceScanner on 8/29/2007
unit frmImageTransferProgress;
//kt Added this entire form.

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls, ComCtrls, DKLang;

type
  TImageTransferForm = class(TForm)
    ProgressBar: TProgressBar;
    Label1: TLabel;
    Image1: TImage;
    ProgressMsg: TLabel;
    DKLanguageController1: TDKLanguageController;
  private
    { Private declarations }
    //startTime:  TDateTime;
    //procedure DetermineIntervalTimes();
  public
    { Public declarations }
    //procedure ResetStartTime;
    procedure setMax(Max : integer);
    procedure updateProgress(Current: integer);
  end;

var
  ImageTransferForm: TImageTransferForm;

implementation

{$R *.dfm}

  //uses DateUtils,Math;

  {
  procedure TUploadProgressForm.ResetStartTime();
  begin
    startTime := Now;
  end;
  }

  procedure TImageTransferForm.setMax(Max : integer);
  begin
    ProgressBar.Max := Max;
  end;


  procedure TImageTransferForm.updateProgress(Current: integer);
  begin
    ProgressBar.Position := Current;
    //DetermineIntervalTimes();
  end;

  {
  procedure TUploadProgressForm.DetermineIntervalTimes();
  var
    elapsedSec: int64;

    elapsedTime : TDateTime;
    remaining : integer;
    rate : real;
    remainSec : int64;

  begin
    elapsedSec := SecondsBetween(Now,startTime);
    if elapsedSec < 1 then elapsedSec := 1;
    elapsedTime := IncSecond(0,elapsedSec);
//  DecodeDateTime(elapsedTime; out AYear, AMonth, ADay, AHour, AMinute, ASecond, AMilliSecond: Word);
    ElapsedTimeLabel.Caption := TimeToStr(elapsedTime);

    rate := ProgressBar.Max / elapsedSec;
    remainSec := floor ((ProgressBar.Max-ProgressBar.Position) / rate);
    RemainingTimeLabel.Caption := TimeToStr(IncSecond(0,remainSec));
  end;
  }

end.
