//kt -- Modified with SourceScanner on 8/7/2007
unit fxBroker;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, DateUtils, ORNet, ORFn, rMisc, ComCtrls, Buttons, ExtCtrls,
  ORCtrls, ORSystem, DKLang;

type
  TfrmBroker = class(TForm)
    pnlTop: TORAutoPanel;
    lblMaxCalls: TLabel;
    txtMaxCalls: TCaptionEdit;
    cmdPrev: TBitBtn;
    cmdNext: TBitBtn;
    udMax: TUpDown;
    memData: TRichEdit;
    lblCallID: TStaticText;
    btnRLT: TButton;
    DKLanguageController1: TDKLanguageController;
    btnClear: TBitBtn;
    lblStoredCallsNum: TLabel;
    cboJumpTo: TComboBox;
    procedure cmdPrevClick(Sender: TObject);
    procedure cmdNextClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormResize(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure btnRLTClick(Sender: TObject);
    procedure btnClearClick(Sender: TObject);
    procedure cboJumpToDropDown(Sender: TObject);
    procedure cboJumpToChange(Sender: TObject);
  private
    { Private declarations }
    FRetained: Integer;
    FCurrent: Integer;
    procedure UpdateDisplay; //kt added
  public
    { Public declarations }
  end;

procedure ShowBroker;

implementation

{$R *.DFM}

procedure ShowBroker;
var
  frmBroker: TfrmBroker;
begin
  frmBroker := TfrmBroker.Create(Application);
  try
    ResizeAnchoredFormToFont(frmBroker);
    with frmBroker do
    begin
      FRetained := RetainedRPCCount - 1;
      FCurrent := FRetained;
      UpdateDisplay; //kt
      { //kt moved to UpdateDisplay
      LoadRPCData(memData.Lines, FCurrent);
      memData.SelStart := 0;
//    lblCallID.Caption := 'Last Call Minus: ' + IntToStr(FRetained - FCurrent);  <-- original line.  //kt 8/7/2007
      lblCallID.Caption := DKLangConstW('fxBroker_Last_Call_Minusx') + IntToStr(HigherOf(FRetained - FCurrent,0)); //kt added 8/7/2007
      lblStoredCallsNum.Caption := DKLangConstW('fxBroker_Stored_Calls') + IntToStr(RetainedRPCCount); //kt added 4/15/10
      }
      ShowModal;
    end;
  finally
    frmBroker.Release;
  end;
end;

procedure TfrmBroker.cmdPrevClick(Sender: TObject);
begin
  FCurrent := HigherOf(FCurrent - 1, 0);
  UpdateDisplay; //kt
  { //kt moved to UpdateDisplay
  LoadRPCData(memData.Lines, FCurrent);
  memData.SelStart := 0;
//lblCallID.Caption := 'Last Call Minus: ' + IntToStr(FRetained - FCurrent);  <-- original line.  //kt 8/7/2007
  lblCallID.Caption := DKLangConstW('fxBroker_Last_Call_Minusx') + IntToStr(HigherOf(FRetained - FCurrent,0)); //kt added 8/7/2007
  lblStoredCallsNum.Caption := DKLangConstW('fxBroker_Stored_Calls') + IntToStr(RetainedRPCCount); //kt added 4/15/10
  }
end;

procedure TfrmBroker.cmdNextClick(Sender: TObject);
begin
  FRetained := RetainedRPCCount - 1;  //kt added line 4/15/10
  FCurrent := LowerOf(FCurrent + 1, FRetained);
  UpdateDisplay; //kt
  { //kt moved to UpdateDisplay
  LoadRPCData(memData.Lines, FCurrent);
  memData.SelStart := 0;
//lblCallID.Caption := 'Last Call Minus: ' + IntToStr(FRetained - FCurrent);  <-- original line.  //kt 8/7/2007
  lblCallID.Caption := DKLangConstW('fxBroker_Last_Call_Minusx') + IntToStr(HigherOf(FRetained - FCurrent,0)); //kt added 8/7/2007
  lblStoredCallsNum.Caption := DKLangConstW('fxBroker_Stored_Calls') + IntToStr(RetainedRPCCount); //kt added 4/15/10
  }
end;

procedure TfrmBroker.UpdateDisplay; //kt added
begin
  FRetained := RetainedRPCCount - 1;  //kt added line 4/15/10
  LoadRPCData(memData.Lines, FCurrent);
  memData.SelStart := 0;
//lblCallID.Caption := 'Last Call Minus: ' + IntToStr(FRetained - FCurrent);  <-- original line.  //kt 8/7/2007
  lblCallID.Caption := DKLangConstW('fxBroker_Last_Call_Minusx') + IntToStr(HigherOf(FRetained - FCurrent,0)); //kt added 8/7/2007
  lblStoredCallsNum.Caption := DKLangConstW('fxBroker_Stored_Calls') + IntToStr(RetainedRPCCount); //kt added 4/15/10
end;

procedure TfrmBroker.cboJumpToDropDown(Sender: TObject);
//kt added entire function
var i : integer;
    s : string;
    Info : TStringList;   //Not owned here...
begin
  cboJumpTo.Items.Clear;
  for i := 0 to RetainedRPCCount - 1 do begin
    Info := AccessRPCData(i);
    if Info.Count < 2 then continue;
    s := Info.Strings[1];
    s := piece(s,'Called at: ',2);
    s := s + ':  ' + Info.Strings[0];
    cboJumpTo.Items.Insert(0,s);
  end;
end;

procedure TfrmBroker.cboJumpToChange(Sender: TObject);
//kt added function
begin
  if cboJumpTo.Items.count > 0 then begin
    FCurrent := (cboJumpTo.Items.count-1) - cboJumpTo.ItemIndex;
    UpdateDisplay; //kt
  end;
end;


procedure TfrmBroker.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  SetRetainedRPCMax(StrToIntDef(txtMaxCalls.Text, 5))
end;

procedure TfrmBroker.FormResize(Sender: TObject);
begin
  Refresh;
end;

procedure TfrmBroker.FormCreate(Sender: TObject);
begin
  udMax.Position := GetRPCMax;
end;

procedure TfrmBroker.FormKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key = VK_ESCAPE then
  begin
    Key := 0;
    Close;
  end;
end;

procedure TfrmBroker.btnRLTClick(Sender: TObject);
var
  startTime, endTime: tDateTime;
  clientVer, serverVer, diffDisplay: string;
  theDiff: integer;
  disclaimer : string; //kt
const
  TX_OPTION  = 'OR CPRS GUI CHART';
//disclaimer = 'NOTE: Strictly relative indicator:';  <-- original line.  //kt 8/7/2007
begin
  disclaimer := DKLangConstW('fxBroker_NOTEx_Strictly_relative_indicatorx'); //kt added 8/7/2007

  clientVer := clientVersion(Application.ExeName); // Obtain before starting.

  // Check time lapse between a standard RPC call:
  startTime := now;
  serverVer :=  serverVersion(TX_OPTION, clientVer);
  endTime := now;
  theDiff := milliSecondsBetween(endTime, startTime);
  diffDisplay := intToStr(theDiff);

  // Show the results:
  //infoBox('Lapsed time (milliseconds) = ' + diffDisplay + '.', disclaimer, MB_OK);  <-- original line.  //kt 8/7/2007
  infoBox(DKLangConstW('fxBroker_Lapsed_time_xmillisecondsx_x') + diffDisplay + '.', disclaimer, MB_OK); //kt added 8/7/2007

end;

procedure TfrmBroker.btnClearClick(Sender: TObject);
  //kt added entire function
begin
  ORNet.RPCCallsClear;
  memData.Lines.Clear; //kt 4/15/10
  cboJumpTo.Text := '-- Select a call to jump to --';
  FCurrent := 0;
  FRetained := RetainedRPCCount - 1;
  cmdNextClick(Sender);
end;


end.
