<?xml version="1.0" encoding="utf-8"?>
<!--
Conversion of CCR to Level 3 CCD

Orginal Author:   	Ken Miller
Solventus LLC
ken.miller@solventus.coms

Contributors:
Richard Braman, EHR Doctors, Inc rbraman@ehrdoctors.com
George Gilly (WorldVistA glilly@glilly.net)
xxxx - Oroville Hospital

Date: 	2010-05-5
Version: 	0.1

License :

        This program is free software: you can redistribute it and/or modify
        it under the terms of the GNU General Public License as published by
        the Free Software Foundation, either version 3 of the License, or
        (at your option) any later version.

        This program is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        GNU General Public License for more details.

        You should have received a copy of the GNU General Public License
        along with this program.  If not, see http://www.gnu.org/licenses.

-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:a="urn:astm-org:CCR" xmlns:date="http://exslt.org/dates-and-times" exclude-result-prefixes="a date" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:str="http://exslt.org/strings" extension-element-prefixes="str" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
    <xsl:import href="./templates/code.xsl"/>
    <xsl:import href="./templates/ccdcodedvalue.xsl"/>
    <xsl:import href="./templates/ccdentity.xsl"/>
    <xsl:import href="./templates/ccdid.xsl"/>
    <xsl:import href="./templates/ccddatetime.xsl"/>
    <xsl:import href="./templates/ccdstatus.xsl"/>
    <xsl:import href="./templates/ccdmedicationfrequency.xsl"/>
    <xsl:import href="./templates/actor.xsl"/>
    <xsl:import href="./templates/problemDescription.xsl"/>
    <xsl:import href="./templates/HL7OIDLookup.xsl"/>

    <xsl:output method="xml" encoding="utf-8" version="1.0" indent="yes"/>
    <xsl:template match="/">
        <xsl:processing-instruction name="xml-stylesheet">type="text/xsl" href="CCD.xsl"</xsl:processing-instruction>
        <ClinicalDocument xmlns="urn:hl7-org:v3" xmlns:voc="urn:hl7-org:v3/voc" xmlns:sdtc="urn:hl7-org:sdtc" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="urn:hl7-org:v3 http://xreg2.nist.gov:8080/hitspValidation/schema/cdar2c32/infrastructure/cda/C32_CDA.xsd" classCode="DOCCLIN" moodCode="EVN">
            <realmCode code="US"/>
            <typeId root="2.16.840.1.113883.1.3" extension="POCD_HD000040"/>
            <templateId root="2.16.840.1.113883.10.20.1"/>
            <templateId root="1.3.6.1.4.1.19376.1.5.3.1.1.1"/>
            <templateId root="2.16.840.1.113883.10.20.3"/>
            <templateId root="2.16.840.1.113883.3.88.11.32.1"/>

            <id>
                <xsl:attribute name="root">
                    <xsl:value-of select="/a:ContinuityOfCareRecord/a:CCRDocumentObjectID"></xsl:value-of>
                </xsl:attribute>
            </id>
            <code code="34133-9" codeSystem="2.16.840.1.113883.6.1" codeSystemName="LOINC" displayName="Summarization of episode note"/>
            <title>Continuity of Care Document</title>
            <effectiveTime>
                <xsl:attribute name="value">
                    <xsl:call-template name="date:format-date">
                        <xsl:with-param name="date-time">
                            <xsl:value-of select="/a:ContinuityOfCareRecord/a:DateTime/a:ExactDateTime"/>
                        </xsl:with-param>
                        <xsl:with-param name="pattern">yyyyMMddhhmmss+0000</xsl:with-param>
                    </xsl:call-template>
                </xsl:attribute>
            </effectiveTime>
            <confidentialityCode code="N" codeSystem="2.16.840.1.113883.5.25"/>
            <languageCode code="en-US"/>
            <xsl:variable name="patientID" select="/a:ContinuityOfCareRecord/a:Patient[1]/a:ActorID"/>
            <recordTarget>
                <xsl:for-each select="/a:ContinuityOfCareRecord/a:Actors/a:Actor[a:ActorObjectID=$patientID]">
                    <patientRole>
                        <xsl:call-template name="ccdEntity">
                            <xsl:with-param name="ccrActorObjectID" select="/a:ContinuityOfCareRecord/a:Patient[1]/a:ActorID"></xsl:with-param>
                            <xsl:with-param name="personNodeName">patient</xsl:with-param>
                        </xsl:call-template>
                    </patientRole>
                </xsl:for-each>
            </recordTarget>

            <xsl:variable name="fromID" select="/a:ContinuityOfCareRecord/a:From/a:ActorLink[1]/a:ActorID"/>
            <author>
                <xsl:for-each select="/a:ContinuityOfCareRecord/a:Actors/a:Actor[a:ActorObjectID=$fromID]">
                    <time>
                        <xsl:attribute name="value">
                            <xsl:call-template name="date:format-date">
                                <xsl:with-param name="date-time">
                                    <xsl:value-of select="/a:ContinuityOfCareRecord/a:DateTime/a:ExactDateTime"/>
                                </xsl:with-param>
                                <xsl:with-param name="pattern">yyyyMMddhhmmss</xsl:with-param>
                            </xsl:call-template>
                        </xsl:attribute>
                    </time>
                    <xsl:call-template name="ccdEntity">
                        <xsl:with-param name="ccrActorObjectID" select="/a:ContinuityOfCareRecord/a:From/a:ActorLink[1]/a:ActorID"></xsl:with-param>
                    </xsl:call-template>
                </xsl:for-each>
            </author>

            <custodian>
                <assignedCustodian>
                    <representedCustodianOrganization>
                        <xsl:call-template name="ccdEntity">
                            <xsl:with-param name="ccrActorObjectID" select="/a:ContinuityOfCareRecord/a:Actors/a:Actor[a:ActorObjectID=$fromID]/a:InternalCCRLink[a:LinkRelationship='Organization']/a:LinkID"></xsl:with-param>
                        </xsl:call-template>
                    </representedCustodianOrganization>
                </assignedCustodian>
            </custodian>

            <documentationOf>
                <serviceEvent classCode="PCPR">
                    <effectiveTime>
                        <low>
                            <xsl:attribute name="value">
                                <xsl:call-template name="date:format-date">
                                    <xsl:with-param name="date-time">
                                        <xsl:for-each select="/a:ContinuityOfCareRecord/a:Body//a:DateTime//a:ExactDateTime">
                                            <xsl:sort order="ascending"/>
                                            <xsl:if test="position()=1">
                                                <xsl:value-of select="."/>
                                            </xsl:if>
                                        </xsl:for-each>
                                    </xsl:with-param>
                                    <xsl:with-param name="pattern">yyyyMMdd</xsl:with-param>
                                </xsl:call-template>
                            </xsl:attribute>
                        </low>
                        <high>
                            <xsl:attribute name="value">
                                <xsl:call-template name="date:format-date">
                                    <xsl:with-param name="date-time">
                                        <xsl:for-each select="/a:ContinuityOfCareRecord/a:Body//a:DateTime//a:ExactDateTime">
                                            <xsl:sort order="descending"/>
                                            <xsl:if test="position()=1">
                                                <xsl:value-of select="."/>
                                            </xsl:if>
                                        </xsl:for-each>
                                    </xsl:with-param>
                                    <xsl:with-param name="pattern">yyyyMMdd</xsl:with-param>
                                </xsl:call-template>
                            </xsl:attribute>
                        </high>
                    </effectiveTime>
                </serviceEvent>

                <xsl:for-each select="/a:ContinuityOfCareRecord/a:Body/a:HealthCareProviders/a:Provider">
                    <assignedEntity>
                        <xsl:call-template name="ccdEntity">
                            <xsl:with-param name="a:ccrActorObjectID" select="a:ActorID"/>
                        </xsl:call-template>
                    </assignedEntity>
                </xsl:for-each>

            </documentationOf>

            <component>
                <structuredBody>
                    <component>
                        <section>
                            <templateId root="2.16.840.1.113883.10.20.1.13"/>
                            <code code="48764-5" codeSystem="2.16.840.1.113883.6.1" />
                            <title>Purpose</title>
                            <text>
                                <xsl:value-of select="/a:ContinuityOfCareRecord/a:Purpose/a:Description/a:Text"></xsl:value-of>
                            </text>
                        </section>
                    </component>
                    <xsl:if test="a:ContinuityOfCareRecord/a:Body/a:Alerts">
                        <component>
                            <section>
                                <templateId root="2.16.840.1.113883.10.20.1.2"/>
                                <code code="46240-8" codeSystem="2.16.840.1.113883.6.1"/>
                                <title>Alerts</title>
                                <text>
                                    <table>
                                        <tbody>
                                            <tr>
                                                <th>Type</th>
                                                <th>Date</th>
                                                <th>Code</th>
                                                <th>Description</th>
                                                <th>Reaction</th>
                                                <th>Source</th>
                                            </tr>
                                            <xsl:for-each select="/a:ContinuityOfCareRecord/a:Body/a:Alerts/a:Alert">
                                                <tr>
                                                    <td>
                                                        <xsl:value-of select="a:Type/a:Text"/>
                                                    </td>
                                                    <td>
                                                        <xsl:call-template name="date:format-date">
                                                            <xsl:with-param name="date-time">
                                                                <xsl:value-of select="a:DateTime/a:ExactDateTime"/>
                                                            </xsl:with-param>
                                                        </xsl:call-template>
                                                    </td>
                                                    <td>
                                                        <xsl:apply-templates select="a:Description/a:Code"/>
                                                    </td>
                                                    <td>
                                                        <xsl:value-of select="a:Description/a:Text"/>
                                                    </td>
                                                    <td>
                                                        <xsl:value-of select="a:Reaction/a:Description/a:Text"/>
                                                        <xsl:if test="a:Reaction/a:Severity/a:Text">
                                                            -<xsl:value-of select="a:Reaction/a:Severity/a:Text"/>
                                                        </xsl:if>
                                                    </td>
                                                    <td>
                                                        <xsl:call-template name="actorName">
                                                            <xsl:with-param name="objID" select="a:Source/a:Actor/a:ActorID"/>
                                                        </xsl:call-template>
                                                    </td>
                                                </tr>
                                            </xsl:for-each>
                                        </tbody>
                                    </table>
                                </text>
                            </section>
                        </component>
                    </xsl:if>
                    <xsl:if test="a:ContinuityOfCareRecord/a:Body/a:AdvanceDirectives">
                        <component>
                            <section>
                                <templateId root="2.16.840.1.113883.10.20.1.1"/>
                                <code code="42348-3" codeSystem="2.16.840.1.113883.6.1"/>
                                <title>Advance Directives</title>
                                <text>
                                    <table>
                                        <tbody>
                                            <tr>
                                                <th>Type</th>
                                                <th>Date</th>
                                                <th>Description</th>
                                                <th>Status</th>
                                                <th>Source</th>
                                            </tr>
                                            <xsl:for-each select="/a:ContinuityOfCareRecord/a:Body/a:AdvanceDirectives/a:AdvanceDirective">
                                                <tr>
                                                    <td>
                                                        <xsl:value-of select="a:Type/a:Text"/>
                                                    </td>
                                                    <td>
                                                        <xsl:call-template name="date:format-date">
                                                            <xsl:with-param name="date-time">
                                                                <xsl:value-of select="a:DateTime/a:ExactDateTime"/>
                                                            </xsl:with-param>
                                                        </xsl:call-template>
                                                    </td>
                                                    <td>
                                                        <xsl:value-of select="a:Description/a:Text"/>
                                                    </td>
                                                    <td>
                                                        <xsl:value-of select="a:Status/a:Text"/>
                                                    </td>
                                                    <td>
                                                        <xsl:call-template name="actorName">
                                                            <xsl:with-param name="objID" select="a:Source/a:Actor/a:ActorID"/>
                                                        </xsl:call-template>
                                                    </td>
                                                </tr>
                                            </xsl:for-each>
                                        </tbody>
                                    </table>

                                </text>
                            </section>
                        </component>
                    </xsl:if>
                    <xsl:if test="a:ContinuityOfCareRecord/a:Body/a:FunctionalStatus">
                        <component>
                            <section>
                                <templateId root="2.16.840.1.113883.10.20.1.5"/>
                                <code code="47420-5" codeSystem="2.16.840.1.113883.6.1"/>
                                <title>Functional Status</title>
                                <text>
                                    <table>
                                        <tbody>
                                            <tr>
                                                <th>Type</th>
                                                <th>Date</th>
                                                <th>Code</th>
                                                <th>Description</th>
                                                <th>Status</th>
                                                <th>Source</th>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <xsl:value-of select="a:Type/a:Text"/>
                                                </td>
                                                <td>
                                                    <xsl:call-template name="date:format-date">
                                                        <xsl:with-param name="date-time">
                                                            <xsl:value-of select="a:DateTime/a:ExactDateTime"/>
                                                        </xsl:with-param>
                                                    </xsl:call-template>
                                                </td>
                                                <td>
                                                    <xsl:apply-templates select="a:Description/a:Code"/>
                                                </td>
                                                <td>
                                                    <xsl:value-of select="a:Description/a:Text"/>
                                                </td>
                                                <td>
                                                    <xsl:value-of select="a:Status/a:Text"/>
                                                </td>
                                                <td>
                                                    <xsl:call-template name="actorName">
                                                        <xsl:with-param name="objID" select="a:Source/a:Actor/a:ActorID"/>
                                                    </xsl:call-template>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </text>
                            </section>
                        </component>
                    </xsl:if>
                    <xsl:if test="a:ContinuityOfCareRecord/a:Body/a:Problems">
                        <component>
                            <section>
                                <templateId root="2.16.840.1.113883.3.88.11.83.103" assigningAuthorityName="HITSP/C83"/>
                                <templateId root="1.3.6.1.4.1.19376.1.5.3.1.3.6" assigningAuthorityName="IHE PCC"/>
                                <templateId root="2.16.840.1.113883.10.20.1.11" assigningAuthorityName="HL7 CCD"/>
                                <code code="11450-4" codeSystem="2.16.840.1.113883.6.1" codeSystemName="LOINC" displayName="Problem list"/>
                                <title>Problems</title>
                                <text>
                                    <table>
                                        <tbody>
                                            <tr>
                                                <th>Type</th>
                                                <th>Date</th>
                                                <th>Code</th>
                                                <th>Description</th>
                                                <th>Status</th>
                                                <th>Source</th>
                                            </tr>
                                            <xsl:for-each select="/a:ContinuityOfCareRecord/a:Body/a:Problems/a:Problem">
                                                <tr>
                                                    <xsl:attribute name="id">
                                                        <xsl:value-of select="a:CCRDataObjectID"></xsl:value-of>
                                                    </xsl:attribute>

                                                    <td>
                                                        <xsl:value-of select="a:Type/a:Text"/>
                                                    </td>
                                                    <td>
                                                        <table>
                                                            <tbody>
                                                                <xsl:apply-templates select="a:DateTime"/>
                                                            </tbody>
                                                        </table>
                                                    </td>
                                                    <td>
                                                        <xsl:apply-templates select="a:Description/a:Code"/>
                                                    </td>
                                                    <td>
                                                        <xsl:value-of select="a:Description/a:Text"/>
                                                    </td>
                                                    <td>
                                                        <xsl:value-of select="a:Status/a:Text"/>
                                                    </td>
                                                    <td>
                                                        <xsl:call-template name="actorName">
                                                            <xsl:with-param name="objID" select="a:Source/a:Actor/a:ActorID"/>
                                                        </xsl:call-template>
                                                    </td>
                                                </tr>
                                            </xsl:for-each>
                                        </tbody>
                                    </table>
                                </text>
                                <xsl:for-each select="/a:ContinuityOfCareRecord/a:Body/a:Problems/a:Problem">
                                    <entry typeCode="DRIV">
                                        <act classCode="ACT" moodCode="EVN">
                                            <templateId root="2.16.840.1.113883.10.20.1.27"/>
                                            <!-- Problem act template -->

                                            <!-- <id> -->
                                            <xsl:call-template name="ccdID">
                                                <xsl:with-param name="ccrObjectID">
                                                    <xsl:value-of select="a:CCRDataObjectID"></xsl:value-of>
                                                </xsl:with-param>
                                            </xsl:call-template>

                                            <code nullFlavor="NA"/>

                                            <performer typeCode="PRF">
                                                <assignedEntity>
                                                    <xsl:call-template name="ccdEntity">
                                                        <xsl:with-param name="ccrActorObjectID">
                                                            <xsl:value-of select="a:Source/a:Actor/a:ActorID"></xsl:value-of>
                                                        </xsl:with-param>
                                                    </xsl:call-template>
                                                </assignedEntity>
                                            </performer>

                                            <entryRelationship typeCode="SUBJ">
                                                <observation classCode="OBS" moodCode="EVN">
                                                    <templateId root="2.16.840.1.113883.10.20.1.28" assigningAuthorityName="CCD"/>
                                                    <!--Problem observation template-->

                                                    <!-- <id> -->
                                                    <xsl:call-template name="ccdID">
                                                        <xsl:with-param name="ccrObjectID">
                                                            <xsl:value-of select="a:CCRDataObjectID"></xsl:value-of>
                                                        </xsl:with-param>
                                                        <xsl:with-param name="suffix">.1</xsl:with-param>
                                                    </xsl:call-template>

                                                    <code code="64572001" displayName="Condition" codeSystem="2.16.840.1.113883.6.96" codeSystemName="SNOMED-CT"/>

                                                    <text>
                                                        <reference>
                                                            <xsl:attribute name="value">
                                                                <xsl:text>#</xsl:text>
                                                                <xsl:value-of select="a:CCRDataObjectID"/>
                                                            </xsl:attribute>
                                                        </reference>
                                                    </text>

                                                    <statusCode code="completed"/>

                                                    <xsl:call-template name="ccdDateTime">
                                                        <xsl:with-param name="dt" select="a:DateTime"/>
                                                    </xsl:call-template>

                                                    <xsl:call-template name="ccdCodedValue">
                                                        <xsl:with-param name="ccrCodedDescription" select="a:Description"/>
                                                    </xsl:call-template>

                                                    <xsl:call-template name="ccdStatus">
                                                        <xsl:with-param name="ccrStatus" select="a:Status"/>
                                                    </xsl:call-template>
                                                </observation>
                                            </entryRelationship>

                                        </act>
                                    </entry>
                                </xsl:for-each>
                            </section>
                        </component>
                    </xsl:if>
                    <xsl:if test="a:ContinuityOfCareRecord/a:Body/a:Procedures">
                        <component>
                            <section>
                                <templateId root="2.16.840.1.113883.10.20.1.12"/>
                                <code code="47519-4" codeSystem="2.16.840.1.113883.6.1"/>
                                <title>Procedures</title>
                                <text>
                                    <table>
                                        <tbody>
                                            <tr>
                                                <th>Type</th>
                                                <th>Date</th>
                                                <th>Code</th>
                                                <th>Description</th>
                                                <th>Location</th>
                                                <th>Substance</th>
                                                <th>Method</th>
                                                <th>Position</th>
                                                <th>Site</th>
                                                <th>Status</th>
                                                <th>Source</th>
                                            </tr>
                                            <xsl:for-each select="/a:ContinuityOfCareRecord/a:Body/a:Procedures/a:Procedure">
                                                <tr>
                                                    <xsl:attribute name="id">
                                                        <xsl:value-of select="a:CCRDataObjectID"></xsl:value-of>
                                                    </xsl:attribute>

                                                    <td>
                                                        <xsl:value-of select="a:Type/a:Text"/>
                                                    </td>
                                                    <table>
                                                        <tbody>
                                                            <xsl:apply-templates select="a:DateTime"/>
                                                        </tbody>
                                                    </table>
                                                    <td>
                                                        <xsl:apply-templates select="a:Description/a:Code"/>
                                                    </td>
                                                    <td>
                                                        <xsl:value-of select="a:Description/a:Text"/>
                                                    </td>
                                                    <td>
                                                        <xsl:for-each select="a:Locations/a:Location">
                                                            <xsl:value-of select="a:Description/a:Text"/>
                                                            <xsl:if test="a:Actor">
                                                                (<xsl:call-template name="actorName">
                                                                    <xsl:with-param name="objID" select="a:Actor/a:ActorID"/>
                                                                </xsl:call-template>
                                                                <xsl:if test="a:Actor/a:ActorRole/a:Text">
                                                                    <xsl:text xml:space="preserve"> - </xsl:text><xsl:value-of select="a:ActorRole/a:Text"/>)
                                                                </xsl:if>
                                                            </xsl:if>)
                                                            <xsl:if test="position() != last()">
                                                                <br/>
                                                            </xsl:if>
                                                        </xsl:for-each>
                                                    </td>
                                                    <td>
                                                        <xsl:for-each select="a:Substance">
                                                            <xsl:value-of select="a:Text"/>
                                                        </xsl:for-each>
                                                    </td>
                                                    <td>
                                                        <xsl:value-of select="a:Method/a:Text"/>
                                                    </td>
                                                    <td>
                                                        <xsl:value-of select="a:Position/a:Text"/>
                                                    </td>
                                                    <td>
                                                        <xsl:value-of select="a:Site/a:Text"/>
                                                    </td>
                                                    <td>
                                                        <xsl:value-of select="a:Status/a:Text"/>
                                                    </td>
                                                    <td>
                                                        <xsl:call-template name="actorName">
                                                            <xsl:with-param name="objID" select="a:Source/a:Actor/a:ActorID"/>
                                                        </xsl:call-template>
                                                    </td>
                                                </tr>
                                            </xsl:for-each>
                                        </tbody>
                                    </table>
                                </text>
                            </section>
                        </component>
                        <xsl:for-each select="/a:ContinuityOfCareRecord/a:Body/a:Procedures/a:Procedure">
                            <entry typeCode="DRIV">
                                <procedure classCode="PROC" moodCode="EVN">
                                    <templateId root="2.16.840.1.113883.3.88.11.83.17" assigningAuthorityName="HITSP C83"/>
                                    <templateId root="2.16.840.1.113883.10.20.1.29" assigningAuthorityName="CCD"/>
                                    <templateId root="1.3.6.1.4.1.19376.1.5.3.1.4.19" assigningAuthorityName="IHE PCC"/>
                                    <id>
                                        <xsl:attribute name="root">
                                            <xsl:value-of select="a:CCRDataObjectID"></xsl:value-of>
                                        </xsl:attribute>
                                    </id>
                                    <code>
                                        <xsl:attribute name="code">
                                            <xsl:value-of select="a:Description/a:Code/a:Value"/>
                                        </xsl:attribute>
                                        <xsl:attribute name="codeSystemName">
                                            <xsl:value-of select="a:Description/a:Code/a:CodingSystem"/>
                                        </xsl:attribute>
                                        <xsl:attribute name="codeSystem">
                                            <xsl:call-template name="HL7OIDLookup">
                                                <xsl:with-param name="name" select="a:Description/a:Code/a:CodingSystem"/>
                                            </xsl:call-template>
                                        </xsl:attribute>
                                        <xsl:attribute name="displayName">
                                            <xsl:value-of select="a:Description/a:Text"/>
                                        </xsl:attribute>
                                    </code>
                                    <text>
                                        <reference>
                                            <xsl:attribute name="value">
                                                <xsl:value-of select="a:CCRDataObjectID"/>
                                            </xsl:attribute>
                                        </reference>
                                    </text>
                                    <statusCode>
                                        <xsl:attribute name="value">
                                            <xsl:value-of select="a:Status/a:Text"/>
                                        </xsl:attribute>
                                    </statusCode>
                                    <xsl:call-template name="ccdDateTime">
                                        <xsl:with-param name="dt" select="a:DateTime"/>
                                    </xsl:call-template>
                                    <xsl:if test="a:Method">
                                        <approachSiteCode>
                                            <xsl:attribute name="code">
                                                <xsl:value-of select="a:Method/a:Code/a:Value"/>
                                            </xsl:attribute>
                                            <xsl:attribute name="codeSystemName">
                                                <xsl:value-of select="a:Method/a:Code/a:CodingSystem"/>
                                            </xsl:attribute>
                                            <xsl:attribute name="codeSystem">
                                                <xsl:call-template name="HL7OIDLookup">
                                                    <xsl:with-param name="name" select="a:Method/a:Code/a:CodingSystem"/>
                                                </xsl:call-template>
                                            </xsl:attribute>
                                            <xsl:attribute name="displayName">
                                                <xsl:value-of select="a:Method/a:Text"/>
                                            </xsl:attribute>
                                        </approachSiteCode>
                                    </xsl:if>
                                    <xsl:if test="a:Site">
                                        <targetSiteCode>
                                            <xsl:attribute name="code">
                                                <xsl:value-of select="a:Site/a:Code/a:Value"/>
                                            </xsl:attribute>
                                            <xsl:attribute name="codeSystemName">
                                                <xsl:value-of select="a:Site/a:Code/a:CodingSystem"/>
                                            </xsl:attribute>
                                            <xsl:attribute name="codeSystem">
                                                <xsl:call-template name="HL7OIDLookup">
                                                    <xsl:with-param name="name" select="a:Site/a:Code/a:CodingSystem"/>
                                                </xsl:call-template>
                                            </xsl:attribute>
                                            <xsl:attribute name="displayName">
                                                <xsl:value-of select="a:Site/a:Text"/>
                                            </xsl:attribute>
                                        </targetSiteCode>
                                    </xsl:if>
                                    <xsl:if test="a:Practitioners/a:Practitioner">
                                        <xsl:variable name="PractitionerActorID" select="a:Practitioners/a:Practitioner[0]/a:ActorID"/>
                                        <performer typeCode="PRF">
                                            <assignedEntity>
                                                <xsl:variable name="CCRActor" select="/a:ContinuityOfCareRecord/a:Actors[a:ActorObjectID=$PractitionerActorID]/a:Actor"/>
                                                <xsl:if test="$CCRActor/a:Address">
                                                    <addr>
                                                        <streetAddressLine>
                                                            <xsl:value-of select="$CCRActor/a:Address[0]/a:Line1"/>
                                                        </streetAddressLine>
                                                        <city>
                                                            <xsl:value-of select="$CCRActor/a:Address[0]/a:City"/>
                                                        </city>
                                                        <state>
                                                            <xsl:value-of select="$CCRActor/a:Address[0]/a:State"/>
                                                        </state>
                                                        <postalcode>
                                                            <xsl:value-of select="$CCRActor/a:Address[0]/a:PostalCode"/>
                                                        </postalcode>
                                                    </addr>
                                                </xsl:if>
                                                <xsl:if test="$CCRActor/a:Telephone">
                                                    <telecom>
                                                        <xsl:attribute name="extension">
                                                            <xsl:value-of select="$CCRActor/a:Telephone[0]/a:Value"/>
                                                        </xsl:attribute>
                                                    </telecom>
                                                </xsl:if>
                                                <assignedPerson>
                                                    <name>
                                                        <xsl:call-template name="actorName">
                                                            <xsl:with-param name="objID" select="$PractitionerActorID"/>
                                                        </xsl:call-template>
                                                    </name>
                                                </assignedPerson>
                                            </assignedEntity>
                                        </performer>
                                    </xsl:if>
                                </procedure>
                            </entry>
                        </xsl:for-each>
                    </xsl:if>
                    <xsl:if test="a:ContinuityOfCareRecord/a:Body/a:Medications">
                        <component>
                            <section>
                                <templateId root="2.16.840.1.113883.3.88.11.83.112" assigningAuthorityName="HITSP/C83"/>
                                <templateId root="1.3.6.1.4.1.19376.1.5.3.1.3.19" assigningAuthorityName="IHE PCC"/>
                                <templateId root="2.16.840.1.113883.10.20.1.8" assigningAuthorityName="HL7 CCD"/>
                                <!--Medications section template-->
                                <code code="10160-0" codeSystem="2.16.840.1.113883.6.1" codeSystemName="LOINC" displayName="History of medication use"/>
                                <title>Medications</title>
                                <text>
                                    <table>
                                        <tbody>
                                            <tr>
                                                <th>Medication</th>
                                                <th>Date</th>
                                                <th>Status</th>
                                                <th>Form</th>
                                                <th>Strength</th>
                                                <th>Quantity</th>
                                                <th>SIG</th>
                                                <th>Indications</th>
                                                <th>Instruction</th>
                                                <th>Refills</th>
                                                <th>Source</th>
                                            </tr>
                                            <xsl:for-each select="/a:ContinuityOfCareRecord/a:Body/a:Medications/a:Medication">
                                                <tr>
                                                    <td>
                                                        <xsl:value-of select="a:Product/a:ProductName/a:Text"/>
                                                        <xsl:if test="a:Product/a:BrandName">
                                                            <xsl:text xml:space="preserve"> </xsl:text>(<xsl:value-of select="a:Product/a:BrandName/a:Text"/>)
                                                        </xsl:if>

                                                    </td>
                                                    <td>
                                                        <xsl:call-template name="date:format-date">
                                                            <xsl:with-param name="date-time">
                                                                <xsl:value-of select="a:DateTime/a:ExactDateTime"/>
                                                            </xsl:with-param>
                                                        </xsl:call-template>
                                                    </td>
                                                    <td>
                                                        <xsl:value-of select="a:Status/a:Text"/>
                                                    </td>
                                                    <td>
                                                        <xsl:value-of select="a:Product/a:Form/a:Text"/>
                                                    </td>
                                                    <td>
                                                        <xsl:for-each select="a:Product/a:Strength">
                                                            <xsl:if test="position() > 1">
                                                                <xsl:text>/</xsl:text>
                                                            </xsl:if>
                                                            <xsl:value-of select="a:Value"/>
                                                            <xsl:text xml:space="preserve"> </xsl:text>
                                                            <xsl:value-of select="a:Units/a:Unit"/>
                                                        </xsl:for-each>
                                                    </td>
                                                    <td>
                                                        <xsl:value-of select="a:Quantity/a:Value"/>
                                                        <xsl:text xml:space="preserve"> </xsl:text>
                                                        <xsl:value-of select="a:Quantity/a:Units/a:Unit"/>
                                                    </td>
                                                    <td>
                                                        <xsl:for-each select="a:Directions/a:Direction">
                                                            <xsl:choose>
                                                                <xsl:when test="a:Description/a:Text">
                                                                    <xsl:value-of select="a:Description/a:Text"/>
                                                                </xsl:when>
                                                                <xsl:otherwise>
                                                                    <xsl:value-of select="a:Dose/a:Value"/>
                                                                    <xsl:text xml:space="preserve"> </xsl:text>
                                                                    <xsl:value-of select="a:Dose/a:Units/a:Unit"/>
                                                                    <xsl:text xml:space="preserve"> </xsl:text>
                                                                    <xsl:value-of select="a:Route/a:Text"/>
                                                                    <xsl:text xml:space="preserve"> </xsl:text>
                                                                    <xsl:value-of select="a:Frequency/a:Value"/>
                                                                    <xsl:if test="a:Duration">
                                                                        <xsl:text xml:space="preserve">( </xsl:text>for <xsl:value-of select="a:Duration/a:Value"/><xsl:text xml:space="preserve"> </xsl:text><xsl:value-of select="a:Duration/a:Units/a:Unit"/><xsl:text xml:space="preserve"> )</xsl:text>
                                                                    </xsl:if>
                                                                    <xsl:if test="a:MultipleDirectionModifier/a:ObjectAttribute">
                                                                        <xsl:for-each select="a:MultipleDirectionModifier/a:ObjectAttribute">
                                                                            <xsl:value-of select="a:Attribute"/>
                                                                            <br/>
                                                                            <xsl:value-of select="a:AttributeValue/a:Value"/>
                                                                        </xsl:for-each>
                                                                    </xsl:if>
                                                                </xsl:otherwise>
                                                            </xsl:choose>
                                                        </xsl:for-each>
                                                    </td>
                                                    <td>
                                                        <xsl:for-each select="a:Directions/a:Direction[1]/a:Indication">
                                                            <xsl:call-template name="problemDescription">
                                                                <xsl:with-param name="objID" select="a:InternalCCRLink/a:LinkID"/>
                                                            </xsl:call-template>
                                                            <br/>
                                                        </xsl:for-each>
                                                    </td>
                                                    <td>
                                                        <xsl:for-each select="a:PatientInstructions/a:Instruction">
                                                            <xsl:value-of select="a:Text"/>
                                                            <br/>
                                                        </xsl:for-each>
                                                    </td>
                                                    <td>
                                                        <xsl:for-each select="a:Refills/a:Refill">
                                                            <xsl:value-of select="a:Number"/>
                                                            <xsl:text xml:space="preserve"> </xsl:text>
                                                        </xsl:for-each>
                                                    </td>
                                                    <td>
                                                        <xsl:call-template name="actorName">
                                                            <xsl:with-param name="objID" select="a:Source/a:Actor/a:ActorID"/>
                                                        </xsl:call-template>
                                                    </td>
                                                </tr>
                                            </xsl:for-each>
                                        </tbody>
                                    </table>
                                </text>
                                <xsl:for-each select="/a:ContinuityOfCareRecord/a:Body/a:Medications/a:Medication">
                                    <entry typeCode="DRIV">
                                        <substanceAdministration classCode="SBADM" moodCode="EVN">
                                            <templateId root="2.16.840.1.113883.10.20.1.24" assigningAuthorityName="CCD"/>
                                            <templateId root="1.3.6.1.4.1.19376.1.5.3.1.4.7.1" assigningAuthorityName="IHE PCC"/>
                                            <!--Medication activity template -->
                                            <id>
                                                <xsl:attribute name="root">
                                                    <xsl:value-of select="a:CCRDataObjectID"></xsl:value-of>
                                                </xsl:attribute>
                                            </id>
                                            <statusCode>
                                                <xsl:attribute name="value">
                                                    <xsl:value-of select="a:Status/a:Text"/>
                                                </xsl:attribute>
                                            </statusCode>
                                            <xsl:call-template name="ccdDateTime">
                                                <xsl:with-param name="dt" select="a:DateTime"/>
                                                <xsl:with-param name="type" select="'IVL_TS'"/>
                                            </xsl:call-template>
                                            <xsl:call-template name="ccdMedicationFrequency">
                                                <xsl:with-param name="frequency" select="a:Directions/a:Direction/a:Frequency"/>
                                            </xsl:call-template>
                                            <xsl:if test="a:Directions/a:Direction/a:Route">
                                                <routeCode>
                                                    <xsl:attribute name="code">
                                                        <xsl:value-of select="a:Directions/a:Direction/a:Route/a:Code/a:Value"></xsl:value-of>
                                                    </xsl:attribute>
                                                    <xsl:attribute name="codeSystem">
                                                        <xsl:call-template name="HL7OIDLookup">
                                                            <xsl:with-param name="name" select="a:Directions/a:Direction/a:Route/a:Code/a:CodingSystem"/>
                                                        </xsl:call-template>
                                                    </xsl:attribute>
                                                    <xsl:attribute name="displayName">
                                                        <xsl:value-of select="a:Directions/a:Direction/a:Route/a:Text"></xsl:value-of>
                                                    </xsl:attribute>
                                                </routeCode>
                                            </xsl:if>
                                            <xsl:if test="a:Directions/a:Direction/a:Dose">
                                                <doseQuantity>
                                                    <low>
                                                        <xsl:attribute name="value">
                                                            <xsl:value-of select="a:Directions/a:Direction/a:Dose/a:Value"></xsl:value-of>
                                                        </xsl:attribute>
                                                        <xsl:attribute name="unit">
                                                            <xsl:value-of select="a:Directions/a:Direction/a:Dose/a:Unit"></xsl:value-of>
                                                        </xsl:attribute>
                                                    </low>
                                                    <high>
                                                        <xsl:attribute name="value">
                                                            <xsl:value-of select="a:Directions/a:Direction/a:Dose/a:Value"></xsl:value-of>
                                                        </xsl:attribute>
                                                        <xsl:attribute name="unit">
                                                            <xsl:value-of select="a:Directions/a:Direction/a:Dose/a:Unit"></xsl:value-of>
                                                        </xsl:attribute>
                                                    </high>
                                                </doseQuantity>
                                            </xsl:if>
                                            <consumable>
                                                <manufacturedProduct>
                                                    <templateId root="2.16.840.1.113883.3.88.11.83.8.2" assigningAuthorityName="HITSP C83"/>
                                                    <templateId root="2.16.840.1.113883.10.20.1.53" assigningAuthorityName="CCD"/>
                                                    <templateId root="1.3.6.1.4.1.19376.1.5.3.1.4.7.2" assigningAuthorityName="IHE PCC"/>
                                                    <!-- Product template -->
                                                    <manufacturedMaterial>
                                                        <code>
                                                            <xsl:attribute name="code">
                                                                <xsl:value-of select="a:Product/a:ProductName/a:Code/a:Value"></xsl:value-of>
                                                            </xsl:attribute>
                                                            <xsl:attribute name="codeSystem">
                                                                <xsl:call-template name="HL7OIDLookup">
                                                                    <xsl:with-param name="name" select="a:Product/a:ProductName/a:Code/a:CodingSystem"/>
                                                                </xsl:call-template>
                                                            </xsl:attribute>
                                                            <xsl:attribute name="displayName">
                                                                <xsl:value-of select="a:Product/a:ProductName/a:Text"></xsl:value-of>
                                                            </xsl:attribute>
                                                        </code>
                                                        <name>
                                                            <xsl:value-of select="a:Product/a:BrandName/a:Text"></xsl:value-of>
                                                        </name>
                                                    </manufacturedMaterial>
                                                </manufacturedProduct>
                                            </consumable>
                                        </substanceAdministration>
                                    </entry>
                                </xsl:for-each>
                            </section>
                        </component>
                    </xsl:if>
                    <xsl:if test="a:ContinuityOfCareRecord/a:Body/a:Immunizations">
                        <component>
                            <section>
                                <templateId root="2.16.840.1.113883.10.20.1.6"/>
                                <code code="11369-6" codeSystem="2.16.840.1.113883.6.1"/>
                                <title>Immunizations</title>
                                <text>
                                    <table>
                                        <tbody>
                                            <tr>
                                                <th>Code</th>
                                                <th>Vaccine</th>
                                                <th>Date</th>
                                                <th>Route</th>
                                                <th>Site</th>
                                                <th>Source</th>
                                            </tr>
                                            <xsl:for-each select="/a:ContinuityOfCareRecord/a:Body/a:Immunizations/a:Immunization">
                                                <tr>
                                                    <td>
                                                        <xsl:apply-templates select="a:Product/a:ProductName/a:Code"/>
                                                    </td>
                                                    <td>

                                                        <xsl:value-of select="a:Product/a:ProductName/a:Text"/>
                                                        <xsl:if test="a:Product/a:Form">
                                                            <xsl:text xml:space="preserve"> </xsl:text>(<xsl:value-of select="a:Product/a:Form/a:Text"/>)
                                                        </xsl:if>
                                                    </td>
                                                    <td>
                                                        <xsl:call-template name="date:format-date">
                                                            <xsl:with-param name="date-time">
                                                                <xsl:value-of select="a:DateTime/a:ExactDateTime"/>
                                                            </xsl:with-param>
                                                        </xsl:call-template>
                                                    </td>
                                                    <td>
                                                        <xsl:value-of select="a:Directions/a:Direction/a:Route/a:Text"/>
                                                    </td>
                                                    <td>
                                                        <xsl:value-of select="a:Directions/a:Direction/a:Site/a:Text"/>
                                                    </td>
                                                    <td>
                                                        <xsl:call-template name="actorName">
                                                            <xsl:with-param name="objID" select="a:Source/a:Actor/a:ActorID"/>
                                                        </xsl:call-template>
                                                    </td>
                                                </tr>
                                            </xsl:for-each>
                                        </tbody>
                                    </table>
                                </text>
                            </section>
                        </component>
                    </xsl:if>
                    <xsl:if test="a:ContinuityOfCareRecord/a:Body/a:VitalSigns">
                        <component>
                            <section>
                                <templateId root="2.16.840.1.113883.10.20.1.16"/>
                                <code code="8716-3" codeSystem="2.16.840.1.113883.6.1"/>
                                <title>Vital Signs</title>
                                <text>
                                    <table>
                                        <tbody>
                                            <tr>
                                                <th>Vital Sign</th>
                                                <th>Date</th>
                                                <th>Result</th>
                                                <th>Source</th>
                                            </tr>
                                            <xsl:for-each select="/a:ContinuityOfCareRecord/a:Body/a:VitalSigns/a:Result">
                                                <tr>
                                                    <td>
                                                        <xsl:value-of select="a:Description/a:Text"/>
                                                    </td>
                                                    <td>
                                                        <xsl:call-template name="date:format-date">
                                                            <xsl:with-param name="date-time">
                                                                <xsl:value-of select="a:DateTime/a:ExactDateTime"/>
                                                            </xsl:with-param>
                                                        </xsl:call-template>
                                                    </td>
                                                    <td>
                                                        <xsl:for-each select="a:Test">
                                                            <xsl:value-of select="a:Description/a:Text"/>
                                                            <xsl:text xml:space="preserve"> </xsl:text>
                                                            <xsl:value-of select="a:TestResult/a:Value"/>
                                                            <xsl:text xml:space="preserve"> </xsl:text>
                                                            <xsl:value-of select="a:TestResult/a:Units/a:Unit"/>
                                                            <xsl:text xml:space="preserve"> </xsl:text>
                                                            <xsl:value-of select="a:Flag/a:Text"/>
                                                            <br/>
                                                        </xsl:for-each>
                                                    </td>
                                                    <td>
                                                        <xsl:call-template name="actorName">
                                                            <xsl:with-param name="objID" select="a:Source/a:Actor/a:ActorID"/>
                                                        </xsl:call-template>
                                                    </td>
                                                </tr>
                                            </xsl:for-each>
                                        </tbody>
                                    </table>
                                </text>
                            </section>
                        </component>
                    </xsl:if>
                    <xsl:if test="a:ContinuityOfCareRecord/a:Body/a:Encounters">
                        <component>
                            <section>
                                <templateId root="2.16.840.1.113883.10.20.1.3"/>
                                <code code="46240-8" codeSystem="2.16.840.1.113883.6.1"/>
                                <title>Encounters</title>
                                <text>
                                    <table>
                                        <tbody>
                                            <tr>
                                                <th>Type</th>
                                                <th>Date</th>
                                                <th>Location</th>
                                                <th>Status</th>
                                                <th>Practitioner</th>
                                                <th>Description</th>
                                                <th>Indications</th>
                                                <th>Source</th>
                                            </tr>
                                            <xsl:for-each select="/a:ContinuityOfCareRecord/a:Body/a:Encounters/a:Encounter">
                                                <tr>
                                                    <td>
                                                        <xsl:value-of select="a:Type/a:Text"/>
                                                    </td>
                                                    <td>
                                                        <xsl:call-template name="date:format-date">
                                                            <xsl:with-param name="date-time">
                                                                <xsl:value-of select="a:DateTime/a:ExactDateTime"/>
                                                            </xsl:with-param>
                                                        </xsl:call-template>
                                                    </td>
                                                    <td>
                                                        <xsl:for-each select="a:Locations/a:Location">
                                                            <xsl:value-of select="a:Description/a:Text"/>
                                                            <xsl:call-template name="actorName">
                                                                <xsl:with-param name="objID" select="a:Actor/a:ActorID"/>
                                                            </xsl:call-template>
                                                            <br/>
                                                        </xsl:for-each>
                                                    </td>
                                                    <td>
                                                        <xsl:value-of select="a:Status/a:Text"/>
                                                    </td>
                                                    <td>
                                                        <xsl:for-each select="a:Practitioners/a:Practitioner">
                                                            <xsl:call-template name="actorName">
                                                                <xsl:with-param name="objID" select="a:ActorID"/>
                                                            </xsl:call-template>
                                                            <br/>
                                                        </xsl:for-each>
                                                    </td>
                                                    <td>
                                                        <xsl:value-of select="a:Description/a:Text"/>
                                                    </td>
                                                    <td>
                                                        <xsl:for-each select="a:Indications/a:Indication">
                                                            <xsl:call-template name="problemDescription">
                                                                <xsl:with-param name="objID" select="a:InternalCCRLink/a:LinkID"/>
                                                            </xsl:call-template>
                                                            <br/>
                                                        </xsl:for-each>
                                                    </td>
                                                    <td>
                                                        <xsl:call-template name="actorName">
                                                            <xsl:with-param name="objID" select="a:Source/a:Actor/a:ActorID"/>
                                                        </xsl:call-template>
                                                    </td>
                                                </tr>
                                            </xsl:for-each>
                                        </tbody>
                                    </table>
                                </text>
                            </section>
                        </component>
                    </xsl:if>
                    <xsl:if test="a:ContinuityOfCareRecord/a:Body/a:SocialHistory">
                        <component>
                            <section>
                                <templateId root="2.16.840.1.113883.10.20.1.15"/>
                                <code code="29762-2" codeSystem="2.16.840.1.113883.6.1"/>
                                <title>Social History</title>
                                <text>
                                    <table>
                                        <tbody>
                                            <tr>
                                                <th>Type</th>
                                                <th>Date</th>
                                                <th>Code</th>
                                                <th>Description</th>
                                                <th>Status</th>
                                                <th>Source</th>
                                            </tr>
                                            <xsl:for-each select="/a:ContinuityOfCareRecord/a:Body/a:SocialHistory/a:SocialHistoryElement">
                                                <tr>
                                                    <td>
                                                        <xsl:value-of select="a:Type/a:Text"/>
                                                    </td>
                                                    <td>
                                                        <xsl:call-template name="date:format-date">
                                                            <xsl:with-param name="date-time">
                                                                <xsl:value-of select="a:DateTime/a:ExactDateTime"/>
                                                            </xsl:with-param>
                                                        </xsl:call-template>
                                                    </td>
                                                    <td>
                                                        <xsl:apply-templates select="a:Description/a:Code"/>
                                                    </td>
                                                    <td>
                                                        <xsl:value-of select="a:Description/a:Text" disable-output-escaping="yes"/>
                                                    </td>
                                                    <td>
                                                        <xsl:value-of select="a:Status/a:Text"/>
                                                    </td>
                                                    <td>
                                                        <xsl:call-template name="actorName">
                                                            <xsl:with-param name="objID" select="a:Source/a:Actor/a:ActorID"/>
                                                        </xsl:call-template>
                                                    </td>
                                                </tr>
                                            </xsl:for-each>
                                        </tbody>
                                    </table>
                                </text>
                            </section>
                        </component>
                    </xsl:if>
                    <xsl:if test="a:ContinuityOfCareRecord/a:Body/a:FamilyHistory">
                        <component>
                            <section>
                                <templateId root="2.16.840.1.113883.10.20.1.4"/>
                                <code code="10157-6" codeSystem="2.16.840.1.113883.6.1"/>
                                <title>Family History</title>
                                <text>
                                    <table>
                                        <tbody>
                                            <tr>
                                                <th>Type</th>
                                                <th>Date</th>
                                                <th>Code</th>
                                                <th>Description</th>
                                                <th>Relationship(s)</th>
                                                <th>Status</th>
                                                <th>Source</th>
                                            </tr>
                                            <xsl:for-each select="/a:ContinuityOfCareRecord/a:Body/a:FamilyHistory/a:FamilyProblemHistory">
                                                <tr>
                                                    <td>
                                                        <xsl:value-of select="a:Type/a:Text"/>
                                                    </td>
                                                    <td>
                                                        <xsl:call-template name="date:format-date">
                                                            <xsl:with-param name="date-time">
                                                                <xsl:value-of select="a:DateTime/a:ExactDateTime"/>
                                                            </xsl:with-param>
                                                        </xsl:call-template>
                                                    </td>
                                                    <td>
                                                        <xsl:apply-templates select="a:Problem/a:Description/a:Code"/>
                                                    </td>
                                                    <td>
                                                        <xsl:for-each select="a:Problem">
                                                            <xsl:value-of select="a:Description/a:Text"/>
                                                            <br/>
                                                        </xsl:for-each>
                                                    </td>
                                                    <td>
                                                        <xsl:value-of select="a:FamilyMember/a:ActorRole/a:Text"/>
                                                    </td>
                                                    <td>
                                                        <xsl:value-of select="a:Status/a:Text"/>
                                                    </td>
                                                    <td>
                                                        <xsl:call-template name="actorName">
                                                            <xsl:with-param name="objID" select="a:Source/a:Actor/a:ActorID"/>
                                                        </xsl:call-template>
                                                    </td>
                                                </tr>
                                            </xsl:for-each>
                                        </tbody>
                                    </table>
                                </text>
                            </section>
                        </component>
                    </xsl:if>
                    <xsl:if test="a:ContinuityOfCareRecord/a:Body/a:Results/a:Result">
                        <component>
                            <section>
                                <templateId root="2.16.840.1.113883.10.20.1.14"/>
                                <code code="30954-2" codeSystem="2.16.840.1.113883.6.1"/>
                                <title>Results</title>
                                <text>
                                    <table>
                                        <tbody>
                                            <tr>
                                                <th>Test</th>
                                                <th>Date</th>
                                                <th>Result</th>
                                                <th>Source</th>
                                            </tr>
                                            <xsl:for-each select="/a:ContinuityOfCareRecord/a:Body/a:Results/a:Result[a:Test/a:TestResult/a:Value!='']">
                                                <tr>
                                                    <td>
                                                        <xsl:value-of select="a:Description/a:Text"/>
                                                    </td>
                                                    <td>
                                                        <xsl:call-template name="date:format-date">
                                                            <xsl:with-param name="date-time">
                                                                <xsl:value-of select="a:DateTime/a:ExactDateTime"/>
                                                            </xsl:with-param>
                                                        </xsl:call-template>
                                                    </td>
                                                    <td>
                                                        <xsl:for-each select="a:Test[a:TestResult/a:Value!='']">
                                                            <xsl:value-of select="a:Description/a:Text"/>
                                                            <xsl:text xml:space="preserve"> </xsl:text>
                                                            <xsl:value-of select="a:TestResult/a:Value"/>
                                                            <xsl:text xml:space="preserve"> </xsl:text>
                                                            <xsl:value-of select="a:TestResult/a:Units/a:Unit"/>
                                                            <xsl:text xml:space="preserve"> </xsl:text>
                                                            <xsl:value-of select="a:Flag/a:Text"/>
                                                            <br/>
                                                        </xsl:for-each>
                                                        <xsl:for-each select="a:Test[a:TestResult/a:Description/a:Text!='']">
                                                            <xsl:value-of select="a:Description/a:Text"/>
                                                            <xsl:text xml:space="preserve"> </xsl:text>
                                                            <xsl:value-of select="a:TestResult/a:Description/a:Text" disable-output-escaping="yes"/>
                                                            <xsl:text xml:space="preserve"> </xsl:text>
                                                            <xsl:value-of select="a:Flag/a:Text"/>
                                                            <br/>
                                                        </xsl:for-each>
                                                    </td>
                                                    <td>
                                                        <xsl:call-template name="actorName">
                                                            <xsl:with-param name="objID" select="a:Source/a:Actor/a:ActorID"/>
                                                        </xsl:call-template>
                                                    </td>
                                                </tr>
                                            </xsl:for-each>
                                        </tbody>
                                    </table>
                                </text>
                            </section>
                        </component>
                    </xsl:if>
                    <xsl:if test="a:ContinuityOfCareRecord/a:Body/a:Payers">
                        <component>
                            <section>
                                <templateId root="2.16.840.1.113883.10.20.1.9"/>
                                <code code="48768-6" codeSystem="2.16.840.1.113883.6.1"/>
                                <title>Insurance</title>
                                <text>
                                    <table>
                                        <tbody>
                                            <tr>
                                                <th>Type</th>
                                                <th>Date</th>
                                                <th>Identification Numbers</th>
                                                <th>Payment Provider</th>
                                                <th>Subscriber</th>
                                                <th>Source</th>
                                            </tr>
                                            <xsl:for-each select="/a:ContinuityOfCareRecord/a:Body/a:Payers/a:Payer">
                                                <tr>
                                                    <td>
                                                        <xsl:value-of select="a:Type/a:Text"/>
                                                    </td>
                                                    <td>
                                                        <xsl:call-template name="date:format-date">
                                                            <xsl:with-param name="date-time">
                                                                <xsl:value-of select="a:DateTime/a:ExactDateTime"/>
                                                            </xsl:with-param>
                                                        </xsl:call-template>
                                                    </td>
                                                    <td>
                                                        <xsl:for-each select="a:IDs">
                                                            <xsl:value-of select="a:Type/a:Text"/>:<xsl:text xml:space="preserve"> </xsl:text><xsl:value-of select="a:ID"/><br/>
                                                        </xsl:for-each>
                                                    </td>
                                                    <td>
                                                        <xsl:call-template name="actorName">
                                                            <xsl:with-param name="objID" select="a:PaymentProvider/a:ActorID"/>
                                                        </xsl:call-template>
                                                    </td>
                                                    <td>
                                                        <xsl:call-template name="actorName">
                                                            <xsl:with-param name="objID" select="a:Subscriber/a:ActorID"/>
                                                        </xsl:call-template>
                                                    </td>
                                                    <td>
                                                        <xsl:call-template name="actorName">
                                                            <xsl:with-param name="objID" select="a:Source/a:Actor/a:ActorID"/>
                                                        </xsl:call-template>
                                                    </td>
                                                </tr>
                                            </xsl:for-each>
                                        </tbody>
                                    </table>
                                </text>
                            </section>
                        </component>
                    </xsl:if>
                    <xsl:if test="a:ContinuityOfCareRecord/a:Body/a:PlanOfCare">
                        <component>
                            <section>
                                <templateId root="2.16.840.1.113883.10.20.1.10"/>
                                <code code="18776-5" codeSystem="2.16.840.1.113883.6.1"/>
                                <title>Plan Of Care</title>
                                <text>
                                    <xsl:if test="a:ContinuityOfCareRecord/a:Body/a:PlanOfCare/a:Plan[a:Type/a:Text='Treatment Recommendation']">
                                        <xsl:text>Plan Of Care Recommendations</xsl:text>
                                        <br/>
                                        <table>
                                            <tbody>
                                                <tr>
                                                    <th>Description</th>
                                                    <th>Recommendation</th>
                                                    <th>Goal</th>
                                                    <th>Status</th>
                                                    <th>Source</th>
                                                </tr>
                                                <xsl:for-each select="/a:ContinuityOfCareRecord/a:Body/a:PlanOfCare/a:Plan[a:Type/a:Text='Treatment Recommendation']">
                                                    <tr>
                                                        <td>
                                                            <xsl:value-of select="a:Description/a:Text"/>
                                                        </td>
                                                        <td>
                                                            <xsl:value-of select="a:OrderRequest/a:Description/a:Text" disable-output-escaping="yes"/>
                                                        </td>
                                                        <td>
                                                            <xsl:value-of select="a:OrderRequest/a:Goals/a:Goal/a:Description/a:Text" disable-output-escaping="yes"/>
                                                        </td>
                                                        <td>
                                                            <xsl:value-of select="a:Status/a:Text"/>
                                                        </td>
                                                        <td>
                                                            <xsl:call-template name="actorName">
                                                                <xsl:with-param name="objID" select="a:Source/a:Actor/a:ActorID"/>
                                                            </xsl:call-template>
                                                        </td>
                                                    </tr>
                                                </xsl:for-each>
                                            </tbody>
                                        </table>
                                    </xsl:if>
                                    <xsl:if test="a:ContinuityOfCareRecord/a:Body/a:PlanOfCare/a:Plan[a:Type/a:Text='Order']">
                                        <xsl:text>Plan Of Care Orders</xsl:text>
                                        <br/>
                                        <table>
                                            <tbody>
                                                <tr>
                                                    <th>Descripion</th>
                                                    <th>Plan Status</th>
                                                    <th>Type</th>
                                                    <th>Date</th>
                                                    <th>Procedure</th>
                                                    <th>Schedule</th>
                                                    <th>Location</th>
                                                    <th>Substance</th>
                                                    <th>Method</th>
                                                    <th>Position</th>
                                                    <th>Site</th>
                                                    <th>Status</th>
                                                    <th>Source</th>
                                                </tr>
                                                <xsl:for-each select="/a:ContinuityOfCareRecord/a:Body/a:PlanOfCare/a:Plan[a:Type/a:Text='Order']">
                                                    <tr>
                                                        <td>
                                                            <xsl:apply-templates select="a:Description/a:Text"/>
                                                        </td>
                                                        <td>
                                                            <xsl:value-of select="a:Status/a:Text"/>
                                                        </td>
                                                        <td>
                                                            <xsl:value-of select="a:OrderRequest/a:Procedures/a:Procedure/a:Type/a:Text"/>
                                                        </td>
                                                        <td>
                                                            <xsl:call-template name="date:format-date">
                                                                <xsl:with-param name="date-time">
                                                                    <xsl:value-of select="a:OrderRequest/a:Procedures/a:Procedure/a:DateTime/a:ExactDateTime"/>
                                                                </xsl:with-param>
                                                            </xsl:call-template>
                                                        </td>
                                                        <td>
                                                            <xsl:apply-templates select="a:OrderRequest/a:Procedures/a:Procedure/a:Description/a:Text"/>
                                                        </td>
                                                        <td>
                                                            <xsl:text xml:space="preserve">Every </xsl:text>
                                                            <xsl:apply-templates select="a:OrderRequest/a:Procedures/a:Procedure/a:Interval/a:Value"/>
                                                            <xsl:text xml:space="preserve"> </xsl:text>
                                                            <xsl:value-of select="a:OrderRequest/a:Procedures/a:Procedure/a:Interval/a:Units/a:Unit"/>
                                                            <xsl:text xml:space="preserve"> for </xsl:text>
                                                            <xsl:value-of select="a:OrderRequest/a:Procedures/a:Procedure/a:Duration/a:Value"/>
                                                            <xsl:text xml:space="preserve"> </xsl:text>
                                                            <xsl:value-of select="a:OrderRequest/a:Procedures/a:Procedure/a:Duration/a:Units/a:Unit"/>
                                                        </td>
                                                        <td>
                                                            <xsl:for-each select="a:OrderRequest/a:Procedures/a:Procedure/a:Locations">
                                                                <xsl:value-of select="a:Location/a:Description/a:Text"/>
                                                                <xsl:if test="position() != last()">
                                                                    <br/>
                                                                </xsl:if>
                                                            </xsl:for-each>
                                                        </td>
                                                        <td>
                                                            <xsl:value-of select="a:OrderRequest/a:Procedures/a:Procedure/a:Substance/a:Text"/>
                                                        </td>
                                                        <td>
                                                            <xsl:value-of select="a:OrderRequest/a:Procedures/a:Procedure/a:Method/a:Text"/>
                                                        </td>
                                                        <td>
                                                            <xsl:value-of select="a:OrderRequest/a:Procedures/a:Procedure/a:Position/a:Text"/>
                                                        </td>
                                                        <td>
                                                            <xsl:value-of select="a:OrderRequest/a:Procedures/a:Procedure/a:Site/a:Text"/>
                                                        </td>
                                                        <td/>
                                                        <td>
                                                            <xsl:call-template name="actorName">
                                                                <xsl:with-param name="objID" select="a:Source/a:Actor/a:ActorID"/>
                                                            </xsl:call-template>
                                                        </td>
                                                    </tr>
                                                </xsl:for-each>
                                            </tbody>
                                        </table>
                                    </xsl:if>
                                </text>
                            </section>
                        </component>
                    </xsl:if>
                    <xsl:if test="a:ContinuityOfCareRecord/a:Body/a:HealthCareProviders">
                        <component>
                            <section>
                                <title>Health Care Providers</title>
                                <text>
                                    <table>
                                        <tbody>
                                            <tr>
                                                <th>Role</th>
                                                <th>Name</th>
                                            </tr>
                                            <xsl:for-each select="/a:ContinuityOfCareRecord/a:Body/a:HealthCareProviders/a:Provider">
                                                <tr>
                                                    <td>
                                                        <xsl:value-of select="a:ActorRole/a:Text"/>
                                                    </td>
                                                    <td>
                                                        <xsl:call-template name="actorName">
                                                            <xsl:with-param name="objID" select="a:Source/a:Actor/a:ActorID"/>
                                                        </xsl:call-template>
                                                    </td>
                                                </tr>
                                            </xsl:for-each>
                                        </tbody>
                                    </table>
                                </text>
                            </section>
                        </component>
                    </xsl:if>
                    <xsl:if test="a:ContinuityOfCareRecord/a:Body/a:SupportProviders">
                        <component>
                            <section>
                                <title>Support Providers</title>
                                <text>
                                    <table>
                                        <tbody>
                                            <tr>
                                                <th>Role</th>
                                                <th>Name</th>
                                            </tr>
                                            <xsl:for-each select="/a:ContinuityOfCareRecord/a:Body/a:Support/a:SupportProvider">
                                                <tr>
                                                    <td>
                                                        <xsl:value-of select="a:ActorRole/a:Text"/>
                                                    </td>
                                                    <td>
                                                        <xsl:call-template name="actorName">
                                                            <xsl:with-param name="objID" select="a:Source/a:Actor/a:ActorID"/>
                                                        </xsl:call-template>
                                                    </td>
                                                </tr>
                                            </xsl:for-each>
                                        </tbody>
                                    </table>
                                </text>
                            </section>
                        </component>
                    </xsl:if>
                    <xsl:if test="a:ContinuityOfCareRecord/a:References">
                        <component>
                            <section>
                                <title>References</title>
                                <text>
                                    <table>
                                        <tbody>
                                            <tr>
                                                <th>Type</th>
                                                <th>Date</th>
                                                <th>Description</th>
                                                <th>Location</th>
                                                <th>Source</th>
                                            </tr>
                                            <xsl:for-each select="/a:ContinuityOfCareRecord/a:References/a:Reference">
                                                <tr>
                                                    <td>
                                                        <xsl:value-of select="a:Type/a:Text"/>
                                                    </td>
                                                    <td>
                                                        <xsl:call-template name="date:format-date">
                                                            <xsl:with-param name="date-time">
                                                                <xsl:value-of select="a:DateTime/a:ExactDateTime"/>
                                                            </xsl:with-param>
                                                        </xsl:call-template>
                                                    </td>
                                                    <td>
                                                        <strong class="clinical">
                                                            <xsl:value-of select="a:Description/a:Text"/>
                                                        </strong>
                                                    </td>
                                                    <td>
                                                        <xsl:value-of select="a:Locations/a:Location/a:Description/a:Text"/>
                                                    </td>
                                                    <td>
                                                        <xsl:call-template name="actorName">
                                                            <xsl:with-param name="objID" select="a:Source/a:Actor/a:ActorID"/>
                                                        </xsl:call-template>
                                                    </td>
                                                </tr>
                                            </xsl:for-each>
                                        </tbody>
                                    </table>
                                </text>
                            </section>
                        </component>
                    </xsl:if>
                    <component>
                        <section>
                            <title>Additional Information About People &amp; Organizations</title>
                            <text>
                                <xsl:if test="a:ContinuityOfCareRecord/a:Actors/a:Actor[a:Person]">
                                    <table>
                                        <tbody>
                                            <tr>
                                                <th>Name</th>
                                                <th>Specialty</th>
                                                <th>Relation</th>
                                                <th>Identification Numbers</th>
                                                <th>Phone</th>
                                                <th>Address/ E-mail</th>
                                            </tr>
                                            <xsl:for-each select="/a:ContinuityOfCareRecord/a:Actors/a:Actor">
                                                <xsl:sort select="a:Person/a:Name/a:DisplayName|a:Person/a:Name/a:CurrentName/a:Family" data-type="text" order="ascending"/>
                                                <xsl:if test="a:Person">
                                                    <tr>
                                                        <td>
                                                            <xsl:call-template name="actorName">
                                                                <xsl:with-param name="objID" select="a:ActorObjectID"/>
                                                            </xsl:call-template>
                                                        </td>
                                                        <td>
                                                            <xsl:value-of select="a:Specialty/a:Text"/>
                                                        </td>
                                                        <td>
                                                            <xsl:value-of select="a:Relation/a:Text"/>
                                                        </td>
                                                        <td>
                                                            <xsl:for-each select="a:IDs">
                                                                <xsl:value-of select="a:Type/a:Text"/>
                                                                <xsl:text>: </xsl:text>
                                                                <xsl:value-of select="a:ID"/>
                                                            </xsl:for-each>
                                                        </td>
                                                        <td>
                                                            <xsl:for-each select="a:Telephone">
                                                                <xsl:value-of select="a:Type/a:Text"/>
                                                                <xsl:text>: </xsl:text>
                                                                <xsl:value-of select="a:Value"/>
                                                            </xsl:for-each>
                                                        </td>
                                                        <td>
                                                            <xsl:for-each select="a:Address">
                                                                <xsl:if test="a:Type">
                                                                    <xsl:value-of select="a:Type/a:Text"/>
                                                                    <xsl:text>:</xsl:text>
                                                                    <br/>
                                                                </xsl:if>
                                                                <xsl:if test="a:Line1">
                                                                    <xsl:value-of select="a:Line1"/>
                                                                    <br/>
                                                                </xsl:if>
                                                                <xsl:if test="a:Line2">
                                                                    <xsl:value-of select="a:Line2"/>
                                                                    <br/>
                                                                </xsl:if>
                                                                <xsl:if test="a:City">
                                                                    <xsl:value-of select="a:City"/>
                                                                    <xsl:text>, </xsl:text>
                                                                </xsl:if>
                                                                <xsl:value-of select="a:State"/>
                                                                <xsl:value-of select="a:PostalCode"/>
                                                                <br/>
                                                            </xsl:for-each>
                                                            <xsl:for-each select="a:EMail">
                                                                <br/>
                                                                <xsl:value-of select="a:Value"/>
                                                            </xsl:for-each>
                                                        </td>
                                                    </tr>
                                                </xsl:if>
                                            </xsl:for-each>
                                        </tbody>
                                    </table>
                                </xsl:if>
                                <xsl:if test="a:ContinuityOfCareRecord/a:Actors/a:Actor[a:Organization]">
                                    <table>
                                        <tbody>
                                            <tr>
                                                <th>Name</th>
                                                <th>Specialty</th>
                                                <th>Relation</th>
                                                <th>Identification Numbers</th>
                                                <th>Phone</th>
                                                <th>Address/ E-mail</th>
                                            </tr>
                                            <xsl:for-each select="/a:ContinuityOfCareRecord/a:Actors/a:Actor">
                                                <xsl:sort select="a:Organization/a:Name" data-type="text" order="ascending"/>
                                                <xsl:if test="a:Organization">
                                                    <tr>
                                                        <td>
                                                            <xsl:value-of select="a:Organization/a:Name"/>
                                                        </td>
                                                        <td>
                                                            <xsl:value-of select="a:Specialty/a:Text"/>
                                                        </td>
                                                        <td>
                                                            <xsl:value-of select="a:Relation/a:Text"/>
                                                        </td>
                                                        <td>
                                                            <xsl:for-each select="a:IDs">
                                                                <xsl:value-of select="a:Type/a:Text"/>
                                                                <xsl:text>: </xsl:text>
                                                                <xsl:value-of select="a:ID"/>
                                                            </xsl:for-each>
                                                        </td>
                                                        <td>
                                                            <xsl:for-each select="a:Telephone">
                                                                <xsl:value-of select="a:Type/a:Text"/>
                                                                <xsl:text>: </xsl:text>
                                                                <xsl:value-of select="a:Value"/>
                                                            </xsl:for-each>
                                                        </td>
                                                        <td>
                                                            <xsl:for-each select="a:Address">
                                                                <xsl:if test="a:Type">
                                                                    <xsl:value-of select="a:Type/a:Text"/>
                                                                    <xsl:text>:</xsl:text>
                                                                    <br/>
                                                                </xsl:if>
                                                                <xsl:if test="a:Line1">
                                                                    <xsl:value-of select="a:Line1"/>
                                                                    <br/>
                                                                </xsl:if>
                                                                <xsl:if test="a:Line2">
                                                                    <xsl:value-of select="a:Line2"/>
                                                                    <br/>
                                                                </xsl:if>
                                                                <xsl:if test="a:City">
                                                                    <xsl:value-of select="a:City"/>
                                                                    <xsl:text>, </xsl:text>
                                                                </xsl:if>
                                                                <xsl:value-of select="a:State"/>
                                                                <xsl:value-of select="a:PostalCode"/>
                                                                <br/>
                                                            </xsl:for-each>
                                                            <xsl:for-each select="a:EMail">
                                                                <br/>
                                                                <xsl:value-of select="a:Value"/>
                                                            </xsl:for-each>
                                                        </td>
                                                    </tr>
                                                </xsl:if>
                                            </xsl:for-each>
                                        </tbody>
                                    </table>
                                </xsl:if>
                                <xsl:if test="a:ContinuityOfCareRecord/a:Actors/a:Actor[a:InformationSystem]">
                                    <table>
                                        <tbody>
                                            <tr>
                                                <th>Name</th>
                                                <th>Type</th>
                                                <th>Version</th>
                                                <th>Identification Numbers</th>
                                                <th>Phone</th>
                                                <th>Address/ E-mail</th>
                                            </tr>
                                            <xsl:for-each select="/a:ContinuityOfCareRecord/a:Actors/a:Actor">
                                                <xsl:sort select="a:InformationSystem/a:Name" data-type="text" order="ascending"/>
                                                <xsl:if test="a:InformationSystem">
                                                    <tr>
                                                        <td>
                                                            <xsl:value-of select="a:InformationSystem/a:Name"/>
                                                        </td>
                                                        <td>
                                                            <xsl:value-of select="a:InformationSystem/a:Type"/>
                                                        </td>
                                                        <td>
                                                            <xsl:value-of select="a:InformationSystem/a:Version"/>
                                                        </td>
                                                        <td>
                                                            <xsl:for-each select="a:IDs">
                                                                <xsl:value-of select="a:Type/a:Text"/>
                                                                <xsl:text>: </xsl:text>
                                                                <xsl:value-of select="a:ID"/>
                                                            </xsl:for-each>
                                                        </td>
                                                        <td>
                                                            <xsl:for-each select="a:Telephone">
                                                                <xsl:value-of select="a:Type/a:Text"/>
                                                                <xsl:text>: </xsl:text>
                                                                <xsl:value-of select="a:Value"/>
                                                            </xsl:for-each>
                                                        </td>
                                                        <td>
                                                            <xsl:for-each select="a:Address">
                                                                <xsl:if test="Type">
                                                                    <xsl:value-of select="a:Type/a:Text"/>
                                                                    <xsl:text>:</xsl:text>
                                                                    <br/>
                                                                </xsl:if>
                                                                <xsl:if test="a:Line1">
                                                                    <xsl:value-of select="a:Line1"/>
                                                                    <br/>
                                                                </xsl:if>
                                                                <xsl:if test="a:Line2">
                                                                    <xsl:value-of select="a:Line2"/>
                                                                    <br/>
                                                                </xsl:if>
                                                                <xsl:if test="a:City">
                                                                    <xsl:value-of select="a:City"/>
                                                                    <xsl:text>, </xsl:text>
                                                                </xsl:if>
                                                                <xsl:value-of select="a:State"/>
                                                                <xsl:value-of select="a:PostalCode"/>
                                                                <br/>
                                                            </xsl:for-each>
                                                            <xsl:for-each select="a:EMail">
                                                                <br/>
                                                                <xsl:value-of select="a:Value"/>
                                                            </xsl:for-each>
                                                        </td>
                                                    </tr>
                                                </xsl:if>
                                            </xsl:for-each>
                                        </tbody>
                                    </table>
                                </xsl:if>
                            </text>
                        </section>
                    </component>
                </structuredBody>
            </component>
        </ClinicalDocument>
    </xsl:template>
</xsl:stylesheet>