﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns="urn:hl7-org:v3" xmlns:a="urn:astm-org:CCR" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:date="http://exslt.org/dates-and-times" exclude-result-prefixes="a date">
    <!-- Converts the CCR DateTime to CCD effectiveTime.  Only ExactDateTime is supported (both alone and in DateTimeRange). -->
    <xsl:import href="../lib/date.format-date.template.xsl"/>
    <xsl:template name="ccdDateTime">
        <xsl:param name="dt"/>
        <xsl:param name="type"/>
        <xsl:if test="$dt">
            <xsl:if test="$dt[1]/a:ExactDateTime">
                <effectiveTime>
                    <xsl:if test="$type">
                        <xsl:attribute name="xsi:type">
                            <xsl:value-of select="$type"></xsl:value-of>
                        </xsl:attribute>
                    </xsl:if>
                    <low>
                        <xsl:attribute name="value">
                            <xsl:call-template name="date:format-date">
                                <xsl:with-param name="date-time">
                                    <xsl:value-of select="$dt[1]/a:ExactDateTime"/>
                                </xsl:with-param>
                                <xsl:with-param name="pattern">yyyyMMdd</xsl:with-param>
                            </xsl:call-template>
                        </xsl:attribute>
                    </low>
                    <high nullFlavor="UNK"/>
                </effectiveTime>
            </xsl:if>
            <xsl:if test="$dt[1]/a:DateTimeRange">
                <effectiveTime>
                    <low>
                        <xsl:attribute name="value">
                            <xsl:call-template name="date:format-date">
                                <xsl:with-param name="date-time">
                                    <xsl:value-of select="$dt[1]/a:DateTimeRange/a:BeginRange/a:ExactDateTime"/>
                                </xsl:with-param>
                                <xsl:with-param name="pattern">yyyyMMdd</xsl:with-param>
                            </xsl:call-template>
                        </xsl:attribute>
                    </low>
                    <high>
                        <xsl:attribute name="value">
                            <xsl:call-template name="date:format-date">
                                <xsl:with-param name="date-time">
                                    <xsl:value-of select="$dt[1]/a:DateTimeRange/a:EndRange/a:ExactDateTime"/>
                                </xsl:with-param>
                                <xsl:with-param name="pattern">yyyyMMdd</xsl:with-param>
                            </xsl:call-template>
                        </xsl:attribute>
                    </high>
                </effectiveTime>
            </xsl:if>
        </xsl:if>
    </xsl:template>

    <xsl:template name="dateTime" match="a:DateTime">
        <xsl:param name="dt" select="."/>
        <xsl:param name="fmt">MMM dd, yyyy</xsl:param>
        <xsl:for-each select="$dt">
            <tr>
                <xsl:if test="$dt/a:Type/a:Text">
                    <td>
                        <xsl:value-of select="a:Type/a:Text"/>:
                    </td>
                </xsl:if>
                <xsl:choose>
                    <xsl:when test="a:ExactDateTime">
                        <td>
                            <xsl:call-template name="date:format-date">
                                <xsl:with-param name="date-time">
                                    <xsl:value-of select="a:ExactDateTime"/>
                                </xsl:with-param>
                                <xsl:with-param name="pattern" select="$fmt"/>
                            </xsl:call-template>
                        </td>
                    </xsl:when>
                    <xsl:when test="$dt/a:Age">
                        <td>
                            <xsl:value-of select="$dt/a:Age/a:Value"/>
                            <xsl:text xml:space="preserve"> </xsl:text>
                            <xsl:value-of select="$dt/a:Age/a:Units/a:Unit"/>
                        </td>
                    </xsl:when>
                    <xsl:when test="$dt/a:ApproximateDateTime">
                        <td>
                            <xsl:value-of select="$dt/a:ApproximateDateTime/a:Text"/>
                        </td>
                    </xsl:when>
                    <xsl:when test="$dt/a:DateTimeRange">
                        <td>
                            <xsl:for-each select="$dt/a:DateTimeRange/a:BeginRange">
                                <xsl:choose>
                                    <xsl:when test="$dt/a:ExactDateTime">
                                        <xsl:call-template name="date:format-date">
                                            <xsl:with-param name="date-time">
                                                <xsl:value-of select="$dt/a:ExactDateTime"/>
                                            </xsl:with-param>
                                            <xsl:with-param name="pattern" select="$fmt"/>
                                        </xsl:call-template>
                                    </xsl:when>
                                    <xsl:when test="$dt/a:Age">
                                        <xsl:value-of select="$dt/a:Age/a:Value"/>
                                        <xsl:text xml:space="preserve"> </xsl:text>
                                        <xsl:value-of select="$dt/a:Age/a:Units/a:Unit"/>
                                    </xsl:when>
                                    <xsl:when test="$dt/a:ApproximateDateTime">
                                        <xsl:value-of select="$dt/a:ApproximateDateTime/a:Text"/>
                                    </xsl:when>
                                    <xsl:otherwise/>
                                </xsl:choose>
                            </xsl:for-each><xsl:text xml:space="preserve"> </xsl:text>
                            -<xsl:text xml:space="preserve"> </xsl:text>
                            <xsl:for-each select="$dt/a:DateTimeRange/a:EndRange">
                                <xsl:choose>
                                    <xsl:when test="$dt/a:ExactDateTime">
                                        <xsl:call-template name="date:format-date">
                                            <xsl:with-param name="date-time">
                                                <xsl:value-of select="$dt/a:ExactDateTime"/>
                                            </xsl:with-param>
                                            <xsl:with-param name="pattern" select="$fmt"/>
                                        </xsl:call-template>
                                    </xsl:when>
                                    <xsl:when test="$dt/a:Age">
                                        <xsl:value-of select="$dt/a:Age/a:Value"/>
                                        <xsl:text xml:space="preserve"> </xsl:text>
                                        <xsl:value-of select="$dt/a:Age/a:Units/a:Unit"/>
                                    </xsl:when>
                                    <xsl:when test="$dt/a:ApproximateDateTime">
                                        <xsl:value-of select="$dt/a:ApproximateDateTime/a:Text"/>
                                    </xsl:when>
                                    <xsl:otherwise/>
                                </xsl:choose>
                            </xsl:for-each>
                        </td>
                    </xsl:when>
                    <xsl:otherwise/>
                </xsl:choose>
            </tr>
        </xsl:for-each>
    </xsl:template>
</xsl:stylesheet>
