﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns="urn:hl7-org:v3" xmlns:a="urn:astm-org:CCR" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" exclude-result-prefixes="a">

    <xsl:import href="ccdcodedvalue.xsl"/>
    
    <xsl:template name="ccdStatus">
        <xsl:param name="ccrStatus"/>

        <entryRelationship typeCode="REFR">
            <observation classCode="OBS" moodCode="EVN">
                <templateId root="2.16.840.1.113883.10.20.1.50"/>
                <!-- Problem status observation template -->
                <code code="33999-4" codeSystem="2.16.840.1.113883.6.1" displayName="Status"/>
                <statusCode code="completed"/>
                <xsl:call-template name="ccdCodedValue">
                    <xsl:with-param name="ccrCodedDescription" select="$ccrStatus"/>
                </xsl:call-template>
            </observation>
        </entryRelationship>
    </xsl:template>
    
    <xsl:template name="ccdStatusObservation">
        <xsl:param name="status"/>
        <xsl:variable name="statusText" select="$status/a:Text"></xsl:variable>
        <xsl:choose>
            <xsl:when test="$statusText='Active'">
                <xsl:call-template name="ccdStatusElement">
                    <xsl:with-param name="statusCode" select="'55561003'"></xsl:with-param>
                    <xsl:with-param name="statusDisplayName" select="$statusText"></xsl:with-param>
                </xsl:call-template>
            </xsl:when>
            <xsl:when test="$statusText='Inactive'">
                <xsl:call-template name="ccdStatusElement">
                    <xsl:with-param name="statusCode" select="'73425007'"></xsl:with-param>
                    <xsl:with-param name="statusDisplayName" select="$statusText"></xsl:with-param>
                </xsl:call-template>
            </xsl:when>
            <xsl:when test="$statusText='Chronic'">
                <xsl:call-template name="ccdStatusElement">
                    <xsl:with-param name="statusCode" select="'90734009'"></xsl:with-param>
                    <xsl:with-param name="statusDisplayName" select="$statusText"></xsl:with-param>
                </xsl:call-template>
            </xsl:when>
        </xsl:choose>
    </xsl:template>

    <xsl:template name="ccdStatusElement">
        <xsl:param name="statusCode"/>
        <xsl:param name="statusDisplayName"/>
        <value>
            <xsl:attribute name="xsi:type">CE</xsl:attribute>
            <xsl:attribute name="code">
                <xsl:value-of select="$statusCode"></xsl:value-of>
            </xsl:attribute>
            <xsl:attribute name="codeSystem">2.16.840.1.113883.6.96</xsl:attribute>
            <xsl:attribute name="displayName">
                <xsl:value-of select="$statusDisplayName"></xsl:value-of>
            </xsl:attribute>
        </value>
    </xsl:template>

</xsl:stylesheet>

