﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns="urn:hl7-org:v3" xmlns:a="urn:astm-org:CCR" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" exclude-result-prefixes="a">
    <xsl:template name="ccdMedicationFrequency">
        <xsl:param name="frequency"/>
        <xsl:if test="$frequency">
            <xsl:choose>
                <xsl:when test="$frequency/a:Value='qd'">
                    <effectiveTime xsi:type="PIVL_TS" operator="A">
                        <xsl:attribute name="institutionSpecified">true</xsl:attribute>
                        <period>
                            <xsl:attribute name="value">24</xsl:attribute>
                            <xsl:attribute name="unit">h</xsl:attribute>
                        </period>
                    </effectiveTime>
                </xsl:when>
                <xsl:when test="$frequency/a:Value='bid'">
                    <effectiveTime xsi:type="PIVL_TS" operator="A">
                        <xsl:attribute name="institutionSpecified">true</xsl:attribute>
                        <period>
                            <xsl:attribute name="value">12</xsl:attribute>
                            <xsl:attribute name="unit">h</xsl:attribute>
                        </period>
                    </effectiveTime>
                </xsl:when>
                <xsl:when test="$frequency/a:Value='tid'">
                    <effectiveTime xsi:type="PIVL_TS" operator="A">
                        <xsl:attribute name="institutionSpecified">true</xsl:attribute>
                        <period>
                            <xsl:attribute name="value">8</xsl:attribute>
                            <xsl:attribute name="unit">h</xsl:attribute>
                        </period>
                    </effectiveTime>
                </xsl:when>
                <xsl:when test="$frequency/a:Value='qid'">
                    <effectiveTime xsi:type="PIVL_TS" operator="A">
                        <xsl:attribute name="institutionSpecified">true</xsl:attribute>
                        <period>
                            <xsl:attribute name="value">6</xsl:attribute>
                            <xsl:attribute name="unit">h</xsl:attribute>
                        </period>
                    </effectiveTime>
                </xsl:when>
                <xsl:when test="$frequency/a:Value='qam'">
                    <effectiveTime xsi:type='EIVL' operator='A'>
                        <event code='ACM'/>
                    </effectiveTime>
                </xsl:when>
                <xsl:when test="$frequency/a:Value='qpm'">
                    <effectiveTime xsi:type='EIVL' operator='A'>
                        <event code='PCV'/>
                    </effectiveTime>
                </xsl:when>
            </xsl:choose>
        </xsl:if>
    </xsl:template>
</xsl:stylesheet>