﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns="urn:hl7-org:v3" xmlns:a="urn:astm-org:CCR" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" exclude-result-prefixes="a">

    <xsl:import href="cdavocablookup.xsl"/>
    <xsl:import href="HL7OIDLookup.xsl"/>

    <xsl:template name="ccdCodedValue">
        <xsl:param name="ccrCodedDescription"/>
        <xsl:param name="type"/>
        <xsl:param name="domain"/>
        <xsl:param name="nodeName">value</xsl:param>

        <xsl:element name="{$nodeName}">
            <xsl:if test="$type">
                <xsl:attribute name="xsi:type">
                    <xsl:value-of select="$type"/>
                </xsl:attribute>
            </xsl:if>
            <xsl:attribute name="displayName">
                <xsl:value-of select="$ccrCodedDescription/a:Text"/>
            </xsl:attribute>
            <xsl:choose>
                <xsl:when test="$ccrCodedDescription/a:Code">
                    <xsl:attribute name="code">
                        <xsl:value-of select="$ccrCodedDescription/a:Code/a:Value"/>
                    </xsl:attribute>
                    <xsl:attribute name="codeSystemName">
                        <xsl:value-of select="$ccrCodedDescription/a:Code/a:CodingSystem"/>
                    </xsl:attribute>
                    <xsl:attribute name="codeSystem">
                        <xsl:call-template name="HL7OIDLookup">
                            <xsl:with-param name="name" select="$ccrCodedDescription/a:Code/a:CodingSystem"/>
                        </xsl:call-template>
                    </xsl:attribute>
                </xsl:when>
                <xsl:when test="$domain">
                    <xsl:attribute name="code">
                        <xsl:call-template name="CDAVocabularyLookup">
                            <xsl:with-param name="domain" select="$domain"/>
                            <xsl:with-param name="ccrDescription" select="$ccrCodedDescription/a:Text"/>
                        </xsl:call-template>
                    </xsl:attribute>
                    <xsl:attribute name="codeSystemName">
                        <xsl:call-template name="CDAVocabularyCodeSystemNameLookup">
                            <xsl:with-param name="domain" select="$domain"/>
                        </xsl:call-template>
                    </xsl:attribute>
                    <xsl:attribute name="codeSystemName">
                        <xsl:call-template name="CDAVocabularyCodeSystemLookup">
                            <xsl:with-param name="domain" select="$domain"/>
                        </xsl:call-template>
                    </xsl:attribute>
                </xsl:when>
            </xsl:choose>
        </xsl:element>

    </xsl:template>
</xsl:stylesheet>