﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns="urn:hl7-org:v3" xmlns:a="urn:astm-org:CCR" xmlns:date="http://exslt.org/dates-and-times" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" exclude-result-prefixes="a date">

    <xsl:import href="actor.xsl"/>
    <xsl:import href="ccdcodedvalue.xsl"/>
    <xsl:import href="ccddatetime.xsl"/>
    <xsl:import href="cdavocablookup.xsl"/>

    <xsl:template name="ccdEntity">
        <xsl:param name="ccrActorObjectID"/>
        <xsl:param name="personNodeName">assignedPerson</xsl:param>

        <xsl:variable name="CCRActor" select="//a:ContinuityOfCareRecord/a:Actors/a:Actor[a:ActorObjectID=$ccrActorObjectID]"/>

        <id>
            <xsl:choose>
                <xsl:when test="$CCRActor/a:IDs">
                    <xsl:attribute name="extension">
                        <xsl:value-of select="$CCRActor/a:IDs[1]/a:ID"/>
                    </xsl:attribute>
                    <xsl:attribute name="root">
                        <xsl:value-of select="$CCRActor/a:IDs[1]/a:Type/a:Text"/>
                    </xsl:attribute>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:attribute name="extension">
                        <xsl:value-of select="$CCRActor/a:ActorObjectID"/>
                    </xsl:attribute>
                    <xsl:attribute name="root">
                        <xsl:text>CCR Actor ID</xsl:text>
                    </xsl:attribute>
                </xsl:otherwise>
            </xsl:choose>
        </id>

        <xsl:if test="$CCRActor/a:Organization">
            <xsl:value-of select="$CCRActor/a:Organization/a:Name"></xsl:value-of>
        </xsl:if>

        <addr>
            <xsl:choose>
                <xsl:when test="$CCRActor/a:Address">
                    <xsl:attribute name="use">
                        <xsl:call-template name="CDAVocabularyLookup">
                            <xsl:with-param name="domain" select="'telecommunicationsAddressUse'"/>
                            <xsl:with-param name="ccrDescription" select="$CCRActor/a:Address/a:Type/a:Text"/>
                        </xsl:call-template>
                    </xsl:attribute>
                    <streetAddressLine>
                        <xsl:value-of select="$CCRActor/a:Address[1]/a:Line1"/>
                    </streetAddressLine>
                    <city>
                        <xsl:value-of select="$CCRActor/a:Address[1]/a:City"/>
                    </city>
                    <state>
                        <xsl:value-of select="$CCRActor/a:Address[1]/a:State"/>
                    </state>
                    <postalcode>
                        <xsl:value-of select="$CCRActor/a:Address[1]/a:PostalCode"/>
                    </postalcode>
                </xsl:when>
                <xsl:otherwise>
                    <streetAddressLine/>
                </xsl:otherwise>
            </xsl:choose>
        </addr>

        <telecom>
            <xsl:if test="$CCRActor/a:Telephone">
                <xsl:attribute name="use">
                    <xsl:call-template name="CDAVocabularyLookup">
                        <xsl:with-param name="domain" select="'telecommunicationsAddressUse'"/>
                        <xsl:with-param name="ccrDescription" select="$CCRActor/a:Telephone/a:Type/a:Text"/>
                    </xsl:call-template>
                </xsl:attribute>
                <xsl:attribute name="value">
                    <xsl:text>tel:+1-</xsl:text>
                    <xsl:value-of select="$CCRActor/a:Telephone[1]/a:Value"/>
                </xsl:attribute>
            </xsl:if>

        </telecom>

        <xsl:if test="$CCRActor/a:Email">
            <telecom>
                <xsl:choose>
                    <xsl:when test="$CCRActor/a:Telephone">
                        <xsl:attribute name="use">
                            <xsl:call-template name="CDAVocabularyLookup">
                                <xsl:with-param name="domain" select="'telecommunicationsAddressUse'"/>
                                <xsl:with-param name="ccrDescription" select="$CCRActor/a:Telephone/a:Type/a:Text"/>
                            </xsl:call-template>
                        </xsl:attribute>
                        <xsl:attribute name="value">
                            <xsl:text>mailto:</xsl:text>
                            <xsl:value-of select="$CCRActor/a:Email[1]/a:Value"/>
                        </xsl:attribute>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:attribute name="value">Unknown</xsl:attribute>
                    </xsl:otherwise>
                </xsl:choose>
            </telecom>
        </xsl:if>

        <xsl:element name="{$personNodeName}">
            <name>
                <xsl:call-template name="actorName">
                    <xsl:with-param name="objID" select="$ccrActorObjectID"/>
                </xsl:call-template>
            </name>

            <xsl:if test="a:Person/a:Gender">
                
                    <xsl:call-template name="ccdCodedValue">
                        <xsl:with-param name="ccrCodedDescription" select="a:Person/a:Gender"/>
                        <xsl:with-param name="domain" select="'AdministrativeGender'"/>
                        <xsl:with-param name="nodeName" select="'administrativeGenderCode'"/>
                    </xsl:call-template>

                
            </xsl:if>

            <xsl:if test="a:Person/a:DateOfBirth">
                <birthTime>
                    <xsl:attribute name="value">
                        <xsl:call-template name="date:format-date">
                            <xsl:with-param name="date-time">
                                <xsl:value-of select="a:Person/a:DateOfBirth/a:ExactDateTime"/>
                            </xsl:with-param>
                            <xsl:with-param name="pattern">yyyyMMddhhmmss</xsl:with-param>
                        </xsl:call-template>
                    </xsl:attribute>
                </birthTime>
            </xsl:if>
        </xsl:element>

        <xsl:if test="$ccrActorObjectID=/a:ContinuityOfCareRecord/a:Patient[1]/a:ActorID">
            <xsl:if test="/a:ContinuityOfCareRecord/a:Body/a:SocialHistory/a:SocialHistoryElement[a:Type/a:Text='Marital Status']">
                
                    <xsl:call-template name="ccdCodedValue">
                        <xsl:with-param name="ccrCodedDescription" select="/a:ContinuityOfCareRecord/a:Body/a:SocialHistory/a:SocialHistoryElement[a:Type/a:Text='Marital Status']/a:Description"></xsl:with-param>
                        <xsl:with-param name="domain" select="'MaritalStatus'"/>
                        <xsl:with-param name="nodeName" select="'maritalStatusCode'"/>
                    </xsl:call-template>
                
            </xsl:if>

            <xsl:if test="/a:ContinuityOfCareRecord/a:Body/a:SocialHistory/a:SocialHistoryElement[a:Type/a:Text='Language']">
                <languageCommunication>
                    <templateId root="2.16.840.1.113883.3.88.11.83.2" assigningAuthorityName="HITSP/C83"/>
                    <templateId root="1.3.6.1.4.1.19376.1.5.3.1.2.1" assigningAuthorityName="IHE/PCC"/>
                    
                        <xsl:call-template name="ccdCodedValue">
                            <xsl:with-param name="ccrCodedDescription" select="/a:ContinuityOfCareRecord/a:Body/a:SocialHistory/a:SocialHistoryElement[a:Type/a:Text='Language']/a:Description"></xsl:with-param>
                            <xsl:with-param name="domain" select="'HumanLanguage'"/>
                            <xsl:with-param name="nodeName" select="'languageCode'"/>
                        </xsl:call-template>
                    
                </languageCommunication>
            </xsl:if>
        </xsl:if>

        <xsl:if test="/a:ContinuityOfCareRecord/a:Actors/a:Actor[a:ActorObjectID=$ccrActorObjectID]/a:InternalCCRLink[a:LinkRelationship='Organization']">
            <representedOrganization>
                <xsl:call-template name="ccdEntity">
                    <xsl:with-param name="ccrActorObjectID" select="/a:ContinuityOfCareRecord/a:Actors/a:Actor[a:ActorObjectID=$ccrActorObjectID]/a:InternalCCRLink[a:LinkRelationship='Organization']/a:LinkID"></xsl:with-param>
                </xsl:call-template>
            </representedOrganization>
        </xsl:if>

    </xsl:template>
</xsl:stylesheet>