GPLCCR   ; CCDCCR/GPL - CCR MAIN PROCESSING; 6/6/08
 ;;0.1;CCDCCR;nopatch;noreleasedate
 ;Copyright 2008 WorldVistA.  Licensed under the terms of the GNU
 ;General Public License See attached copy of the License.
 ;
 ;This program is free software; you can redistribute it and/or modify
 ;it under the terms of the GNU General Public License as published by
 ;the Free Software Foundation; either version 2 of the License, or
 ;(at your option) any later version.
 ;
 ;This program is distributed in the hope that it will be useful,
 ;but WITHOUT ANY WARRANTY; without even the implied warranty of
 ;MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ;GNU General Public License for more details.
 ;
 ;You should have received a copy of the GNU General Public License along
 ;with this program; if not, write to the Free Software Foundation, Inc.,
 ;51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 ;
 ; EXPORT A CCR
 ;
EXPORT   ; EXPORT ENTRY POINT FOR CCR
       ; Select a patient.
       S DIC=2,DIC(0)="AEMQ" D ^DIC
       I Y<1 Q  ; EXIT
       S DFN=$P(Y,U,1) ; SET THE PATIENT
       N CCRGLO
       D CCRRPC(.CCRGLO,DFN,"CCR","","","")
       S OARY=$NA(^TMP("GPLCCR",$J,DFN,"CCR",1))
       S ONAM="PAT_"_DFN_"_CCR_V1.xml"
       S ODIRGLB=$NA(^TMP("GPLCCR","ODIR"))
       I '$D(@ODIRGLB) D  ; IF NOT ODIR HAS BEEN SET
       . S @ODIRGLB="/home/glilly/CCROUT"
       . ;S @ODIRGLB="/home/cedwards/"
       . ;S @ODIRGLB="/opt/wv/p/"
       S ODIR=@ODIRGLB
       D OUTPUT^GPLXPATH(OARY,ONAM,ODIR)
       Q
       ;
CCRRPC(CCRGRTN,DFN,CCRPART,TIME1,TIME2,HDRARY)  ;RPC ENTRY POINT FOR CCR OUTPUT
    ; CCRGRTN IS RETURN ARRAY PASSED BY NAME
    ; DFN IS PATIENT IEN
    ; CCRPART IS "CCR" FOR ENTIRE CCR, OR SECTION NAME FOR A PART
    ;   OF THE CCR BODY.. PARTS INCLUDE "PROBLEMS" "VITALS" ETC
    ; TIME1 IS STARTING TIME TO INCLUDE - NULL MEANS ALL
    ; TIME2 IS ENDING TIME TO INCLUDE TIME IS FILEMAN TIME
    ; - NULL MEANS NOW
    ; HDRARY IS THE HEADER ARRAY DEFINING THE "FROM" AND
    ;    "TO" VARIABLES
    ;    IF NULL WILL DEFAULT TO "FROM" DUZ AND "TO" DFN
    S DEBUG=0
    S CCD=0 ; NEED THIS FLAG TO DISTINGUISH FROM CCD
    S TGLOBAL=$NA(^TMP("GPLCCR",$J,"TEMPLATE")) ; GLOBAL FOR STORING TEMPLATE
    S CCRGLO=$NA(^TMP("GPLCCR",$J,DFN,"CCR")) ; GLOBAL FOR BUILDING THE CCR
    S ACTGLO=$NA(^TMP("GPLCCR",$J,DFN,"ACTORS")) ; GLOBAL FOR ALL ACTORS
    ; TO GET PART OF THE CCR RETURNED, PASS CCRPART="PROBLEMS" ETC
    S CCRGRTN=$NA(^TMP("GPLCCR",$J,DFN,CCRPART)) ; RTN GLO NM OF PART OR ALL
    D LOAD^GPLCCR0(TGLOBAL)  ; LOAD THE CCR TEMPLATE
    D CP^GPLXPATH(TGLOBAL,CCRGLO) ; COPY THE TEMPLATE TO CCR GLOBAL
    ;
    ; DELETE THE BODY, ACTORS AND SIGNATURES SECTIONS FROM GLOBAL
    ; THESE WILL BE POPULATED AFTER CALLS TO THE XPATH ROUTINES
    D REPLACE^GPLXPATH(CCRGLO,"","//ContinuityOfCareRecord/Body")
    D REPLACE^GPLXPATH(CCRGLO,"","//ContinuityOfCareRecord/Actors")
    D REPLACE^GPLXPATH(CCRGLO,"","//ContinuityOfCareRecord/Signatures")
    I DEBUG F I=1:1:@CCRGLO@(0) W @CCRGLO@(I),!
    ;
    D HDRMAP(CCRGLO,DFN,HDRARY) ; MAP HEADER VARIABLES
    ;
    K ^TMP("GPLCCR",$J,"CCRSTEP") ; KILL GLOBAL PRIOR TO ADDING TO IT
    S CCRXTAB=$NA(^TMP("GPLCCR",$J,"CCRSTEP")) ; GLOBAL TO STORE CCR STEPS
    D INITSTPS(CCRXTAB) ; INITIALIZED CCR PROCESSING STEPS
    N I,XI,TAG,RTN,CALL,XPATH,IXML,OXML,INXML,CCRBLD
    F I=1:1:@CCRXTAB@(0)  D  ; PROCESS THE CCR BODY SECTIONS
    . S XI=@CCRXTAB@(I) ; CALL COPONENTS TO PARSE
    . S RTN=$P(XI,";",2) ; NAME OF ROUTINE TO CALL
    . S TAG=$P(XI,";",1) ; LABEL INSIDE ROUTINE TO CALL
    . S XPATH=$P(XI,";",3) ; XPATH TO XML TO PASS TO ROUTINE
    . D QUERY^GPLXPATH(TGLOBAL,XPATH,"INXML") ; EXTRACT XML TO PASS
    . S IXML="INXML"
    . S OXML=$P(XI,";",4) ; ARRAY FOR SECTION VALUES
    . ; W OXML,!
    . S CALL="D "_TAG_"^"_RTN_"(IXML,DFN,OXML)" ; SETUP THE CALL
    . W "RUNNING ",CALL,!
    . X CALL
    . ; NOW INSERT THE RESULTS IN THE CCR BUFFER
    . D INSERT^GPLXPATH(CCRGLO,OXML,"//ContinuityOfCareRecord/Body")
    . I DEBUG F GPLI=1:1:@OXML@(0) W @OXML@(GPLI),!
    D ACTLST^GPLCCR(CCRGLO,ACTGLO) ; GEN THE ACTOR LIST
    D QUERY^GPLXPATH(TGLOBAL,"//ContinuityOfCareRecord/Actors","ACTT")
    D EXTRACT^GPLACTORS("ACTT",ACTGLO,"ACTT2")
    D INSINNER^GPLXPATH(CCRGLO,"ACTT2","//ContinuityOfCareRecord/Actors")
    N I,J,DONE S DONE=0
    F I=0:0 D  Q:DONE ; DELETE UNTIL ALL EMPTY ELEMENTS ARE GONE
    . S J=$$TRIM^GPLXPATH(CCRGLO) ; DELETE EMPTY ELEMENTS
    . W "TRIMMED",J,!
    . I J=0 S DONE=1 ; DONE WHEN TRIM RETURNS FALSE
    Q
    ;
INITSTPS(TAB)  ; INITIALIZE CCR PROCESSING STEPS
    ; TAB IS PASSED BY NAME
    W "TAB= ",TAB,!
    ; ORDER FOR CCR IS PROBLEMS,FAMILYHISTORY,SOCIALHISTORY,MEDICATIONS,VITALSIGNS,RESULTS,HEALTHCAREPROVIDERS
    D PUSH^GPLXPATH(TAB,"EXTRACT;GPLPROBS;//ContinuityOfCareRecord/Body/Problems;^TMP(""GPLCCR"",$J,DFN,""PROBLEMS"")")
    ;D PUSH^GPLXPATH(TAB,"EXTRACT;GPLMEDS;//ContinuityOfCareRecord/Body/Medications;^TMP(""GPLCCR"",$J,DFN,""MEDICATIONS"")")
    D PUSH^GPLXPATH(TAB,"EXTRACT;GPLVITALS;//ContinuityOfCareRecord/Body/VitalSigns;^TMP(""GPLCCR"",$J,DFN,""VITALS"")")
    Q
    ;
HDRMAP(CXML,DFN,IHDR)   ; MAP HEADER VARIABLES: FROM, TO ECT
    N VMAP S VMAP=$NA(^TMP("GPLCCR",$J,DFN,"HEADER"))
    ; K @VMAP
    S @VMAP@("DATETIME")=$$FMDTOUTC^CCRUTIL($$NOW^XLFDT,"DT")
    I IHDR="" D  ; HEADER ARRAY IS NOT PROVIDED, USE DEFAULTS
    . S @VMAP@("ACTORPATIENT")="ACTORPATIENT_"_DFN
    . S @VMAP@("ACTORFROM")="ACTORORGANIZATION_"_DUZ ; FROM DUZ - ???
    . S @VMAP@("ACTORFROM2")="ACTORSYSTEM_1" ; SECOND FROM IS THE SYSTEM
    . S @VMAP@("ACTORTO")="ACTORPATIENT_"_DFN  ; FOR TEST PURPOSES
    . S @VMAP@("PURPOSEDESCRIPTION")="CEND PHR"  ; FOR TEST PURPOSES
    . S @VMAP@("ACTORTOTEXT")="Patient"  ; FOR TEST PURPOSES
    . ; THIS IS THE USE CASE FOR THE PHR WHERE "TO" IS THE PATIENT
    I IHDR'="" D  ; HEADER VALUES ARE PROVIDED
    . D CP^GPLXPATH(IHDR,VMAP) ; COPY HEADER VARIABLES TO MAP ARRAY
    N CTMP
    D MAP^GPLXPATH(CXML,VMAP,"CTMP")
    D CP^GPLXPATH("CTMP",CXML)
    Q
    ;
ACTLST(AXML,ACTRTN) ; RETURN THE ACTOR LIST FOR THE XML IN AXML
    ; AXML AND ACTRTN ARE PASSED BY NAME
    ; EACH ACTOR RECORD HAS 3 PARTS - IE IF OBJECTID=ACTORPATIENT_2
    ; P1= OBJECTID - ACTORPATIENT_2
    ; P2= OBJECT TYPE - PATIENT OR PROVIDER OR SOFTWARE
    ;OR INSTITUTION
    ;  OR PERSON(IN PATIENT FILE IE NOK)
    ; P3= IEN RECORD NUMBER FOR ACTOR - 2
    N I,J,K,L
    K @ACTRTN ; CLEAR RETURN ARRAY
    F I=1:1:@AXML@(0) D  ; SCAN ALL LINES
    . I @AXML@(I)?.E1"<ActorID>".E D  ; THERE IS AN ACTOR THIS LINE
    . . S J=$P($P(@AXML@(I),"<ActorID>",2),"</ActorID>",1)
    . . W "<ActorID>=>",J,!
    . . I J'="" S K(J)="" ; HASHING ACTOR
    . . ;  TO GET RID OF DUPLICATES
    S I="" ; GOING TO $O THROUGH THE HASH
    F J=0:0 D  Q:$O(K(I))=""
    . S I=$O(K(I)) ; WALK THROUGH THE HASH OF ACTORS
    . S $P(L,U,1)=I ; FIRST PIECE IS THE OBJECT ID
    . S $P(L,U,2)=$P($P(I,"ACTOR",2),"_",1) ; ACTOR TYPE
    . S $P(L,U,3)=$P(I,"_",2) ; IEN RECORD NUMBER FOR ACTOR
    . D PUSH^GPLXPATH(ACTRTN,L) ; ADD THE ACTOR TO THE RETURN ARRAY
    Q
    ;
TEST ; RUN ALL THE TEST CASES
  D TESTALL^GPLUNIT("GPLCCR")
  Q
  ;
ZTEST(WHICH)  ; RUN ONE SET OF TESTS
  N ZTMP
  D ZLOAD^GPLUNIT("ZTMP","GPLCCR")
  D ZTEST^GPLUNIT(.ZTMP,WHICH)
  Q
  ;
TLIST  ; LIST THE TESTS
  N ZTMP
  D ZLOAD^GPLUNIT("ZTMP","GPLCCR")
  D TLIST^GPLUNIT(.ZTMP)
  Q
  ;
 ;;><TEST>
 ;;><PROBLEMS>
 ;;>>>K GPL S GPL=""
 ;;>>>D CCRRPC^GPLCCR(.GPL,"2","PROBLEMS","","","")
 ;;>>?@GPL@(@GPL@(0))["</Problems>"
 ;;><VITALS>
 ;;>>>K GPL S GPL=""
 ;;>>>D CCRRPC^GPLCCR(.GPL,"2","VITALS","","","")
 ;;>>?@GPL@(@GPL@(0))["</VitalSigns>"
 ;;><CCR>
 ;;>>>K GPL S GPL=""
 ;;>>>D CCRRPC^GPLCCR(.GPL,"2","CCR","","","")
 ;;>>?@GPL@(@GPL@(0))["</ContinuityOfCareRecord>"
 ;;><ACTLST>
 ;;>>>K GPL S GPL=""
 ;;>>>D CCRRPC^GPLCCR(.GPL,"2","CCR","","","")
 ;;>>>D ACTLST^GPLCCR(GPL,"ACTTEST")
 ;;><ACTORS>
 ;;>>>D ZTEST^GPLCCR("ACTLST")
 ;;>>>D QUERY^GPLXPATH(TGLOBAL,"//ContinuityOfCareRecord/Actors","G2")
 ;;>>>D EXTRACT^GPLACTORS("G2","ACTTEST","G3")
 ;;>>?G3(G3(0))["</Actors>"
 ;;><TRIM>
 ;;>>>D ZTEST^GPLCCR("CCR")
 ;;>>>W $$TRIM^GPLXPATH(CCRGLO)
 ;;><CCD>
 ;;>>>K GPL S GPL=""
 ;;>>>D CCRRPC^GPLCCR(.GPL,"2","CCD","","","")
 ;;>>?@GPL@(@GPL@(0))["</ContinuityOfCareRecord>"
 ;;></TEST>
