//kt -- Modified with SourceScanner on 8/25/2007
unit fConsult513Prt;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  fAutoSz, ORCtrls, StdCtrls, Mask, ORNet, ORFn, ComCtrls, DKLang;

type
  Tfrm513Print = class(TfrmAutoSz)
    grpChooseCopy: TGroupBox;
    radChartCopy: TRadioButton;
    radWorkCopy: TRadioButton;
    grpDevice: TGroupBox;
    lblMargin: TLabel;
    lblLength: TLabel;
    txtRightMargin: TMaskEdit;
    txtPageLength: TMaskEdit;
    cmdOK: TButton;
    cmdCancel: TButton;
    lblConsultTitle: TMemo;
    cboDevice: TORComboBox;
    lblPrintTo: TLabel;
    dlgWinPrinter: TPrintDialog;
    chkDefault: TCheckBox;
    procedure cboDeviceNeedData(Sender: TObject; const StartFrom: String;
      Direction, InsertAt: Integer);
    procedure FormCreate(Sender: TObject);
    procedure cboDeviceChange(Sender: TObject);
    procedure radChartCopyClick(Sender: TObject);
    procedure radWorkCopyClick(Sender: TObject);
    procedure cmdOKClick(Sender: TObject);
    procedure cmdCancelClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    //kt Begin Mod (change Consts to Vars) 8/25/2007
    TX_NODEVICE      : string;  //kt
    TX_NODEVICE_CAP  : string;  //kt
    TX_ERR_CAP       : string;  //kt
    TX_QUEUED_CAP    : string;  //kt
    //kt End Mod -------------------
    { Private declarations }
    FConsult: Integer;
    FReportText: TRichEdit;
    procedure DisplaySelectDevice;
    procedure SetupVars;  //kt
  public
    { Public declarations }
  end;

procedure PrintSF513(AConsult: Longint; AConsultTitle: string);

implementation

{$R *.DFM}

uses rCore, rConsults, Printers, rReports, uCore;

const
//TX_NODEVICE = 'A device must be selected to print, or press ''Cancel'' to not print.';  <-- original line.  //kt 8/25/2007
//TX_NODEVICE_CAP = 'Device Not Selected';  <-- original line.  //kt 8/25/2007
//TX_ERR_CAP = 'Print Error';  <-- original line.  //kt 8/25/2007
//TX_QUEUED_CAP = 'Printing Report' ;  <-- original line.  //kt 8/25/2007
  PAGE_BREAK = '**PAGE BREAK**';



procedure Tfrm513Print.SetupVars;
//kt Added entire function to replace constant declarations 8/25/2007
begin
  TX_NODEVICE := DKLangConstW('fConsult513Prt_A_device_must_be_selected_to_printx_or_press_xxCancelxx_to_not_printx');
  TX_NODEVICE_CAP := DKLangConstW('fConsult513Prt_Device_Not_Selected');
  TX_ERR_CAP := DKLangConstW('fConsult513Prt_Print_Error');
  TX_QUEUED_CAP := DKLangConstW('fConsult513Prt_Printing_Report') ; 
end;
 
procedure PrintSF513(AConsult: Longint; AConsultTitle: string);
{ displays a form that prompts for a device and then prints the SF513 }
var
  frm513Print: Tfrm513Print;
  DefPrt: string;
begin
  frm513Print := Tfrm513Print.Create(Application);
  try
    ResizeFormToFont(TForm(frm513Print));
    with frm513Print do
    begin
      lblConsultTitle.Text := AConsultTitle;
      FConsult := AConsult;
      DefPrt := GetDefaultPrinter(User.Duz, Encounter.Location);
      if User.CurrentPrinter = '' then User.CurrentPrinter := DefPrt;
      with cboDevice do
        begin
          if Printer.Printers.Count > 0 then
            begin
//            Items.Add('WIN;Windows Printer^Windows Printer');   <-- original line.  //kt 8/25/2007
              Items.Add('WIN;'+DKLangConstW('fConsult513Prt_Windows_Printer')+'^'+DKLangConstW('fConsult513Prt_Windows_Printer')); //kt added 8/25/2007
//            Items.Add('^--------------------VistA Printers----------------------');  <-- original line.  //kt 8/25/2007
              Items.Add('^'+DKLangConstW('fConsult513Prt_xxxxxxxxxxxxxxxxxxxxxVistA_Printersxxxxxxxxxxxxxxxxxxxxxx')); //kt added 8/25/2007
            end;
          if User.CurrentPrinter <> '' then
            begin
              InitLongList(Piece(User.CurrentPrinter, ';', 2));
              SelectByID(User.CurrentPrinter);
            end
          else
            InitLongList('');
        end;
      if (DefPrt = 'WIN;Windows Printer') and
         (User.CurrentPrinter = DefPrt) then
         cmdOKClick(frm513Print)
      else
         ShowModal;
    end;
  finally
    frm513Print.Release;
  end;
end;

procedure Tfrm513Print.FormCreate(Sender: TObject);
begin
  inherited;
  FReportText := TRichEdit.Create(Self);
  with FReportText do
    begin
      Parent := Self;
      Visible := False;
      Width := 600;
    end;
end;

procedure Tfrm513Print.DisplaySelectDevice;
begin
  with cboDevice, lblPrintTo do
  begin
//  if radChartCopy.Checked then Caption := 'Print Chart Copy on:  ' + Piece(ItemID, ';', 2);  <-- original line.  //kt 8/25/2007
    if radChartCopy.Checked then Caption := DKLangConstW('fConsult513Prt_Print_Chart_Copy_onx') + Piece(ItemID, ';', 2); //kt added 8/25/2007
//  if radWorkCopy.Checked then Caption := 'Print Work Copy on:  ' + Piece(ItemID, ';', 2);  <-- original line.  //kt 8/25/2007
    if radWorkCopy.Checked then Caption := DKLangConstW('fConsult513Prt_Print_Work_Copy_onx') + Piece(ItemID, ';', 2); //kt added 8/25/2007
  end;
end;

procedure Tfrm513Print.cboDeviceNeedData(Sender: TObject; const StartFrom: string;
  Direction, InsertAt: Integer);
begin
  inherited;
  cboDevice.ForDataUse(SubsetOfDevices(StartFrom, Direction));
end;

procedure Tfrm513Print.cboDeviceChange(Sender: TObject);
begin
  inherited;
  with cboDevice do if ItemIndex > -1 then
    begin
      txtRightMargin.Text := Piece(Items[ItemIndex], '^', 4);
      txtPageLength.Text := Piece(Items[ItemIndex], '^', 5);
      DisplaySelectDevice;
    end;
end;

procedure Tfrm513Print.radChartCopyClick(Sender: TObject);
begin
  inherited;
  DisplaySelectDevice;
end;

procedure Tfrm513Print.radWorkCopyClick(Sender: TObject);
begin
  inherited;
  DisplaySelectDevice;
end;

procedure Tfrm513Print.cmdOKClick(Sender: TObject);
var
  ADevice, ErrMsg: string;
  ChartCopy: string;
  RemoteSiteID: string;    //for Remote site printing
  RemoteQuery: string;    //for Remote site printing
begin
  SetupVars;  //kt added 8/25/2007 to replace constants with vars.
  inherited;
  RemoteSiteID := '';
  RemoteQuery := '';
  if cboDevice.ItemID = '' then
  begin
    InfoBox(TX_NODEVICE, TX_NODEVICE_CAP, MB_OK);
    Exit;
  end;
  if radChartCopy.Checked then ChartCopy := 'C' else ChartCopy := 'W';
  if Piece(cboDevice.ItemID, ';', 1) = 'WIN' then
    begin
      if dlgWinPrinter.Execute then with FReportText do
        begin
          FReportText.Lines.Assign(GetFormattedSF513(FConsult, ChartCopy));
          PrintWindowsReport(FReportText, PAGE_BREAK, Self.Caption, ErrMsg, Application); //kt 8/09, Added ',Application'
          if Length(ErrMsg) > 0 then InfoBox(ErrMsg, TX_ERR_CAP, MB_OK);
        end;
    end
  else
    begin
      ADevice := Piece(cboDevice.ItemID, ';', 2);
      PrintSF513ToDevice(FConsult, ADevice, ChartCopy, ErrMsg);
      ErrMsg := Piece(FReportText.Lines[0], U, 2);
      if Length(ErrMsg) > 0 then InfoBox(ErrMsg, TX_ERR_CAP, MB_OK);
    end;
  if chkDefault.Checked then SaveDefaultPrinter(Piece(cboDevice.ItemID, ';', 1));
  User.CurrentPrinter := cboDevice.ItemID;
  Close;
end;

procedure Tfrm513Print.cmdCancelClick(Sender: TObject);
begin
  inherited;
  Close;
end;

procedure Tfrm513Print.FormDestroy(Sender: TObject);
begin
  FReportText.Free;
  inherited;
end;

end.
