TMGBUTIL ;TMG/kst/Binary Global Data Utilities ;03/25/06
         ;;1.0;TMG-LIB;**1**;08/20/05
 
 ;"TMG BINARY GLOBAL DATA UTILITY FUNCTIONS
 ;"Kevin Toppenberg MD
 ;"GNU General Public License (GPL) applies
 ;"8-20-2005
 
 ;"=======================================================================
 ;" API -- Public Functions.
 ;"=======================================================================
 ;"DISPLAY(globalRef,incSubscr,offset,numLines,bytesPerLine)
 ;"BROWSE(globalRef,incSubscr)
 
 ;"=======================================================================
 ;"PRIVATE API FUNCTIONS
 ;"=======================================================================
 
 
 ;"=======================================================================
 ;"DEPENDENCIES
 ;"=======================================================================
 ;"Uses:   TMGBINF
 ;"          TMGMISC
 ;"          TMGSTUTL
 
 ;"=======================================================================
 
BROWSE(globalRef,incSubscr)
        ;"SCOPE: PUBLIC
        ;"Purpose: to browse a binary set as hex codes
 
        new offset set offset=0
        new input
        for  do  quit:(offset="")
        . read "Offset to browse (? for help): ",input:$get(DTIME,3600),!
        . if input="?" write "^ to abort,A=browse up, Z=browse down",! quit
        . if input="^" set offset="" quit
        . if input="" set input="Z"
        . if "Aa"[input set offset=offset-(8*16)
        . if "Zz"[input set offset=offset+(8*16)
        . if $extract(input,1)="$" set input=$$HEX2NUM^TMGMISC(input)
        . if +input=input set offset=input
        . if +offset'=offset set offset="" quit
        . do DISPLAY(globalRef,incSubscr,offset,8,16)
 
        quit
 
 
DISPLAY(globalRef,incSubscr,offset,numLines,bytesPerLine)
        ;"SCOPE: PUBLIC
        ;"Purpose: to display a binary set as hex codes
        ;"Input: gobalRef -- the reference of the beginning of the block (in closed form)
        ;"        incSubscr-- (required) Identifies the incrementing subscript level.  For example, if you
        ;"                           pass ^TMP(115,1,1,0) as the global_ref parameter and pass 3 as the
        ;"                           inc_subscr parameter, $$BIN2GBL will increment the third subscript, such
        ;"                           as ^TMP(115,1,x), but will WRITE notes at the full global reference, such
        ;"                           as ^TMP(115,1,x,0).
        ;"        offset --       (OPTIONAL) the bytes offset from the beginning of the
        ;"                          block to start from. Default=0
        ;"        numLines -- (OPTIONAL) the number of lines to show.  Default=8
        ;"        bytesPerLine -- (OPTIONAL) the number of bytes to show per line Default=16
        ;"Output -- displays the hex bytes to the screen
        ;"Result -- none
 
        ;"Note: each line in the global ref is assumed to hold 512 bytes.
 
        new index,data
        new bytesNeeded
        new atEnd set atEnd=0
 
        set offset=$get(offset,0)
        set numLines=$get(numLines,8)
        set bytesPerLine=$get(bytesPerLine,16)
        set bytesNeeded=numLines*bytesPerLine
        set index=offset\512
 
        if index>0 set globalRef=$$NEXTNODE^TMGBINF(globalRef,incSubscr,1,index)
        if (globalRef="") goto DispDone
        set data=$extract($get(@globalRef),(offset#512)+1,512)
 
        for  quit:($length(data)'<bytesNeeded)!(atEnd>0)  do
        . set globalRef=$$NEXTNODE^TMGBINF(globalRef,incSubscr,1,1)
        . if (globalRef="") set atEnd=1 quit
        . new oneLine set oneLine=$get(@globalRef)
        . if oneLine="" set atEnd=1 quit
        . set data=data_$extract(oneLine,1,bytesNeeded-$length(data))
 
        ;"Now display data
        new dispLine
        new dispOffset set dispOffset=offset
        for  quit:($length(data)=0)  do
        . set dispLine=$extract(data,1,bytesPerLine)
        . set data=$extract(data,bytesPerLine+1,bytesNeeded)
        . write "$",$$HEXCHR2^TMGMISC(dispOffset,6),"  "
        . write $$STRB2H^TMGSTUTL(dispLine,1),!
        . set dispOffset=dispOffset+bytesPerLine
 
 
DispDone
        quit
