TMGBROWS ;TMG/kst/Record browser ;03/25/06
         ;;1.0;TMG-LIB;**1**;03/10/07
 
 ;" TMG BROWSE RECORDS
 ;"Kevin Toppenberg MD
 ;"GNU General Public License (GPL) applies
 ;"3-10-2007
 
 ;"=======================================================================
 ;" API -- Public Functions.
 ;"=======================================================================
 ;"ASKBROWSE -- browse records, and follow pointers
 
 ;"=======================================================================
 ;" Private Functions.
 ;"=======================================================================
 ;"Browse(FileNum,IENS,ShowEmpty) --Browse a record, allowing display of
 ;"      the current record, or follow pointers to other records.
 ;"DispRec(FileNum,IEN) -- To display record
 
 ;"=======================================================================
 
 
ASKBROWSE
        ;"Purpose: To browse records, and follow pointers.
 
        write !!,"  -= RECORD BROWSE =-",!
        new FIENS,IENS
AL1
        set FIENS=$$AskFIENS^TMGDBAPI()
        if (FIENS["?")!(FIENS="^") goto ASKDone
 
        set FileNum=$piece(FIENS,"^",1)
        set IENS=$piece(FIENS,"^",2)
 
AL2
        set IENS=$$AskIENS^TMGDBAPI(FileNum,IENS)
        if (IENS["?")!(IENS="") goto AL1
 
        new % set %=2
        write "Display empty fields"
        do YN^DICN
        if %=-1 write ! goto ASKDone
 
        ;"Do the output
        write ! do Browse(FileNum,IENS,(%=1))
        set IENS=$piece(IENS,",",2,99)  ;"force Pick of new record to dump
        if +IENS>0 goto AL2
        goto AL1
 
 
ASKDone
        quit
 
 
Browse(FileNum,IENS,ShowEmpty)
        ;"Purpose: Browse a record, allowing display of the current record, or
        ;"         follow pointers to other records.
        ;"Input: FileNum -- the number of the file to browse
        ;"       IENS -- the record number to display (or IENS: #,#,#,)
        ;"       ShowEmpty -- OPTIONAL;  if 1 then empty fields will be displayed
 
        new FldInfo,field
        do GetPtrsOUT^TMGDBAPI(FileNum,.FldInfo)
 
        if $extract(IENS,$length(IENS))'="," set IENS=IENS_","
 
        set field=""
        for  set field=$order(FldInfo(field)) quit:(field="")  do
        . new name set name=$$GetFldName^TMGDBAPI(FileNum,field)
        . set FldInfo(field,"NAME")=name
 
        new Menu
        new count set count=1
                write "File: ",$$GetFName^TMGDBAPI(FileNum),!
 
        set Menu(0)="File: "_$$GetFName^TMGDBAPI(FileNum)_" ("_FileNum_"), Record: "_IENS
        set field=""
        for  set field=$order(FldInfo(field)) quit:(field="")  do
        . new ptr set ptr=$$GET1^DIQ(FileNum,IENS,field,"I")
        . new otherName set otherName=$$GET1^DIQ(FileNum,IENS,field)
        . if ptr="" quit
        . new name set name=$$GetFldName^TMGDBAPI(FileNum,field)
        . set Menu(count)="BROWSE: ("_field_") "_name_"--> "_otherName_$char(9)_FldInfo(field)_"|"_ptr
        . set count=count+1
 
        set Menu(count)="DUMP entire record"_$char(9)_"DUMP"
 
M0      write #
        set UsrSlct=$$Menu^TMGUSRIF(.Menu,"^")
 
        if UsrSlct="DUMP" do DispRec(FileNum,IENS) goto M0
        if UsrSlct["|" do  goto M0
        . new newFile set newFile=$piece(UsrSlct,"|",1)
        . new IEN set IEN=$piece(UsrSlct,"|",2)_","
        . do Browse(newFile,IEN,.ShowEmpty)
        if UsrSlct="^" goto MenuDone
        goto M0
 
MenuDone
        quit
 
 
DispRec(FileNum,IEN)
        ;"Purpose: To display record
        ;"Input:  FileNum -- The File number to display
        ;"        IEN -- the IEN (record number) to display in file.
        ;"Results: none
 
        write "File: ",$$GetFName^TMGDBAPI(FileNum),!
        do DumpRec2^TMGDEBUG(FileNum,IEN_",",0)
        do PressToCont^TMGUSRIF
 
        quit
 
