unit fImagePickPDF;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, OleCtrls, SHDocVw, FileCtrl, StdCtrls, Buttons, ExtCtrls;

type
  TfrmImagePickPDF = class(TForm)
    pnlTop: TPanel;
    UDSplitter: TSplitter;
    pnlBottom: TPanel;
    pnlTopLeft: TPanel;
    LRSplitter: TSplitter;
    pnlTopRight: TPanel;
    DriveComboBox: TDriveComboBox;
    DirectoryListBox: TDirectoryListBox;
    FileListBox: TFileListBox;
    pnlButtons: TPanel;
    btnOK: TBitBtn;
    btnCancel: TBitBtn;
    FilterComboBox: TFilterComboBox;
    WebBrowser: TWebBrowser;
    procedure FileListBoxChange(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormHide(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    Filename : string;
    Files : TStringList;
    function Execute : boolean;
    constructor Create(AOwner : TComponent);  override;
    destructor Destroy;                       override;
  end;

var
  frmImagePickPDF: TfrmImagePickPDF;

implementation

{$R *.dfm}

uses fImages, StrUtils;


  function TfrmImagePickPDF.Execute : boolean;
  var i : integer;
      OneFile : string;
  begin
    Files.Clear;
    Result := (self.ShowModal = mrOK);
    if FileListBox.FileName = '' then Result := false;
    for i := 0 to FileListBox.Count-1 do begin
      if not FileListBox.Selected[i] then continue;
      OneFile := DirectoryListBox.Directory;
      if RightStr(OneFile,1) <> '\' then OneFile := OneFile + '\';
      Onefile := OneFile + FileListBox.Items.Strings[i];
      Files.Add(OneFile);
    end;
    if Files.IndexOf(FileListBox.FileName)<0 then begin
      Files.Add(FileListBox.FileName);
    end;
  end;

  procedure TfrmImagePickPDF.FileListBoxChange(Sender: TObject);
  var FName : string;
  begin
    Filename := FileListBox.FileName;
    if FileListBox.FileName <> '' then begin
      FName := FileListBox.FileName;
    end else begin
      FName := frmImages.NullImageName
    end;
    WebBrowser.Navigate(FName);
  end;

  procedure TfrmImagePickPDF.FormShow(Sender: TObject);
  begin
    WebBrowser.Navigate(frmImages.NullImageName);
  end;

  procedure TfrmImagePickPDF.FormHide(Sender: TObject);
  begin
    WebBrowser.Navigate(frmImages.NullImageName);
  end;

  constructor TfrmImagePickPDF.Create(AOwner : TComponent);
  begin
    inherited Create(AOwner);
    Files := TStringList.Create;
  end;

  destructor TfrmImagePickPDF.Destroy;
  begin
    Files.Free;
    inherited Destroy;
  end;

  end.

