unit frmSearchResults;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ORCtrls, StdCtrls, ORNet, ORFn, ComCtrls, Trpcb, Buttons,
  ExtCtrls;

type
  TfrmSrchResults = class(TForm)
    cboResultList: TORComboBox;
    lblCaption: TLabel;
    btnSelectRecord: TBitBtn;
    btnCancel: TBitBtn;
    pnlDetails: TPanel;
    Memo: TMemo;
    procedure cboResultListNeedData(Sender: TObject;
      const StartFrom: String; Direction, InsertAt: Integer);
    procedure cboResultListChange(Sender: TObject);
    procedure btnSelectRecordClick(Sender: TObject);
  private
    { Private declarations }
    FJobNum : string;
    FTargetFName : string;
    FLastDFN : string;
    function SubSetOfResults(JobNum: string; const StartFrom: string; Direction: Integer): TStrings;
    procedure ShowDemog(ItemID: string);
    procedure ClearDemog;
    procedure InitORComboBox(ORComboBox: TORComboBox; initValue : string; boxtype : string);
  public
    { Public declarations }
    SelectedIEN : string;   //used only as OUT parameters
    SelectedName : string; //used only as OUT parameters
    function PrepForm(JobNum, TargetFName, NumMatches, Fields: string) : Boolean;
  end;

var
  frmSrchResults: TfrmSrchResults;

implementation

{$R *.dfm}

  uses rcore;

  function TfrmSrchResults.PrepForm(JobNum, TargetFName, NumMatches, Fields: string) : Boolean;
  //Returns TRUE if OK, and FALSE if error
  var
    cmd,RPCResult : string;
  begin
    FJobNum := JobNum;
    FTargetFName := TargetFName;
    lblCaption.Caption := 'Select Desired Record from File '+ TargetFName + '   '
                          + NumMatches + ' found.';

    Result := TRUE; //default
    RPCBrokerV.remoteprocedure := 'TMG SEARCH CHANNEL';
    RPCBrokerV.Param[0].Value := '.X';  // not used
    RPCBrokerV.param[0].ptype := list;
    cmd := 'PREP SUBSET';
    cmd := cmd + '^' + JobNum + '^' + Fields;
    RPCBrokerV.Param[0].Mult['"REQUEST"'] := cmd;
    RPCBrokerV.Call;
    if RPCBrokerV.Results.Count > 0 then begin
      RPCResult := RPCBrokerV.Results[0];    //returns:  error: -1;  success=1
      if piece(RPCResult,'^',1)='-1' then begin
        MessageDlg(piece(RPCResult,'^',2),mtInformation,[mbOK],0);
        Result := false;
      end;
    end;
    if Result=false then exit;
    InitORComboBox(cboResultList,'A','record');
  end;

  procedure TfrmSrchResults.InitORComboBox(ORComboBox: TORComboBox; initValue : string; boxtype : string);
  begin
    ORComboBox.Items.Clear;
    ORComboBox.Text := '';  //initValue;
    ORComboBox.InitLongList(initValue);
    if ORComboBox.Items.Count > 0 then begin
      ORComboBox.Text := Piece(ORComboBox.Items[0],'^',2);
    end else begin
      ORComboBox.Text := '<Begin by selecting ' + boxtype + '>';
    end;
  end;


  function TfrmSrchResults.SubSetOfResults(JobNum: string;
                                         const StartFrom: string;
                                         Direction: Integer       ): TStrings;

  { returns a pointer to a list of file entries (for use in a long list box) -
    The return value is a pointer to RPCBrokerV.Results, so the data must
    be used BEFORE the next broker call! }
  var
    cmd,RPCResult : string;
  begin
    RPCBrokerV.remoteprocedure := 'TMG SEARCH CHANNEL';
    RPCBrokerV.Param[0].Value := '.X';  // not used
    RPCBrokerV.param[0].ptype := list;
    cmd := 'RESULTS LIST SUBSET';
    cmd := cmd + '^' + JobNum + '^' + StartFrom + '^' + IntToStr(Direction);
    RPCBrokerV.Param[0].Mult['"REQUEST"'] := cmd;
    RPCBrokerV.Call;
    if RPCBrokerV.Results.Count > 0 then begin
      RPCResult := RPCBrokerV.Results[0];    //returns:  error: -1;  success=1
      if piece(RPCResult,'^',1)='-1' then begin
       // handle error...
      end else begin
        RPCBrokerV.Results.Delete(0);
        if RPCBrokerV.Results.Count=0 then begin
          //RPCBrokerV.Results.Add('0^<NO DATA>');
        end;
      end;
    end;
    Result := RPCBrokerV.Results;
  end;

  procedure TfrmSrchResults.cboResultListNeedData(Sender: TObject;
                        const StartFrom: String; Direction, InsertAt: Integer);
  var  Result : TStrings;
       ORComboBox : TORComboBox;
  begin
    ORComboBox := TORComboBox(Sender);
    Result := SubSetOfResults(FJobNum, StartFrom, Direction);
    ORComboBox.ForDataUse(Result);
  end;


  procedure TfrmSrchResults.cboResultListChange(Sender: TObject);
  var SelEntry : string;
  begin
    if cboResultList.ItemIndex >=0 then begin
      SelEntry := cboResultList.Items[cboResultList.ItemIndex];
      SelectedIEN := piece(SelEntry,'^',1);
      SelectedName := piece(SelEntry,'^',2);
    end else begin
      SelectedIEN := '';
      SelectedName := ''
    end;
    if FTargetFName = 'PATIENT' then begin
      ShowDemog(SelectedIEN);
    end else begin
      Memo.Clear;
    end;
  end;

  procedure TfrmSrchResults.btnSelectRecordClick(Sender: TObject);
  begin
   //Check that something is selected, etc.
    if SelectedName = '' then begin
      MessageDlg('Please Select a Record First.',mtInformation,[mbOK],0);
    end else begin
      ModalResult := mrOK;
      //Self.Close;
    end;
  end;


  procedure TfrmSrchResults.ShowDemog(ItemID: string);
  { gets a record of patient indentifying information from the server and displays it }
  var   PtRec: TPtIDInfo;
  begin
    if ItemID = '' then begin
      ClearDemog;
      Exit;
    end;
    if ItemID = FLastDFN then Exit;
    Memo.Clear;
    FLastDFN := ItemID;
    //Memo.Lines.Add('After integration into CPRS, Fix ShowDemog().')
    PtRec := rCore.GetPtIDInfo(ItemID);
    with PtRec do begin
      Memo.Lines.Add(Name);
      Memo.Lines.Add('SSN: ' + SSN + '.');
      Memo.Lines.Add('DOB:' + DOB + '.');
      if Sex <> '' then Memo.Lines.Add(Sex + '.');
      if Location <> '' then
        Memo.Lines.Add('Location: ' + Location + '.');
      if RoomBed <> '' then
        Memo.Lines.Add('Room: ' + RoomBed + '.');
      if HRN <> '' then Memo.Lines.Add('HRN: ' + HRN + '.');
    end;
  end;

  procedure TfrmSrchResults.ClearDemog;
  begin
    Memo.Lines.Clear;
    FLastDFN := '';

  end;

  end.

