//kt -- Modified with SourceScanner on 7/24/2007
unit fNoteST;
{
Text Search CQ: HDS00002856
This Unit Contains the Dialog Used to Capture the Text that will be
searched for in the current notes view.
}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, ORCtrls, StdCtrls, ORFn, uTIU, fAutoSz, DKLang;

type
  TfrmNotesSearchText = class(TfrmAutoSz)
    lblSearchInfo: TLabel;
    edtSearchText: TEdit;
    lblAuthor: TLabel;
    cmdOK: TButton;
    cmdCancel: TButton;
    procedure cmdCancelClick(Sender: TObject);
    procedure cmdOKClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormResize(Sender: TObject);
  private
    //kt Begin Mod (change Consts to Vars) 7/24/2007
    TX_SEARCH_TEXT  : string;  //kt
    TX_SEARCH_CAP   : string;  //kt
    //kt End Mod -------------------
    FChanged: Boolean;
    FSearchString: string;
    procedure SetupVars;  //kt
  end;

  TSearchContext = record
    Changed: Boolean;
    SearchString: string;
  end;

procedure SelectSearchText(FontSize: Integer; var SearchText: String; var SearchContext: TSearchContext);

implementation

{$R *.DFM}

uses rTIU, rCore, uCore, rMisc;

//const
//TX_SEARCH_TEXT = 'Select a search string or press Cancel.';  <-- original line.  //kt 7/24/2007
//TX_SEARCH_CAP = 'Missing search string';  <-- original line.  //kt 7/24/2007

procedure TfrmNotesSearchText.SetupVars;
//kt Added entire function to replace constant declarations 7/24/2007
begin
  TX_SEARCH_TEXT := DKLangConstW('fNoteST_Select_a_search_string_or_press_Cancelx');
  TX_SEARCH_CAP := DKLangConstW('fNoteST_Missing_search_string'); 
end;
 
procedure SelectSearchText(FontSize: Integer; var SearchText: String; var SearchContext: TSearchContext);
{ displays author select form for progress notes and returns a record of the selection }
var
  frmNotesSearchText: TfrmNotesSearchText;
  W, H: integer;
//  CurrentAuthor: Int64;
begin
  frmNotesSearchText := TfrmNotesSearchText.Create(Application);
  try
    with frmNotesSearchText do
    begin
      edtSearchText.Text:=SearchText;
      Font.Size := FontSize;
      W := ClientWidth;
      H := ClientHeight;
      ResizeToFont(FontSize, W, H);
//      ClientWidth  := W; pnlBase.Width  := W;
//      ClientHeight := H; pnlBase.Height := W;
      FChanged := False;
      Show;
      edtSearchText.SetFocus;
      Hide;
      ShowModal;
      If edtSearchText.Text<>'' then
      with SearchContext do
      begin
        Changed := FChanged;
        SearchString := FSearchString;
      end; {with SearchContext}
    end; {with frmNotesSearchText}
  finally
    frmNotesSearchText.Release;
  end;
end;

procedure TfrmNotesSearchText.cmdCancelClick(Sender: TObject);
begin
  FChanged:=False;
  Close;
end;

procedure TfrmNotesSearchText.cmdOKClick(Sender: TObject);
begin
  SetupVars;  //kt added 7/24/2007 to replace constants with vars.
  if edtSearchText.Text = '' then
  begin
    InfoBox(TX_SEARCH_TEXT, TX_SEARCH_CAP, MB_OK or MB_ICONWARNING);
    Exit;
  end;
  FChanged := True;
  FSearchString := edtSearchText.Text;
  Close;
end;

procedure TfrmNotesSearchText.FormShow(Sender: TObject);
begin
  SetFormPosition(Self);
end;

procedure TfrmNotesSearchText.FormDestroy(Sender: TObject);
begin
  SaveUserBounds(Self);
end;

procedure TfrmNotesSearchText.FormResize(Sender: TObject);
begin
  inherited;
  lblSearchInfo.Width := edtSearchText.Width;
end;

end.
