                    <xsl:if test="a:ContinuityOfCareRecord/a:Body/a:Encounters">
                        <component>
                            <section>
                                <templateId root="2.16.840.1.113883.3.88.11.83.127" assigningAuthorityName="HITSP/C83"/>
                                <templateId root="1.3.6.1.4.1.19376.1.5.3.1.1.5.3.3" assigningAuthorityName="IHE PCC"/>
                                <templateId root="2.16.840.1.113883.10.20.1.3" assigningAuthorityName="HL7 CCD"/>
                                <!--Encounters section template-->
                                <code code="46240-8" codeSystem="2.16.840.1.113883.6.1" codeSystemName="LOINC" displayName="History of encounters"/>
                                <title>Encounters</title>
                                <text>
                                    <table>
                                        <tbody>
                                            <tr>
                                                <th>Type</th>
                                                <th>Date</th>
                                                <th>Location</th>
                                                <th>Status</th>
                                                <th>Practitioner</th>
                                                <th>Description</th>
                                                <th>Indications</th>
                                                <th>Source</th>
                                            </tr>
                                            <xsl:for-each select="/a:ContinuityOfCareRecord/a:Body/a:Encounters/a:Encounter">
                                                <tr>
                                                    <xsl:attribute name="id">
                                                        <xsl:value-of select="a:CCRDataObjectID"/>
                                                    </xsl:attribute>

                                                    <td>
                                                        <xsl:value-of select="a:Type/a:Text"/>
                                                    </td>
                                                    <td>
                                                        <xsl:call-template name="date:format-date">
                                                            <xsl:with-param name="date-time" select="a:DateTime/a:ExactDateTime"/>
                                                        </xsl:call-template>
                                                    </td>
                                                    <td>
                                                        <xsl:for-each select="a:Locations/a:Location">
                                                            <xsl:value-of select="a:Description/a:Text"/>
                                                            <xsl:call-template name="actorName">
                                                                <xsl:with-param name="objID" select="a:Actor/a:ActorID"/>
                                                            </xsl:call-template>
                                                            <br/>
                                                        </xsl:for-each>
                                                    </td>
                                                    <td>
                                                        <xsl:value-of select="a:Status/a:Text"/>
                                                    </td>
                                                    <td>
                                                        <xsl:for-each select="a:Practitioners/a:Practitioner">
                                                            <xsl:call-template name="actorName">
                                                                <xsl:with-param name="objID" select="a:ActorID"/>
                                                            </xsl:call-template>
                                                            <br/>
                                                        </xsl:for-each>
                                                    </td>
                                                    <td>
                                                        <xsl:value-of select="a:Description/a:Text"/>
                                                    </td>
                                                    <td>
                                                        <xsl:for-each select="a:Indications/a:Indication">
                                                            <xsl:call-template name="problemDescription">
                                                                <xsl:with-param name="objID" select="a:InternalCCRLink/a:LinkID"/>
                                                            </xsl:call-template>
                                                            <br/>
                                                        </xsl:for-each>
                                                    </td>
                                                    <td>
                                                        <xsl:call-template name="actorName">
                                                            <xsl:with-param name="objID" select="a:Source/a:Actor/a:ActorID"/>
                                                        </xsl:call-template>
                                                    </td>
                                                </tr>
                                            </xsl:for-each>
                                        </tbody>
                                    </table>
                                </text>
                                <xsl:for-each select="/a:ContinuityOfCareRecord/a:Body/a:Encounters/a:Encounter">
                                    <entry typeCode="DRIV">
                                        <encounter classCode="ENC" moodCode="EVN">
                                            <templateId root="2.16.840.1.113883.3.88.11.83.16" assigningAuthorityName="HITSP C83"/>
                                            <templateId root="2.16.840.1.113883.10.20.1.21" assigningAuthorityName="CCD"/>
                                            <templateId root="1.3.6.1.4.1.19376.1.5.3.1.4.14" assigningAuthorityName="IHE PCC"/>

                                            <!-- Encounter activity template -->

                                            <!-- <id> -->
                                            <xsl:call-template name="ccdID">
                                                <xsl:with-param name="ccrObjectID" select="a:CCRDataObjectID"/>
                                            </xsl:call-template>

                                            <xsl:call-template name="ccdCodedValue">
                                                <xsl:with-param name="ccrCodedDescription" select="a:Description"/>
                                                <xsl:with-param name="nodeName" select="'code'"/>
                                            </xsl:call-template>

                                            <text>
                                                <reference>
                                                    <xsl:attribute name="value">
                                                        <xsl:text>#</xsl:text>
                                                        <xsl:value-of select="a:CCRDataObjectID"/>
                                                    </xsl:attribute>
                                                </reference>
                                            </text>

                                            <xsl:call-template name="ccdDateTime">
                                                <xsl:with-param name="dt" select="a:DateTime"/>
                                            </xsl:call-template>

                                            <xsl:if test="a:Practitioners[1]/a:Practitioner">
                                                <xsl:call-template name="ccdPerformer">
                                                    <xsl:with-param name="ccrActorReference" select="a:Practitioners/a:Practitioner[1]"/>
                                                </xsl:call-template>
                                            </xsl:if>

                                            <xsl:if test="a:Locations[1]/a:Location">
                                                <participant typeCode="LOC">
                                                    <templateId root="2.16.840.1.113883.10.20.1.45"/>
                                                    <!-- Location participation template -->
                                                    <xsl:choose>
                                                        <xsl:when test="a:Locations[1]/a:Location/a:ActorID">
                                                            <xsl:call-template name="ccdParticipantRoleActor">
                                                                <xsl:with-param name="ccrActorObjectID" select="a:Locations[1]/a:Location/a:ActorID"/>
                                                            </xsl:call-template>
                                                        </xsl:when>
                                                        <xsl:otherwise>
                                                            <xsl:call-template name="ccdParticipantRoleCodedDescription">
                                                                <xsl:with-param name="ccrCodedDescription" select="a:Locations[1]/a:Location/a:Description"/>
                                                            </xsl:call-template>
                                                        </xsl:otherwise>
                                                    </xsl:choose>
                                                </participant>
                                            </xsl:if>
                                        </encounter>
                                    </entry>
                                </xsl:for-each>
                            </section>
                        </component>
                    </xsl:if>
