                    <xsl:if test="a:ContinuityOfCareRecord/a:Body/a:Alerts">
                        <component>
                            <section>
							  <templateId root="2.16.840.1.113883.10.20.1.2" />
							  <!--C83 Allergies and Other Adverse Reactions Section Conformance Identifier-->
							  <templateId root="2.16.840.1.113883.3.88.11.83.102" />
							  <!--IHE Allergies and Other Adverse Reactions Section Conformance Identifier-->
							  <templateId root="1.3.6.1.4.1.19376.1.5.3.1.3.13" />
                                <code code="48765-2" displayName="Allergies, adverse reactions, alerts" codeSystem="2.16.840.1.113883.6.1" codeSystemName="LOINC" />
                                <title>Alerts</title>
                                <text>
                                    <table>
                                        <tbody>
                                            <tr>
                                                <th>Type</th>
                                                <th>Date</th>
                                                <th>Code</th>
                                                <th>Description</th>
                                                <th>Reaction</th>
                                                <th>Source</th>
                                            </tr>
                                            <xsl:for-each select="/a:ContinuityOfCareRecord/a:Body/a:Alerts/a:Alert">
                                                <tr>
                                                    <td>
                                                        <xsl:value-of select="a:Type/a:Text"/>
                                                    </td>
                                                    <td>
                                                        <xsl:call-template name="date:format-date">
                                                            <xsl:with-param name="date-time" select="a:DateTime/a:ExactDateTime"/>
                                                        </xsl:call-template>
                                                    </td>
                                                    <td>
                                                        <xsl:apply-templates select="a:Description/a:Code"/>
                                                    </td>
                                                    <td>
                                                        <xsl:attribute name="ID">
															<xsl:value-of select="a:CCRDataObjectID"/>
														</xsl:attribute>
                                                        <xsl:value-of select="a:Description/a:Text"/>
                                                    </td>
                                                    <td>
                                                        <xsl:value-of select="a:Reaction/a:Description/a:Text"/>
                                                        <xsl:if test="a:Reaction/a:Severity/a:Text">
                                                            -<xsl:value-of select="a:Reaction/a:Severity/a:Text"/>
                                                        </xsl:if>
                                                    </td>
                                                    <td>
                                                        <xsl:call-template name="actorName">
                                                            <xsl:with-param name="objID" select="a:Source/a:Actor/a:ActorID"/>
                                                        </xsl:call-template>
                                                    </td>
                                                </tr>
                                            </xsl:for-each>
                                        </tbody>
                                    </table>
                                </text>
                                <xsl:for-each select="/a:ContinuityOfCareRecord/a:Body/a:Alerts/a:Alert">
                                    <entry typeCode="DRIV">
                                        <act classCode="ACT" moodCode="EVN">
                                             <!--CCD Problem Act Identifier-->
											 <templateId root="2.16.840.1.113883.10.20.1.27"></templateId>
											 <!--C83 Allergy Entry-->
											 <templateId root="2.16.840.1.113883.3.88.11.83.6" />
											 <!--IHE Concern Entry Conformance Identifier-->
											 <templateId root="1.3.6.1.4.1.19376.1.5.3.1.4.5.1"></templateId>
											 <!--IHE Allergy and Intolerance Concerns Entry-->
											 <templateId root="1.3.6.1.4.1.19376.1.5.3.1.4.5.3"></templateId>

                                            <!-- <id> -->
                                            <xsl:call-template name="ccdID">
                                                <xsl:with-param name="ccrObjectID" select="a:CCRDataObjectID"/>
                                            </xsl:call-template>

                                            <code nullFlavor="NA"/>
                                            <entryRelationship typeCode="SUBJ">
                                                <observation classCode="OBS" moodCode="EVN">
                                                      <!--CCD Alert Observation-->
													  <templateId root="2.16.840.1.113883.10.20.1.18"></templateId>
													  <!--CCD Problem Observation-->
													  <templateId root="2.16.840.1.113883.10.20.1.28" />
													  <!--IHE Problem Entry-->
													  <templateId root="1.3.6.1.4.1.19376.1.5.3.1.4.5" />
													  <!--IHE Allergies and Intolerances Entry-->
													  <templateId root="1.3.6.1.4.1.19376.1.5.3.1.4.6" />
                                                    <!-- <id> -->
                                                    <xsl:call-template name="ccdID">
                                                        <xsl:with-param name="ccrObjectID" select="a:CCRDataObjectID"/>
                                                        <xsl:with-param name="suffix"></xsl:with-param>
                                                    </xsl:call-template>

                                                    <code code="416098002" codeSystem="2.16.840.1.113883.6.96" displayName="drug allergy" codeSystemName="SNOMED CT"/>

                                                    <text>
                                                        <reference>
                                                            <xsl:attribute name="value">
                                                                <xsl:text>#</xsl:text>
                                                                <xsl:value-of select="a:CCRDataObjectID"/>
                                                            </xsl:attribute>
                                                        </reference>
                                                    </text>

                                                    <statusCode code="completed"/>
													<value xsi:type="CD" />
													
                                                   <participant typeCode="CSM">
                                                        <xsl:choose>
                                                            <xsl:when test="a:Agent/a:Products/a:Product/a:Product">
                                                                <xsl:call-template name="ccdParticipantRoleCodedDescription">
                                                                    <xsl:with-param name="ccrCodedDescription" select="a:Product/a:Description"/>
                                                                </xsl:call-template>
                                                            </xsl:when>
                                                            
                                                        </xsl:choose>
                                                    </participant>

                                                    <xsl:if test="a:Reaction">
                                                        <entryRelationship typeCode="MFST" inversionInd="true">
                                                            <observation classCode="OBS" moodCode="EVN">
                                                                <templateId root="2.16.840.1.113883.10.20.1.54"/>
                                                                <!--Reaction observation template -->
                                                                <code code="ASSERTION" codeSystem="2.16.840.1.113883.5.4"/>
                                                                <statusCode code="completed"/>
                                                                <xsl:call-template name="ccdCodedValue">
                                                                    <xsl:with-param name="ccrCodedDescription" select="a:Reaction/a:Description"/>
                                                                </xsl:call-template>
                                                            </observation>
                                                        </entryRelationship>
                                                    </xsl:if>

                                                    <xsl:call-template name="ccdStatus">
                                                        <xsl:with-param name="ccrStatus" select="a:Status"/>
                                                    </xsl:call-template>

                                                </observation>
                                            </entryRelationship>
                                        </act>
                                    </entry>
                                </xsl:for-each>
                            </section>
                        </component>
                    </xsl:if>
