                    <xsl:if test="a:ContinuityOfCareRecord/a:Body/a:SocialHistory">
                        <component>
                            <section>
                                <templateId root="2.16.840.1.113883.10.20.1.15"/>
                                <code code="29762-2" codeSystem="2.16.840.1.113883.6.1"/>
                                <title>Social History</title>
                                <text>
                                    <table>
                                        <tbody>
                                            <tr>
                                                <th>Type</th>
                                                <th>Date</th>
                                                <th>Code</th>
                                                <th>Description</th>
                                                <th>Status</th>
                                                <th>Source</th>
                                            </tr>
                                            <xsl:for-each select="/a:ContinuityOfCareRecord/a:Body/a:SocialHistory/a:SocialHistoryElement">
                                                <tr>
                                                    <td>
                                                        <xsl:value-of select="a:Type/a:Text"/>
                                                    </td>
                                                    <td>
                                                        <xsl:call-template name="date:format-date">
                                                            <xsl:with-param name="date-time" select="a:DateTime/a:ExactDateTime"/>
                                                        </xsl:call-template>
                                                    </td>
                                                    <td>
                                                        <xsl:apply-templates select="a:Description/a:Code"/>
                                                    </td>
                                                    <td>
                                                        <xsl:value-of select="a:Description/a:Text" disable-output-escaping="yes"/>
                                                    </td>
                                                    <td>
                                                        <xsl:value-of select="a:Status/a:Text"/>
                                                    </td>
                                                    <td>
                                                        <xsl:call-template name="actorName">
                                                            <xsl:with-param name="objID" select="a:Source/a:Actor/a:ActorID"/>
                                                        </xsl:call-template>
                                                    </td>
                                                </tr>
                                            </xsl:for-each>
                                        </tbody>
                                    </table>
                                </text>
                                <xsl:for-each select="/a:ContinuityOfCareRecord/a:Body/a:SocialHistory/a:SocialHistoryElement">
                                    <entry typeCode="DRIV">
                                        <observation classCode="OBS" moodCode="EVN">
                                            <templateId root="2.16.840.1.113883.3.88.11.83.19" assigningAuthorityName="HITSP C83"/>
                                            <templateId root="2.16.840.1.113883.10.20.1.33" assigningAuthorityName="CCD"/>
                                            <!-- Social history observation template -->
                                            <!-- <id> -->
                                            <xsl:call-template name="ccdID">
                                                <xsl:with-param name="ccrObjectID" select="a:CCRDataObjectID"/>
                                            </xsl:call-template>
                                            <statusCode code="completed"/>
                                            <xsl:call-template name="ccdDateTime">
                                                <xsl:with-param name="dt" select="a:DateTime"/>
                                            </xsl:call-template>
                                            <entryRelationship typeCode="SUBJ" inversionInd="true">
                                                <observation classCode="OBS" moodCode="EVN">
                                                    <templateId root="2.16.840.1.113883.10.20.1.41"/>
                                                    <!-- Episode observation template -->
                                                    <statusCode code="completed"/>
                                                    <entryRelationship typeCode="SAS">
                                                        <observation classCode="OBS" moodCode="EVN">
                                                            <xsl:call-template name="ccdCodedValue">
                                                                <xsl:with-param name="ccrCodedDescription" select="a:Description"/>
                                                                <xsl:with-param name="nodeName" select="'code'"/>
                                                            </xsl:call-template>
                                                        </observation>
                                                    </entryRelationship>
                                                </observation>
                                            </entryRelationship>
                                        </observation>
                                    </entry>
                                </xsl:for-each>
                            </section>
                        </component>
                    </xsl:if>
