                    <xsl:if test="a:ContinuityOfCareRecord/a:Body/a:Procedures">
                        <component>
                            <section>
                                <templateId root="2.16.840.1.113883.10.20.1.12"/>
                                <code code="47519-4" codeSystem="2.16.840.1.113883.6.1"/>
                                <title>Procedures</title>
                                <text>
                                    <table>
                                        <tbody>
                                            <tr>
                                                <th>Type</th>
                                                <th>Date</th>
                                                <th>Code</th>
                                                <th>Description</th>
                                                <th>Location</th>
                                                <th>Substance</th>
                                                <th>Method</th>
                                                <th>Position</th>
                                                <th>Site</th>
                                                <th>Status</th>
                                                <th>Source</th>
                                            </tr>
                                            <xsl:for-each select="/a:ContinuityOfCareRecord/a:Body/a:Procedures/a:Procedure">
                                                <tr>
                                                    <xsl:attribute name="id">
                                                        <xsl:value-of select="a:CCRDataObjectID"/>
                                                    </xsl:attribute>

                                                    <td>
                                                        <xsl:value-of select="a:Type/a:Text"/>
                                                    </td>
                                                    <table>
                                                        <tbody>
                                                            <xsl:apply-templates select="a:DateTime"/>
                                                        </tbody>
                                                    </table>
                                                    <td>
                                                        <xsl:apply-templates select="a:Description/a:Code"/>
                                                    </td>
                                                    <td>
                                                        <xsl:value-of select="a:Description/a:Text"/>
                                                    </td>
                                                    <td>
                                                        <xsl:for-each select="a:Locations/a:Location">
                                                            <xsl:value-of select="a:Description/a:Text"/>
                                                            <xsl:if test="a:Actor">
                                                                (<xsl:call-template name="actorName">
                                                                    <xsl:with-param name="objID" select="a:Actor/a:ActorID"/>
                                                                </xsl:call-template>
                                                                <xsl:if test="a:Actor/a:ActorRole/a:Text">
                                                                    <xsl:text xml:space="preserve"> - </xsl:text><xsl:value-of select="a:ActorRole/a:Text"/>)
                                                                </xsl:if>
                                                            </xsl:if>)
                                                            <xsl:if test="position() != last()">
                                                                <br/>
                                                            </xsl:if>
                                                        </xsl:for-each>
                                                    </td>
                                                    <td>
                                                        <xsl:for-each select="a:Substance">
                                                            <xsl:value-of select="a:Text"/>
                                                        </xsl:for-each>
                                                    </td>
                                                    <td>
                                                        <xsl:value-of select="a:Method/a:Text"/>
                                                    </td>
                                                    <td>
                                                        <xsl:value-of select="a:Position/a:Text"/>
                                                    </td>
                                                    <td>
                                                        <xsl:value-of select="a:Site/a:Text"/>
                                                    </td>
                                                    <td>
                                                        <xsl:value-of select="a:Status/a:Text"/>
                                                    </td>
                                                    <td>
                                                        <xsl:call-template name="actorName">
                                                            <xsl:with-param name="objID" select="a:Source/a:Actor/a:ActorID"/>
                                                        </xsl:call-template>
                                                    </td>
                                                </tr>
                                            </xsl:for-each>
                                        </tbody>
                                    </table>
                                </text>

                                <xsl:for-each select="/a:ContinuityOfCareRecord/a:Body/a:Procedures/a:Procedure">
                                    <entry typeCode="DRIV">
                                        <procedure classCode="PROC" moodCode="EVN">
                                            <templateId root="2.16.840.1.113883.3.88.11.83.17" assigningAuthorityName="HITSP C83"/>
                                            <templateId root="2.16.840.1.113883.10.20.1.29" assigningAuthorityName="CCD"/>
                                            <templateId root="1.3.6.1.4.1.19376.1.5.3.1.4.19" assigningAuthorityName="IHE PCC"/>

                                            <!-- <id> -->
                                            <xsl:call-template name="ccdID">
                                                <xsl:with-param name="ccrObjectID" select="a:CCRDataObjectID"/>
                                            </xsl:call-template>

                                            <!-- <code> -->
                                            <xsl:call-template name="ccdCodedValue">
                                                <xsl:with-param name="ccrCodedDescription" select="a:Description"/>
                                                <xsl:with-param name="nodeName" select="'code'"/>
                                            </xsl:call-template>

                                            <text>
                                                <reference>
                                                    <xsl:attribute name="value">
                                                        <xsl:text>#</xsl:text>
                                                        <xsl:value-of select="a:CCRDataObjectID"/>
                                                    </xsl:attribute>
                                                </reference>
                                            </text>

                                            <xsl:call-template name="ccdStatusProcedure">
                                                <xsl:with-param name="status" select="a:Status"/>
                                            </xsl:call-template>

                                            <xsl:call-template name="ccdDateTime">
                                                <xsl:with-param name="dt" select="a:DateTime"/>
                                            </xsl:call-template>

                                            <xsl:if test="a:Method">
                                                <xsl:call-template name="ccdCodedValue">
                                                    <xsl:with-param name="ccrCodedDescription" select="a:Method"/>
                                                    <xsl:with-param name="nodeName" select="'approachSiteCode'"/>
                                                </xsl:call-template>
                                            </xsl:if>

                                            <xsl:if test="a:Site">
                                                <xsl:call-template name="ccdCodedValue">
                                                    <xsl:with-param name="ccrCodedDescription" select="a:Site"/>
                                                    <xsl:with-param name="nodeName" select="'targetSiteCode'"/>
                                                </xsl:call-template>
                                            </xsl:if>

                                            <xsl:if test="a:Practitioners/a:Practitioner">
                                                <xsl:call-template name="ccdPerformer">
                                                    <xsl:with-param name="ccrActorReference" select="a:Practitioners/a:Practitioner[1]"/>
                                                </xsl:call-template>
                                            </xsl:if>
                                        </procedure>
                                    </entry>
                                </xsl:for-each>
                            </section>
                        </component>
                    </xsl:if>
