                    <xsl:if test="a:ContinuityOfCareRecord/a:Body/a:AdvanceDirectives">
                        <component>
                            <section>
                                <templateId root="2.16.840.1.113883.10.20.1.1" assigningAuthorityName="HL7 CCD"/>
                                <templateId root="2.16.840.1.113883.3.88.11.83.116" assigningAuthorityName="HITSP/C83"/>
                                <templateId root="1.3.6.1.4.1.19376.1.5.3.1.3.35" assigningAuthorityName="IHE PCC"/>
                                <templateId root="1.3.6.1.4.1.19376.1.5.3.1.3.34" assigningAuthorityName="IHE PCC"/>
                                <!--Advance Directives section template-->
                                <code code="42348-3" codeSystem="2.16.840.1.113883.6.1" codeSystemName="LOINC" displayName="Advance directives"/>
                                <title>Advance Directives</title>
                                <text>
                                    <table>
                                        <tbody>
                                            <tr>
                                                <th>Type</th>
                                                <th>Date</th>
                                                <th>Description</th>
                                                <th>Status</th>
                                                <th>Source</th>
                                            </tr>
                                            <xsl:for-each select="/a:ContinuityOfCareRecord/a:Body/a:AdvanceDirectives/a:AdvanceDirective">
                                                <tr>
                                                    <xsl:attribute name="id">
                                                        <xsl:value-of select="a:CCRDataObjectID"/>
                                                    </xsl:attribute>
                                                    <td>
                                                        <xsl:value-of select="a:Type/a:Text"/>
                                                    </td>
                                                    <td>
                                                        <xsl:call-template name="date:format-date">
                                                            <xsl:with-param name="date-time" select="a:DateTime/a:ExactDateTime"/>
                                                        </xsl:call-template>
                                                    </td>
                                                    <td>
                                                        <xsl:attribute name="id">
                                                            <xsl:value-of select="a:CCRDataObjectID"/>
                                                            <xsl:text>:Narrative</xsl:text>
                                                        </xsl:attribute>

                                                        <xsl:value-of select="a:Description/a:Text"/>
                                                    </td>
                                                    <td>
                                                        <xsl:value-of select="a:Status/a:Text"/>
                                                    </td>
                                                    <td>
                                                        <xsl:call-template name="actorName">
                                                            <xsl:with-param name="objID" select="a:Source/a:Actor/a:ActorID"/>
                                                        </xsl:call-template>
                                                    </td>
                                                </tr>
                                            </xsl:for-each>
                                        </tbody>
                                    </table>
                                </text>
                                <xsl:for-each select="/a:ContinuityOfCareRecord/a:Body/a:AdvanceDirectives/a:AdvanceDirective">
                                    <entry typeCode="DRIV">
                                        <observation classCode="OBS" moodCode="EVN">
                                            <templateId root="2.16.840.1.113883.3.88.11.83.12" assigningAuthorityName="HITSP C83"/>
                                            <templateId root="2.16.840.1.113883.10.20.1.17" assigningAuthorityName="CCD"/>
                                            <templateId root="1.3.6.1.4.1.19376.1.5.3.1.4.13" assigningAuthorityName="IHE PCC"/>
                                            <templateId root="1.3.6.1.4.1.19376.1.5.3.1.4.13.7" assigningAuthorityName="IHE PCC"/>
                                            <!-- Advance directive observation template -->

                                            <!-- <id> -->
                                            <xsl:call-template name="ccdID">
                                                <xsl:with-param name="ccrObjectID" select="a:CCRDataObjectID"/>
                                            </xsl:call-template>

                                            <text>
                                                <reference>
                                                    <xsl:attribute name="value">
                                                        <xsl:text>#</xsl:text>
                                                        <xsl:value-of select="a:CCRDataObjectID"/>
                                                    </xsl:attribute>
                                                </reference>
                                            </text>

                                            <statusCode code="completed"/>

                                            <xsl:call-template name="ccdDateTime">
                                                <xsl:with-param name="dt" select="a:DateTime"/>
                                            </xsl:call-template>

                                            <xsl:call-template name="ccdCodedValue">
                                                <xsl:with-param name="ccrCodedDescription" select="a:Description"/>
                                                <xsl:with-param name="originalTextReference">
                                                    <xsl:text>#</xsl:text>
                                                    <xsl:value-of select="a:CCRDataObjectID"/>
                                                    <xsl:text>:Narrative</xsl:text>
                                                </xsl:with-param>
                                            </xsl:call-template>

                                            <participant typeCode="VRF">
                                                <templateId root="2.16.840.1.113883.10.20.1.58"/>
                                                <!--Verification of an advance directive observation template -->
                                                <time nullFlavor="UNK"/>
                                                <xsl:call-template name="ccdParticipantRoleActor">
                                                    <xsl:with-param name="ccrActorObjectID" select="a:Source[1]/a:ActorID"/>
                                                </xsl:call-template>
                                            </participant>

                                            <xsl:if test="a:ReferenceID">
                                                <reference typeCode="REFR">
                                                    <externalDocument>
                                                        <templateId root="2.16.840.1.113883.10.20.1.36"/>
                                                        <!-- Advance directive reference template -->
                                                        <xsl:variable name="referenceID" select="a:ReferenceID"/>
                                                        <!-- <id> -->
                                                        <xsl:call-template name="ccdID">
                                                            <xsl:with-param name="ccrObjectID" select="$referenceID"/>
                                                        </xsl:call-template>
                                                        <code code="371538006" codeSystem="2.16.840.1.113883.6.96" displayName="Advance directive"/>
                                                        <xsl:variable name="reference" select="/a:ContinuityOfCareRecord/a:References/a:Reference[a:ReferenceObjectID=$referenceID]"/>
                                                        <text>
                                                            <xsl:attribute name="mediaType">
                                                                <xsl:value-of select="$reference/a:Type/a:Text"/>
                                                            </xsl:attribute>
                                                            <reference>
                                                                <xsl:value-of select="$reference/a:Location[1]/a:Description/a:Text"/>
                                                            </reference>
                                                        </text>
                                                    </externalDocument>
                                                </reference>
                                            </xsl:if>
                                        </observation>
                                    </entry>

                                </xsl:for-each>
                            </section>
                        </component>
                    </xsl:if>
