<?xml version="1.0" encoding="utf-8"?>
<!--
Conversion of CCR to Level 3 CCD

Orginal Author:   	Ken Miller
Solventus LLC
ken.miller@solventus.coms

Contributors:
Richard Braman, EHR Doctors, Inc rbraman@ehrdoctors.com
George Lilly (WorldVistA glilly@glilly.net)
xxxx - Oroville Hospital

Date: 	2010-05-5
Version: 	0.1

License :

        This program is free software: you can redistribute it and/or modify
        it under the terms of the GNU General Public License as published by
        the Free Software Foundation, either version 3 of the License, or
        (at your option) any later version.

        This program is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        GNU General Public License for more details.

        You should have received a copy of the GNU General Public License
        along with this program.  If not, see http://www.gnu.org/licenses.

-->
<xsl:stylesheet version="1.0" xmlns="urn:hl7-org:v3" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:a="urn:astm-org:CCR" xmlns:date="http://exslt.org/dates-and-times"
xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" exclude-result-prefixes="a date">
    <xsl:import href="./templates/cdavocablookup.xsl"/>
    <xsl:import href="./templates/hl7oidlookup.xsl"/>
    <xsl:import href="./templates/code.xsl"/>
    <xsl:import href="./templates/actor.xsl"/>
    <xsl:import href="./templates/datetime.xsl"/>
    <xsl:import href="./templates/problemDescription.xsl"/>

    <xsl:output method="xml" encoding="utf-8" version="1.0" indent="yes"/>
    <xsl:template match="/">
        <ClinicalDocument xmlns="urn:hl7-org:v3" xmlns:voc="urn:hl7-org:v3/voc" xmlns:sdtc="urn:hl7-org:sdtc"  xsi:schemaLocation="urn:hl7-org:v3 http://xreg2.nist.gov:8080/hitspValidation/schema/cdar2c32/infrastructure/cda/C32_CDA.xsd" classCode="DOCCLIN" moodCode="EVN">
            <realmCode code="US"/>
            <typeId root="2.16.840.1.113883.1.3" extension="POCD_HD000040"/>
            <templateId root="2.16.840.1.113883.10.20.1"/>
            <templateId root="1.3.6.1.4.1.19376.1.5.3.1.1.1"/>
            <templateId root="2.16.840.1.113883.10.20.3"/>
            <templateId root="2.16.840.1.113883.3.88.11.32.1"/>

            <id>
                <xsl:attribute name="root">
                    <xsl:value-of select="/a:ContinuityOfCareRecord/a:CCRDocumentObjectID"></xsl:value-of>
                </xsl:attribute>
            </id>
            <code code="34133-9" codeSystem="2.16.840.1.113883.6.1" codeSystemName="LOINC" displayName="Summarization of episode note"/>
             <xsl:variable name="fromID" select="/a:ContinuityOfCareRecord/a:From/a:ActorLink[1]/a:ActorID"/>
              <xsl:variable name="ccrFromActorObjectID" select="/a:ContinuityOfCareRecord/a:Actors/a:Actor[a:ActorObjectID=$fromID]/a:InternalCCRLink[a:LinkRelationship='representedOrganization']/a:LinkID"/>
            <title>Continuity of Care Document from <xsl:value-of select="/a:ContinuityOfCareRecord/a:Actors/a:Actor[a:ActorObjectID=$ccrFromActorObjectID]/a:Organization/a:Name"/></title>
            <effectiveTime>
                <xsl:attribute name="value">
                    <xsl:call-template name="date:format-date">
                        <xsl:with-param name="date-time" select="/a:ContinuityOfCareRecord/a:DateTime/a:ExactDateTime"/>
                        <xsl:with-param name="pattern">yyyyMMddhhmmss+0000</xsl:with-param>
                    </xsl:call-template>
                </xsl:attribute>
            </effectiveTime>
            <confidentialityCode code="N" codeSystem="2.16.840.1.113883.5.25"/>
            <languageCode code="en-US"/>

            <recordTarget typeCode="RCT" contextControlCode="OP">
            <patientRole>
                <xsl:call-template name="ccdPatientRole">
                    <xsl:with-param name="ccrActorObjectID" select="/a:ContinuityOfCareRecord/a:Patient[1]/a:ActorID"/>
                </xsl:call-template>
                </patientRole>
            </recordTarget>

            <author>
                <time>
                    <xsl:attribute name="value">
                        <xsl:call-template name="date:format-date">
                            <xsl:with-param name="date-time" select="/a:ContinuityOfCareRecord/a:DateTime/a:ExactDateTime"/>
                            <xsl:with-param name="pattern">yyyyMMddhhmmss</xsl:with-param>
                        </xsl:call-template>
                    </xsl:attribute>
                </time>
                <xsl:call-template name="ccdAssignedAuthor">
                    <xsl:with-param name="ccrActorObjectID" select="$fromID"/>
                </xsl:call-template>
            </author>

            <xsl:if test="/a:ContinuityOfCareRecord/a:Actors/a:Actor[a:ActorObjectID=$fromID]/a:InternalCCRLink[a:LinkRelationship='representedOrganization']">
                <custodian>
                    <assignedCustodian>
                        <xsl:call-template name="ccdOrganization">
                            <xsl:with-param name="ccrActorObjectID" select="/a:ContinuityOfCareRecord/a:Actors/a:Actor[a:ActorObjectID=$fromID]/a:InternalCCRLink[a:LinkRelationship='representedOrganization']/a:LinkID"/>
                            <xsl:with-param name="organizationNodeName" select="'representedCustodianOrganization'"/>
                        </xsl:call-template>
                    </assignedCustodian>
                </custodian>
            </xsl:if> 

            <documentationOf>
                <serviceEvent classCode="PCPR">
                    <effectiveTime>
                        <low>
                            <xsl:attribute name="value">
                                <xsl:call-template name="date:format-date">
                                    <xsl:with-param name="date-time">
                                        <xsl:for-each select="/a:ContinuityOfCareRecord/a:Body//a:DateTime//a:ExactDateTime">
                                            <xsl:sort order="ascending"/>
                                            <xsl:if test="position()=1">
                                                <xsl:value-of select="."/>
                                            </xsl:if>
                                        </xsl:for-each>
                                    </xsl:with-param>
                                    <xsl:with-param name="pattern">yyyyMMdd</xsl:with-param>
                                </xsl:call-template>
                            </xsl:attribute>
                        </low>
                        <high>
                            <xsl:attribute name="value">
                                <xsl:call-template name="date:format-date">
                                    <xsl:with-param name="date-time">
                                        <xsl:for-each select="/a:ContinuityOfCareRecord/a:Body//a:DateTime//a:ExactDateTime">
                                            <xsl:sort order="descending"/>
                                            <xsl:if test="position()=1">
                                                <xsl:value-of select="."/>
                                            </xsl:if>
                                        </xsl:for-each>
                                    </xsl:with-param>
                                    <xsl:with-param name="pattern">yyyyMMdd</xsl:with-param>
                                </xsl:call-template>
                            </xsl:attribute>
                        </high>
                    </effectiveTime>
                </serviceEvent>

                <xsl:for-each select="/a:ContinuityOfCareRecord/a:Body/a:HealthCareProviders/a:Provider">
                    <xsl:call-template name="ccdAssignedEntity">
                        <xsl:with-param name="ccrActorObjectID" select="a:ActorID"/>
                    </xsl:call-template>
                </xsl:for-each>

            </documentationOf>

            <component>
                <structuredBody>
