                    <xsl:if test="a:ContinuityOfCareRecord/a:Body/a:PlanOfCare">
                        <component>
                            <section>
                                <templateId root="2.16.840.1.113883.10.20.1.10"/>
                                <code code="18776-5" codeSystem="2.16.840.1.113883.6.1"/>
                                <title>Plan Of Care</title>
                                <text>
                                    <xsl:if test="a:ContinuityOfCareRecord/a:Body/a:PlanOfCare/a:Plan[a:Type/a:Text='Treatment Recommendation']">
                                        <xsl:text>Plan Of Care Recommendations</xsl:text>
                                        <br/>
                                        <table>
                                            <tbody>
                                                <tr>
                                                    <th>Description</th>
                                                    <th>Recommendation</th>
                                                    <th>Goal</th>
                                                    <th>Status</th>
                                                    <th>Source</th>
                                                </tr>
                                                <xsl:for-each select="/a:ContinuityOfCareRecord/a:Body/a:PlanOfCare/a:Plan[a:Type/a:Text='Treatment Recommendation']">
                                                    <tr>
                                                        <td>
                                                            <xsl:value-of select="a:Description/a:Text"/>
                                                        </td>
                                                        <td>
                                                            <xsl:value-of select="a:OrderRequest/a:Description/a:Text" disable-output-escaping="yes"/>
                                                        </td>
                                                        <td>
                                                            <xsl:value-of select="a:OrderRequest/a:Goals/a:Goal/a:Description/a:Text" disable-output-escaping="yes"/>
                                                        </td>
                                                        <td>
                                                            <xsl:value-of select="a:Status/a:Text"/>
                                                        </td>
                                                        <td>
                                                            <xsl:call-template name="actorName">
                                                                <xsl:with-param name="objID" select="a:Source/a:Actor/a:ActorID"/>
                                                            </xsl:call-template>
                                                        </td>
                                                    </tr>
                                                </xsl:for-each>
                                            </tbody>
                                        </table>
                                    </xsl:if>
                                    <xsl:if test="a:ContinuityOfCareRecord/a:Body/a:PlanOfCare/a:Plan[a:Type/a:Text='Order']">
                                        <xsl:text>Plan Of Care Orders</xsl:text>
                                        <br/>
                                        <table>
                                            <tbody>
                                                <tr>
                                                    <th>Descripion</th>
                                                    <th>Plan Status</th>
                                                    <th>Type</th>
                                                    <th>Date</th>
                                                    <th>Procedure</th>
                                                    <th>Schedule</th>
                                                    <th>Location</th>
                                                    <th>Substance</th>
                                                    <th>Method</th>
                                                    <th>Position</th>
                                                    <th>Site</th>
                                                    <th>Status</th>
                                                    <th>Source</th>
                                                </tr>
                                                <xsl:for-each select="/a:ContinuityOfCareRecord/a:Body/a:PlanOfCare/a:Plan[a:Type/a:Text='Order']">
                                                    <tr>
                                                        <td>
                                                            <xsl:apply-templates select="a:Description/a:Text"/>
                                                        </td>
                                                        <td>
                                                            <xsl:value-of select="a:Status/a:Text"/>
                                                        </td>
                                                        <td>
                                                            <xsl:value-of select="a:OrderRequest/a:Procedures/a:Procedure/a:Type/a:Text"/>
                                                        </td>
                                                        <td>
                                                            <xsl:call-template name="date:format-date">
                                                                <xsl:with-param name="date-time" select="a:OrderRequest/a:Procedures/a:Procedure/a:DateTime/a:ExactDateTime"/>
                                                            </xsl:call-template>
                                                        </td>
                                                        <td>
                                                            <xsl:apply-templates select="a:OrderRequest/a:Procedures/a:Procedure/a:Description/a:Text"/>
                                                        </td>
                                                        <td>
                                                            <xsl:text xml:space="preserve">Every </xsl:text>
                                                            <xsl:apply-templates select="a:OrderRequest/a:Procedures/a:Procedure/a:Interval/a:Value"/>
                                                            <xsl:text xml:space="preserve"> </xsl:text>
                                                            <xsl:value-of select="a:OrderRequest/a:Procedures/a:Procedure/a:Interval/a:Units/a:Unit"/>
                                                            <xsl:text xml:space="preserve"> for </xsl:text>
                                                            <xsl:value-of select="a:OrderRequest/a:Procedures/a:Procedure/a:Duration/a:Value"/>
                                                            <xsl:text xml:space="preserve"> </xsl:text>
                                                            <xsl:value-of select="a:OrderRequest/a:Procedures/a:Procedure/a:Duration/a:Units/a:Unit"/>
                                                        </td>
                                                        <td>
                                                            <xsl:for-each select="a:OrderRequest/a:Procedures/a:Procedure/a:Locations">
                                                                <xsl:value-of select="a:Location/a:Description/a:Text"/>
                                                                <xsl:if test="position() != last()">
                                                                    <br/>
                                                                </xsl:if>
                                                            </xsl:for-each>
                                                        </td>
                                                        <td>
                                                            <xsl:value-of select="a:OrderRequest/a:Procedures/a:Procedure/a:Substance/a:Text"/>
                                                        </td>
                                                        <td>
                                                            <xsl:value-of select="a:OrderRequest/a:Procedures/a:Procedure/a:Method/a:Text"/>
                                                        </td>
                                                        <td>
                                                            <xsl:value-of select="a:OrderRequest/a:Procedures/a:Procedure/a:Position/a:Text"/>
                                                        </td>
                                                        <td>
                                                            <xsl:value-of select="a:OrderRequest/a:Procedures/a:Procedure/a:Site/a:Text"/>
                                                        </td>
                                                        <td/>
                                                        <td>
                                                            <xsl:call-template name="actorName">
                                                                <xsl:with-param name="objID" select="a:Source/a:Actor/a:ActorID"/>
                                                            </xsl:call-template>
                                                        </td>
                                                    </tr>
                                                </xsl:for-each>
                                            </tbody>
                                        </table>
                                    </xsl:if>
                                </text>
                                <xsl:for-each select="/a:ContinuityOfCareRecord/a:Body/a:PlanOfCare/a:Plan/a:OrderRequest/a:Procedures/a:Procedure">
                                    <entry typeCode="DRIV">
                                        <observation classCode="OBS" moodCode="RQO">
                                            <templateId root="1.3.6.1.4.1.19376.1.5.3.1.1.20.3.1"/>

                                            <!-- <id> -->
                                            <xsl:call-template name="ccdID">
                                                <xsl:with-param name="ccrObjectID" select="a:CCRDataObjectID"/>
                                            </xsl:call-template>

                                            <!-- <code> -->
                                            <xsl:call-template name="ccdCodedValue">
                                                <xsl:with-param name="ccrCodedDescription" select="a:Description"/>
                                                <xsl:with-param name="nodeName" select="'code'"/>
                                            </xsl:call-template>

                                            <statusCode code="new"/>

                                            <effectiveTime>
                                                <xsl:choose>
                                                    <xsl:when test="a:DateTime">
                                                        <xsl:call-template name="ccdDateTime">
                                                            <xsl:with-param name="dt" select="a:DateTime"/>
                                                        </xsl:call-template>
                                                    </xsl:when>
                                                    <xsl:when test="a:Interval">
                                                        <xsl:attribute name="xsi:type">PIVL_TS</xsl:attribute>
                                                        <xsl:attribute name="operator">A</xsl:attribute>
                                                        <xsl:attribute name="institutionSpecified">true</xsl:attribute>
                                                        <period>
                                                            <xsl:attribute name="value">
                                                                <xsl:value-of select="a:Interval/a:Value"/>
                                                            </xsl:attribute>
                                                            <xsl:attribute name="unit">
                                                                <xsl:value-of select="a:Interval/a:Units/a:Unit"/>
                                                            </xsl:attribute>
                                                        </period>
                                                    </xsl:when>
                                                </xsl:choose>
                                            </effectiveTime>
                                        </observation>
                                    </entry>
                                </xsl:for-each>

                                <xsl:for-each select="/a:ContinuityOfCareRecord/a:Body/a:PlanOfCare/a:Plan/a:OrderRequest/a:Medications/a:Medication">
                                    <entry typeCode="DRIV">
                                        <substanceAdministration classCode="SBADM" moodCode="INT">
                                            <templateId root="2.16.840.1.113883.10.20.1.24" assigningAuthorityName="CCD"/>
                                            <templateId root="1.3.6.1.4.1.19376.1.5.3.1.4.7.1" assigningAuthorityName="IHE PCC"/>

                                            <!--Medication activity template -->

                                            <!-- <id> -->
                                            <xsl:call-template name="ccdID">
                                                <xsl:with-param name="ccrObjectID" select="a:CCRDataObjectID"/>
                                            </xsl:call-template>

                                            <statusCode code='completed'/>

                                            <xsl:call-template name="ccdDateTime">
                                                <xsl:with-param name="dt" select="a:DateTime"/>
                                                <xsl:with-param name="type" select="'IVL_TS'"/>
                                            </xsl:call-template>

                                            <xsl:call-template name="ccdMedicationFrequency">
                                                <xsl:with-param name="frequency" select="a:Directions/a:Direction/a:Frequency"/>
                                            </xsl:call-template>

                                            <xsl:call-template name="ccdCodedValue">
                                                <xsl:with-param name="ccrCodedDescription" select="a:Directions/a:Direction/a:Route"/>
                                                <xsl:with-param name="nodeName" select="'routeCode'"/>
                                                <xsl:with-param name="domain" select="'RouteOfAdministration'"/>
                                            </xsl:call-template>

                                            <xsl:if test="a:Directions/a:Direction/a:Dose">
                                                <doseQuantity>
                                                    <low>
                                                        <xsl:attribute name="value">
                                                            <xsl:value-of select="a:Directions/a:Direction/a:Dose/a:Value"></xsl:value-of>
                                                        </xsl:attribute>
                                                        <xsl:attribute name="unit">
                                                            <xsl:value-of select="a:Directions/a:Direction/a:Dose/a:Unit"></xsl:value-of>
                                                        </xsl:attribute>
                                                    </low>
                                                    <high>
                                                        <xsl:attribute name="value">
                                                            <xsl:value-of select="a:Directions/a:Direction/a:Dose/a:Value"></xsl:value-of>
                                                        </xsl:attribute>
                                                        <xsl:attribute name="unit">
                                                            <xsl:value-of select="a:Directions/a:Direction/a:Dose/a:Unit"></xsl:value-of>
                                                        </xsl:attribute>
                                                    </high>
                                                </doseQuantity>
                                            </xsl:if>
                                            <consumable>
                                                <manufacturedProduct>
                                                    <templateId root="2.16.840.1.113883.3.88.11.83.8.2" assigningAuthorityName="HITSP C83"/>
                                                    <templateId root="2.16.840.1.113883.10.20.1.53" assigningAuthorityName="CCD"/>
                                                    <templateId root="1.3.6.1.4.1.19376.1.5.3.1.4.7.2" assigningAuthorityName="IHE PCC"/>

                                                    <!-- Product template -->

                                                    <manufacturedMaterial>
                                                        <xsl:call-template name="ccdCodedValue">
                                                            <xsl:with-param name="ccrCodedDescription" select="a:Product/a:ProductName"/>
                                                            <xsl:with-param name="nodeName" select="'code'"/>
                                                        </xsl:call-template>
                                                        <name>
                                                            <xsl:value-of select="a:Product/a:BrandName/a:Text"/>
                                                        </name>
                                                    </manufacturedMaterial>
                                                </manufacturedProduct>
                                            </consumable>
                                        </substanceAdministration>
                                    </entry>
                                </xsl:for-each>
                                <xsl:for-each select="/a:ContinuityOfCareRecord/a:Body/a:PlanOfCare/a:Plan/a:OrderRequest/a:Immunizations/a:Immunization">

                                    <entry typeCode="DRIV">
                                        <substanceAdministration classCode="SBADM" moodCode="EVN">
                                            <templateId root="2.16.840.1.113883.10.20.1.24" assigningAuthorityName="CCD"/>
                                            <templateId root="2.16.840.1.113883.3.88.11.83.13" assigningAuthorityName="HITSP C83"/>
                                            <templateId root="1.3.6.1.4.1.19376.1.5.3.1.4.12" assigningAuthorityName="IHE PCC"/>

                                            <!-- Medication activity template -->

                                            <!-- <id> -->
                                            <xsl:call-template name="ccdID">
                                                <xsl:with-param name="ccrObjectID" select="a:CCRDataObjectID"/>
                                            </xsl:call-template>

                                            <code code="IMMUNIZ" codeSystem="2.16.840.1.113883.5.4" codeSystemName="HL7 ActCode"/>
                                            <text>
                                                <reference>
                                                    <xsl:attribute name="value">
                                                        <xsl:text>#</xsl:text>
                                                        <xsl:value-of select="a:CCRDataObjectID"/>
                                                    </xsl:attribute>
                                                </reference>
                                            </text>

                                            <statusCode code='completed'/>

                                            <xsl:call-template name="ccdDateTime">
                                                <xsl:with-param name="dt" select="a:DateTime"/>
                                                <xsl:with-param name="type" select="'IVL_TS'"/>
                                            </xsl:call-template>

                                            <xsl:call-template name="ccdCodedValue">
                                                <xsl:with-param name="ccrCodedDescription" select="a:Directions/a:Direction/a:Route"/>
                                                <xsl:with-param name="nodeName" select="'routeCode'"/>
                                                <xsl:with-param name="domain" select="'RouteOfAdministration'"/>
                                            </xsl:call-template>

                                            <xsl:if test="a:Directions/a:Direction/a:Site">
                                                <xsl:call-template name="ccdCodedValue">
                                                    <xsl:with-param name="ccrCodedDescription" select="a:Directions/a:Direction/a:Site"/>
                                                    <xsl:with-param name="nodeName" select="'approachSiteCode'"/>
                                                    <xsl:with-param name="originalTextReference">
                                                        <xsl:text>#</xsl:text>
                                                        <xsl:value-of select="a:CCRDataObjectID"/>
                                                        <xsl:text>:Site</xsl:text>
                                                    </xsl:with-param>
                                                </xsl:call-template>
                                            </xsl:if>

                                            <consumable>
                                                <manufacturedProduct>
                                                    <templateId root="2.16.840.1.113883.3.88.11.83.8.2" assigningAuthorityName="HITSP C83"/>
                                                    <templateId root="2.16.840.1.113883.10.20.1.53" assigningAuthorityName="CCD"/>
                                                    <templateId root="1.3.6.1.4.1.19376.1.5.3.1.4.7.2" assigningAuthorityName="IHE PCC"/>

                                                    <!-- Product template -->

                                                    <manufacturedMaterial>
                                                        <xsl:call-template name="ccdCodedValue">
                                                            <xsl:with-param name="ccrCodedDescription" select="a:Product/a:ProductName"/>
                                                            <xsl:with-param name="nodeName" select="'code'"/>
                                                        </xsl:call-template>
                                                        <name>
                                                            <xsl:value-of select="a:Product/a:BrandName/a:Text"/>
                                                        </name>
                                                    </manufacturedMaterial>
                                                </manufacturedProduct>
                                            </consumable>

                                        </substanceAdministration>
                                    </entry>
                                </xsl:for-each>

                                <xsl:for-each select="/a:ContinuityOfCareRecord/a:Body/a:PlanOfCare/a:Plan/a:OrderRequest/a:Encounters/a:Encounter">
                                    <entry typeCode="DRIV">
                                        <encounter classCode="ENC" moodCode="INT">
                                            <templateId root="2.16.840.1.113883.3.88.11.83.16" assigningAuthorityName="HITSP C83"/>
                                            <templateId root="2.16.840.1.113883.10.20.1.21" assigningAuthorityName="CCD"/>
                                            <templateId root="1.3.6.1.4.1.19376.1.5.3.1.4.14" assigningAuthorityName="IHE PCC"/>

                                            <!-- Encounter activity template -->

                                            <!-- <id> -->
                                            <xsl:call-template name="ccdID">
                                                <xsl:with-param name="ccrObjectID" select="a:CCRDataObjectID"/>
                                            </xsl:call-template>

                                            <xsl:call-template name="ccdCodedValue">
                                                <xsl:with-param name="ccrCodedDescription" select="a:Description"/>
                                                <xsl:with-param name="nodeName" select="'code'"/>
                                            </xsl:call-template>

                                            <text>
                                                <reference>
                                                    <xsl:attribute name="value">
                                                        <xsl:text>#</xsl:text>
                                                        <xsl:value-of select="a:CCRDataObjectID"/>
                                                    </xsl:attribute>
                                                </reference>
                                            </text>

                                            <xsl:call-template name="ccdDateTime">
                                                <xsl:with-param name="dt" select="a:DateTime"/>
                                            </xsl:call-template>

                                            <xsl:if test="a:Practitioners[1]/a:Practitioner">
                                                <xsl:call-template name="ccdPerformer">
                                                    <xsl:with-param name="ccrActorReference" select="a:Practitioners/a:Practitioner[1]"/>
                                                </xsl:call-template>
                                            </xsl:if>

                                            <xsl:if test="a:Locations[1]/a:Location">
                                                <participant typeCode="LOC">
                                                    <templateId root="2.16.840.1.113883.10.20.1.45"/>
                                                    <!-- Location participation template -->
                                                    <xsl:choose>
                                                        <xsl:when test="a:Locations[1]/a:Location/a:ActorID">
                                                            <xsl:call-template name="ccdParticipantRoleActor">
                                                                <xsl:with-param name="ccrActorObjectID" select="a:Locations[1]/a:Location/a:ActorID"/>
                                                            </xsl:call-template>
                                                        </xsl:when>
                                                        <xsl:otherwise>
                                                            <xsl:call-template name="ccdParticipantRoleCodedDescription">
                                                                <xsl:with-param name="ccrCodedDescription" select="a:Locations[1]/a:Location/a:Description"/>
                                                            </xsl:call-template>
                                                        </xsl:otherwise>
                                                    </xsl:choose>
                                                </participant>
                                            </xsl:if>
                                        </encounter>
                                    </entry>
                                </xsl:for-each>
                            </section>
                        </component>
                    </xsl:if>
