                    <xsl:if test="a:ContinuityOfCareRecord/a:Body/a:Results/a:Result">
                        <component>
                            <section>
                                <templateId root="2.16.840.1.113883.10.20.1.14"/>
                                <code code="30954-2" codeSystem="2.16.840.1.113883.6.1"/>
                                <title>Results</title>
                                <text>
                                    <table>
                                        <tbody>
                                            <tr>
                                                <th>Test</th>
                                                <th>Date</th>
                                                <th>Result</th>
                                                <th>Source</th>
                                            </tr>
                                            <xsl:for-each select="/a:ContinuityOfCareRecord/a:Body/a:Results/a:Result">
                                                <tr>
                                                    <xsl:attribute name="id">
                                                        <xsl:value-of select="a:CCRDataObjectID"/>
                                                    </xsl:attribute>
                                                    <td>
                                                        <xsl:value-of select="a:Description/a:Text"/>
                                                    </td>
                                                    <td>
                                                        <xsl:call-template name="date:format-date">
                                                            <xsl:with-param name="date-time" select="a:DateTime/a:ExactDateTime"/>
                                                        </xsl:call-template>
                                                    </td>
                                                    <td>
                                                        <xsl:for-each select="a:Test[a:TestResult/a:Value!='']">
                                                            <div>
                                                                <xsl:attribute name="id">
                                                                    <xsl:value-of select="a:CCRDataObjectID"/>
                                                                </xsl:attribute>

                                                                <xsl:value-of select="a:Description/a:Text"/>
                                                                <xsl:text xml:space="preserve"> </xsl:text>
                                                                <xsl:value-of select="a:TestResult/a:Value"/>
                                                                <xsl:text xml:space="preserve"> </xsl:text>
                                                                <xsl:value-of select="a:TestResult/a:Units/a:Unit"/>
                                                                <xsl:text xml:space="preserve"> </xsl:text>
                                                                <xsl:value-of select="a:Flag/a:Text"/>
                                                                <br/>
                                                            </div>
                                                        </xsl:for-each>
                                                        <xsl:for-each select="a:Test[a:TestResult/a:Description/a:Text!='']">
                                                            <div>
                                                                <xsl:attribute name="id">
                                                                    <xsl:value-of select="a:CCRDataObjectID"/>
                                                                </xsl:attribute>

                                                                <xsl:value-of select="a:Description/a:Text"/>
                                                                <xsl:text xml:space="preserve"> </xsl:text>
                                                                <xsl:value-of select="a:TestResult/a:Description/a:Text" disable-output-escaping="yes"/>
                                                                <xsl:text xml:space="preserve"> </xsl:text>
                                                                <xsl:value-of select="a:Flag/a:Text"/>
                                                                <br/>
                                                            </div>
                                                        </xsl:for-each>
                                                    </td>
                                                    <td>
                                                        <xsl:call-template name="actorName">
                                                            <xsl:with-param name="objID" select="a:Source/a:Actor/a:ActorID"/>
                                                        </xsl:call-template>
                                                    </td>
                                                </tr>
                                            </xsl:for-each>
                                        </tbody>
                                    </table>
                                </text>
                                <xsl:for-each select="/a:ContinuityOfCareRecord/a:Body/a:Results/a:Result">
                                    <entry typeCode="DRIV">
                                        <xsl:variable name="testDate" select="a:DateTime"/>

                                        <xsl:choose>
                                            <xsl:when test="count(a:Test)>1">
                                                <organizer classCode="BATTERY" moodCode="EVN">
                                                    <templateId root="2.16.840.1.113883.10.20.1.32"/>
                                                    <!--Result organizer template -->

                                                    <!-- <id> -->
                                                    <xsl:call-template name="ccdID">
                                                        <xsl:with-param name="ccrObjectID" select="a:CCRDataObjectID"/>
                                                    </xsl:call-template>

                                                    <!-- <code> -->
                                                    <xsl:call-template name="ccdCodedValue">
                                                        <xsl:with-param name="ccrCodedDescription" select="a:Description"/>
                                                        <xsl:with-param name="nodeName" select="'code'"/>
                                                    </xsl:call-template>

                                                    <statusCode code="completed"/>

                                                    <!-- <effectiveTime> -->
                                                    <xsl:call-template name="ccdDateTime">
                                                        <xsl:with-param name="dt" select="$testDate"/>
                                                    </xsl:call-template>

                                                    <xsl:call-template name="ccdPerformer">
                                                        <xsl:with-param name="ccrActorReference" select="a:Source/a:Actor"/>
                                                    </xsl:call-template>

                                                    <xsl:for-each select="a:Test">
                                                        <xsl:call-template name="ccdObservation">
                                                            <xsl:with-param name="ccrTestNode" select="."/>
                                                            <xsl:with-param name="testDate" select="$testDate"/>
                                                        </xsl:call-template>
                                                    </xsl:for-each>

                                                </organizer>

                                            </xsl:when>
                                            <xsl:otherwise>
                                                <xsl:call-template name="ccdObservation">
                                                    <xsl:with-param name="ccrTestNode" select="a:Test[1]"/>
                                                    <xsl:with-param name="testDate" select="$testDate"/>
                                                </xsl:call-template>
                                            </xsl:otherwise>
                                        </xsl:choose>
                                    </entry>
                                </xsl:for-each>
                            </section>
                        </component>
                    </xsl:if>
