<?xml version="1.0" encoding="UTF-8"?>
<!--
Conversion of CCR to Level 3 CCD

Orginal Author:   	Ken Miller
Solventus LLC
ken.miller@solventus.coms

Contributors:
Richard Braman, EHR Doctors, Inc rbraman@ehrdoctors.com
George Lilly (WorldVistA glilly@glilly.net)
xxxx - Oroville Hospital

Date: 	2010-05-5
Version: 	0.1

License :

        This program is free software: you can redistribute it and/or modify
        it under the terms of the GNU General Public License as published by
        the Free Software Foundation, either version 3 of the License, or
        (at your option) any later version.

        This program is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        GNU General Public License for more details.

        You should have received a copy of the GNU General Public License
        along with this program.  If not, see http://www.gnu.org/licenses.

-->
<xsl:stylesheet version="1.0" xmlns="urn:hl7-org:v3" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:a="urn:astm-org:CCR" xmlns:date="http://exslt.org/dates-and-times"
xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" exclude-result-prefixes="a date">
    <xsl:import href="./templates/cdavocablookup.xsl"/>
    <xsl:import href="./templates/hl7oidlookup.xsl"/>
    <xsl:import href="./templates/code.xsl"/>
    <xsl:import href="./templates/actor.xsl"/>
    <xsl:import href="./templates/datetime.xsl"/>
    <xsl:import href="./templates/problemDescription.xsl"/>

    <xsl:output method="xml" encoding="utf-8" version="1.0" indent="yes"/>
    <xsl:template match="/">
<!--WV Added new munltiple documentation of added have to do with encounter times, etc.-->

<!--
********************************************************
CDA Header
********************************************************
-->

<!--
******************
Document Information
**********************
-->
<ClinicalDocument xmlns="urn:hl7-org:v3" xmlns:voc="urn:hl7-org:v3/voc" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="urn:hl7-org:v3 CDA.xsd">
	<!-- Created with XML Copy Editor  Open Source Sourceforge project. -->
<!--WVP This is the clinical document type ID-->
  <realmCode code="US"/>
	<typeId root="2.16.840.1.113883.1.3" extension="POCD_HD000040"/>
	<!-- QRDA Category I generic template ID. -->
	<!--WVP these next two lines are fixed-->
	<templateId root="2.16.840.1.113883.10.20.12" />
	<!--only in the july spec so not sure if it should be here-->
	<templateId root="2.16.840.1.113883.3.249.11.100.1"/>
	<!--WVV 2.16.840.1.113883.3.543 is fixed and is the beginninng of WorldVistAs OID, change the extension for a new document and the version for changes to this one-->
	<!-- WV? for this group of 10 documents we are submitting-->
	<id root="2.16.840.1.113883.3.543" extension="01.01.01.100000001.1"/>
		 <!--WVP next two lines fixed-->
	<code code="55182-0" codeSystem="2.16.840.1.113883.6.1" codeSystemName="LOINC" displayName="Quality Measure Report"/>
	<title>QRDA Incidence Report</title>
		<!--WVV time-->
	<effectiveTime value="20100703"/>
		<!--WVP for next two lines-->
  <confidentialityCode codeSystem="2.16.840.1.113883.5.25" code="N"/>
  <languageCode code="en-US"/>
  <!--WV? Don't change this in the document set we are working on-->
  <setId root="2.16.840.1.113883.3.543" extension="01.01.01.100000001"/>
	 <versionNumber value="1"/>
  <!--WVP  I made one up but we will have to have an OID for the Clincal Document SET which we will make up for ourselves eventually-->
  
 <!--
 *******************
 Patient Information
 ****************
 -->
	<!-- This is the patient for which the report is describing. -->
	<recordTarget>
		<patientRole>
		  <!--WVV Id coding system is in the downloadable resoure and SSN is the extension. Edit the extension here-->
		  <!--Can't change during the reporting period-->
			<id root="2.16.840.1.113883.4.1" extension="002386407"/>
      <!--WVV address is not required-->
			<addr>
			  <streetAddressLine>1200 Sanders Lane</streetAddressLine>
			  <city>Rockville</city>
			  <state>MD</state>
			  <postalCode>20850</postalCode>
			</addr>
			<patient>
<!-- WVV  something called use="L" found in some samples - not sure what it is or need for it -->
				<name>
				  <!-- WV Edit -->
					<given>Jody</given>
					<family>Jones</family>
				</name >

				<!--VV Gender code can be M, F  or UN for undifferentiated-->
				<administrativeGenderCode code="F" codeSystem="2.16.840.1.113883.5.1"/>
      <!--WVV  Birth Time at least to the day-->
        <birthTime value="19450101"/>
        <!--WVV Edit-->
				<!--WVV race is in there too, tab L in downloadable resources 2054-5 is Back or African American -->
				<!--WVV 2106-3 is white and there are no hispanic and a huge number of indian tribes-->
				<raceCode code="2106.3" codeSystem="2.16.840.1.113883.5.104"/>
        <!--WVVEdit  from downloadable resource tab M for Ethnicity -->
				<!--WV 2186-5 is Not Hispanic or Latino -->
				<ethnicGroupCode code="2186-5" codeSystem="2.16.840.1.113883.5.50"/>
      </patient>
      <!--WV Added to sample document and required NPI as extension and root is permanent-->
      <providerOrganization>
      <id root="2.16.840.1.113883.4.6" extension="6558574524" />
        <name>WorldVistA Test Clinic</name>
        <!--WVV address of organization which must have NPI is optional-->
        <addr>
          <streetAddressLine>123 Maple Ave</streetAddressLine>
          <city>Gaithersburg</city>
          <state>MD</state>
          <postalCode>20877</postalCode>
        </addr>
      <!--WVP required asOrganizationPartOf added to sample-->
        <asOrganizationPartOf>
          <wholeOrganization>
            <!--WVV tax ID (SS# or EIN)for the organizaton is the extension and the root is required  and WVP2.16.840.1.113883.4.2-->
            <id root="2.16.840.1.113883.4.2" extension="002345678"/>
          </wholeOrganization> 
        </asOrganizationPartOf>
      </providerOrganization>
		</patientRole>
	</recordTarget>

<!--
*****************************
Author
**************
-->
	<!-- This example assumes the doctor is creating the report and it is Required.  -->
	<author>
	  <!--WVV Edit time has to be precise at least to the day-->
		<time value="20100703" />
		<assignedAuthor>
		  <!--WVP eventually id this is required, the root is fixed -->
		  <!--andn the extension is the SOFTWARE version number assigned by CMS to WV EHR-->
			<id root="2.16.840.1.113883.3.249.6" extension="100001" />
			<!--WVVassignedPerson not required-->
			<assignedPerson>
				<name>
				  <!--WV Edit-->
					<given>Nancy</given>
					<family>Anthracite</family>
					<suffix>MD</suffix>
				</name>
			</assignedPerson>
			<representedOrganization>
			  <!--WV? id root is OID for the organization so I made one up for this document set-->
				<id root="2.16.840.1.113883.3.543" extension="1558574526" />
				<name>WorldVistA Test Clinic</name>
			</representedOrganization>
		</assignedAuthor>
	</author>
		<!-- The reporting healthcare facility is represented using the CCD "Source of Information" construct, via the Informant participant. -->
	<informant>
	   <assignedEntity>
      <!--WV this null flavor is required as is-->
			<id nullFlavor="NA"/>
			<representedOrganization>
				<!--WV root is the OID of the organization.  ID is required but name is not and id is OID stated earlier-->
        <id root="2.16.840.1.113883.3.543" extension="1558574526" />
				<name>World VistA Test Clinic</name>
			</representedOrganization>
		</assignedEntity>
	</informant>

	<!-- This example assumes that the institution responsible for the data is serving as custodian. -->
	<!--WV This element is required as is the sSD which is not stated if it is an OID but assumed it is-->
	<!--WV Name is not required, only ID is required.-->
	<custodian>
		<assignedCustodian>
			<representedCustodianOrganization>
				<id root="2.16.840.1.113883.3.543" extension="1558574526" />
				<name>WorldVistA Test Clinic</name>
			</representedCustodianOrganization>
		</assignedCustodian>
	</custodian>

	<!-- In this example, the author is also serving as legal authenticator. -->
	<!--WV section is this is not required-->
<legalAuthenticator>
		<time value="20100703" />
		<!--WV the signature code of S is required-->
		<signatureCode code="S" />
		<assignedEntity>
      <!--WV document does not specify the requirements of the id but it is required-->
      <!--WVP and the sample suggests it is the number below and extension is ???-->
			<id root="2.16.840.1.113883.3.543" extension="111111" />
			<assignedPerson>
				<name>
					<given>Nancy</given>
					<family>Anthracite</family>
					<suffix>MD</suffix>
				</name>
			</assignedPerson>
			<representedOrganization>
			  <!--WV? and is fixed for the WorldVistA Test Clinic in this submitted document series-->
				<id root="2.16.840.1.113883.3.543" extension="1558574526" />
				<name>WorldVistA Test Clinic</name>
			</representedOrganization>
		</assignedEntity>
	</legalAuthenticator>
	
	
	
	<!--Added to sample as it is new since 2008-->
	<!--WVP permanent for participant in the primary care provider participant-->
<!--WVP performer type codes are numerous but PRF is performer or the person who did it-->
	<participant typeCode="PRF">
	  <!--WVP required as is for function-->
	  <!-- WVP I believe PCP is primary care provider but not sure-->
	  <functionCode code="PCP" codeSystem="2.16.840.1.113883.5.88"/>
	  <!--WVP Associated Entity is required ti be there with this PROV-->
	  <associatedEntity classCode="PROV">
	    <!--WV? OID of the provider fixed for this series of documents-->
	    <id root="2.16.840.1.113883.3.249.6" extension="111111" />
	    <!--WV associated person is not required so presumabley the code will suffice not sure??-->
	    <associatedPerson>
	      <name>
	        <prefix>Dr.</prefix>
	        <given>Nancy</given>
	        <family>Anthracite</family>
        </name>
	    </associatedPerson>
    </associatedEntity>
	</participant>
	
	<!--The service event is the encounter that describes tehe encunter as well as the provider, location and time-->
	<!--!There can be one or more documentation elements depending on the number of encounters during the reporting period-->
	<!--WVV IMPORTANT!! The encounter codeds are recorded here-->
	<!-- They are in appendix B of the downloadable resource document-->
	<!-- Each documentation of is a single service event-->
	
<!--Occurence of Measures episode documention-->
<!--Like an encounter section only for QRDA-->
<!--Same doctor, same clinic, different date and different enconter code-->
	
	
	<!--First Visit documentationOf section-->
	
	<documentationOf>
	  <serviceEvent>
	    <!--WV serviceEvent codes from Tab B from the downloadabe resource coding system is -->
	    <!--WVF  codeSystem is 2.16.840.1.113883 -->
      <!--WV code root shall be WVP 2.16.840.1.113883.6.12 and the extension shall be the encounter code -->
      <!-- WV? like the length of visit and complexity codes for example-->
      
      <code code="99202" codeSystem="2.16.840.1.113883.6.12" codeSystemName="C4"/>
      <effectiveTime>
        <!--WV Edit-->
        <!-- This has to be precise at least to the day. Something with time would be better.  Not sure of the necessary format so did not add time-->
        <low value="20100205"/>
        <high value="20100205"/>
      </effectiveTime>
      <performer typeCode="PRF">
        <assignedEntity>
        <!-- WV? Provider NPI  Required root 2.16.840.1.113883.9.96 is ?? and the NPI is an extension for the provider-->
        <!--This is variable but may remain unchanged for this document set-->
        <id root="2.16.840.1.113883.3.543" extension="6558574524"/>
          <!--<id root="2.16.840.1.113883.3.543" extension="1457402711"/>-->
          <!--WV this element should be present and the code is probably for a General Physician for!-->
          <!--It may be the type of provider as the example as I think  2.16.840.1.113883.6.69is the NDC-->
          <!-- codeSystemName is SNOMED CT and code is an 8 digit num and display name is for a physician-->
          <!--O6120 is SPECIALIZED PHYSICIAN when I looked it up so I don't know where to look for this 8 digit number-->
         <!-- http://terminology.vetmed.vt.edu/SCT/menu.cfm to look up codes-->
         <!--59058001 is general physician ;Family Medicine specialist is 62247001-->
          <code code="62247001" codeSystem="2.16.840.1.113883.6.69" codeSystemName="SNOMED CT" displayName="Internal Medician Specialist"/>
          <addr>
            <streetAddressLine>123 Maple Ave</streetAddressLine>
            <city>Gaithersburg</city>
            <state>MD</state>
            <postalCode>20877</postalCode>
          </addr>
          <assignedPerson>
            <name>
              <given>Nancy</given>
              <family>Anthracite</family>
              <suffix>MD</suffix>
            </name>
          </assignedPerson>
        </assignedEntity>
      </performer>
    </serviceEvent>
  </documentationOf>
	
	
	<!--Second Visit documentationOf section-->
	
	<documentationOf>
	  <serviceEvent>
	    <!--WV serviceEvent codes from Tab B from the downloadabe resource coding system is -->
	    <!--WVF  codeSystem is 2.16.840.1.113883 -->
      <!--WV code root shall be WVP 2.16.840.1.113883.6.12 and the extension shall be the encounter code -->
      <!-- WV? like the length of visit and complexity codes for example-->
      
      <code code="99204" codeSystem="2.16.840.1.113883.6.12" codeSystemName="C4"/>
      <effectiveTime>
        <!--WV Edit-->
        <!-- This has to be precise at least to the day. Something with time would be better.  Not sure of the necessary format so did not add time-->
        <low value="20100703"/>
        <high value="20100703"/>
      </effectiveTime>
      <performer typeCode="PRF">
        <assignedEntity>
        <!-- WV? Provider NPI  Required root 2.16.840.1.113883.9.96 is ?? and the NPI is an extension for the provider-->
        <!--This is variable but may remain unchanged for this document set-->
        <id root="2.16.840.1.113883.3.543" extension="6558574524"/>
          <!--<id root="2.16.840.1.113883.3.543" extension="1457402711"/>-->
          <!--WV this element should be present and the code is probably for a General Physician for!-->
          <!--It may be the type of provider as the example as I think  2.16.840.1.113883.6.69is the NDC-->
          <!-- codeSystemName is SNOMED CT and code is an 8 digit num and display name is for a physician-->
          <!--O6120 is SPECIALIZED PHYSICIAN when I looked it up so I don't know where to look for this 8 digit number-->
         <!-- http://terminology.vetmed.vt.edu/SCT/menu.cfm to look up codes-->
         <!--59058001 is general physician ;Family Medicine specialist is 62247001-->
          <code code="62247001" codeSystem="2.16.840.1.113883.6.69" codeSystemName="SNOMED CT" displayName="Internal Medician Specialist"/>
          <addr>
            <streetAddressLine>123 Maple Ave</streetAddressLine>
            <city>Gaithersburg</city>
            <state>MD</state>
            <postalCode>20877</postalCode>
          </addr>
          <assignedPerson>
            <name>
              <given>Nancy</given>
              <family>Anthracite</family>
              <suffix>MD</suffix>
            </name>
          </assignedPerson>
        </assignedEntity>
      </performer>
    </serviceEvent>
  </documentationOf>
	<!-- 
********************************************************
CDA Body
********************************************************
-->
 <component>
 	<structuredBody>
  	<!-- 
	  ********************************************************
     Measure Set Section
	  ********************************************************
     -->
 	    <component>
        <section>
        <!-- WVP QRDA Category I measure-specific template ID for 2010 #1. -->
        <!--WP Next 3 lines do not change during the reporting period, for the measures section-->
          <templateId root="2.16.840.1.113883.3.249.11.12" />
          <code code="55185-3" codeSystem="2.16.840.1.113883.6.1" />
          <title>Measure set: CMS EHR Measure Set</title>
          <text>2010 Measures Set Measures</text>
          <!--
                ***************************************************
                Measure Section
                ***************************************************
                -->
           <component>
            <section>
              <!--template ID for each measure being reported-->
              <templateId root="2.16.840.1.113883.3.249.11.2" />
              <templateId root="2.16.840.1.113883.3.249.11.3" />
              <templateId root="2.16.840.1.113883.3.249.11.4" />
              <templateId root="2.16.840.1.113883.3.249.11.5" />
              <templateId root="2.16.840.1.113883.3.249.11.6" />
              <templateId root="2.16.840.1.113883.3.249.11.7" />
              <templateId root="2.16.840.1.113883.3.249.11.8" />
              <templateId root="2.16.840.1.113883.3.249.11.9" />
              <templateId root="2.16.840.1.113883.3.249.11.10" />
              <templateId root="2.16.840.1.113883.3.249.11.11" />
              <templateId root="2.16.840.1.113883.3.249.11.15" />
              <code code="55186-1" codeSystem="2.16.840.1.113883.6.1" />
              <title>Measure Section</title>
              <!--Here is where the HTML begins for the above and it is optional-->
              <text>
                <list>
                  <item>CMS Measure #1: Diabetes Mellitus: Hemoglobin A1c Poor Control in Diabetes Mellitus</item>
                  <item>CMS Measure #2: Diabetes Mellitus: Low Density Lipoprotein (LDL-C) Control in Diabetes Mellitus</item>
                  <item>CMS Measure #3: Diabetes Mellitus: High Blood Pressure Control in Diabetes Mellitus</item>
                  <item>CMS Measure #5: Heart Failure: Angiotensin-Converting Enzyme (ACE) Inhibitor or Angiotensin Receptor Blocker (ARB) Therapy for Left Ventricular Systolic Dysfunction (LVSD)</item>
                  <item>CMS Measure #7: Coronary Artery Disease (CAD): Beta-Blocker Therapy for CAD Patients with Prior Myocardial Infarction (MI)</item>
                  <item>CMS Measure #110: Preventive Care and Screening: Influenza Immunization for Patients >= 50 Years</item>
                  <item>CMS Measure #111: Preventive Care and Screening: Pneumonia Vaccination for Patients 65 Years and Older</item>
                  <item>CMS Measure #112: Preventive Care and Screening: Screening Mammography</item>
                  <item>CMS Measure #113: Preventive Care and Screening: Colorectal Cancer Screening</item>
                  <item>CMS Measure #124: Health Information Technology (HIT): Adoption/Use of Electronic Health Records (EHR)</item>
                  <item>CMS Measure eRx:Adoption/Use of Medication Electronic Prescribing Measure</item>
                </list>
              </text>
              <!--Begin listing of acts-->
             <entry typeCode="DRIV">
                <act classCode="ACT" moodCode="DEF">
                  <id root="3944fd20-865c-11df-a4ee-0800200c9a66"/>
                  <code code="PQRI-1" codeSystem="2.16.840.1.113883.3.249.12" displayName="Hemoglobin A1c Poor Control in Diabetes Mellitus"/>
                  <text>Percentage of patients 18 through 75 years with diabetes mellitus who had most recent hemoglobin A1C greater than 9.0%</text>
                  <statusCode code="completed"/>
                </act>
              </entry>
              <entry typeCode="DRIV">
                <act classCode="ACT" moodCode="DEF">
                  <id root="3944fd21-865c-11df-a4ee-0800200c9a66"/>
                  <code code="PQRI-2" codeSystem="2.16.840.1.113883.3.249.12" displayName="Low Density Lipoprotein (LDL-C) Control in Diabetes Mellitus"/>
                  <text>Percentage of patients 18 through 75 years with diabetes mellitus who had most recent LDL-C level in control (less than 100 mg./dL)</text>
                  <statusCode code="completed"/>
                </act>
              </entry>
              <entry typeCode="DRIV">
                <act classCode="ACT" moodCode="DEF">
                  <id root="3944fd22-865c-11df-a4ee-0800200c9a66"/>
                  <code code="PQRI-3" codeSystem="2.16.840.1.113883.3.249.12" displayName="Hemoglobin A1c Poor Control in Diabetes Mellitus"/>
                  <text>Percentage of patients 18 through 75 years with diabetes mellitus who had most recent blood pressure in control (less than 140/80 mmHg)</text>
                  <statusCode code="completed"/>
                </act>
              </entry>
              <entry typeCode="DRIV">
                <act classCode="ACT" moodCode="DEF">
                  <id root="3944fd23-865c-11df-a4ee-0800200c9a66"/>
                  <code code="PQRI-5" codeSystem="2.16.840.1.113883.3.249.12" displayName="Heart Failure: Angiotensin-Converting Enzyme (ACE) Inhibitor or Angiotensin Receptor Blocker (ARB) Therapy for Left Ventricular Systolic Dysfunction (LVSD)"/>
                  <text>Percentage of patients 18 years and older with a diagnosis of heart frilure and LVSD who were prescribed ACE inhibitor or ARB therapy</text>
                  <statusCode code="completed"/>
                </act>
              </entry>
              <entry typeCode="DRIV">
                <act classCode="ACT" moodCode="DEF">
                  <id root="3944fd24-865c-11df-a4ee-0800200c9a66"/>
                  <code code="PQRI-7" codeSystem="2.16.840.1.113883.3.249.12" displayName="Beta-Blocker Therapy for CAD Patients with Prior Myocardial Infarction"/>
                  <text>Percentage of patients 18 aged 18 years and older wit a diagnosis of CAD and prior MI who were prescribed beta-blocker therapy</text>
                  <statusCode code="completed"/>
                </act>
              </entry>
              <entry typeCode="DRIV">
                <act classCode="ACT" moodCode="DEF">
                  <id root="3944fd25-865c-11df-a4ee-0800200c9a66"/>
                  <code code="PQRI-110" codeSystem="2.16.840.1.113883.3.249.12" displayName="Influenza Immunization for Patients >= 50 Years"/>
                  <text>Percentage of patients aged 50 years and older who received an influenza immunization during the flu season (September through February)</text>
                  <statusCode code="completed"/>
                </act>
              </entry>
              <entry typeCode="DRIV">
                <act classCode="ACT" moodCode="DEF">
                  <id root="3944fd26-865c-11df-a4ee-0800200c9a66"/>
                  <code code="PQRI-111" codeSystem="2.16.840.1.113883.3.249.12" displayName="Pneumonia Vaccination for Patients 65 Years and Older"/>
                  <text>Percentage of patients afed 65 years and older who have ever received a pneumoccal vaccine</text>
                  <statusCode code="completed"/>
                </act>
              </entry>
              <entry typeCode="DRIV">
                <act classCode="ACT" moodCode="DEF">
                  <id root="3944fd27-865c-11df-a4ee-0800200c9a66"/>
                  <code code="PQRI-112" codeSystem="2.16.840.1.113883.3.249.12" displayName="Screening Mammography"/>
                  <text>Percentage of womaen aged 40 through 69 years who had a mammogram to screen for breast cancer within 24 months</text>
                  <statusCode code="completed"/>
                </act>
              </entry>
              <entry typeCode="DRIV">
                <act classCode="ACT" moodCode="DEF">
                  <id root="3944fd28-865c-11df-a4ee-0800200c9a66"/>
                  <code code="PQRI-113" codeSystem="2.16.840.1.113883.3.249.12" displayName="Colorectal Cancer Screening"/>
                  <text>Percentage of patients aged 50 through 80 who received the appropriate colorectal cancer screening</text>
                  <statusCode code="completed"/>
                </act>
              </entry>
              <entry typeCode="DRIV">
                <act classCode="ACT" moodCode="DEF">
                  <id root="3944fd29-865c-11df-a4ee-0800200c9a66"/>
                  <code code="PQRI-124" codeSystem="2.16.840.1.113883.3.249.12" displayName="Adoption/Use of Electronic Health Records (EHR)"/>
                  <text>Documents whether provider has adopted and is using health information technology. To qualify, the provider must havea adopted and be using a certified/qualified electronic health record (EHR)</text>
                  <statusCode code="completed"/>
                </act>
              </entry>
              <entry typeCode="DRIV">
                <act classCode="ACT" moodCode="DEF">
                  <id root="3944fd30-865c-11df-a4ee-0800200c9a66"/>
                  <code code="eRx" codeSystem="2.16.840.1.113883.3.249.12" displayName="Adoption/Use of Medication Electronic Prescribing Measure"/>
                  <text>Documents whether provider has adopted and is using ePrescribing</text>
                  <statusCode code="completed"/>
                </act>
              </entry>
                  <!--
                  *******************************
                  Reporting Parameters Section
                  *****************************
                   -->
              <component>
                  <section>
                    <code code="55187-9" codeSystem="2.16.840.1.113883.6.1"/>
                      <title>Reporting Parameters</title>
                      <text>
                        <list>
                          <item>Reporting Period Jan 1, 2010 to Dec 31, 2010</item>
                        </list>
                      </text>
                      <entry>
                        <act classCode="ACT" moodCode="EVN">
                        <code code="252116004" codeSystem="2.16.840.1.113883.6.96" displayName="Observation Parameters"/>
                        <effectiveTime>
                          <low value="20100101"/>
                          <high value="20101231"/>
                        </effectiveTime>
                      </act>
                    </entry>
                  </section>
                </component>
