TMGRPC1B ;TMG/kst-RPC Functions ;3/28/10, 7/11/10
         ;;1.0;TMG-LIB;**1**;3/28/10
 ;
 ;"TMG RPC FUNCTIONS
 ;
 ;"Copyright Kevin Toppenberg MD
 ;"Released under GNU General Public License (GPL)
 ;"
 ;"=======================================================================
 ;" RPC -- Public Functions.
 ;"=======================================================================
 ;"ENSUREALL -- Ensure all needed TMG RPC entries have been added
 ;
 ;"=======================================================================
 ;"PRIVATE API FUNCTIONS
 ;"=======================================================================
 ;"ENSURE1(RPCNAME) -- ensure 1 RPC is in OPTION record OR CPRS GUI CHART
 ;
 ;"=======================================================================
 ;"=======================================================================
 ;"Dependencies:
 ;" DIC
 ;"=======================================================================
 ;"=======================================================================
 ;
ENSUREAL
        ;"Ensure all needed TMG RPC entries have been added
L1      ;;TMG ADD PATIENT
        ;;TMG AUTOSIGN TIU DOCUMENT
        ;;TMG BARCODE DECODE
        ;;TMG BARCODE ENCODE
        ;;TMG CHANNEL
        ;;TMG CPRS GET URL LIST
        ;;TMG DOWNLOAD FILE
        ;;TMG DOWNLOAD FILE DROPBOX
        ;;TMG GET BLANK TIU DOCUMENT
        ;;TMG GET DFN
        ;;TMG GET IMAGE LONG DESCRIPTION
        ;;TMG GET PATIENT DEMOGRAPHICS
        ;;TMG INIFILE GET
        ;;TMG INIFILE SET
        ;;TMG MSGLINK CHANNEL
        ;;TMG SEARCH CHANNEL
        ;;TMG SET PATIENT DEMOGRAPHICS
        ;;TMG UPLOAD FILE
        ;;TMG UPLOAD FILE DROPBOX
        ;;TMG IMAGE DELETE
        ;;MAGGADDIMAGE
        ;;MAG3 TIU IMAGE
        ;;MAG3 CPRS TIU NOTE
        ;;<END>
        ;
        NEW TMGI
        NEW DONE SET DONE=0
        FOR TMGI=0:1 DO  QUIT:DONE
        . NEW RPC SET RPC=$PIECE($TEXT(L1+TMGI^TMGRPC1B),";;",2)
        . IF (RPC="")!(RPC="<END>") SET DONE=1 QUIT
        . DO ENSURE1(RPC)
        QUIT
        ;
ENSURE1(RPCNAME) ;
        ;"Purpose: to ensure 1 RPC is in OPTION record OR CPRS GUI CHART
        ;"         (add if needed)
        NEW DIC,X,Y,DA
        SET DIC="^DIC(19,",DIC(0)="M"
        SET X="OR CPRS GUI CHART"
        DO ^DIC
        IF +Y'>0 DO  QUIT
        . WRITE "ERROR.  Unable to find [OR CPRS GUI CHART] in file OPTION (#19)",!
        . NEW TEMP READ "Press [ENTER] to continue...",TEMP:($GET(DTIME,3600))
        . WRITE !
        SET DA(1)=+Y
        SET DIC=DIC_DA(1)_",""RPC"","
        SET DIC(0)="ML" ;"LAYGO --> add entry if not found
        SET X=RPCNAME
        DO ^DIC
        IF +Y'>0 DO
        . WRITE "ERROR.  Unable to add or find "_RPCNAME_" for subfile RPC in record",!
        . WRITE "OR CPRS GUI CHART in file OPTION (#19)",!
        . NEW TEMP READ "Press [ENTER] to continue...",TEMP:($GET(DTIME,3600))
        . WRITE !
        QUIT
        
        
