TMGNDF1E ;TMG/kst/FDA Import: Pick imports to skip ;03/25/06
         ;;1.0;TMG-LIB;**1**;01/23/07

 ;"FDA - NATIONAL DRUG FILES COMPILING FUNCTIONS
 ;"More code for determining files to skip.
 ;"Kevin Toppenberg MD
 ;"GNU General Public License (GPL) applies
 ;"1-23-07

 ;"=======================================================================
 ;" API -- Public Functions.
 ;"=======================================================================
 ;"Menu

 ;"=======================================================================
 ;" Private Functions.
 ;"=======================================================================
 ;"=======================================================================

Menu
        ;"Purpose: To give an interactive menu of tools to clean up data.

        new Menu,UsrSlct
        new i set i=0
        set Menu(i)="Pick Option for Picking Imports to SKIP (1E)",i=i+1
        set Menu(i)="Flag DUPLICATE entries to be skipped"_$char(9)_"DUPS",i=i+1
        set Menu(i)="Flag entries with MISSING STRENGTH to be skipped"_$char(9)_"RemoveStrMissing",i=i+1
        set Menu(i)="Flag entries with MISSING UNITS to be skipped"_$char(9)_"RemoveUnitMissing",i=i+1
        set Menu(i)="Flag entries with MISSING INGREDIENTS to be skipped"_$char(9)_"RemoveIngredMissing",i=i+1
        set Menu(i)="Flag entries with MISSING TRADE NAME to be skipped"_$char(9)_"RemoveTNameMissing",i=i+1
        set Menu(i)="Flag entries with MISSING GENERIC NAME to be skipped"_$char(9)_"RemoveGNameMissing",i=i+1
        set Menu(i)="Flag entries with MISSING NDC to be skipped"_$char(9)_"RemoveNDCMissing",i=i+1
        set Menu(i)="Manually PICK drugs to be skipped: Trade Name, Units, Strength"_$char(9)_"PICK",i=i+1
        set Menu(i)="Manually PICK drugs to be skipped: Trade Name, Generic Name, Strength"_$char(9)_"PICK2",i=i+1
        set Menu(i)="Manually PICK drugs to be skipped: Long Name, Trade&Form, Generic&Form"_$char(9)_"PICK3",i=i+1
        set Menu(i)="Manually PICK drugs to be UNSKIPPED: Trade Name, Units, Strength"_$char(9)_"UNPICK",i=i+1
        set Menu("P")="Prev Stage"_$char(9)_"Prev"
        set Menu("N")="Next Stage"_$char(9)_"Next"

CD1
        write #
        set UsrSlct=$$Menu^TMGUSRIF(.Menu,"^")
        if UsrSlct="^" goto CDDone
        if UsrSlct=0 set UsrSlct=""

        if UsrSlct="Prev" goto Menu^TMGNDF1D  ;"quit can occur from there...
        if UsrSlct="Next" goto Menu^TMGNDF1F  ;"quit can occur from there...

        if UsrSlct="DUPS" do RemoveDups goto CD1
        if UsrSlct="RemoveStrMissing" do RemoveStrMissing goto CD1
        if UsrSlct="RemoveUnitMissing" do RemoveUnitMissing goto CD1
        if UsrSlct="RemoveTNameMissing" do RemoveTNameMissing goto CD1
        if UsrSlct="RemoveGNameMissing" do RemoveGNameMissing goto CD1
        if UsrSlct="RemoveNDCMissing" do RemoveNDCMissing goto CD1
        if UsrSlct="RemoveIngredMissing" do RemoveIngredMissing goto CD1
        if UsrSlct="PICK" do PickSkips(,,1,1)  goto CD1
        if UsrSlct="PICK2" do PickSkp2(,)  goto CD1
        if UsrSlct="PICK3" do PickSkp3(,)  goto CD1
        if UsrSlct="UNPICK" do PickSkips(,,,,"ALL")  goto CD1
        goto CDDone
CDDone
        quit




SelectScan(ScrnCode,editStr,edtUnit)
        ;"Purpose: Set chosen records to be skipped
        ;"       This will scan for records passing screen and pre-select
        ;"       them.  Then display them to the user to allow
        ;"       the individual drugs to be de-selected if wanted.
        ;"       After finishing the review, then all the selected
        ;"       records may be set to SKIP
        ;"Input: ScrnCode -- OPTIONAL.  M Code to execute in the following format:
        ;"            set flagToSkip=$$SomeTest(IEN)
        ;"            Code may use variable IEN, which is record in 22706.9
        ;"       editStr: Optional.  Default=0.  1 if Can edit Strength field
        ;"       editUnit: Optional.  Default=0.  1 if Can edit Unit field
        ;"Output: Records may be set to be skipped if user chooses to do this.
        ;"Results: none

        new SelArray,flagToSkip
        set ScrnCode=$get(ScrnCode)

        new Itr,IEN,abort,name
        set abort=0
        write "Scanning drugs for entries to be preselected for skipping...",!
        set IEN=$$ItrInit^TMGITR(22706.9,.Itr)
        do PrepProgress^TMGITR(.Itr,20,0,"IEN")
        if IEN'="" for  do  quit:($$ItrNext^TMGITR(.Itr,.IEN)'>0)!abort
        . if $piece($get(^TMG(22706.9,IEN,1)),"^",4)'=0 quit  ;"0=KEEP; 1=SKIP
        . if $$KeyPressed^TMGUSRIF=27 set abort=27 quit
        . set flagToSkip=0
        . new $etrap set $etrap="write !,""Error trapped."",!"
        . if ScrnCode'="" xecute ScrnCode
        . if flagToSkip=1 set SelArray(IEN)=""

        new %
        if $data(SelArray)=0 do  goto:(%'=2) SScDone
        . set %=1
        . write !,"No entries found.  Done" do YN^DICN
        else  do  goto:(%=-1) SScDone
        . set %=1
        . write !,"Show ONLY preselected drugs (faster)"
        . do YN^DICN write !
        . if %=2 write !,"Now will show entries PRESELECTED in list of all drugs.",!
        do PickSkips(.SelArray,(%=1),.editStr,.editUnit)

SScDone
        quit



PickSkips(SelArray,JustSelected,editStr,edtUnit,SkipValue)
        ;"Purpose: to select records to mark as to be skipped.
        ;"Input: SelArray: Optional.  PASS BY REFERENCE.  An array of preselected IEN's
        ;"               Format:  SelArray(IEN in 22706.9)="" <-- IEN preselected
        ;"       JustSelected: Optional.  if 1, then ONLY IENs from SelArray shown.
        ;"       editStr: Optional.  Default=0.  1 if Can edit Strength field
        ;"       editUnit: Optional.  Default=0.  1 if Can edit Unit field
        ;"       SkipValue: OPTIONAL. Default=0.
        ;"              0=show only values NOT marked to be skipped
        ;"              1=show only values MARKED to be skipped
        ;"              ALL=show BOTH skip and non-skipped fields.
        ;"Output: User may alter the value of SKIP THIS RECORD field for all records
        ;"Results: none

        new Options,IEN
        set Options("FIELDS",1)=".05^TRADENAME^50"
        set Options("FIELDS",1,"NO EDIT")=1  ;"i.e. show for browsing, but don't allow edit
        set Options("FIELDS",2)="1^STRENGTH^9"
        if +$get(editStr)=0 set Options("FIELDS",2,"NO EDIT")=1  ;"i.e. show for browsing, but don't allow edit
        set Options("FIELDS",3)="2^UNIT^9"
        if +$get(editUnit)=0 set Options("FIELDS",3,"NO EDIT")=1  ;"i.e. show for browsing, but don't allow edit
        set Options("FIELDS",4)="6^SKIP THIS RECORD^4"
        set Options("FIELDS","MAX NUM")=4
        set Options("FILE")="22706.9^TMG FDA IMPORT COMPILED"

        set SkipValue=$get(SkipValue,0)
        if +$get(JustSelected)=0 do
        . ;"Get all records with chosed SKIP THIS RECORD value
        . if SkipValue=0 do
        . . new ScrnCode set ScrnCode="($get(RecValue)=1)"  ;"Field has THREE possible values: 0,1,NULL
        . . do GetFldVScreen^TMGSELED(22706.9,6,ScrnCode,$name(Options("IEN LIST")))
        . else  do
        . . do GetFldValue^TMGSELED(22706.9,6,SkipValue,$name(Options("IEN LIST")))
        else  do
        . merge Options("IEN LIST")=SelArray

PSK1    if $data(SelArray) do
        . set IEN=""
        . for  set IEN=$order(SelArray(IEN)) quit:(IEN="")  do
        . . if $data(Options("IEN LIST",IEN))>0 do
        . . . set Options("IEN LIST",IEN,"SEL")=""

        if $$SELED^TMGSELED(.Options)'=2 goto PSKDone
        if $$GetIENs^TMGSELED(.Options)=0 goto PSKDone
        goto PSK1

PSKDone quit


PickSkp2(SelArray,JustSelected,SkipValue)
        ;"Purpose: to select records to mark as to be skipped.
        ;"         Showing Tradename and Generic name
        ;"Input: SelArray: Optional.  PASS BY REFERENCE.  An array of preselected IEN's
        ;"               Format:  SelArray(IEN in 22706.9)="" <-- IEN preselected
        ;"       JustSelected: Optional.  if 1, then ONLY IENs from SelArray shown.
        ;"       SkipValue: OPTIONAL. Default=0.
        ;"              0=show only values NOT marked to be skipped
        ;"              1=show only values MARKED to be skipped
        ;"              ALL=show BOTH skip and non-skipped fields.
        ;"Output: User may alter the value of SKIP THIS RECORD field for all records
        ;"Results: none

        new Options,IEN
        set Options("FIELDS",1)=".05^TRADENAME^30"
        set Options("FIELDS",1,"NO EDIT")=1  ;"i.e. show for browsing, but don't allow edit
        set Options("FIELDS",2)=".07^GENERIC NAME^30"
        set Options("FIELDS",2,"NO EDIT")=1  ;"i.e. show for browsing, but don't allow edit
        set Options("FIELDS",3)="1^STRENGTH^9"
        set Options("FIELDS",3,"NO EDIT")=1  ;"i.e. show for browsing, but don't allow edit
        set Options("FIELDS",4)="6^SKIP THIS RECORD^4"
        set Options("FIELDS","MAX NUM")=4
        set Options("FILE")="22706.9^TMG FDA IMPORT COMPILED"

        set SkipValue=$get(SkipValue,0)
        if +$get(JustSelected)=0 do
        . ;"Get all records with chosed SKIP THIS RECORD value
        . if SkipValue=0 do
        . . new ScrnCode set ScrnCode="($get(RecValue)=1)"  ;"Field has THREE possible values: 0,1,NULL
        . . do GetFldVScreen^TMGSELED(22706.9,6,ScrnCode,$name(Options("IEN LIST")))
        . else  do
        . . do GetFldValue^TMGSELED(22706.9,6,SkipValue,$name(Options("IEN LIST")))
        else  do
        . merge Options("IEN LIST")=SelArray

PSK21   if $data(SelArray) do
        . set IEN=""
        . for  set IEN=$order(SelArray(IEN)) quit:(IEN="")  do
        . . if $data(Options("IEN LIST",IEN))>0 do
        . . . set Options("IEN LIST",IEN,"SEL")=""

        if $$SELED^TMGSELED(.Options)'=2 goto PSK2Done
        if $$GetIENs^TMGSELED(.Options)=0 goto PSK2Done
        goto PSK21

PSK2Done quit



PickSkp3(SelArray,JustSelected,SkipValue)
        ;"Purpose: to select records to mark as to be skipped.
        ;"         Showing Tradename and Generic name
        ;"Input: SelArray: Optional.  PASS BY REFERENCE.  An array of preselected IEN's
        ;"               Format:  SelArray(IEN in 22706.9)="" <-- IEN preselected
        ;"       JustSelected: Optional.  if 1, then ONLY IENs from SelArray shown.
        ;"       SkipValue: OPTIONAL. Default=0.
        ;"              0=show only values NOT marked to be skipped
        ;"              1=show only values MARKED to be skipped
        ;"              ALL=show BOTH skip and non-skipped fields.
        ;"Output: User may alter the value of SKIP THIS RECORD field for all records
        ;"Results: none

        new Options,IEN
        set Options("FIELDS",1)=".04^LONG NAME^30"
        set Options("FIELDS",1,"NO EDIT")=1  ;"i.e. show for browsing, but don't allow edit
        set Options("FIELDS",2)=".055^TRADE NAME & FORM - 40^20"
        set Options("FIELDS",2,"NO EDIT")=1  ;"i.e. show for browsing, but don't allow edit
        set Options("FIELDS",3)=".075^GENERIC NAME & FORM - 40^20"
        set Options("FIELDS",3,"NO EDIT")=1  ;"i.e. show for browsing, but don't allow edit
        set Options("FIELDS",4)="6^SKIP THIS RECORD^4"
        set Options("FIELDS","MAX NUM")=4
        set Options("FILE")="22706.9^TMG FDA IMPORT COMPILED"

        set SkipValue=$get(SkipValue,0)
        if +$get(JustSelected)=0 do
        . ;"Get all records with chosed SKIP THIS RECORD value
        . if SkipValue=0 do
        . . new ScrnCode set ScrnCode="($get(RecValue)=1)"  ;"Field has THREE possible values: 0:keep,1:skip,NULL
        . . do GetFldVScreen^TMGSELED(22706.9,6,ScrnCode,$name(Options("IEN LIST")))
        . else  do
        . . do GetFldValue^TMGSELED(22706.9,6,SkipValue,$name(Options("IEN LIST")))
        else  do
        . merge Options("IEN LIST")=SelArray

PSK31   if $data(SelArray) do
        . set IEN=""
        . for  set IEN=$order(SelArray(IEN)) quit:(IEN="")  do
        . . if $data(Options("IEN LIST",IEN))>0 do
        . . . set Options("IEN LIST",IEN,"SEL")=""

        if $$SELED^TMGSELED(.Options)'=2 goto PSK3Done
        if $$GetIENs^TMGSELED(.Options)=0 goto PSK3Done
        goto PSK31

PSK3Done quit



RemoveDups
        ;"Purpose: Set duplicate records to be skipped
        ;"       Then allow selected records to be set to SKIP

        new ref set ref=$name(^TMG("TMP","SEL SCAN"))
        kill @ref
        do SelectScan("set flagToSkip=$$DupTest(IEN)",0,0)
        kill @ref
        quit


DupTest(IEN)
        ;"Purpose: to determine if record should be selected
        ;"Returns 1 if should be flagged for skip, otherwise 0

        new result set result=0
        if $get(IEN)'="" do
        . new ref set ref=$name(^TMG("TMP","SEL SCAN"))
        . ;"if $piece($get(^TMG(22706.9,IEN,1)),"^",4)=1 set result=1 goto DTDone
        . new name set name=$$MakeName^TMGNDF2G(IEN)
        . if $data(@ref@(name))>0 set result=1
        . else  set @ref@(name)=""

DTDone  quit result


RemoveStrMissing
        ;"Purpose: Set incomplete records to be skipped
        ;"       Then allow selected records to be set to SKIP
        write "Preselect items with Strength missing...",!
        do SelectScan("set flagToSkip=$$MissStrTest(IEN)",1,1)
        quit

MissStrTest(IEN)
        ;"Purpose: to determine if record should be selected
        ;"         Will flag for skipping if missing STRENGTH
        ;"Returns 1 if should be flagged for skip, otherwise 0

        new result set result=0
        new s set s=$get(^TMG(22706.9,IEN,0))
        ;"0;2=STENGTH field
        if ($piece(s,"^",2)="") set result=1
        quit result


RemoveUnitMissing
        ;"Purpose: Set incomplete records to be skipped
        ;"       Then allow selected records to be set to SKIP
        write "Preselect items with Units missing...",!
        do SelectScan("set flagToSkip=$$MissUnitTest(IEN)",1,1)
        quit


MissUnitTest(IEN)
        ;"Purpose: to determine if record should be selected
        ;"         Will flag for skipping if missing UNITS
        ;"Returns 1 if should be flagged for skip, otherwise 0

        new result set result=0
        new s set s=$get(^TMG(22706.9,IEN,0))
        ;"0;3=UNIT field
        if ($piece(s,"^",3)="") set result=1
        quit result

RemoveTNameMissing
        ;"Purpose: Set incomplete records to be skipped
        ;"       Then allow selected records to be set to SKIP
        write "Preselect items with Tradename missing...",!
        do SelectScan("set flagToSkip=$$MissTNameTest(IEN)",1,1)
        quit


MissTNameTest(IEN)
        ;"Purpose: to determine if record should be selected
        ;"         Will flag for skipping if missing TRADENAME
        ;"Returns 1 if should be flagged for skip, otherwise 0

        new result set result=0
        new s set s=$get(^TMG(22706.9,IEN,0))
        ;"0;4=TRADENAME
        if ($piece(s,"^",4)="") set result=1
        quit result

RemoveGNameMissing
        ;"Purpose: Set incomplete records to be skipped
        ;"       Then allow selected records to be set to SKIP
        write "Preselect items with Generic Name missing...",!
        do SelectScan("set flagToSkip=$$MissGNameTest(IEN)",1,1)
        quit


MissGNameTest(IEN)
        ;"Purpose: to determine if record should be selected
        ;"         Will flag for skipping if missing GENERIC NAME
        ;"Returns 1 if should be flagged for skip, otherwise 0

        new result set result=0
        new s set s=$get(^TMG(22706.9,IEN,0))
        ;"0;6=GENERIC NAME
        if ($piece(s,"^",6)="") set result=1
        quit result

RemoveNDCMissing
        ;"Purpose: Set incomplete records to be skipped
        ;"       Then allow selected records to be set to SKIP
        write "Preselect items with NDC missing...",!
        do SelectScan("set flagToSkip=$$MissNDCTest(IEN)",1,1)
        quit


MissNDCTest(IEN)
        ;"Purpose: to determine if record should be selected
        ;"         Will flag for skipping if missing NDC
        ;"Returns 1 if should be flagged for skip, otherwise 0

        new result set result=0
        set s=$get(^TMG(22706.9,IEN,1))
        ;"1;2=NDC 12 DIGIT
        if ($piece(s,"^",2)="") set result=1
        quit result

RemoveIngredMissing
        ;"Purpose: Set incomplete records to be skipped
        ;"       Then allow selected records to be set to SKIP
        write "Preselect items with Ingredients missing...",!
        do SelectScan("set flagToSkip=$$MissIngredTest(IEN)",1,1)
        quit


MissIngredTest(IEN)
        ;"Purpose: to determine if record should be selected
        ;"         Will flag for skipping if missing NDC
        ;"Returns 1 if should be flagged for skip, otherwise 0

        new result set result=0
        ;"4th piece of 0 node is total number of records
        new numRecs
        set numRecs=+$piece($get(^TMG(22706.9,IEN,4,0)),"^",4)
        if numRecs=0 set result=1
        if numRecs=1 do
        . if +$piece($get(^TMG(22706.9,IEN,4,1,0)),"^",3)=0 set result=1
        quit result

