TMGSEQL3 ;TMG/kst/Code to interface with SequelSystems PMS ;03/25/06
         ;;1.0;TMG-LIB;**1**;09/01/05
 
 ;"TMG SEQUEL IMPORT UTILITY FUNCTIONS
 ;"Kevin Toppenberg MD
 ;"GNU General Public License (GPL) applies
 ;"1-9-2006
 
 
 ;"=======================================================================
 ;" API -- Public Functions.
 ;"=======================================================================
 ;"RPTSSNCF  ;"i.e. Report SSN Conflict
 ;"RPTDOBER  ;"i.e. Report DOB Errors
 ;"CLEARALL
 
 
 ;"FIXERRORS --OLD
 ;"FixOneError(OneLine,OneErr,OneChLog) -- OLD
 ;"tempMakeAlerts
 
 ;"=======================================================================
 ;"PRIVATE API FUNCTIONS
 ;"=======================================================================
 ;"ShowOneConflict(IEN,ErrMsg)
 ;"$$QuietClear(DUZ)
 
 
 ;"=======================================================================
 ;"DEPENDENCIES
 ;"TMGSEQL1
 ;"TMGSEQL2
 ;"TMGSTUTL
 ;"TMGGDFN
 ;"TMGDEBUG
 ;"=======================================================================
 ;"=======================================================================
 
 
 
tempMakeAlerts
        ;"Purpose: To creat alerts for all entries in file 22706
        ;"Input: none
        ;"Output: This will generate Alerts, sent to the current user (DUZ)
        ;"Result: none
 
        new i,OneLine
 
        set i=$order(^TMG(22706,0))
        if +i>0 for  do  quit:(+i'>0)
        . new ref,IEN
        . set IEN=i
        . set i=$order(^TMG(22706,i))
        . set ref="^TMG(22706,"_IEN_",2)"
        . set OneLine=$$WPToStr^TMGSTUTL(ref)
        . set Msg="Problem with upload of Sequel data"
        . do MakeErrAlert^TMGSEQL2(IEN,DUZ,Msg)
 
        quit
 
 
FIXERRORS     ;"NOTE-- this is an OLD function, not being used
        ;"Purpose: To handles errors encountered during the ASKIMPORT function
        ;"Input: none
        ;"Output: the database is modified
        ;"Results: none
 
        new index
        new Abort set Abort=0
        new NewArray,newI
        new NewErrArray,NewChgLog
        new MaxCount
        new TMGRemSex
        set TMGRemSex=$$GET1^DIQ(22711,"1,",6,"I") ;"6=PICK GENDER FROM NAME?
 
        new Ref set Ref=$name(^TMP("TMG","SEQUELIMPORT","ERRORS"))
        set MaxCount=$order(@Ref@(""),-1)
 
        set index=$order(@Ref@(""))
        if index'="" for  do  quit:(+index'>0)!(Abort)
        . new result
        . new OneErrArray,OneChLog
        . merge OneErrArray=@Ref@(index)
        . new OneLine set OneLine=$get(@Ref@(index))
        . write "(",index,"/",MaxCount,") "
        . set result=$$FixOneError^TMGSEQL2(OneLine,.OneErrArray,.OneChLog)
        . if result=-1 set Abort=1 quit
        . if result>0 do
        . . ;"merge NewChgLog(index)=OneChLog
        . . merge ^TMP("TMG","SEQUELIMPORT","CHANGES",$H,index)=OneChLog
        . else  do
        . . kill @Ref@(index)
        . . merge @Ref@(index)=OneErrArray(1)
        . set index=$order(@Ref@(index))
 
        if 1=0 do
        . set newI=$get(newI)+1
        . set NewArray(newI)=OneLine
        . if $$ProcessPt^TMGSEQL1(OneLine,.NewErrArray,.NewChgLog) do
        . . MERGE ^TMP("TMG","SEQUELIMPORT","CHANGES",$H)=NewChgLog
        . . if $data(NewErrArray) do
        . . . MERGE ^TMP("TMG","SEQUELIMPORT","ERRORS")=NewErrArray
        . . . write "Here is the info about adding that patient:",!
        . . . zwr NewErrArray(*)
        . . . write !!
        . . . kill NewErrArray
        . . ;"write "killing: ",Ref,"(",Idx,")",!
        . . kill @Ref@(Idx)
 
 
        write !,"Goodbye.",!
FEDone
        quit
 
 
FixOneError(OneLine,OneErr,OneChLog)  ;"NOTE-- this is an OLD function, not being used
        ;"Purpose: to Fix one filing error
        ;"Input: OneLine -- the original data line in CVS format.
        ;"       OneErr -- PASS BY REFERENCE
        ;"              coming in, it will pass the original error.
        ;"              passed back out, it will contain any new errors.
        ;"       OneChLog -- PASS BY REFERENCE
        ;"              This will contain messages about changes made.
        ;"       Note: uses var with global scipe: TMGRemSex
        ;"Result: 1 = error fixed
        ;"        0 = error NOT fixed
        ;"       -1 = aborted
 
        new Abort set Abort=0
        new NewArray,newI
        new NewErrArray,NewChgLog
        new result set result=0
 
        new Len set Len=$length(OneLine)
        if $extract(OneLine,Len)=$char(13) set OneLine=$extract(OneLine,1,Len-1)
 
        new Info merge Info=OneErr("INFO")
        new DIERR merge DIERR=OneErr("INFO","DIERR")
        if OneLine="" goto FOEDone
 
        new LName,FName,DOB,SID
        set LName=$piece(OneLine,",",3)
        set FName=$piece(OneLine,",",4)
        set DOB=$piece($piece(OneLine,",",17)," ",1)
        set SID=$piece(OneLine,",",5)
        write FName," ",LName," ("_DOB_"); #",SID,"): "
        new Prov set Prov=$piece(OneLine,",",14)
        new skip set skip=0
        new temp set temp=""
 
        if $$InvalPtName^TMGSEQL1(FName,LName) do  goto FOEDone
        . write !,"Skipping and deleting, because name is: ",FName," ",LName,!
        . set result=0
 
        if $$InvalidProvider^TMGSEQL1(Prov) do  goto FOEDone
        . write !,"Skipping and deleting, because provider is: ",Prov,!
        . set result=0
 
        if ($get(DIERR(1))=311)&($get(Info(0))="PATIENT NOT IN DATABASE")&($get(DIERR(1,"PARAM","FIELD"))=.02) do
        . set temp=""
        . for  do  quit:(temp'="")!(Abort=1)
        . . set skip=0
        . . if TMGRemSex=1 set temp=$$GetSex^TMGSEQL2(FName)
        . . if temp="" read "MALE/FEMALE? ?// ",temp:$get(DTIME,3600)
        . . if temp="" set temp="?"
        . . set temp=$$UP^XLFSTR(temp)
        . . if temp="?" do  quit
        . . . write "Options:",!
        . . . write "-----------------",!
        . . . write "M   Name is MALE (and remember in future).",!
        . . . write "F   Name is FEMALE (and remember in future).",!
        . . . write "D   Show the data line from the other computer (Sequel)",!
        . . . ;"write "S   Turn automatic selecting SEX based on first name: "
        . . . ;"write $select(TMGRemSex=1:"OFF",TMGRemSex=0:"ON"),!
        . . . write "x   Skip this patient.",!
        . . . write "Q   Query the database to see existing entries.",!
        . . . write "^   Abort.",!
        . . . set temp=""
        . . if temp="Q" do  quit
        . . . new DIC set DIC=2
        . . . set DIC(0)="AEQM"
        . . . do ^DIC
        . . . set temp=""
        . . if temp="S" do  quit
        . . . ;"set TMGRemSex='TMGRemSex
        . . if temp="D" do  quit
        . . . write !,OneLine,!
        . . . set temp=""
        . . if ("MALE"[temp)&(temp'="FEMALE") do  quit
        . . . write "MALE",!
        . . . set OneLine=OneLine_"^MALE"
        . . . if TMGRemSex=1 do
        . . . . new temp
        . . . . set temp=$$SetSex^TMGSEQL2(FName,"MALE")
        . . else  if "FEMALE"[temp do  quit
        . . . write "FEMALE",!
        . . . set OneLine=OneLine_"^FEMALE"
        . . . if TMGRemSex=1 do
        . . . . new temp
        . . . . set temp=$$SetSex^TMGSEQL2(FName,"FEMALE")
        . . else  if temp="^" do  quit
        . . . write "aborting..",!
        . . . set Abort=1
        . . else  do  quit
        . . . write "skip...",!
        . . . set skip=1,temp="x"
        else  do
        . write "??",!
        . write "Here is info array.  I don't know how to fix this:",!
        . zwr Info(*)
        . set temp="?"
        . for  do  quit:(temp'="")!(Abort=1)
        . . set skip=0
        . . if temp="?" do  quit
        . . . write "Options:",!
        . . . write "-----------------",!
        . . . write "D   Show the data line from the other computer (Sequel)",!
        . . . write "E   Edit data line.",!
        . . . write "x   Skip this patient.",!
        . . . write "Q   Query the database to see existing entries.",!
        . . . write "^   Abort.",!
        . . . set temp=""
        . . else  if temp="Q" do  quit
        . . . new DIC set DIC=2
        . . . set DIC(0)="AEQM"
        . . . do ^DIC
        . . . set temp=""
        . . else  if temp="S" do
        . . . set TMGRemSex='TMGRemSex
        . . else  if temp="D" do  quit
        . . . write !,OneLine,!
        . . . set temp=""
        . . else  if temp="E" do
        . . . new r,NewLine
        . . . set r=$$EditOneLine^TMGSEQL2(OneLine,NewLine)
        . . . if r=1 set OneLine=NewLine ;"NOTE: later I will save old line to keep from having to process each update cycle
        . . else  if temp="^" do  quit
        . . . write "aborting..",!
        . . . set Abort=1
        . . else  do  quit
        . . . write "skip...",!
        . . . set skip=1
        . . read !,"Enter Option: ?//",temp:$get(DTIME,3600),!
        . . if temp="" set temp="?"
        . . set temp=$$UP^XLFSTR(temp)
 
        if skip=0 do
        . kill OneErr
        . if $$ProcessPt^TMGSEQL1(OneLine,.OneErr,.OneChLog) do
        . . if $data(OneErr) do
        . . . write "Here is the info about adding that patient:",!
        . . . zwr OneErr(*)
        . . . write !!
        . . else  set result=1
 
FOEDone
        if Abort set result=-1
        quit result
 
 
 
RPTSSNCF  ;"i.e. Report SSN Conflict
        ;"Purpose: to output a report of all instances of conflicted SSNum's
 
        do RptMsg("CONFLICTING SS-NUMBERS")
        quit
 
 
RPTDOBER  ;"i.e. Report DOB Errors
        ;"Purpose: to output a report of all instances of conflicted SSNum's
 
        do RptMsg("DOB")
        quit
 
 
RptMsg(MatchMsg)  ;"i.e. Alerts with matching message
        ;"Purpose: to output a report of all instances of errors with matching message
        ;"input: MatchMsg -- A message of error to match for.
        ;"              e.g. CONFLICTING SS-NUMBERS
 
        set %ZIS("A")="Enter output printer or device (^ to abort): "
        do ^%ZIS
        if POP do  goto RpmDone
        . write !,"Error selecting output printer or device. Aborting report.",!
        use IO
 
        new IEN,count
        set count=0
        set IEN=$order(^TMG(22706,0))
        if +IEN'=0 for  do  quit:(+IEN'>0)
        . new Node0 set Node0=$get(^TMG(22706,IEN,0))
        . new SQLNum set SQLNum=$piece(Node0,"^",1)
        . new Msg set Msg=$piece(Node0,"^",2)
        . if Msg[MatchMsg do
        . . do ShowOneConflict(IEN,Msg)
        . . set count=count+1
        . set IEN=$order(^TMG(22706,IEN))
 
        write count," conflicts found."
 
        use IO(0)
        do ^%ZISC
 
RpmDone
        write !,"Goodbye.",!
        quit
 
 
 
 
ShowOneConflict(IEN,ErrMsg)
        ;"Purpose: to output one conflict
        ;"Input: IEN, the IEN from file 22706
 
        new OneLine,TMGWP,TMGMSG,PtInfo
        new sqSSNum,vSSNum
 
        new x set x=$$GET1^DIQ(22706,IEN_",",2,"","TMGWP","TMGMSG")
        if $data(TMGMSG("DIERR"))'=0 do  goto SOCDone
        . new PriorErrorFound
        . do ShowDIERR^TMGDEBUG(.TMGMSG,.PriorErrorFound)
        set OneLine=$$WPToStr^TMGSTUTL("TMGWP","")
        if $$ParseLine^TMGSEQL1(OneLine,.PtInfo)=0 do  goto SOCDone
        . write "Error parsing Alert data into patient data.",!
 
        if $get(ErrMsg)="" goto SOCDone
 
        set sqSSN=$piece(ErrMsg,"Sequel#=",2)
        set sqSSN=$piece(sqSSN," ",1)
        set vSSN=$piece(ErrMsg,"VistA#=",2)
        set vSSN=$piece(vSSN," ",1)
 
        new vFullName
        do  ;"get actual full name & DOB for VistA SSN
        . new vName,vDOB
        . new tempDFN set tempDFN=$$SSNumLookup^TMGGDFN(vSSN)
        . new TMGMSG,TMGERR,IENS
        . set IENS=+tempDFN_","
        . do GETS^DIQ(2,IENS,".01;.03","E","TMGMSG","TMGERR")
        . if $data(TMGERR("DIERR")) do
        . . new PriorErrorFound
        . . do ShowDIERR^TMGDEBUG(.TMGMSG,.PriorErrorFound)
        . set vName=$get(TMGMSG(2,IENS,.01,"E"))
        . set vDOB=$get(TMGMSG(2,IENS,.03,"E"))
        . set vFullName=vName_" ("_vDOB_")"
 
        write sqSSN," is Sequel SSN for: ",$get(PtInfo("FULL NAME2"))," phone: ",$get(PtInfo("PHONE NUM")),!
        write vSSN," is VistA SSN for:  ",$get(vFullName),!
        write !
 
SOCDone
        quit
 
 
 
CLEARALL
        ;"Purpose: Wrapper for QuietClear (which clears all entries in file 22706 and all alerts.)
        ;"Input: none, DUZ (in global scope) is used
        ;"Output: All entries in the file and all associated Alerts are deleted
        ;"Results: none
 
        new TMGLIST
        new i,count
        set count=0
 
        write !,"-==Error Deleater==-",!
        write "This will delete all error alerts related to",!
        write "importing demographics from Sequel system",!!
 
        set count=$$QuietClear(DUZ)
 
        write count," data import errors "
        if count>0 write "deleted.",!
        else  write "to delete.",!
 
        write !,"Goodbye.",!
 
        quit
 
 
QuietClear(DUZ)
        ;"Purpose: To clear all entries in file 22706 and all alerts.
        ;"Input: DUZ, the user to delete alerts for.
        ;"Output: All entries in the file and all associated Alerts are deleted
        ;"Results: count of errors deleted.
 
        new TMGLIST
        new i,count
        set count=0
 
        do USER^XQALERT("TMGLIST",DUZ)
 
        set i=$order(TMGLIST(""))
        if i'="" for  do  quit:(+i'>0)
        . new alertID,IEN,TMGDATA,line
        . set line=$get(TMGLIST(i))
        . set i=$order(TMGLIST(i))
        . set alertID=$piece(line,"^",2)
        . if $piece(alertID,";",1)'="TMGSQLIMPORT" quit
        . new XQAID
        . do GETACT^XQALERT(alertID)  ;"loads XQADATA, XQAID
        . if +XQADATA>0 do
        . . new TMGERR,result
        . . set count=count+1
        . . ;"write "Deleting from file 22706, IEN=",XQADATA,!
        . . set result=$$DelIEN^TMGDBAPI(22706,XQADATA,.TMGERR)
        . . if result=0 do ShowDIERR^TMGDEBUG(.TMGERR)
        . . else  do
        . . . ;"write $piece(line,"^",1),!!
        . . . do DELETE^XQALERT
        . ;"else  write "?? XQADATA ??",!
 
        quit count
 
 
 
Schedule(Time,Routine,Descr)
        ;"Purpose: to schedule a task at the given time, to run the specified routine
        ;"Input:  Time: The time to run the task, in FileMan or $HOROLOG format
        ;"        Routine: the routine to run.   E.g. "TEST^TMGSEQL3"
        ;"        Descr: Task description (don't include package name)
        ;"Output: Will shedule the task with TaskMan
        ;"Result: returns the task number
 
        new result
        set result=""
 
        ;"New all vars used by taskman scheduler, to ensure to use of unexpected values
        new ZTRTN,ZTDESC,ZTDTH,ZTIO,ZTUCI,ZTCPU
        new ZTPRI,ZTSAVE,ZTKIL,ZTSYNC
 
        set ZTRTN=$get(Routine)
        set ZTDESC="TMG SEQUELIMPORTER "_$get(Descr)
        set ZTDTH=$get(Time)
        set ZTIO=""
 
        do ^%ZTLOAD
 
        set result=$get(ZTSK)
 
SchDone
        quit result
 
 
SHOWTIME
        ;"Purpose: to show the last time that the import task was run
        ;"Input: none
        ;"Output: will write to screen
        ;"Result: none
 
        new time
 
        write !!,"SEQUEL BILLING SYSTEM DEMOGRAPHICS IMPORT",!
        write "Last demographics import date/time was: "
        set time=$$GET1^DIQ(22711,"1,","LAST IMPORT DATE","I")
        write $$FMTE^XLFDT(time,"P"),!
 
        new task
        set task=$$GET1^DIQ(22711,"1,","TASK FOR NEXT RUN","I")
        if +task>0 do
        . write "Next demographics import date/time is: "
        . set time=$$GET1^DIQ(14.4,task_",","Scheduled Run Time ($H)")
        . write $$HTE^XLFDT(time,"P"),!
 
        quit
 
