TMGNDF2F ;TMG/kst/FDA Import: Fix drugs with missing ingredients ;03/25/06
         ;;1.0;TMG-LIB;**1**;11/21/06
 
 ;" FDA - NATIONAL DRUG FILES COMPILING FUNCTIONS
 ;"      Further processing, after functions in TMGNDF2E
 ;"      Fixing drugs with missing ingredients (i.e. not provided by FDA database)
 ;"Kevin Toppenberg MD
 ;"GNU General Public License (GPL) applies
 ;"11-21-2006
 
 ;"=======================================================================
 ;" API -- Public Functions.
 ;"=======================================================================
 ;" //no Menu -- will launch FixMissing from Menu^TMGNDF2E
 ;"=======================================================================
 ;"FixMissing -- Fix entries in file 22706.9 that don't have any ingredients,
 ;"              either by finding similar drugs already present, and using
 ;"              their ingredients, or asking user.
 
 ;"=======================================================================
 ;" Private Functions.
 ;"=======================================================================
 ;"GetMissing(List) -- Gather list of drugs that have no ingredients
 ;"GetSuggestions(List) -- expand list such that it contains suggested ingredients
 ;"Suggest1(IEN,Array) -- find a suggested answer for one record
 ;"SgstFromVAP(IEN,vapIEN,Array) -- Return list of ingredient IENs based on IEN from VA PRODUCT
 ;"SgstByName(IEN,Array) -- find suggested ingredients of one drug, based on IEN from 22706.9
 ;"ShowList(Array,Answers,ShowBoth,ByGeneric,ShowIngred,CompactMode) -- display the list generated by GetSuggestions
 ;"HandleList(Array) -- allow user to manipulate and fix problems found
 ;"XMenuOption(Prompt,FnStr,HlpFn,EntryList,EntryS) -- carry out the various menu functions
 ;"SetSkip(Array,Answers,EntryList) -- remove entries from consideration for adding to 50.68
 ;"ShowInfo(Array,Answers,EntryList) -- allow user to explore existing entries in 22706.9 file
 ;"Lookup(Array,Answers,EntryList) -- allow user to explore existing entries in 50.68 file
 ;"FixItems(Array,Answers,EntryList) -- Fix one item
 ;"AskFix1Item(Array,IEN) -- fix one entry, with user input
 ;"Show1(Array,IEN,Answers,ShowIgd) -- display the list generated by GetSuggestions
 ;"Look2Fix(IEN,Array) -- allow user to find a match to use for fixing.
 ;"KillMatch(IEN,Array,Answers,EntryList) -- remove VA PRODUCT matches from consideration
 ;"ArrayKill(IEN,Array) -- remove entry IEN from the Array of drugs to be fixed
 ;"Fix1From(IEN,vapIEN,Array,NoVerify) -- use rec in VA PRODUCT file to fix rec in TMG FDA IMPORT COMPILED
 ;"VerifySource(vapIEN) -- show the drug name, and the drug's ingredients, and ask user to verify choice
 ;"Copy1(vapIEN,IEN) -- fill in missing answers in the record in 22706.9, from record in 50.68
 ;"ManIngredients(Array,Answers,EntryList) -- Manually Add ingredients to a list of records
 ;"AskManIngred(IEN,IngredArray) -- ask user for a list of ingredients, then add to record in 22706.9
 ;"ShowIngreds(IngredArray) -- Show list of ingredients in array
 ;"Add1Ingredients(IEN,IngredArray) -- put a list of ingredients into one (1) record in 22706.9
 
 ;"=======================================================================
 ;"=======================================================================
 
 ;"Note: The FDA database lists some drugs that do not have ingredients specified.
 ;"      Some such drugs may not be wanted, and some others might have easily
 ;"      identifiable ingredients (i.e. Lasix -->can figure out ingredient of furosemide)
 ;"      So the purpose of this module is to handle those drugs that don't have
 ;"      enough information for addition into the VistA system.
 
FixMissing
        ;"Purpose: Fix entries in file 22706.9 that don't have any ingredients,
        ;"              either by finding similar drugs already present, and using
        ;"              their ingredients, or asking user.
 
        new List,Answers
        write "Scanning TMG FDA IMPORT COMPILED file for drugs with missing information.",!
        do GetMissing(.List)
        write !
        write "Searching for potential fixes for each drug with missing information",!
        do GetSuggestions(.List)
        write !
        do HandleList(.List)
 
        ;"do ShowList(.List,.Answers,1,0)
 
        quit
 
 
GetMissing(List)
        ;"Purpose: Gather list of drugs that have no ingredients
        ;"Input: List -- PASS BY REFERENCE, an OUT PARAMETER
        ;"              format:
        ;"                      List(IEN)=TMGTradeName^TMGGeneric
        ;"                      List(IEN)=TMGTradeName^TMGGeneric
        ;"                      List("BY GENERIC",TMGGeneric,IEN)=TMGTradeName
        ;"                      List("BY TRADE",TMGTradeName,IEN)=TMGGeneric
        ;"results: none
 
        new Itr,IEN
        set IEN=$$ItrInit^TMGITR(22706.9,.Itr)
        do PrepProgress^TMGITR(.Itr,2)
        if IEN'="" for  do  quit:($$ItrNext^TMGITR(.Itr,.IEN)'>0)
        . if $piece($get(^TMG(22706.9,IEN,1)),"^",4)=1 quit  ;" 1;4=SKIP THIS RECORD
        . if +$piece($get(@Itr@(IEN,4,0)),"^",4)=0 do   ;"4;0 -> header of INGREDIENTS subfile, part 4=rec count
        . . new TMGTradeName set TMGTradeName=$$GET1^DIQ(22706.9,IEN,.05)
        . . set TMGTradeName=$translate(TMGTradeName,"""","'")
        . . if TMGTradeName="" set TMGTradeName="?"
        . . new TMGGeneric set TMGGeneric=$$GET1^DIQ(22706.9,IEN,.07)
        . . set TMGGeneric=$translate(TMGGeneric,"""","'")
        . . if TMGGeneric="" set TMGGeneric="?"
        . . set List(IEN)=TMGTradeName_"^"_TMGGeneric
        . . if TMGGeneric'="?" set List("BY GENERIC",TMGGeneric,IEN)=TMGTradeName
        . . set List("BY TRADE",TMGTradeName,IEN)=TMGGeneric
 
        quit
 
 
GetSuggestions(List)
        ;"Purpose: expand list such that it contains suggested ingredients
        ;"Input: List -- PASS BY REFERENCE,
        ;"                      List(IEN)=TMGTradeName^VAGeneric
        ;"                      List(IEN)=TMGTradeName^VAGeneric
        ;"                      List("BY GENERIC",TMGGeneric,IEN)=TMGTradeName
        ;"                      List("BY TRADE",TMGTradeName,IEN)=TMGGeneric
        ;"Output: List is filled in, as follows:
        ;"                      List(IEN,"POSS IGD MATCH",igdIEN)=IngredientName
        ;"                      List(IEN,"POSS IGD MATCH"igdIEN)=IngredientName
        ;"                      List(IEN,"POSS RX MATCH",RxIEN)=vapEntryName
        ;"                      List(IEN,"POSS RX MATCH",RxIEN)=vapEntryName
        ;"                      List(IEN)=TMGTradeName^VAGeneric
        ;"                      List(IEN)=TMGTradeName^VAGeneric
        ;"                      List("BY GENERIC",TMGGeneric,IEN)=TMGTradeName
        ;"                      List("BY TRADE",TMGTradeName,IEN)=TMGGeneric
 
        new IEN,Itr
        set IEN=$$ItrAInit^TMGITR("List",.Itr)
        do PrepProgress^TMGITR(.Itr,10)
        if IEN'="" for  do  quit:($$ItrANext^TMGITR(.Itr,.IEN)'>0)
        . do Suggest1(IEN,.List)
 
        quit
 
 
Suggest1(IEN,Array)
        ;"Purpose: To find a suggested answer for one record
        ;"Input: IEN -- the IEN in file 22706.9 to find answer for
        ;"       Array -- PASS BY REFERENCE, an OUT PARAMETER.  FORMAT:
        ;"                      Array(IEN)=TMGTradeName^VAGeneric
        ;"                      Array(IEN)=TMGTradeName^VAGeneric
        ;"Output: Array is returned
        ;"              Note: RxIEN is IEN in file 50.416
        ;"                      Array(IEN)=TMGTradeName^VAGeneric
        ;"                      Array(IEN)=TMGTradeName^VAGeneric
        ;"                      List(IEN,"POSS IGD MATCH",igdIEN)=IngredientName
        ;"                      List(IEN,"POSS IGD MATCH"igdIEN)=IngredientName
        ;"                      List(IEN,"POSS RX MATCH",RxIEN)=vapEntryName
        ;"                      List(IEN,"POSS RX MATCH",RxIEN)=vapEntryName
        ;"Results: none
 
        new Itr,RxIEN,vapIEN
        set vapIEN=$$ItrFInit^TMGITR(22706.914,.Itr,.RxIEN,.01,IEN,"I")
        if vapIEN'="" for  do  quit:($$ItrFNext^TMGITR(.Itr,.RxIEN,.vapIEN)'>0)
        . do SgstFromVAP(IEN,vapIEN,.Array)
 
        kill Itr
        set RxIEN=$$ItrFInit^TMGITR(22706.915,.Itr,.RxIEN,.01,IEN,"I")
        if RxIEN'="" for  do  quit:($$ItrFNext^TMGITR(.Itr,.RxIEN,.vapIEN)'>0)
        . do SgstFromVAP(IEN,RxIEN,.Array)
 
        do SgstByName(IEN,.Array)
 
        quit
 
 
SgstFromVAP(IEN,vapIEN,Array)
        ;"Purpose: Return list of ingredient IENs based on IEN from VA PRODUCT
        ;"Input: IEN -- the IEN in file 22706.9
        ;"       vapIEN -- an IEN to file 50.68 (VA PRODUCT)
        ;"       Array -- PASS BY REFERENCE, an OUT PARAMETER.  format:
        ;"              Note: RxIEN is IEN in file 50.416
        ;"              Array(IEN)=TMGTradeName^TMGGeneric
        ;"Output: Array is filled with data, if found
        ;"              Note: RxIEN is IEN in file 50.416
        ;"              Array(IEN)=TMGTradeName^TMGGeneric
        ;"              Array(IEN)=TMGTradeName^TMGGeneric
        ;"              Array(IEN,"POSS IGD MATCH",igdIEN)=IngredientName
        ;"              Array(IEN,"POSS IGD MATCH"igdIEN)=IngredientName
        ;"              Array(IEN,"POSS RX MATCH",RxIEN)=vapEntryName
        ;"              Array(IEN,"POSS RX MATCH",RxIEN)=vapEntryName
        ;"Results: none.
 
        new Itr,igdIEN,IEN2
        set igdIEN=$$ItrFInit^TMGITR(50.6814,.Itr,.IEN2,.01,vapIEN,"I")
        if igdIEN'="" for  do  quit:($$ItrFNext^TMGITR(.Itr,.IEN2,.igdIEN)'>0)
        . if igdIEN'=0 do
        . . new IENS set IENS=igdIEN_","_IEN_","
        . . new IngredName set IngredName=$$GET1^DIQ(50.416,IENS,.01)
        . . set Array(IEN,"POSS IGD MATCH",igdIEN)=IngredName
 
        quit
 
 
SgstByName(IEN,Array)
        ;"Purpose: to find suggested ingredients of one drug, based on IEN from 22706.9
        ;"Input: IEN -- IEN from 22706.9
        ;"       Array -- PASS BY REFERENCE, an OUT PARAMETER.  format:
        ;"              Note: RxIEN is IEN in file 50.416
        ;"              Array(IEN)=TMGTradeName^TMGGeneric
        ;"Output: Array is filled with data, if found
        ;"              Note: RxIEN is IEN in file 50.416
        ;"              Array(IEN)=TMGTradeName^TMGGeneric
        ;"              Array(IEN)=TMGTradeName^TMGGeneric
        ;"              Array(IEN,"POSS IGD MATCH",igdIEN)=IngredientName
        ;"              Array(IEN,"POSS IGD MATCH"igdIEN)=IngredientName
        ;"              Array(IEN,"POSS RX MATCH",RxIEN)=vapEntryName
        ;"              Array(IEN,"POSS RX MATCH",RxIEN)=vapEntryName
        ;"Results: none.
 
        new TMGTradeName,TMGFDA,TMGMSG,PriorErrorFound
        set TMGTradeName=$piece($get(Array(IEN)),"^",1)
        if (TMGTradeName="")!(TMGTradeName="?") goto SBNDone
        new Value set Value=$piece(TMGTradeName," ",1)
        do FIND^DIC(50.68,,.01,"M",Value,"*",,,,"TMGFDA","TMGMSG")
        if $data(TMGMSG("DIERR"))'=0 do  goto SBNDone
        . do ShowDIERR^TMGDEBUG(.TMGMSG,.PriorErrorFound)
 
        ;"Now gather ingredient list from results found
        new i,vapIEN
        for i=1:1:$piece($get(TMGFDA("DILIST",0)),"^",1) do
        . set vapIEN=+$get(TMGFDA("DILIST",2,i))
        . new vapName set vapName=$$GET1^DIQ(50.68,vapIEN,.01)
        . set Array(IEN,"POSS RX MATCH",vapIEN)=vapName
        . do SgstFromVAP(IEN,vapIEN,.Array)
 
SBNDone
        quit
 
 ;"=======================================================================
 
ShowList(Array,Answers,ShowBoth,ByGeneric,ShowIngred,CompactMode)
        ;"Purpose: To display the list generated by GetSuggestions
        ;"Input: Array -- PASS BY REFERENCE.  Array with data.  Format:
        ;"                      note IEN is from 22706.9
        ;"                      Array(IEN)=TMGTradeName^TMGGeneric
        ;"                      Array(IEN)=TMGTradeName^TMGGeneric
        ;"                      Array("BY GENERIC",TMGGeneric,IEN)=TMGTradeName
        ;"                      Array("BY TRADE",TMGTradeName,IEN)=TMGGeneric
        ;"                      Array(IEN,"POSS IGD MATCH",igdIEN)=IngredientName
        ;"                      Array(IEN,"POSS IGD MATCH"igdIEN)=IngredientName
        ;"                      Array(IEN,"POSS RX MATCH",RxIEN)=vapEntryName
        ;"                      Array(IEN,"POSS RX MATCH",RxIEN)=vapEntryName
        ;"       Answers -- PASS BY REFERENCE, and OUT PARAMETER
        ;"              An array that will link display numbers with IENs
        ;"                      Answer(count)=IEN^TMGTradeName^TMGGeneric
        ;"                      Answer(count)=IEN^TMGTradeName^TMGGeneric
        ;"       ShowBoth -- OPTIONAL, if value=1, thenTMGGeneric & TMGTrade names will both be shown. Default=0
        ;"       ByGeneric -- OPTIONAL, if value=1, then list is shown sorted by Generic Name. Default=0
        ;"       ShowIngred -- OPTIONAL, if value=1 then all possible ingredients are shown. Default=0
        ;"       CompactMode -- OPTIONAL, if value=1 then only 20 entries are shown.
        ;"Output: List is shown, and the Answers array is established and passed back.
        ;"Results: none.
 
        new someShown set someShown=0
        new count
        set count=1
        kill Answers
        set ShowBoth=$get(ShowBoth,0)
        set ByGeneric=$get(ByGeneric,0)
        set ShowIngred=$get(ShowIngred,0)
        set CompactMode=$get(CompactMode,0)
        new NodeName set NodeName="BY TRADE"
        if ByGeneric=1 set NodeName="BY GENERIC"
        new ShortLen set ShortLen=25
 
        write NodeName,!
 
        new done set done=0
        new Itr,RxName,OtherName,IEN
        set RxName=$$ItrAInit^TMGITR("Array("""_NodeName_""")",.Itr)
        if RxName'="" for  do  quit:($$ItrANext^TMGITR(.Itr,.RxName)="")!(done=1)
        . new Itr2
        . set IEN=$$ItrAInit^TMGITR("Array("""_NodeName_""","""_RxName_""")",.Itr2)
        . if IEN'="" for  do  quit:($$ItrANext^TMGITR(.Itr2,.IEN)'>0)!(done=1)
        . . set OtherName=$get(Array(NodeName,RxName,IEN))
        . . set Answers(count)=IEN
        . . if (CompactMode=0)!(count'>ShortLen) do
        . . . new NumMatches set NumMatches=$$ListCt^TMGMISC("Array("""_IEN_""",""POSS RX MATCH"")")
        . . . write count,".    ",RxName
        . . . if (ShowBoth)&(OtherName'="?") write " (",OtherName,")"
        . . . write " (",NumMatches," possible matches)",!
        . . set someShown=1
        . . set count=count+1
        . . if (CompactMode=1)&(count>ShortLen) quit
        . . new Itr3,IngredIEN set IngredIEN=""
        . . if ShowIngred=0 quit
        . . set IngredIEN=$$ItrAInit^TMGITR("Array("""_IEN_""",""POSS IGD MATCH"")",.Itr3)
        . . if IngredIEN'="" for  do  quit:($$ItrANext^TMGITR(.Itr3,.IngredIEN)="")
        . . . new IngredName set IngredName=$get(Array(IEN,"POSS IGD MATCH",IngredIEN))
        . . . if IngredName'="" write "           -- ",IngredName,!
        if (CompactMode=1)&(count>ShortLen) do
        . write "... ",(count-ShortLen-1)," other items truncated.",!
 
SL2     if 'someShown write "  --- (List is Empty) ---",!
 
SLDone  quit
 
 
HandleList(Array)
        ;"Purpose: to allow user to manipulate and fix problems found
        ;"Input: Array -- PASS BY REFERENCE.  The list as created by GetSuggestions()
        ;"                      note IEN is from 22706.9
        ;"                      Array(IEN)=TMGTradeName^TMGGeneric
        ;"                      Array(IEN)=TMGTradeName^TMGGeneric
        ;"                      Array("BY GENERIC",TMGGeneric,IEN)=TMGTradeName
        ;"                      Array("BY TRADE",TMGTradeName,IEN)=TMGGeneric
        ;"                      Array(IEN,"POSS IGD MATCH",igdIEN)=IngredientName
        ;"                      Array(IEN,"POSS IGD MATCH"igdIEN)=IngredientName
        ;"                      Array(IEN,"POSS RX MATCH",RxIEN)=vapEntryName
        ;"                      Array(IEN,"POSS RX MATCH",RxIEN)=vapEntryName
 
        new done set done=0
        new input set input="R"
        new Answers
        new CompactMode set CompactMode=1 ;" (list display mode: 1=compact,  0=verbose)
        new ShowBoth set ShowBoth=0
        new ShowIngred set ShowIngred=0
        new ByGeneric set ByGeneric=0
        new EntryList,EntryS,Fn,Cancelled
        new CompactMode set CompactMode=1
        set Cancelled=0
 
        for  do  quit:(done=1)
        . if input="R" do
        . . write !!
        . . write "--------------------------------------------------",!
        . . write "Specify which drugs to FIX",!
        . . write "--------------------------------------------------",!
        . . do ShowList(.Array,.Answers,ShowBoth,ByGeneric,ShowIngred,CompactMode)
        . . write "--------------------------------------------------",!
        . . write "Specify which drugs to FIX",!
        . . write "--------------------------------------------------",!
        . . write "  R to refresh, L lookup X remove from list, N iNfo",!
        . . write "  M to Manually add Ingredients",!
        . . write "  C turn Compact display ",$select((CompactMode=1):"OFF",1:"ON")
        . . write "  I turn Show Ingredients display ",$select((ShowIngred=1):"OFF",1:"ON"),!
        . . if $get(EntryS)'="" write " Current SET #'s: ",EntryS,",  D to delete SET",!
        . . write "  # or #-# or #,#-#,# etc.,  ^ done, ",!
        . write "Enter number(s) to Fix (or codes listed above): ^//"
        . read input:$get(DTIME,3600),!
        . if input="" set input="^"
        . set input=$$UP^XLFSTR(input)
        . if input="^" set done=1 quit
        . if input="R" quit
        . else  if input="I" do  quit
        . . set ShowIngred='ShowIngred
        . . set input="R"
        . else  if input="C" do  quit
        . . set CompactMode='CompactMode
        . . set input="R"
        . else  if input="M" do  quit;"<----- Manual add Ingredients
        . . set Fn="do ManIngredients(.Array,.Answers,.EntryList)"
        . . do XMenuOption("MANUALLY add INGREDIENTS to",Fn,"",.EntryList,.EntryS)
        . . set input="R"
        . else  if input="D" do  quit;"---- delete set
        . . kill EntryList,EntryS
        . . set input="R"
        . else  if input="L" do  quit;"<----- Do Lookup
        . . set input=1  ;"a dummy entry, not needed.
        . . set Fn="do Lookup(.Array,.Answers,.EntryList)"
        . . do XMenuOption("",Fn,"",.EntryList,.EntryS)
        . else  if input="N" do  quit;"<----- Show Info
        . . set Fn="do ShowInfo(.Array,.Answers,.EntryList)"
        . . do XMenuOption("show INFO about",Fn,"",.EntryList,.EntryS)
        . else  if input="X" do  quit;"<----- Set Skip
        . . set Fn="do SetSkip(.Array,.Answers,.EntryList)"
        . . do XMenuOption("specify NOT to ADD",Fn,"",.EntryList,.EntryS)
        . . set input="R"
        . else  do  ;"default is ACCEPT
        . . set Cancelled=0
        . . set Fn="do FixItems(.Array,.Answers,.EntryList)"
        . . do XMenuOption("",Fn,"",.EntryList,.EntryS)
        . . set input="R"
 
        quit
 
 
XMenuOption(Prompt,FnStr,HlpFn,EntryList,EntryS)
        ;"Purpose: To carry out the various menu functions
        ;"Input:  Prompt: the message to use to prompt user to enter numbers etc.
        ;"                "Enter the Number(s) to" will be automatically provided
        ;"                and ": (? help) ^// " will be added at end
        ;"        FnStr: -- code to execute, e.g. "do DoLookup(.Array,.Answers,.Classes,.EntryList)"
        ;"        HlpFn: e.g. FindHelp, SimHelp, LookupHelp,  etc  Don't add () to name
        ;"        EntryList -- PASS BY REFERENCE
        ;"        EntryS -- PASS BY REFERENCE.  a string showing current set as a string
        ;"Note: makes use of global scope of 'input', and 'CompactMode', 'Cancelled'
        ;"Result: none.
 
        if $get(EntryS)="" do  quit:(valid=0)
        . if Prompt'="" do
XMO1    . . write "Enter the Number(s) to ",Prompt,": (? help) ^// "
        . . read input,!
        . . if (input="?") do  goto XMO1
        . . . if Hlpfn="" write "(Sorry, no help available)",! quit
        . . . new Code set Code="do "_HlpFn_"()"
        . . . Xecute code
        . set valid=$$MkMultList^TMGMISC(input,.EntryList)
        . if valid set EntryS=input
        Xecute FnStr
        if $get(CompactMode)=1 set input="R"
        if $get(Cancelled)=0 kill EntryList,EntryS
 
        quit
 
 
SetSkip(Array,Answers,EntryList)
        ;"Purpose: To remove entries from consideration for adding to 50.68
        ;"Input: Array -- PASS BY REFERENCE.  Array with data.  Format same as for HandleList
        ;"       Answers -- PASS BY REFERENCE
        ;"                      An array that will link display numbers with IENs
        ;"                      Answers(count)=IEN^TMGTradeName^TMGGeneric
        ;"                      Answers(count)=IEN^TMGTradeName^TMGGeneric
        ;"       EntryList -- PASS BY REFERENCE -- an array of entries (user input values) to process.
        ;"                      Format as follows.
        ;"                      EntryList(Entry number)=""  (same as count above)
        ;"                      EntryList(Entry number)=""
        ;"Results: none
 
        new Itr,Count,IEN
        set Count=$$ItrAInit^TMGITR("EntryList",.Itr)
        if Count>0 for  do  quit:($$ItrANext^TMGITR(.Itr,.Count)'>0)
        . set IEN=$piece($get(Answers(Count)),"^",1)
        . if IEN="" quit
        . new TMGTradeName,TMGGeneric
        . set TMGTradeName=$piece($get(Array(IEN)),"^",1)
        . set TMGGeneric=$piece($get(Array(IEN)),"^",2)
        . ;"I could put in some undo code here...
        . set $piece(^TMG(22706.9,IEN,1),"^",4)=1   ;"set skipflag to true
        . ;"Now delete data from display data
        . kill Array(IEN)
        . if (TMGGeneric'="") kill Array("BY GENERIC",TMGGeneric,IEN)
        . if (TMGTradeName'="") kill Array("BY TRADE",TMGTradeName,IEN)
 
        quit
 
 
ShowInfo(Array,Answers,EntryList)
        ;"Purpose: To allow user to explore existing entries in 22706.9 file
        ;"Input: Array -- PASS BY REFERENCE.  Array with data.  Format same as for HandleList
        ;"       Answers -- PASS BY REFERENCE,
        ;"              An array that will link display numbers with IENs
        ;"                      Answer(count)=IEN
        ;"       EntryList -- PASS BY REFERENCE -- an array of entries (user input values) to process.
        ;"                      Format as follows.
        ;"                      EntryList(Entry number)=""  (same as count above)
 
        new Itr,Count,IEN
        set Count=$$ItrAInit^TMGITR("EntryList",.Itr)
        if Count>0 for  do  quit:($$ItrANext^TMGITR(.Itr,.Count)'>0)
        . set IEN=$piece($get(Answers(Count)),"^",1)
        . do DumpRec2^TMGDEBUG(22706.9,IEN,0)
        . do PressToCont^TMGUSRIF
 
        quit
 
 
Lookup(Array,Answers,EntryList)
        ;"Purpose: To allow user to explore existing entries in 50.68 file
        ;"Input: Array -- PASS BY REFERENCE.  Array with data.  Format same as for HandleList
        ;"       Answers -- PASS BY REFERENCE,
        ;"              An array that will link display numbers with IENs
        ;"                      Answer(count)=IEN
        ;"       EntryList -- PASS BY REFERENCE -- an array of entries (user input values) to process.
        ;"                      Format as follows.
        ;"                      EntryList(Entry number)=""  (same as count above)
 
        new DIC,Y
        set DIC=50.68
        set DIC(0)="MAEQ"
        do ^DIC write !
        if +Y>0 do
        . do DumpRec2^TMGDEBUG(50.68,+Y,0)
        . do PressToCont^TMGUSRIF
 
        quit
 
FixItems(Array,Answers,EntryList)
        ;"Purpose: To Fix one item
        ;"Input: Array -- PASS BY REFERENCE.  Array with data.  Format same as for HandleList
        ;"       Answers -- PASS BY REFERENCE
        ;"                      An array that will link display numbers with IENs
        ;"                      Answers(count)=IEN^TMGTradeName^TMGGeneric
        ;"                      Answers(count)=IEN^TMGTradeName^TMGGeneric
        ;"       EntryList -- PASS BY REFERENCE -- an array of entries (user input values) to process.
        ;"                      Format as follows.
        ;"                      EntryList(Entry number)=""  (same as count above)
        ;"                      EntryList(Entry number)=""
        ;"Results: none
 
        new Itr,Count,IEN
        new done set done=0
        new vapIEN set vapIEN=0  ;"for first cycle, no ready answer available.
 
        set Count=$$ItrAInit^TMGITR("EntryList",.Itr)
        if Count>0 for  do  quit:($$ItrANext^TMGITR(.Itr,.Count)'>0)!(done=1)
        . set IEN=$piece($get(Answers(Count)),"^",1)
        . if vapIEN'=0 do  ;"If we've already fixed on, use same answer for rest of list
        . . if $$Fix1From(IEN,vapIEN,.Array,1)=0 set done=1
        . else  do
        . . set vapIEN=$$AskFix1Item(.Array,IEN)
        . . if vapIEN=0 set done=1
        . if done=1 quit
        . do ArrayKill(IEN,.Array)  ;"delete data from display data
 
        quit
 
 
AskFix1Item(Array,IEN)
        ;"Purpose: to fix one entry, with user input
        ;"Input: Array -- PASS BY REFERENCE.  Array with data.  Format same as for HandleList
        ;"       IEN -- the Record to fix.
        ;"Results: 1 if item Fixed, 0 if not
 
        ;"First, ask if the drug is similar enough that a copy of that other drug
        ;"      is allowed
        ;"Next, (if above fails), ask for matching of possible ingredients
        ;"If no ingredient found, even consider adding a new ingredient to INGREDIENT file
 
        new done set done=0
        new input set input="R"
        new Answers,Fn
        new CompactMode set CompactMode=1 ;" (list display mode: 1=compact,  0=verbose)
        new ShowBoth set ShowBoth=0
        new ShowIngred set ShowIngred=0
        new ByGeneric set ByGeneric=0
        new EntryList,EntryS,Fn,Cancelled
        new FixedWithIEN set FixedWithIEN=0
 
        for  do  quit:(done=1)
        . if input="R" do
        . . write !!
        . . write "--------------------------------------------------",!
        . . write "Specify CLOSEST MATCH (IGNORE DOSE & FORM)",!
        . . do Show1(.Array,IEN,.Answers,0)
        . . if $$ListCt^TMGMISC("Answers")>20 do
        . . . write "--------------------------------------------------",!
        . . . write "Specify CLOSEST MATCH (IGNORE DOSE & FORM)",!
        . . write "--------------------------------------------------",!
        . . write "  R to refresh, F to find Match",!
        . . write "  X to remove from list",!
        . . if $get(EntryS)'="" write " Current SET #'s: ",EntryS,",  D to delete SET",!
        . . write "  ^ if done, ",!
        . write "Enter number to ACCEPT (or codes listed above): ^//"
        . read input:$get(DTIME,3600),!
        . if input="" set input="^"
        . set input=$$UP^XLFSTR(input)
        . if input="^" set done=1 quit
        . if input="R" quit
        . else  if input="D" do  quit;"---- delete set
        . . kill EntryList,EntryS
        . . set input="R"
        . else  if input="F" do  quit;"<----- Look for answer
        . . set FixedWithIEN=$$Look2Fix(IEN,.Array)
        . . if FixedWithIEN'=0 set done=1
        . . else  set input="R"
        . else  if input="X" do  quit;"<----- Set Skip
        . . set Fn="do KillMatch(IEN,.Array,.Answers,.EntryList)"
        . . do XMenuOption("specify match NOT to USE",Fn,"",.EntryList,.EntryS)
        . else  do  ;"default is ACCEPT
        . . if (input["-")!(input[",") write "ENTER ONLY *ONE* ENTRY NUMBER",! quit
        . . new vapIEN set vapIEN=+$get(Answers(+input))
        . . if vapIEN>0 set FixedWithIEN=$$Fix1From(IEN,vapIEN,.Array)
        . . if FixedWithIEN'=0 set done=1
        . . else  set input="R"
 
        quit FixedWithIEN
 
 
Show1(Array,IEN,Answers,ShowIgd)
        ;"Purpose: To display the list generated by GetSuggestions
        ;"Input: Array -- PASS BY REFERENCE.  Array with data.  Format same as for HandleList
        ;"       IEN -- the One entry to display
        ;"       Answers -- PASS BY REFERENCE, and OUT PARAMETER
        ;"              An array that will link display numbers with IENs
        ;"                      Answer(count)=IEN
        ;"                      Answer(count)=IEN
        ;"       ShowIgd -- OPTIONAL, if value=1 then ingredients will be shown, otherwise
        ;"                      matches in VA PRODUCT FILE are shown.
        ;"Output: List is shown, and the Answers array is established and passed back.
        ;"Results: none.
 
        new someShown set someShown=0
        new count set count=1
        kill Answers
        new NodeName set NodeName="POSS RX MATCH"
        if $get(ShowIgd)=1 set NodeName="POSS IGD MATCH"
 
        new Itr,subIEN
        new TMGTradeName,TMGGeneric
 
        set TMGTradeName=$piece($get(Array(IEN)),"^",1)
        set TMGGeneric=$piece($get(Array(IEN)),"^",2)
        write "  For: ",TMGTradeName
        if (TMGGeneric'="?")&(TMGGeneric'="") write " (",TMGGeneric,")"
        write !
        write "--------------------------------------------------",!
 
        if $get(IEN)="" goto S1Done
 
        set subIEN=$$ItrAInit^TMGITR("Array("_IEN_","""_NodeName_""")",.Itr)
        if subIEN'="" for  do  quit:($$ItrANext^TMGITR(.Itr,.subIEN)="")
        . set Answers(count)=subIEN
        . new Name set Name=$get(Array(IEN,NodeName,subIEN))
        . write count,".    ",Name,!
        . set count=count+1
        . set someShown=1
 
S1Done
        if 'someShown write "  --- (List is Empty) ---",!
        quit
 
 
Look2Fix(IEN,Array)
        ;"Purpose: To allow user to find a match to use for fixing.
        ;"Input: IEN -- the IEN to fix
        ;"       Array -- PASS BY REFERENCE.  Array with data.  Format same as for HandleList
        ;"Result: 0 if no fix, or vapIEN (IEN in 50.68) otherwise
 
        new result set result=0 ;"default to failure
 
        write "SEARCH for a drug that can be used to fix incomplete entry.",!
        new DIC,Y
        set DIC=50.68
        set DIC(0)="MAEQ"
        do ^DIC write !
        if +Y>0 do
        . if $$Fix1From(IEN,+Y,.Array)=1 set result=+Y
 
        quit result
 
 
KillMatch(IEN,Array,Answers,EntryList)
        ;"Purpose: To remove VA PRODUCT matches from consideration
        ;"Input: IEN -- the IEN in 22706.9,
        ;"       Array -- PASS BY REFERENCE.  Array with data.  Format same as for HandleList
        ;"       Answers -- PASS BY REFERENCE,
        ;"              An array that will link display numbers with IENs
        ;"                      Answer(count)=IEN
        ;"       EntryList -- PASS BY REFERENCE -- an array of entries (user input values) to process.
        ;"                      Format as follows.
        ;"                      EntryList(Entry number)=""  (same as count above)
 
        new Itr,Count,subIEN
        set Count=$$ItrAInit^TMGITR("EntryList",.Itr)
        if Count>0 for  do  quit:($$ItrANext^TMGITR(.Itr,.Count)'>0)
        . set subIEN=$piece($get(Answers(Count)),"^",1)
        . new TMGTradeName,TMGGeneric
        . set TMGTradeName=$piece($get(Array(IEN)),"^",1)
        . set TMGGeneric=$piece($get(Array(IEN)),"^",2)
        . ;"I could put in some undo code here...
        . ;"Now delete data from display data
        . ;"kill Array(IEN,"POSS RX MATCH",subIEN)
        . do ArrayKill(IEN,.Array)
        quit
 
 
ArrayKill(IEN,Array)
        ;"Purpose: to remove entry IEN from the Array of drugs to be fixed
        ;"Input: IEN -- the IEN to remove
        ;"       Array -- the array with the drug info.  Format as follows:
        ;"                      Array(IEN)=TMGTradeName^TMGGeneric
        ;"                      Array(IEN)=TMGTradeName^TMGGeneric
        ;"                      Array("BY GENERIC",TMGGeneric,IEN)=TMGTradeName
        ;"                      Array("BY TRADE",TMGTradeName,IEN)=TMGGeneric
        ;"                      Array(IEN,"POSS IGD MATCH",igdIEN)=IngredientName
        ;"                      Array(IEN,"POSS IGD MATCH"igdIEN)=IngredientName
        ;"                      Array(IEN,"POSS RX MATCH",RxIEN)=vapEntryName
        ;"                      Array(IEN,"POSS RX MATCH",RxIEN)=vapEntryName
 
        new TMGTradeName,TMGGeneric
        set TMGTradeName=$piece($get(Array(IEN)),"^",1)
        set TMGGeneric=$piece($get(Array(IEN)),"^",2)
        if TMGTradeName="" set TMGTradeName="?"
        if TMGGeneric="" set TMGGeneric="?"
        kill Array(IEN)
        kill Array("BY TRADE",TMGTradeName,IEN)
        kill Array("BY GENERIC",TMGGeneric,IEN)
 
        quit
 
 
Fix1From(IEN,vapIEN,Array,NoVerify)
        ;"Purpose: To take a record in VA PRODUCT file (50.68) and use this to fix record in
        ;"              TMG FDA IMPORT COMPILED (22706.9)
        ;"Input: IEN -- the IEN in 22706.9,
        ;"       vapIEN -- the IEN in 50.68 to fix from
        ;"       Array -- PASS BY REFERENCE.  Array with data.  Format same as for HandleList
        ;"       NoVerify -- OPTIONAL, if value=1 no user verification asked. Default=0
        ;"result: 1 if OK to continue, 0 if user abort
 
        new result set result=0 ;"default to failure
 
        if $get(NoVerify,0)=0,$$VerifySource(vapIEN)=0 goto F1FDone
        ;"I could put in some undo code here...  BUT undoing changes from Copy1 would be HARD
        if $$Copy1(vapIEN,IEN)=0 goto F1FDone
        do ArrayKill(IEN,.Array)
        set result=1  ;"success
 
F1FDone
        quit result
 
 
VerifySource(vapIEN)
        ;"Purpose: to show the drug name, and the drug's ingredients, and ask user to verify choice
        ;"Input: vapIEN -- IEN in file 50.68
        ;"Result: 1 if OK to use this drug.  0 if don't use
 
        new PriorErrorFound
        new result set result=0
        write "-------------------------------------------------",!
        write "Drug Information:",!
        write "-------------------------------------------------",!
        ;"write "NAME: ",$$GET1^DIQ(50.68,vapIEN,.01),!
        write "GENERIC NAME: ",$$GET1^DIQ(50.68,vapIEN,.05),!
        write "INGREDIENTS:",!
        new TMGMSG,TMGFDA
        do LIST^DIC(50.6814,","_vapIEN_",",".01;1","","*",,,,,,"TMGFDA","TMGMSG")
        if $data(TMGMSG("DIERR"))'=0 do  goto VSDone
        . do ShowDIERR^TMGDEBUG(.TMGMSG,.PriorErrorFound)
        new i
        for i=1:1:+$get(TMGFDA("DILIST",0)) do
        . write "    ",$get(TMGFDA("DILIST",1,i)),!
        write "-------------------------------------------------",!
        write "Use this drug to fix entry in FDA database"
        new % set %=1
        do YN^DICN write !
        if %=1 set result=1
 
VSDone
        quit result
 
 
Copy1(vapIEN,IEN)
        ;"Purpose: to fill in missing answers in the record in 22706.9, from record in 50.68
        ;"Input: vapIEN -- IEN in 50.68
        ;"       IEN -- IEN in 22706.9
        ;"Result: 1 if OK to continue, 0 if error
 
        new result set result=0  ;"default to failure
        new error set error=0
        new PriorErrorFound
 
        new CompFields set CompFields=".08;.05^.09;15"
        new TMGFDA,TMGMSG
        new i,TMGField,vapField
        for i=1:1:$length(CompFields,"^") do
        . new field1,field2,comp
        . new Value1,Value2
        . set comp=$piece(CompFields,"^",i)
        . set field1=$piece(comp,";",1)
        . set field2=$piece(comp,";",2)
        . set Value1=$$GET1^DIQ(22706.9,IEN,field1)
        . set Value2=$$GET1^DIQ(50.68,vapIEN,field2)
        . if (Value1="")&(Value2'="") do
        . . set TMGFDA(22706.9,IEN_",",field1)=Value2
 
        if $data(TMGFDA) do  goto:(error=1) C1Done
        . do FILE^DIE("EK","TMGFDA","TMGMSG")
        . if $data(TMGMSG("DIERR"))'=0 do
        . . set error=1
        . . do ShowDIERR^TMGDEBUG(.TMGMSG,.PriorErrorFound)
 
        ;"Now prep to copy over ingredients...
X1      new Itr,subIEN,IngredArray,tempIEN
        set subIEN=$$ItrInit^TMGITR(50.6814,.Itr,vapIEN)
        if subIEN>0 for  do  quit:($$ItrNext^TMGITR(.Itr,.subIEN)'>0)!(error=1)
        . set tempIEN=+$piece($get(^PSNDF(50.68,vapIEN,2,subIEN,0)),"^",1)
        . if tempIEN'>0 quit
        . kill TMGFDA
        . do FIND^DIC(22706.916,","_IEN_",",".01","AQ",tempIEN,"*",,,,"TMGFDA","TMGMSG")
        . if $data(TMGMSG("DIERR"))'=0 do  quit
        . . set error=1
        . . do ShowDIERR^TMGDEBUG(.TMGMSG,.PriorErrorFound)
        . if $get(TMGFDA("DILIST",0))>0 quit
        . set IngredArray(tempIEN)=""  ;"store ingredients.  Next I'll see if they are new
 
        set result=$$Add1Ingredients(IEN,.IngredArray)
 
C1Done
        quit result
 
 
ManIngredients(Array,Answers,EntryList)
        ;"Purpose: to Manually Add ingredients to a list of records
        ;"Input: Array -- PASS BY REFERENCE.  Array with data.  Format same as for HandleList
        ;"       Answers -- PASS BY REFERENCE,
        ;"              An array that will link display numbers with IENs
        ;"                      Answer(count)=IEN
        ;"       EntryList -- PASS BY REFERENCE -- an array of entries (user input values) to process.
        ;"                      Format as follows.
        ;"                      EntryList(Entry number)=""  (same as count above)
        ;"Result: None
 
        new Itr,Count,IEN
        new IngredArray
        new result set result=1
 
        set Count=$$ItrAInit^TMGITR("EntryList",.Itr)
        if Count>0 for  do  quit:($$ItrANext^TMGITR(.Itr,.Count)'>0)
        . set IEN=$piece($get(Answers(Count)),"^",1)
        . if $data(IngredArray)=0 do
        . . set result=$$AskManIngred(IEN,.IngredArray)
        . else  do
        . . set result=$$Add1Ingredients(IEN,.IngredArray)
        . ;"I could put in some undo code here...
        . if result=0 kill IngredArray quit
        . do ArrayKill(IEN,.Array)
 
        quit
 
 
AskManIngred(IEN,IngredArray)
        ;"Purpose: To ask user for a list of ingredients, then add to record in 22706.9
        ;"Input:   IEN -- the IEN in 22706.9 to have ingredients added to
        ;"         IngredArray -- OPTIONAL.  PASS BY REFERENCE, an OUT PARAMETER
        ;"              Ised to pass back out list of ingredients, so they can be used for other enteries
        ;"              Any former entries in list will be killed
        ;"Result: 1 = OK To Continue, 0 if abort
 
        new result set result=0
        kill IngredArray
 
        new DIC,Y
        set DIC=50.416,DIC(0)="AEQML"
        set DIC("A")="Enter a drug INGREDIENT to add (^ when done): "
 
        for  do  quit:(+Y'>0)
        . do ^DIC
        . if +Y>0 set IngredArray(+Y)=""
        . else  write ! quit
        . write "  ... OK, added.",!
 
        if $data(IngredArray)=0 goto AMIDone
 
        write "Done adding new ingredients.",!!
        new % set %=1
        write "Ingredient List:",!
        write "------------------------------",!
        do ShowIngreds(.IngredArray)
        write "Add INGREDIENT(S) to selected drugs:"
        do YN^DICN write !
        if %'=1 goto AMIDone
 
        set result=$$Add1Ingredients(IEN,.IngredArray)
 
AMIDone
        quit result
 
 
ShowIngreds(IngredArray)
        ;"Purpose: to Show list of ingredients in array
 
        new IEN,Itr
        set IEN=$$ItrAInit^TMGITR("IngredArray",.Itr)
        if IEN>0 for  do  quit:($$ItrANext^TMGITR(.Itr,.IEN)'>0)
        . write "  ",$$GET1^DIQ(50.416,IEN,.01),!
 
        quit
 
 
Add1Ingredients(IEN,IngredArray)
        ;"Purpose: To put a list of ingredients into one (1) record in 22706.9
        ;"Input:  IEN -- the IEN in 22706.9 to load ingredients into
        ;"        IngredArray -- array with list of ingredients.  Format as follows:
        ;"                      IngredArray(ingredIEN)=""
        ;"                      IngredArray(ingredIEN)=""
        ;"Output: Ingredients will be added to 22706.9.  Note: If ingredients are already present, they
        ;"                      will be added a second time.
        ;"        Also, FillGenericName will be called to fill in TMGGeneric Name
        ;"Results: 1 if OK to continue, 0 if error
 
        new Itr,TMGFDA,TMGMSG,tempIEN
        new result set result=0  ;"default to failure
        new error set error=0
 
        ;"Cycle through IngredArray, and set up FDA for adding to 22706.9
        kill Itr,TMGFDA
        set tempIEN=$$ItrAInit^TMGITR("IngredArray",.Itr)
        if tempIEN'="" for  do  quit:(+$$ItrANext^TMGITR(.Itr,.tempIEN)'>0)
        . new IENS set IENS="+"_tempIEN_","_IEN_","  ;" +# format with # as arbitrary unique number
        . set TMGFDA(22706.916,IENS,.01)=tempIEN  ;"an arbitrary index number
        . set TMGFDA(22706.916,IENS,2)=tempIEN   ;"a pointer to the ingredent
 
        ;"Call UPDATE^DIE with FDA
        if $data(TMGFDA) do  goto:(error=1) ADIDone
        . new TMGIEN
        . do UPDATE^DIE("","TMGFDA","TMGIEN","TMGMSG")
        . if $data(TMGMSG("DIERR"))'=0 do
        . . set error=1
        . . do ShowDIERR^TMGDEBUG(.TMGMSG,.PriorErrorFound)
 
        ;"Create a generic name from ingredients
        do FillGenericName^TMGNDF1C(IEN)
 
        set result=1  ;"success
ADIDone
        quit result
