TMGKIDS ;TMG/kst/Code used for pre and post routines for KIDS build ;04/16/08
         ;;1.0;TMG-LIB;**1**;04/16/08

POSTINST
        ;"Purpose: To provide a function that KIDS can call after installing patch.
        ;"This particular function will add custom RPC entries to the RPC field in
        ;"the OPTION field in OR CPRS GUI CHART.

D1      ;"Below is a data list, not simple comments
        ;;TMG ADD PATIENT
        ;;TMG AUTOSIGN TIU DOCUMENT
        ;;TMG BARCODE DECODE
        ;;TMG BARCODE ENCODE
        ;;TMG DOWNLOAD FILE
        ;;TMG DOWNLOAD FILE DROPBOX
        ;;TMG GET BLANK TIU DOCUMENT
        ;;TMG GET DFN
        ;;TMG GET IMAGE LONG DESCRIPTION
        ;;TMG GET PATIENT DEMOGRAPHICS
        ;;TMG SET PATIENT DEMOGRAPHICS
        ;;TMG UPLOAD FILE
        ;;TMG UPLOAD FILE DROPBOX
        ;;TMG CPRS GET URL LIST
        ;;--END OF LIST--

        new ienORCPRS,DIC,X,Y
        ;"set ienORCPRS= ... find in OPTION file.
        set DIC=19  ;"OPTION file
        set X="OR CPRS GUI CHART"
        do ^DIC
        set ienORCPRS=+$piece(Y,"^",1)
        if ienORCPRS'>0 do  goto PostDone
        . write !,!,"Sorry, unable to locate OR CPRS GUI CHART in OPTION file.",!
        . write "Unable to add TMG's RPC's to allowed list of RPC's for CPRS.",!

        new i,rpcName
        for i=1:1 do  quit:(rpcName="")
        . set rpcName=$text(D1+i^TMGKIDS)
        . set rpcName=$piece(rpcName,";;",2)
        . if rpcName="--END OF LIST--" set rpcName=""
        . if rpcName="" quit
        . do AddRPC(ienORCPRS,rpcName)

PostDone
        quit



AddRPC(IENOption,RPCName)
        ;"Purpose: To add the RPC Name to the RPC subfile in the Option record,
        ;"         given by IENOption
        ;"Note: If IENRPC is already present, then it won't be added again.

        ;"See if RPC is already present, to avoid duplication
        new DIC,TMGD0,X,Y
        set TMGD0=IENOption
        set X=RPCName
        set DIC="^DIC(19,"_IENOption_",""RPC"","
        set DIC(0)="MZ"
        do ^DIC

        write RPCName
        if +Y'>0 do
        . ;"code to add RPC here.
        . new TMGFDA,TMGIEN,TMGMSG
        . set TMGFDA(19.05,"+1,"_IENOption_",",.01)=RPCName
        . do UPDATE^DIE("E","TMGFDA","TMGIEN","TMGMSG")
        . do ShowIfDIERR^TMGDEBUG(.TMGMSG)
        . write ?30,"... Added as allowed RPC from CPRS",!
        else  do
        . write ?30,"... already present",!

        quit



