TMGNDF3B ;TMG/kst/FDA Import: Set skip flag based on drug class ;03/25/06
         ;;1.0;TMG-LIB;**1**;11/21/06
 
 ;" FDA - NATIONAL DRUG FILES COMPILING FUNCTIONS
 ;"      Set skip flag based on CLASS
 ;"Kevin Toppenberg MD
 ;"GNU General Public License (GPL) applies
 ;"11-21-2006
 
 ;"=======================================================================
 ;" API -- Public Functions.
 ;"=======================================================================
 ;"PickSkips -- allow user to scan for drugs by class and choose which to skip.
 ;"          -- NOTE: This is called from menu in TMGNDF3A
 
 ;"=======================================================================
 ;" Private Functions.
 ;"=======================================================================
 ;"GetChildClasses(Array,Result) -- get a child array block showing the heirarchy of all VA DRUG classes
 ;"GetRxClasses(pList,Array) -- create an array of drug classes for the input List
 ;"GetMatch(RxClasses,ChildClasses,ClassIEN,Results) -- return those Drugs contained in class IEN
 ;"WeedClasses(Classes,RxClasses,ChildClasses) -- remove entries from Classes that don't have any children in RxClasses
 ;"NumDescendents(ClassIEN,Classes,ChildClasses,CountArray) -- return num having class, or descendent class
 ;"DoWeedBySel(pList,mode) -- remove items, view all drugs, & select to remove
 ;"GetInfo(IEN,array) -- get all the associated names linked to a DRUG file entry
 
 ;"=======================================================================
 ;"=======================================================================
PickSkips
        ;"Purpose: To allow user to scan for drugs by class and choose which to skip.
 
        new List
        do GetList("List")
        do WeedByClass("List")
 
        quit
 
GetList(pList)
        ;"Purpose: To create a list of records not currently marked to be skipped
        ;"Input: pList -- PASS BY NAME -- an OUT PARAMETER.  Format:
        ;"       @pList@(DrugName,IENin22706.9)=""
        ;"       @pList@(DrugName,IENin22706.9)=""
 
        new Itr,IEN
        new abort set abort=0
        write "Gathering names of the current imports not flagged to be SKIPPED...",!
        set IEN=$$ItrInit^TMGITR(22706.9,.Itr)
        do PrepProgress^TMGITR(.Itr,20,0,"IEN")
        if IEN'="" for  do  quit:($$ItrNext^TMGITR(.Itr,.IEN)'>0)!abort
        . if $$UserAborted^TMGUSRIF set abort=1 quit
        . if $piece($get(^TMG(22706.9,IEN,1)),"^",4)=1 quit ;"1=SKIP
        . new DrugName set DrugName=$piece($get(^TMG(22706.9,IEN,7)),"^",6)
        . set @pList@(DrugName,IEN)=""
        do ProgressDone^TMGITR(.Itr)
 
        quit
 
WeedByClass(pList)
        ;"Purpose: To allow the user to weed the list of drugs for addition, by drug class
        ;"Input: pList -- PASS BY NAME -- list of drugs to be added, as created by FillList(pList)
        ;"Output: the List will be edited.
        ;"Result: none
 
        new Classes,ParentArray,ChildArray,IEN,RxClasses
 
        write "Gathering information about drug CLASSES from the imports..."
        do GetClasses^TMGNDF3A(.Classes)
        do KillIntro^TMGNDF3A(.Classes)
        do GetChildClasses(.Classes,.ChildArray)
        do GetRxClasses(pList,.RxClasses)
        do WeedClasses(.Classes,.RxClasses,.ChildArray)
 
        new done set done=0
        for  do  quit:(done=1)
        . new classIEN
        . set classIEN=$$SelectClass^TMGNDF3A(.Classes,1)
        . if classIEN=0 set done=1 quit
        . new Match
        . do GetMatch(.RxClasses,.ChildArray,classIEN,.Match)
        . if $data(Match) do
        . . new delList
        . . do SelRxList("Match","delList","SELECT DRUGS TO BE DELETED.  [ESC][ESC] WHEN DONE")
        . . do DoWeed(pList,"delList")
        . . new name set name=""
        . . for  set name=$order(delList(name)) quit:(name="")  do
        . . . new IEN set IEN=""
        . . . for  set IEN=$order(delList(name,IEN)) quit:(+IEN'>0)  do
        . . . . new TMGFDA,TMGMSG
        . . . . set TMGFDA(22706.9,IEN_",",6)=1  ;"1=SKIP
        . . . . do FILE^DIE("K","TMGFDA","TMGMSG")
        . . . . do ShowIfDIERR^TMGDEBUG(.TMGMSG)
        . . . . new classIEN set classIEN=$piece($get(^TMG(22706.9,IEN,1)),"^",5)
        . . . . if $data(RxClasses(classIEN,name,IEN)) do
        . . . . . kill RxClasses(classIEN,name,IEN)
        . . ;"kill RxClasses
        . . ;"write "Gathering drug classes..."
        . . ;"do GetRxClasses(pList,.RxClasses)
        . . do WeedClasses(.Classes,.RxClasses,.ChildArray)
        . else  write "(No matches found.)",!
 
        ;"write "Counting drugs in list...  "
        ;"set @pList@(-1)=$$ListCt^TMGMISC(pList)-1  ;"recount ItemsCount node
 
        quit
 
 
GetRxClasses(pList,Array)
        ;"Purpose: To create an array of drug classes for the input List
        ;"Input: pList -- PASS BY NAME,
        ;"              format:  @List@(-1)=ItemsCount  <-- REMOVED
        ;"                       @List@(DrugName,IEN)=""   ;IEN is IEN in file 22706.9
        ;"       Array -- PASS BY REFERENCE, an OUT PARAMETER
        ;"              format: Array(ClassIEN,DrugName,IEN)=""
        ;"                      Array(ClassIEN,DrugName,IEN)=""
        ;"                      Array(ClassIEN,DrugName,IEN)=""
        ;"Output: Array  -- prior entries are not deleted.
        ;"Result: none
 
        new Itr,DrugName
        new IEN,ClassIEN
        new abort set abort=0
        set DrugName=$$ItrAInit^TMGITR(pList,.Itr)
        do PrepProgress^TMGITR(.Itr,20,1,"DrugName")
        write !
        if DrugName'="" for  do  quit:($$ItrANext^TMGITR(.Itr,.DrugName)="")!abort
        . if $$UserAborted^TMGUSRIF set abort=1 quit
        . set IEN=0
        . for  set IEN=$order(@pList@(DrugName,IEN)) quit:(+IEN'>0)  do
        . . set ClassIEN=$piece($get(^TMG(22706.9,IEN,1)),"^",5)
        . . if ClassIEN>0 set Array(ClassIEN,DrugName,IEN)=""
        do ProgressDone^TMGITR(.Itr)
 
        quit
 
 
 
GetChildClasses(Array,Result)
        ;"Purpose: To get a child array block showing the heirarchy of all VA DRUG classes
        ;"Input:  Array -- PASS BY REFERENCE, array as created by GetClasses^TMGNDF3A(.Array)
        ;"           Array(GGF-IEN)=e.g. ""AD000^ANTIDOTES,DETERRENTS AND POISON CONTROL"
        ;"           Array(GGF-IEN,GF-IEN)=e.g. "AD100^ALCOHOL DETERRENTS"
        ;"           Array(GGF-IEN,GF-IEN,F-IEN)=e.g. "AD150^ALCOHOL DETERRENTS -- GENERAL TYPE 1"
        ;"           Array(GGF-IEN,GF-IEN,F-IEN,IEN)=e.g. "AD152^ALCOHOL DETERRENTS -- GENERAL TYPE 1b"
        ;"           Note: There are no more than 3 levels
        ;"        Result -- PASS BY REFERENCE, an OUT PARAMETER
        ;"Output: Result filled as follows:
        ;"              Note: the IEN's here are IEN's in VA DRUG CLASS file
        ;"              Result (IEN)="IEN1,IEN2,IEN3,IEN4,IEN5,IEN6,"  a list of all child IENs
        ;"              Result (IEN)="IEN1,IEN2,IEN3,IEN4,IEN5,IEN6,"  a list of all child IENs
        ;"              Result (IEN)="IEN1,IEN2,IEN3,IEN4,IEN5,IEN6,"  a list of all child IENs
        ;"              Result (IEN)="IEN1,IEN2,IEN3,IEN4,IEN5,IEN6,"  a list of all child IENs
        ;"              e.g. ChildArray(1)= 2,3,240, means that 2,3,240 are children of 1
        ;"Results: none
 
        new parentIEN,IEN
 
        new i1,i2,i3,i4
        set i1=$order(Array(""))
        if i1'="" for  do  quit:(i1="")
        . set i2=$order(Array(i1,""))
        . if i2'="" for  do  quit:(i2="")
        . . if $data(Array(i1,i2))#10>0 do
        . . . set Result(i1)=$get(Result(i1))_i2_","
        . . set i3=$order(Array(i1,i2,""))
        . . if i3'="" for  do  quit:(i3="")
        . . . if $data(Array(i1,i2,i3))#10>0 do
        . . . . set Result(i1)=$get(Result(i1))_i3_","
        . . . set i3=$order(Array(i1,i2,i3))
        . . set i2=$order(Array(i1,i2))
        . set i1=$order(Array(i1))
 
        quit
 
 
WeedClasses(Classes,RxClasses,ChildClasses)
        ;"Purpose: To removed entries from Classes that don't have any children in RxClasses
        ;"Input:
        ;"       Classes -- PASS BY REFERENCE.  Array  filled as follows:
        ;"           Array(GGF-IEN)=e.g. ""AD000^ANTIDOTES,DETERRENTS AND POISON CONTROL"
        ;"           Array(GGF-IEN,GF-IEN)=e.g. "AD100^ALCOHOL DETERRENTS"
        ;"           Array(GGF-IEN,GF-IEN,F-IEN)=e.g. "AD150^ALCOHOL DETERRENTS -- GENERAL TYPE 1"
        ;"           Array(GGF-IEN,GF-IEN,F-IEN,IEN)=e.g. "AD152^ALCOHOL DETERRENTS -- GENERAL TYPE 1b"
        ;"      RxClasses: PASS BY REFERENCE
        ;"              format: Array(ClassIEN,DrugName,IEN)=""
        ;"                      Array(ClassIEN,DrugName,IEN)=""
        ;"                      Array(ClassIEN,DrugName,IEN)=""
        ;"      ChildClasses: PASS BY REFERENCE
        ;"              Note: the IEN's here are IEN's in VA DRUG CLASS file
        ;"              Array(IEN)="IEN1,IEN2,IEN3,IEN4,IEN5,IEN6,"  a list of all child IENs
        ;"              Array(IEN)="IEN1,IEN2,IEN3,IEN4,IEN5,IEN6,"  a list of all child IENs
        ;"              Array(IEN)="IEN1,IEN2,IEN3,IEN4,IEN5,IEN6,"  a list of all child IENs
        ;"              Array(IEN)="IEN1,IEN2,IEN3,IEN4,IEN5,IEN6,"  a list of all child IENs
        ;"              e.g. Array(1)= 2,3,240, means that 2,3,240 are children of 1
        ;"Output: Classes Array will be edited with empty clases removed
        ;"Results: none
 
        ;"First count all entries for each drug class IEN
 
        new CountArray
        ;"Format: CountArray(ClassIEN)=CountOfDrugsWithThisClass
 
        new count
        new ClassIEN set ClassIEN=$order(RxClasses(""))
        if ClassIEN'="" for  do  quit:(ClassIEN="")
        . set count=0
        . new DrugName set DrugName=$order(RxClasses(ClassIEN,""))
        . if DrugName'="" for  do  quit:(DrugName="")
        . . new DrugIEN set DrugIEN=$order(RxClasses(ClassIEN,DrugName,""))
        . . if DrugIEN'="" for  do  quit:(DrugIEN="")
        . . . set count=count+1
        . . . set DrugIEN=$order(RxClasses(ClassIEN,DrugName,DrugIEN))
        . . set DrugName=$order(RxClasses(ClassIEN,DrugName))
        . set CountArray(ClassIEN)=count
        . set ClassIEN=$order(RxClasses(ClassIEN))
 
 
        ;"Now remove all ClassIENs that don't have any entries, or children or grandchildren etc.
        ;"       Classes -- Array will be filled as follows:
        ;"           Array(GGF-IEN)=e.g. ""AD000^ANTIDOTES,DETERRENTS AND POISON CONTROL"
        ;"           Array(GGF-IEN,GF-IEN)=e.g. "AD100^ALCOHOL DETERRENTS"
        ;"           Array(GGF-IEN,GF-IEN,F-IEN)=e.g. "AD150^ALCOHOL DETERRENTS -- GENERAL TYPE 1"
        ;"           Array(GGF-IEN,GF-IEN,F-IEN,IEN)=e.g. "AD152^ALCOHOL DETERRENTS -- GENERAL TYPE 1b"
 
        new i1,i2,i3,i4
        set i1=$order(Classes(""))
        if i1'="" for  do  quit:(i1="")
        . if $$NumDescendents(i1,.Classes,.ChildClasses,.CountArray)=0 do  quit
        . . new temp set temp=i1
        . . set i1=$order(Classes(i1))
        . . kill Classes(temp)
        . . ;"write "Removing class ",temp,"... It doesn't have any entries or descendents",!
        . set i2=$order(Classes(i1,""))
        . if i2'="" for  do  quit:(i2="")
        . . if $$NumDescendents(i2,.Classes,.ChildClasses,.CountArray)=0 do  quit
        . . . new temp set temp=i2
        . . . set i2=$order(Classes(i1,i2))
        . . . kill Classes(i1,temp)
        . . . ;"write "Removing class ",temp,"... It doesn't have any entries or descendents",!
        . . set i3=$order(Classes(i1,i2,""))
        . . if i3'="" for  do  quit:(i3="")
        . . . if $$NumDescendents(i3,.Classes,.ChildClasses,.CountArray)=0 do  quit
        . . . . new temp set temp=i3
        . . . . set i3=$order(Classes(i1,i2,i3))
        . . . . kill Classes(i1,i2,temp)
        . . . . ;"write "Removing class ",temp,"... It doesn't have any entries or descendents",!
        . . . set i3=$order(Classes(i1,i2,i3))
        . . set i2=$order(Classes(i1,i2))
        . set i1=$order(Classes(i1))
 
        quit
 
 
GetMatch(RxClasses,ChildClasses,ClassIEN,Results)
        ;"Purpose: To return those Drugs contained in class IEN
        ;"Input: RxClasses: PASS BY REFERENCE  Array as created by GetRxClasses(pList,Array)
        ;"              -- a list of drugs arranged by class
        ;"       ChildClasses: PASS BY REFERENCE  Array as created by GetChildClasses(Array,Result)
        ;"              -- a list of child class for any given class IEN
        ;"       ClassIEN: The IEN from file VA DRUG CLASS to match against.
        ;"       Results: PASS BY REFERENCE, an OUT PARAMETER
        ;"Output: Results -- List of matches, if found.  Format as follows:
        ;"              format: Results(-1)=ItemsCount   <-- REMOVED
        ;"                      Results(DrugName,IEN)=""
        ;"
        ;"Results: none
 
        ;"First get all matches for ClassIEN
        merge Results=RxClasses(ClassIEN)
 
        ;"Now get matches for all descenents
        new i,kids
        set kids=$get(ChildClasses(ClassIEN))
        for i=1:1:$length(kids,",") do
        . new kidIEN set kidIEN=$piece(kids,",",i)
        . merge Results=RxClasses(kidIEN)
        quit
 
 
NumDescendents(ClassIEN,Classes,ChildClasses,CountArray)
        ;"Purpose: For a given drug class, return the number of drugs that have this class, or one
        ;"              of it's descendent classes as its assigned drug class
        ;"Input: ClassIEN -- the IEN to evaluate
        ;"       Classes -- Array will be filled as follows:
        ;"           Array(GGF-IEN)=e.g. ""AD000^ANTIDOTES,DETERRENTS AND POISON CONTROL"
        ;"           Array(GGF-IEN,GF-IEN)=e.g. "AD100^ALCOHOL DETERRENTS"
        ;"           Array(GGF-IEN,GF-IEN,F-IEN)=e.g. "AD150^ALCOHOL DETERRENTS -- GENERAL TYPE 1"
        ;"           Array(GGF-IEN,GF-IEN,F-IEN,IEN)=e.g. "AD152^ALCOHOL DETERRENTS -- GENERAL TYPE 1b"
        ;"      ChildClasses:
        ;"              Note: the IEN's here are IEN's in VA DRUG CLASS file
        ;"              Array(IEN)="IEN1,IEN2,IEN3,IEN4,IEN5,IEN6,"  a list of all child IENs
        ;"              Array(IEN)="IEN1,IEN2,IEN3,IEN4,IEN5,IEN6,"  a list of all child IENs
        ;"              Array(IEN)="IEN1,IEN2,IEN3,IEN4,IEN5,IEN6,"  a list of all child IENs
        ;"              Array(IEN)="IEN1,IEN2,IEN3,IEN4,IEN5,IEN6,"  a list of all child IENs
        ;"              e.g. Array(1)= 2,3,240, means that 2,3,240 are children of 1
        ;"      CountArray:  Array filled with a counting of drugs using each class (pre-counted array)
        ;"              CountArray(ClassIEN)=CountOfDrugsWithThisClass
        ;"              CountArray(ClassIEN)=CountOfDrugsWithThisClass
        ;"              CountArray(ClassIEN)=CountOfDrugsWithThisClass
        ;"Result: returns the number using this class, or a descendent class.
 
        new result
        set result=+$get(CountArray(ClassIEN))
 
        new ChildList set ChildList=$get(ChildClasses(ClassIEN))
        new i for i=1:1:$length(ChildList,",") do
        . new subClassIEN set subClassIEN=+$piece(ChildList,",",i)
        . if subClassIEN=0 quit
        . set result=result+$$NumDescendents(subClassIEN,.Classes,.ChildClasses,.CountArray)
 
        quit result
 
 
 
SelRxList(pList,pSelList,HdrText,mode)
        ;"Purpose: To display the Drug list, and allow user to select from the list.
        ;"Input: pList -- PASS BY NAME -- list of drugs to be added, as created by FillList(pList)
        ;"                   @pList@(drugName,IEN)=""
        ;"       pSelList -- PASS BY NAME, an OUT PARAMETER.
        ;"              Returns list of selected items
        ;"                   @pSelList@(drugName,IEN)=""  ;IEN is from 22706.9
        ;"                   @pSelList@(drugName,IEN)=""
        ;"       HdrText -- optional, some text to show on top of selector
        ;"       mode -- OPTIONAL.  Default=1
        ;"                 1 --> Display by LONG NAME  .04 name
        ;"                 2 --> Display by VA PRODUCT (50.68) .01 name
        ;"                 3 --> Display by FDA import name
        ;"                 4 --> Display by VA GENERIC name
 
        ;"Results: none
 
        new ref set ref="^TMP(""VEE"",$J)"
        kill @ref
        new count set count=1
        set mode=$get(mode,1)
 
        new pNDCIndex
        set pNDCIndex=$$GetNDCIndex^TMGNDF4A(1)
 
        write "Prepping to display list...",!
        ;"First convert list to a display format
        new name,IEN,Itr
 
        set name=$$ItrAInit^TMGITR(pList,.Itr)
        do PrepProgress^TMGITR(.Itr,20,1,"name")
        if name'="" for  do  quit:($$ItrANext^TMGITR(.Itr,.name)="")
        . new addedArray,showName
        . set IEN=0
        . for  set IEN=$order(@pList@(name,IEN)) quit:(IEN="")  do
        . . new NameInfo do GetInfo(IEN,.NameInfo)
        . . new IdxName set IdxName=$get(NameInfo("MODES",mode))
        . . if mode=3 do  ;"Display by FDA import name
        . . . set showName=""
        . . . for  set showName=$order(NameInfo(IdxName,showName)) quit:(showName="")  do
        . . . . set @ref@(count)=name_"^"_IEN_$char(9)_showName set count=count+1
        . . . set showName=""  ;"prevent duplicate addition below
        . . else  if (mode>0)&(mode<5) set showName=$order(NameInfo(IdxName,""))
        . . if (showName'="") set @ref@(count)=name_"^"_IEN_$char(9)_showName set count=count+1
 
        set @ref@("HD")=$get(HdrText,"MENU")
 
        ;"Note: Rules of use:
        ;"  ref must=^TMP("VEE",$J)
        ;"  Each line should be in this format:
        ;"      @ref@(number)=ReturnValue_$char(9)_DisplayValue
        ;"      @ref@(number)=ReturnValue_$char(9)_DisplayValue
        ;"      @ref@(number)=ReturnValue_$char(9)_DisplayValue
        ;"  Results come back in:
        ;"      ^TMP("VPE","SELECT",$J,number)=ReturnValue_$char(9)_DisplayValue
        ;"      ^TMP("VPE","SELECT",$J,number)=ReturnValue_$char(9)_DisplayValue
        ;"      ^TMP("VPE","SELECT",$J,number)=ReturnValue_$char(9)_DisplayValue
 
        write !,"Passing off to Selector..."
        D SELECT^%ZVEMKT(ref)
 
        set ref="^TMP(""VPE"",""SELECT"","_$J_")"
        new number set number=""
        for  set number=$order(@ref@(number)) quit:(number="")  do
        . new ReturnValue set ReturnValue=$piece(@ref@(number),$char(9),1)
        . new drugName set drugName=$piece(ReturnValue,"^",1)
        . new IEN set IEN=$piece(ReturnValue,"^",2)
        . set @pSelList@(drugName,IEN)=""
 
        quit
 
 
DoWeed(pList,pDelList)
        ;"Purpose: To remove all items in pDelList from pList
        ;"Input: pList -- PASS BY NAME-- list of drugs to be edited, as created by FillList(pList)
        ;"              format:  @pList@(-1)=ItemsCount   <-- REMOVED
        ;"                       @pList@(DrugName,IEN)=""
        ;"                       @pList@(DrugName,IEN)=""
        ;"       pDelList -- PASS BY NAME -- list of drugs to be removed, as created by UsrWeedList
        ;"              format: @pDelList@(DrugName,IEN)=""
        ;"                      @pDelList@(DrugName,IEN)=""
 
        new % set %=2
        if '$data(pDelList) goto DWDone
 
        write "Setting selected imports to be SKIPPED...  "
        new drugName
        set drugName=$order(@pDelList@(0))
        if drugName'="" for  do  quit:(drugName="")
        . new IEN set IEN=$order(@pDelList@(drugName,0))
        . if IEN'="" for  do  quit:(IEN="")
        . . kill @pList@(drugName,IEN)
        . . set IEN=$order(@pDelList@(drugName,IEN))
        . set drugName=$order(@pDelList@(drugName))
 
        ;"write "Counting drugs in list...  "
        ;"set @pList@(-1)=$$ListCt^TMGMISC(pList)-1  ;"remove count of ItemsCount node
 
DWDone
        quit
 
 
GetInfo(IEN,array)
        ;"Purpose: to get all the associated names linked to a DRUG file entry
        ;"Input: IEN -- the IEN in file 22706.9
        ;"       array -- PASS BY REFERENCE.  An OUT PARAMETER.  Format:
        ;"                  array("DRUG NAME",Name)=""      NAME (.04) FROM 22706.9
        ;"                  array("VAP NAME",Name)=""       Name from VA PRODUCT file
        ;"                  array("FDA IMPORT NAME",Names)=""    Name from .05 TRADE NAME IN 22706.9
        ;"                  array("VA GENERIC NAME",Name)=""     Name from VA GENERIC file
        ;"                  array("MODES",1)="DRUG NAME"
        ;"                  array("MODES",2)="VAP NAME"
        ;"                  array("MODES",3)="FDA IMPORT NAME"
        ;"                  array("MODES",4)="VA GENERIC NAME"
        ;"results: none
 
        new showName
        kill array
 
        set array("MODES",1)="DRUG NAME"
        set array("MODES",2)="VAP NAME"
        set array("MODES",3)="FDA IMPORT NAME"
        set array("MODES",4)="VA GENERIC NAME"
 
        ;"new vapIEN set vapIEN=+$piece($get(^PSDRUG(IEN,"ND")),"^",3)
        new vapIEN set vapIEN=+$piece($get(^TMG(22706.9,IEN,6)),"^",2)
        if vapIEN'=0 do
        . set showName=$piece($get(^PSNDF(50.68,vapIEN,0)),"^",1)
        . set:(showName'="") array("VAP NAME",showName)=""
        . . else  if mode=3 do  ;"Display by FDA import name
 
        ;"new vagIEN set vagIEN=+$piece($get(^PSNDF(50.68,vapIEN,0)),"^",2)
        new vagIEN set vagIEN=+$piece($get(^TMG(22706.9,IEN,1)),"^",3)
        if vagIEN'=0 do
        . set showName=$piece($get(^PSNDF(50.6,vagIEN,0)),"^",1)
        . set:(showName'="") array("VA GENERIC NAME",showName)=""
 
        ;"set showName=$piece($get(^PSDRUG(IEN,0)),"^",1)
        set showName=$piece($get(^TMG(22706.9,IEN,7)),"^",6)  ;"7;6 = LONG NAME
        set:(showName'="") array("DRUG NAME",showName)=""
 
        set showName=$piece($get(^TMG(22706.9,IEN,0)),"^",4)  ;"0;4 = TRADENAME
        set:(showName'="") array("FDA IMPORT NAME",showName)=""
 
        quit
 
 
 
 
