TMGDBAP2 ;TMG/kst/Barcode Interface to Linux ;12/20/07
         ;;1.0;TMG-LIB;**1**;12/20/07


 ;"=======================================================================
 ;" API -- Public Functions.
 ;"=======================================================================
 ;"$$MAKEBC^TMGBARC(Message) -- shell to Linux, to create barcode image.
 ;"$$READBC^TMGBARC(FPathName) -- shell to Linux, to read barcode image.

 ;"=======================================================================
 ;"PRIVATE API FUNCTIONS
 ;"=======================================================================
 ;"Test

 ;"=======================================================================


MAKEBC(Message,Option)
        ;"Purpose: to shell out to Linux, and call dmtxwrite to create
        ;"         the barcode image.
        ;"Input: Message -- the text to be encode in the barcode
        ;"                 Note: the barcode function may limit what type of chars
        ;"                 can be put it, and how long. (explore more later...)
        ;"       Option -- PASS BY REFERENCE.  Array that may hold optional
        ;"                 settings, as follows:  Default value is "png"
        ;"                 Option("IMAGE TYPE")="jpg" <-- output is desired in .jpg format
        ;"Output: Returns filename, on host file system, of created image, or "" if error
        ;"
        ;"NOTE: dmtxwrite must be installed on linux host.
        ;"      I found source code here:
        ;"      http://sourceforge.net/projects/libdmtx/
        ;"      After installing (./configure --> make --> make install etc), I
        ;"        copied dmtxread and dmtxwrite, which were found in the
        ;"        (installdir)/util/dmtxread/.libs and (installdir)/util/dmtxwrite/.libs
        ;"        folders, into a folder on the system path.  I chose /usr/bin/
        ;"      Also, to achieve compile of above, I had to install required libs.
        ;"      See notes included with source code.

        new result set result=""
        new msgFName set msgFName=$$UNIQUE^%ZISUTL("/tmp/msg.txt")
        new imageFName set imageFName=$$UNIQUE^%ZISUTL("/tmp/barcode.png")
        new imageType set imageType=$$LOW^XLFSTR($get(OPTION("IMAGE TYPE"),"png"))

        ;"Write Message to host file .txt file
        new %ZIS,IOP,POP
        set %ZIS("HFSNAME")=msgFName
        set IOP="HFS"
        do ^%ZIS  ;"standard device call
        if POP goto MBCDone
        use IO
        write Message
        do ^%ZISC  ;"close device

        ;"Setup and launch linux command to execute dmtxwrite
        ;"Note: dmtxwrite only makes .png format images
        new CmdStr
        set CmdStr="cat "_msgFName_" | dmtxwrite -o "_imageFName
        do
        . new $ETRAP,$ZTRAP
        . set $ETRAP="S $ECODE="""""
        . zsystem CmdStr  ;"Launch command

        ;"get result of execution. (low byte only)  -- if wanted
        new CmdResult
        set CmdResult=$ZSYSTEM&255
        if CmdResult'=0 goto MBCDone

        ;"No error, so successful

        ;"Convert to specified image type, if needed
        if imageType'="png" set imageFName=$$Convert^TMGKERNL(imageFName,imageType)

        set result=imageFName

        ;"Delete Message .txt file
        new FName,FPath,FileSpec
        do SplitFNamePath^TMGIOUTL(msgFName,.FPath,.FName,"/")
        set FileSpec(FName)=""
        new temp set temp=$$DEL^%ZISH(FPath,$name(FileSpec))

MBCDone
        quit result


READBC(FPathName)
        ;"Purpose: to shell out to Linux, and call dmtxread to read a
        ;"         barcode image.
        ;"Input: FPathName -- valid host file name of image to be decoded.
        ;"Output: Returns message stored in barcode, or "" if problem
        ;"
        ;"NOTE: dmtxread must be installed on linux host.
        ;"      I found source code here:
        ;"      http://sourceforge.net/projects/libdmtx/
        ;"      After installing (./configure --> make --> make install), I
        ;"        copied dmtxread and dmtxwrite, which were found in the
        ;"        (installdir)/util/dmtxread/.libs and (installdir)/util/dmtxwrite/.libs
        ;"        folders, into a folder on the system path.  I chose /usr/bin/
        ;"      Also, to achieve compile of above, I had to install required libs.
        ;"      See notes included with source code.

        new result set result=""

        new msgFName set msgFName=$$UNIQUE^%ZISUTL("/tmp/msg.txt")
        new FName,FPath,FileSpec
        do SplitFNamePath^TMGIOUTL(msgFName,.FPath,.FName,"/")
        set FileSpec(FName)=""

        ;"Setup and launch linux command to execute dmtxwrite
        new CmdStr
        set CmdStr="dmtxread -g 32 "_FPathName_" >> "_msgFName
        ;"Add a leading filler character to prevent possible read error
        ;"from an empty file.
        set CmdStr="echo ""#"" > "_msgFName_";"_CmdStr
        do
        . zsystem CmdStr  ;"Launch command

        ;"get result of execution. (low byte only)  -- if wanted
        new CmdResult set CmdResult=$ZSYSTEM&255
        if CmdResult'=0 goto RBCDone

        set ^TMG("TMP","BARCODE","LOG")="5d"  ;"temp

        new resultArray
        if $$FTG^%ZISH(FPath,FName,"resultArray(0)",1)=0 do  goto RBCDone
        ;"First line should be just '#' (filler character)
        ;"Second line should hold answer
        set result=$get(resultArray(1))

        merge ^TMG("TMP","BARCODE","RESULT FILE")=resultArray

        ;"Read Message from host file .txt file
        ;"do OPEN^%ZISH("FILE1",FPath,FName,"R")
        ;"if POP goto RBCDone
        ;"do
        ;". use IO
        ;". read result
        ;"do CLOSE^%ZISH("FILE1")
        ;"new resultArray
        ;"do CleaveToArray^TMGSTUTL(result,$char(10),.resultArray)
        ;"for now I am only going to pay attention to first line...
        ;"set result=$get(resultArray(1))
        ;"set result=$extract(result,2,999) ;"remove 1st character which is filler '#'


        ;"Delete Message .txt file
        ;"TEMP!!! DELETE LATER...
        new temp set temp=$$DEL^%ZISH(FPath,$name(FileSpec))

RBCDone
        quit result


Test
        new msg,file
        set msg="This is a test message"
        write "Creating barcode...",!
        set file=$$MAKEBC(msg)
        write "reading barcode....",!,!
        write $$READBC(file),!

        ;"delete temp image file
        new FName,FPath,FileSpec
        do SplitFNamePath^TMGIOUTL(file,.FPath,.FName,"/")
        set FileSpec(FName)=""
        new temp set temp=$$DEL^%ZISH(FPath,"FileSpec")

        quit
