TMGIDE5 ;TMG/kst/GT/M debugger Interrupt handler code ;03/18/09
         ;;1.0;TMG-LIB;**1**;03/23/09
 ;
 ;" TMG IDE Debugger Interrupt handler code
 ;"
 ;" K. Toppenberg
 ;" 3/18/09
 ;" License: GPL Applies
 ;"
 ;"------------------------------------------------------------
 ;"PUBLIC API
 ;"------------------------------------------------------------
 ;"PICKINTR -- show currently running jobs, and allow user to start debugging them
 ;"INTERUPT -- respond to mupip intrpt, assigning control to a remote process

 ;"------------------------------------------------------------
 ;"PRIVATE API
 ;"------------------------------------------------------------
 ;"LaunchIntr(JobNum) -- create interrupt message to job, then start listening
 ;"         for requests for control from interrupted process
 ;"------------------------------------------------------------
 ;"Dependencies
 ;"   TMGIDE4
 ;"   TMGKERNL
 ;"   %ZISUTL
 ;"   TMGUSRIF

PICKINTR
        ;"Purpose: To show currently running jobs, and allow user to start
        ;"         debugging them (tapping into process currently running)
        ;"Called from TMGIDE
        ;
        new array
        do MJOBS^TMGKERNL(.array)
        kill array($J)  ;"don't show this process
        new Menu,UsrSlct
        new i,j set i="",j=1
        for  set i=$order(array(i)) quit:(i="")  do
        . set Menu(j)="Job "_$get(array(i))_$char(9)_i
        . set j=j+1
        if $data(Menu)=0 do  goto PIDone
        set Menu(0)="Pick Job to Debug"
        ;
M1      set UsrSlct=$$Menu^TMGUSRIF(.Menu,"^")
        ;
        if UsrSlct="^" goto PIDone
        if UsrSlct=0 set UsrSlct="" goto M1
        if UsrSlct=+UsrSlct do LaunchIntr(UsrSlct)
        goto M1
        ;
PIDone  quit
        ;
LaunchIntr(JobNum)
        ;"Purpose: To create interrupt message to job, then start listening
        ;"         for requests for control from interrupted process
        if +$get(JobNum)'>0 quit
        set tmgDbgRemoteJob=JobNum
        set ^XUTL("XUSYS","TMG COMMAND")="INTRPT"
        zsystem "mupip intrpt "_JobNum
        do Controller^TMGIDE3 ;"launch the controller
        set ^XUTL("XUSYS","TMG COMMAND")=""
        quit
        ;
INTERUPT
       ;"Purpose: To respond to mupip interrupt for a process, turning control
       ;"         over to a remote control process
       ;"NOTE: This will be called by a modified version of JOBEXAM^ZU
       if $get(TMGDEBUG) write !,"Sending INQ to connect to remote controller..."
       new TMGR set TMGR=$$MessageOut^TMGIDE4("INQ "_$J,30)
       if TMGR="" goto Int2
       if $get(TMGDEBUG) do
       . write !
       . write "*****************************************************",!
       . write "* INTERRUPT RECEIVED.  Transferring control to      *",!
       . write "* a remote controller.  That is process ",$$LJ^XLFSTR($piece(TMGR," ",2),5),?52,"*",!
       . write "*                                                   *",!
       . write "* Please switch to that process window for control. *",!
       . write "*****************************************************",!
       set TMGR=$$MessageOut^TMGIDE4("WRITE Notice: Controlling interrupted job #"_$J,,0)
       set $ZSTEP="N TMGTrap S TMGTrap=$$STEPTRAP^TMGIDE4($ZPOS) zstep:(TMGTrap=1) into zstep:(TMGTrap=2) over zcontinue"
       set TMGStepMode="into"
       zstep into quit
Int2   quit
       ;
